/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver.cfg;

import com.jinfonet.resstore.loader.CatalogID;
import com.jinfonet.resstore.loader.CatalogIDImpl;
import com.jinfonet.resstore.loader.ReportID;
import com.jinfonet.resstore.loader.ReportIDImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jet.cs.CSUtil;
import jet.server.ServerEnv;
import jet.server.api.admin.cfg.OrgConfiguration;
import jet.server.api.http.HttpUtil;
import jet.server.db.cfg.PropsTable;
import jet.server.jrc.ConcurrentReportManager;
import jet.server.jrc.JRTaskManager;
import jet.server.jrc.resource.ResourceTreeManagerImpl;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.jrc.version.SimpleVersionInfo;
import jet.server.jrserver.JRRptServer;
import jet.server.jrserver.JRUserSessionManager;
import jet.server.jrserver.cfg.JROrgConfigurationDefault;
import jet.server.log.ServiceLogger;
import jet.server.resstore.ServerResourceStoreFactory;
import jet.server.resstore.impl.JRServerResourceStore;
import jet.server.util.ResourceConvertor;

public class JROrgConfiguration
implements OrgConfiguration {
    private static final String SEDU = "preload.catalogs";
    private static final String add = "preload.reports";
    private static final String append = ",";
    private String ceil;
    private String compile;
    private PropsTable equals;
    private Properties getActiveRealm = new Properties();
    private JROrgConfigurationDefault getBoolean;
    private JRUserSessionManager getCatRealPath;
    private ConcurrentReportManager getCatalogLoader;

    public JROrgConfiguration(String string, PropsTable propsTable, JROrgConfigurationDefault jROrgConfigurationDefault) {
        this.ceil = string;
        this.compile = "organization_config.properties_" + string;
        this.getBoolean = jROrgConfigurationDefault;
        this.equals = propsTable;
        this.loadProperties();
    }

    private JRUserSessionManager SEDU() {
        if (this.getCatRealPath == null) {
            this.getCatRealPath = (JRUserSessionManager)HttpUtil.getHttpRptServer().getUserSessionManager();
        }
        return this.getCatRealPath;
    }

    private ConcurrentReportManager add() {
        if (this.getCatalogLoader == null) {
            JRTaskManager jRTaskManager = (JRTaskManager)((JRRptServer)((Object)HttpUtil.getHttpRptServer())).getTaskManager();
            this.getCatalogLoader = jRTaskManager.getConcurrentReportManager();
        }
        return this.getCatalogLoader;
    }

    public void loadProperties() {
        try {
            this.getActiveRealm = this.equals.queryProp(this.compile);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception, 3);
        }
    }

    @Override
    public void setProperty(String string, String string2) {
        block30: {
            JRServerResourceStore jRServerResourceStore = ServerResourceStoreFactory.getInstance().getResourceStore(this.ceil);
            try {
                if ("Concurrent_Users".equals(string)) {
                    int n = Integer.parseInt(string2);
                    if (n < 1) {
                        throw new IllegalArgumentException();
                    }
                    break block30;
                }
                if ("Concurrent_Reports".equals(string)) {
                    int n = Integer.parseInt(string2);
                    if (n < 1) {
                        throw new IllegalArgumentException();
                    }
                    break block30;
                }
                if ("Maximum_Disk_Size".equals(string)) {
                    int n = Integer.parseInt(string2);
                    if (n < 1) {
                        throw new IllegalArgumentException();
                    }
                    jRServerResourceStore.getDiskStore().getSpaceAllocator().setMaxSpace((long)n * 0x40000000L);
                    break block30;
                }
                if ("Maximum_Memory_Size".equals(string)) {
                    int n = Integer.parseInt(string2);
                    if (n < 1) {
                        throw new IllegalArgumentException();
                    }
                    jRServerResourceStore.getMemoryStore().getSpaceAllocator().setMaxSpace((long)n * 0x40000000L);
                    break block30;
                }
                if ("Enable_cache_catalogs".equals(string)) {
                    boolean bl = CSUtil.getBoolean(string2);
                    jRServerResourceStore.getMemoryStore().getCatalogLoader().setCacheEnabled(bl);
                    break block30;
                }
                if ("Maximum_cache_catalog_size".equals(string)) {
                    int n = Integer.parseInt(string2);
                    if (n < 0) {
                        throw new IllegalArgumentException();
                    }
                    jRServerResourceStore.getMemoryStore().getCatalogLoader().setMaxSpace((long)n * 0x100000L);
                    break block30;
                }
                if ("Enable_cache_reports".equals(string)) {
                    boolean bl = CSUtil.getBoolean(string2);
                    jRServerResourceStore.getMemoryStore().getReportLoader().setCacheEnabled(bl);
                    break block30;
                }
                if ("Maximum_cache_report_size".equals(string)) {
                    int n = Integer.parseInt(string2);
                    if (n < 0) {
                        throw new IllegalArgumentException();
                    }
                    jRServerResourceStore.getMemoryStore().getReportLoader().setMaxSpace((long)n * 0x100000L);
                    break block30;
                }
                if ("Enable_cache_images".equals(string)) {
                    boolean bl = CSUtil.getBoolean(string2);
                    jRServerResourceStore.getMemoryStore().getImageLoader().setCacheEnabled(bl);
                    break block30;
                }
                if ("Maximum_cache_image_size".equals(string)) {
                    int n = Integer.parseInt(string2);
                    if (n < 0) {
                        throw new IllegalArgumentException();
                    }
                    jRServerResourceStore.getMemoryStore().getImageLoader().setMaxSpace((long)n * 0x100000L);
                    break block30;
                }
                if ("Maximum_report_data_size".equals(string)) {
                    long l = Long.parseLong(string2);
                    if (l < 0L) {
                        throw new IllegalArgumentException();
                    }
                    jRServerResourceStore.getMemoryStore().getCrdCache().setMaxMemorySize(l * 0x100000L);
                    break block30;
                }
                if ("Maximum_cube_size".equals(string)) {
                    long l = Long.parseLong(string2);
                    if (l < 0L) {
                        throw new IllegalArgumentException();
                    }
                    jRServerResourceStore.getMemoryStore().getCubeSpaceAllocator().setMaxSpace(l * 0x100000L);
                    break block30;
                }
                if ("Compress_Swap_Files".equals(string) || SEDU.equals(string) || add.equals(string)) break block30;
                if ("cache.catalogs.maxsize".equals(string)) {
                    int n = Integer.parseInt(string2);
                    if (n < 0) {
                        throw new IllegalArgumentException();
                    }
                    jRServerResourceStore.getMemoryStore().getCatalogLoader().setMaxSize(n);
                    break block30;
                }
                if ("cache.reports.maxsize".equals(string)) {
                    int n = Integer.parseInt(string2);
                    if (n < 0) {
                        throw new IllegalArgumentException();
                    }
                    jRServerResourceStore.getMemoryStore().getReportLoader().setMaxSize(n);
                    break block30;
                }
                return;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(numberFormatException);
            }
        }
        try {
            String string3 = (String)this.getActiveRealm.setProperty(string, string2);
            if (!string2.equals(string3)) {
                this.equals.updateProp(this.compile, string, string2);
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    @Override
    public int getMaxConcurrentUsers() {
        return CSUtil.parseInt(this.getActiveRealm.getProperty("Concurrent_Users"), this.getBoolean.getMaxConcurrentUsers());
    }

    @Override
    public int getMaxConcurrentReports() {
        return CSUtil.parseInt(this.getActiveRealm.getProperty("Concurrent_Reports"), this.getBoolean.getMaxConcurrentReports());
    }

    @Override
    public int getMaxDiskSpace() {
        return CSUtil.parseInt(this.getActiveRealm.getProperty("Maximum_Disk_Size"), this.getBoolean.getMaxDiskSpace());
    }

    @Override
    public int getMaxMemorySpace() {
        return CSUtil.parseInt(this.getActiveRealm.getProperty("Maximum_Memory_Size"), this.getBoolean.getMaxMemorySpace());
    }

    @Override
    public boolean isEnabledCacheCatalogs() {
        return CSUtil.getBoolean(this.getActiveRealm.getProperty("Enable_cache_catalogs"), this.getBoolean.isEnabledCacheCatalogs());
    }

    @Override
    public int getMaxCacheCatalogsSize() {
        return CSUtil.parseInt(this.getActiveRealm.getProperty("Maximum_cache_catalog_size"), this.getBoolean.getMaxCacheCatalogsSize());
    }

    @Override
    public boolean isEnabledCacheReports() {
        return CSUtil.getBoolean(this.getActiveRealm.getProperty("Enable_cache_reports"), this.getBoolean.isEnabledCacheReports());
    }

    @Override
    public int getMaxCacheReportsSpace() {
        return CSUtil.parseInt(this.getActiveRealm.getProperty("Maximum_cache_report_size"), this.getBoolean.getMaxCacheReportsSpace());
    }

    @Override
    public boolean isEnabledCacheImages() {
        return CSUtil.getBoolean(this.getActiveRealm.getProperty("Enable_cache_images"), this.getBoolean.isEnabledCacheImages());
    }

    @Override
    public int getMaxCacheImagesSpace() {
        return CSUtil.parseInt(this.getActiveRealm.getProperty("Maximum_cache_image_size"), this.getBoolean.getMaxCacheImagesSpace());
    }

    @Override
    public int getMaxReportDataSpace() {
        return CSUtil.parseInt(this.getActiveRealm.getProperty("Maximum_report_data_size"), this.getBoolean.getMaxReportDataSpace());
    }

    @Override
    public int getMaxCubeSpace() {
        return CSUtil.parseInt(this.getActiveRealm.getProperty("Maximum_cube_size"), this.getBoolean.getMaxCubeSpace());
    }

    @Override
    public boolean isCompressSwapFiles() {
        return CSUtil.getBoolean(this.getActiveRealm.getProperty("Compress_Swap_Files"), this.getBoolean.isCompressSwapFiles());
    }

    @Override
    public int getCurConcurrentUsers() {
        if (this.SEDU() != null) {
            return this.getCatRealPath.getUserSessionNumberByOrg(this.ceil);
        }
        return 0;
    }

    @Override
    public int getCurConcurrentReports() {
        if (this.add() != null) {
            return this.getCatalogLoader.getCurrentReportsByOrg(this.ceil);
        }
        return 0;
    }

    @Override
    public int getCurDiskSpace() {
        int n = (int)Math.ceil((double)ServerResourceStoreFactory.getInstance().getResourceStore(this.ceil).getDiskStore().getSpaceAllocator().getUsedSpace() / 1.073741824E9);
        return n;
    }

    @Override
    public int getCurMemorySpace() {
        int n = (int)Math.ceil((double)ServerResourceStoreFactory.getInstance().getResourceStore(this.ceil).getMemoryStore().getSpaceAllocator().getUsedSpace() / 1.073741824E9);
        return n;
    }

    public List getPreloadCatalogsName() {
        return this.append(this.getActiveRealm.getProperty(SEDU));
    }

    public void setPreloadCatalogsName(List list) {
        this.setProperty(SEDU, this.ceil(list));
    }

    public List getPreloadReportsName() {
        return this.append(this.getActiveRealm.getProperty(add));
    }

    public void setPreloadReportsName(List list) {
        this.setProperty(add, this.ceil(list));
    }

    private List append(String string) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null || string.trim().isEmpty()) {
            return arrayList;
        }
        for (String string2 : stringArray = string.split(append, -1)) {
            if (string2.trim().isEmpty()) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    private String ceil(List list) {
        StringBuilder stringBuilder = new StringBuilder();
        if (list != null) {
            for (String string : list) {
                stringBuilder.append(string).append(append);
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public int getMaxCachedCatalogSize() {
        return CSUtil.parseInt(this.getActiveRealm.getProperty("cache.catalogs.maxsize"), this.getBoolean.getMaxCachedCatalogSize());
    }

    public List getCachedCatalogs() {
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = ServerResourceStoreFactory.getInstance().getResourceStore(this.ceil).getMemoryStore().getCatalogLoader().getKeys();
        ResourceTreeManagerImpl resourceTreeManagerImpl = UserDataToolkit.getResourceManager(ServerEnv.getActiveRealm());
        for (CatalogID catalogID : list) {
            SimpleVersionInfo simpleVersionInfo = resourceTreeManagerImpl == null ? null : resourceTreeManagerImpl.getResourceVersionByDiskPath(catalogID.getFile().toString());
            String string = simpleVersionInfo == null ? catalogID.getFile().toString() : simpleVersionInfo.getResourcePath() + "-V" + simpleVersionInfo.getVersionNumber();
            arrayList.add(string);
        }
        return arrayList;
    }

    @Override
    public void setCachedCatalog(String string, String string2, boolean bl) {
        try {
            File file = new File(ResourceConvertor.getInstance().getCatRealPath(string, string2));
            if (bl) {
                ServerResourceStoreFactory.getInstance().getResourceStore(this.ceil).getMemoryStore().loadCatalog(file);
            } else {
                ServerResourceStoreFactory.getInstance().getResourceStore(this.ceil).getMemoryStore().getCatalogLoader().remove((Object)new CatalogIDImpl(file));
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    @Override
    public int getMaxCachedReportSize() {
        return CSUtil.parseInt(this.getActiveRealm.getProperty("cache.reports.maxsize"), this.getBoolean.getMaxCachedReportSize());
    }

    public List getCachedReports() {
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = ServerResourceStoreFactory.getInstance().getResourceStore(this.ceil).getMemoryStore().getReportLoader().getKeys();
        ResourceTreeManagerImpl resourceTreeManagerImpl = UserDataToolkit.getResourceManager(ServerEnv.getActiveRealm());
        for (ReportID reportID : list) {
            String string;
            SimpleVersionInfo simpleVersionInfo = resourceTreeManagerImpl == null ? null : resourceTreeManagerImpl.getResourceVersionByDiskPath(reportID.getFile().toString());
            String string2 = string = simpleVersionInfo == null ? reportID.getFile().toString() : simpleVersionInfo.getResourcePath() + "-V" + simpleVersionInfo.getVersionNumber();
            if (reportID.getStyleGroup() != null) {
                string = string + "(" + reportID.getStyleGroup() + ")";
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    @Override
    public void setCachedReport(String string, String string2, boolean bl) {
        try {
            String string3 = ResourceConvertor.getInstance().getRptRealPath(string, string2);
            Pattern pattern = Pattern.compile("^(.*)\\((.*)\\)$");
            Matcher matcher = pattern.matcher(string3);
            File file = null;
            String string4 = null;
            if (matcher.matches()) {
                file = new File(matcher.group(1));
                string4 = matcher.group(2);
            } else {
                file = new File(string3);
            }
            if (bl) {
                ServerResourceStoreFactory.getInstance().getResourceStore(this.ceil).getMemoryStore().loadReport(file, string4, null);
            } else {
                ServerResourceStoreFactory.getInstance().getResourceStore(this.ceil).getMemoryStore().getReportLoader().remove((Object)new ReportIDImpl(file, string4, null));
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }
}

