/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver.cfg.logger;

import jet.JSvrResource;
import jet.server.api.admin.cfg.logger.ConfigAppender;
import jet.server.api.admin.cfg.logger.ConfigLogger;
import jet.server.jrserver.cfg.logger.JRConfigAppender;
import jet.server.jrserver.cfg.logger.JRConfigConsoleAppender;
import jet.server.jrserver.cfg.logger.JRConfigDailyRollingFileAppender;
import jet.server.jrserver.cfg.logger.JRConfigFileAppender;
import jet.server.jrserver.cfg.logger.JRConfigNTLogAppender;
import jet.server.jrserver.cfg.logger.JRConfigRollingFileAppender;
import jet.server.jrserver.cfg.logger.JRConfigSocketAppender;
import jet.server.jrserver.cfg.logger.JRConfigSysLogAppender;
import jet.server.jrserver.cfg.logger.JRConfigTelnetAppender;
import jet.server.log.JRLoggerConfigService;
import jet.server.log.LogConfigFactory;

public class JRConfigLogger
implements ConfigLogger {
    private int DST_NAMES;
    private String LOG_FULL_NAMES;
    private String LOG_NAMES;
    private ConfigAppender[] SEDU;

    public JRConfigLogger(String string, String string2) {
        this.LOG_FULL_NAMES = string;
        this.DST_NAMES = this.LOG_FULL_NAMES();
        this.LOG_NAMES = string2;
    }

    @Override
    public String getName() {
        return this.LOG_FULL_NAMES;
    }

    @Override
    public String getDescription() {
        return this.LOG_NAMES;
    }

    @Override
    public String getLevel() {
        String string = JRLoggerConfigService.instance().getConfigFile().getValue(this.getLevelKey());
        if (string == null) {
            return null;
        }
        int n = (string = string.trim()).indexOf(",");
        if (n > 0) {
            return string.substring(0, n).trim();
        }
        return "ALL";
    }

    @Override
    public void setLevel(String string) {
        if (string != null) {
            String string2 = this.getLevelKey();
            String string3 = JRLoggerConfigService.instance().getConfigFile().getValue(string2);
            if (string3 == null) {
                return;
            }
            int n = string3.indexOf(",");
            string = string + string3.substring(n);
            JRLoggerConfigService.instance().getConfigFile().setValue(string2, string);
        }
    }

    @Override
    public String getErrorLevel() {
        String string = JRLoggerConfigService.instance().getConfigFile().getValue(this.getErrorLevelKey());
        if (string == null) {
            return null;
        }
        return string.trim().toUpperCase();
    }

    @Override
    public String getTraceLevel() {
        String string = JRLoggerConfigService.instance().getConfigFile().getValue(this.getTraceLevelKey());
        if (string == null) {
            return null;
        }
        return string.trim().toUpperCase();
    }

    @Override
    public void setErrorLevel(String string) {
        if (string != null) {
            JRLoggerConfigService.instance().getConfigFile().setValue(this.getErrorLevelKey(), string);
        }
    }

    @Override
    public void setTraceLevel(String string) {
        if (string != null) {
            JRLoggerConfigService.instance().getConfigFile().setValue(this.getTraceLevelKey(), string);
        }
    }

    String getLevelKey() {
        return "log4j.logger." + LogConfigFactory.LOG_FULL_NAMES[this.DST_NAMES];
    }

    String getErrorLevelKey() {
        return "errorLevel." + LogConfigFactory.LOG_FULL_NAMES[this.DST_NAMES];
    }

    String getTraceLevelKey() {
        return "traceLevel." + LogConfigFactory.LOG_FULL_NAMES[this.DST_NAMES];
    }

    @Override
    public boolean isAdditivity() {
        String string = JRLoggerConfigService.instance().getConfigFile().getValue(this.DST_NAMES());
        return string != null && string.equalsIgnoreCase("true");
    }

    @Override
    public void setAdditivity(boolean bl) {
        JRLoggerConfigService.instance().getConfigFile().setValue(this.DST_NAMES(), String.valueOf(bl));
    }

    private String DST_NAMES() {
        return "log4j.additivity." + LogConfigFactory.LOG_FULL_NAMES[this.DST_NAMES];
    }

    @Override
    public ConfigAppender[] getAppenders() {
        if (this.SEDU == null) {
            this.SEDU = new ConfigAppender[LogConfigFactory.DST_NAMES.length];
            this.SEDU[0] = new JRConfigFileAppender(this, LogConfigFactory.DST_NAMES[0]);
            this.SEDU[1] = new JRConfigRollingFileAppender(this, LogConfigFactory.DST_NAMES[1]);
            this.SEDU[2] = new JRConfigDailyRollingFileAppender(this, LogConfigFactory.DST_NAMES[2]);
            this.SEDU[3] = new JRConfigSocketAppender(this, LogConfigFactory.DST_NAMES[3]);
            this.SEDU[4] = new JRConfigNTLogAppender(this, LogConfigFactory.DST_NAMES[4]);
            this.SEDU[5] = new JRConfigSysLogAppender(this, LogConfigFactory.DST_NAMES[5]);
            this.SEDU[6] = new JRConfigAppender(this, LogConfigFactory.DST_NAMES[6]);
            this.SEDU[7] = new JRConfigTelnetAppender(this, LogConfigFactory.DST_NAMES[7]);
            this.SEDU[8] = new JRConfigConsoleAppender(this, LogConfigFactory.DST_NAMES[8]);
        }
        return this.SEDU;
    }

    private int LOG_FULL_NAMES() {
        for (int i = 0; i < LogConfigFactory.LOG_NAMES.length; ++i) {
            if (!LogConfigFactory.LOG_NAMES[i].equals(this.LOG_FULL_NAMES)) continue;
            return i;
        }
        throw new IllegalArgumentException(JSvrResource.getMessage("LOGGING_M_00010", "[name=" + this.LOG_FULL_NAMES + "]"));
    }
}

