/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver.dynamiccon;

import jet.cs.util.APIEnums;
import jet.server.api.admin.DynamicConnectionRecord;
import jet.server.api.admin.DynamicConnectionUserMapping;
import jet.server.api.dynamiccon.DynamicConnection;

class AdapterRecordDynamicConnection
implements DynamicConnection {
    private static final String SEDU = "-";
    private DynamicConnectionRecord append;
    private DynamicConnectionUserMapping getDatabasePassword;
    private String getDatabaseUser;

    static String makeConnectionId(int n, APIEnums.PrincipalType principalType, String string) {
        return n + SEDU + principalType.name() + SEDU + string;
    }

    static Object[] parseConnectionId(String string) {
        if (string == null) {
            return null;
        }
        try {
            String[] stringArray = string.split(SEDU, 3);
            int n = Integer.parseInt(stringArray[0]);
            APIEnums.PrincipalType principalType = APIEnums.PrincipalType.valueOf(stringArray[1]);
            String string2 = stringArray[2];
            return new Object[]{n, principalType, string2};
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public AdapterRecordDynamicConnection(DynamicConnectionRecord dynamicConnectionRecord, DynamicConnectionUserMapping dynamicConnectionUserMapping) {
        this.append = dynamicConnectionRecord;
        this.getDatabasePassword = dynamicConnectionUserMapping;
        this.getDatabaseUser = AdapterRecordDynamicConnection.makeConnectionId(dynamicConnectionRecord.getRecordId(), dynamicConnectionUserMapping.getPrincipalType(), dynamicConnectionUserMapping.getPrincipal());
    }

    @Override
    public String getDynamicConnectionId() {
        return this.getDatabaseUser;
    }

    @Override
    public String getDatabaseUser() {
        return this.getDatabasePassword != null && this.getDatabasePassword.getDatabaseUser() != null ? this.getDatabasePassword.getDatabaseUser() : this.append.getDatabaseUser();
    }

    @Override
    public String getDatabasePassword() {
        return this.getDatabasePassword != null && this.getDatabasePassword.getDatabasePassword() != null ? this.getDatabasePassword.getDatabasePassword() : this.append.getDatabasePassword();
    }

    @Override
    public String getName() {
        return this.append.getName();
    }

    @Override
    public String getDescription() {
        return this.append.getDescription();
    }

    @Override
    public Boolean isJndiDatasource() {
        return this.append.isJndiDatasource();
    }

    @Override
    public String getJndiDatasourceName() {
        return this.append.getJndiDatasourceName();
    }

    @Override
    public String getURL() {
        return this.append.getURL();
    }

    @Override
    public String getJdbcDriver() {
        return this.append.getJdbcDriver();
    }

    @Override
    public String getDateFormat() {
        return this.append.getDateFormat();
    }

    @Override
    public APIEnums.ConnectionNamePattern getNamePattern() {
        return this.append.getNamePattern();
    }

    @Override
    public APIEnums.ConnectionReadOnly getReadOnly() {
        return this.append.getReadOnly();
    }

    @Override
    public String getTimeFormat() {
        return this.append.getTimeFormat();
    }

    @Override
    public String getTimestampFormat() {
        return this.append.getTimestampFormat();
    }

    @Override
    public APIEnums.ConnectionTransactionIsolation getTransactionIsolation() {
        return this.append.getTransactionIsolation();
    }

    @Override
    public String getExtraCharacters() {
        return this.append.getExtraCharacters();
    }

    @Override
    public String getQuoteCharacter() {
        return this.append.getQuoteCharacter();
    }
}

