/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver.dynamiccon;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jet.cs.CSUtil;
import jet.cs.util.APIEnums;
import jet.server.ServerEnv;
import jet.server.api.RptServerException;
import jet.server.api.admin.DynamicConnectionManager;
import jet.server.api.admin.DynamicConnectionRecord;
import jet.server.api.admin.DynamicConnectionUserMapping;
import jet.server.api.dynamiccon.DynamicConnection;
import jet.server.api.dynamiccon.DynamicConnectionProvider;
import jet.server.api.exception.NoSuchUserException;
import jet.server.intf.security.SecurityService;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.jrserver.dynamiccon.AdapterRecordDynamicConnection;
import jet.server.log.ServiceLogger;

class DefaultDynamicConnectionProvider
implements DynamicConnectionProvider {
    private DynamicConnectionManager GROUP;
    private SecurityService ROLE;

    public DefaultDynamicConnectionProvider(DynamicConnectionManager dynamicConnectionManager) {
        this.GROUP = dynamicConnectionManager;
        this.ROLE = UserDataToolkit.getSecurityService(ServerEnv.getActiveRealm());
    }

    @Override
    public DynamicConnection[] getAvailableDynamicConnections(String string, String string2, String string3, String string4, DynamicConnection dynamicConnection) {
        try {
            List<DynamicConnectionRecord> list = this.GROUP.getDynamicConnections(string, string3, string4, CSUtil.getPrincipalDisplayName(string, string2));
            return this.GROUP(string, string2, list);
        }
        catch (NoSuchUserException noSuchUserException) {
            ServiceLogger.logError((Throwable)((Object)noSuchUserException), 3);
            return null;
        }
        catch (RptServerException rptServerException) {
            ServiceLogger.logError((Throwable)((Object)rptServerException), 3);
            return null;
        }
    }

    @Override
    public DynamicConnection[] getAvailableDynamicConnections(String string, String string2, String string3, String string4, String string5, DynamicConnection dynamicConnection) {
        try {
            List<DynamicConnectionRecord> list = this.GROUP.getDynamicConnections(string, string3, string4, string5, CSUtil.getPrincipalDisplayName(string, string2));
            return this.GROUP(string, string2, list);
        }
        catch (NoSuchUserException noSuchUserException) {
            ServiceLogger.logError((Throwable)((Object)noSuchUserException), 3);
            return null;
        }
        catch (RptServerException rptServerException) {
            ServiceLogger.logError((Throwable)((Object)rptServerException), 3);
            return null;
        }
    }

    @Override
    public DynamicConnection getDynamicConnection(String string, String string2, String string3, String string4, DynamicConnection dynamicConnection, String string5) {
        try {
            List<DynamicConnectionRecord> list = this.GROUP.getDynamicConnections(string, string3, string4, CSUtil.getPrincipalDisplayName(string, string2));
            Object[] objectArray = AdapterRecordDynamicConnection.parseConnectionId(string5);
            if (objectArray != null) {
                int n = (Integer)objectArray[0];
                APIEnums.PrincipalType principalType = (APIEnums.PrincipalType)((Object)objectArray[1]);
                String string6 = (String)objectArray[2];
                for (DynamicConnectionRecord dynamicConnectionRecord : list) {
                    if (dynamicConnectionRecord.getRecordId() != n) continue;
                    for (DynamicConnectionUserMapping dynamicConnectionUserMapping : dynamicConnectionRecord.getUserMapping()) {
                        if (dynamicConnectionUserMapping.getPrincipalType() != principalType || !string6.equals(dynamicConnectionUserMapping.getPrincipal())) continue;
                        return new AdapterRecordDynamicConnection(dynamicConnectionRecord, dynamicConnectionUserMapping);
                    }
                }
            }
            if (string5 != null || !ServerEnv.needSecurity()) {
                return null;
            }
            DynamicConnection[] dynamicConnectionArray = this.GROUP(string, string2, list);
            return dynamicConnectionArray == null ? null : dynamicConnectionArray[0];
        }
        catch (RptServerException rptServerException) {
            ServiceLogger.logError((Throwable)((Object)rptServerException), 3);
            return null;
        }
        catch (NoSuchUserException noSuchUserException) {
            ServiceLogger.logError((Throwable)((Object)noSuchUserException), 3);
            return null;
        }
    }

    @Override
    public DynamicConnection getDynamicConnection(String string, String string2, String string3, String string4, String string5, DynamicConnection dynamicConnection, String string6) {
        try {
            List<DynamicConnectionRecord> list = this.GROUP.getDynamicConnections(string, string3, string4, string5, CSUtil.getPrincipalDisplayName(string, string2));
            Object[] objectArray = AdapterRecordDynamicConnection.parseConnectionId(string6);
            if (objectArray != null) {
                int n = (Integer)objectArray[0];
                APIEnums.PrincipalType principalType = (APIEnums.PrincipalType)((Object)objectArray[1]);
                String string7 = (String)objectArray[2];
                for (DynamicConnectionRecord dynamicConnectionRecord : list) {
                    if (dynamicConnectionRecord.getRecordId() != n) continue;
                    for (DynamicConnectionUserMapping dynamicConnectionUserMapping : dynamicConnectionRecord.getUserMapping()) {
                        if (dynamicConnectionUserMapping.getPrincipalType() != principalType || !string7.equals(dynamicConnectionUserMapping.getPrincipal())) continue;
                        return new AdapterRecordDynamicConnection(dynamicConnectionRecord, dynamicConnectionUserMapping);
                    }
                }
            }
            if (string6 != null || !ServerEnv.needSecurity()) {
                return null;
            }
            DynamicConnection[] dynamicConnectionArray = this.GROUP(string, string2, list);
            return dynamicConnectionArray == null ? null : dynamicConnectionArray[0];
        }
        catch (RptServerException rptServerException) {
            ServiceLogger.logError((Throwable)((Object)rptServerException), 3);
            return null;
        }
        catch (NoSuchUserException noSuchUserException) {
            ServiceLogger.logError((Throwable)((Object)noSuchUserException), 3);
            return null;
        }
    }

    private DynamicConnection[] GROUP(String string, String string2, List list) throws NoSuchUserException {
        Object object22;
        String string3 = CSUtil.getPrincipalDisplayName(string, string2);
        ArrayList<AdapterRecordDynamicConnection> arrayList = new ArrayList<AdapterRecordDynamicConnection>();
        block0: for (Object object22 : list) {
            for (DynamicConnectionUserMapping object3 : ((DynamicConnectionRecord)object22).getUserMapping()) {
                if (object3.getPrincipalType() != APIEnums.PrincipalType.USER || !string3.equals(object3.getPrincipal())) continue;
                arrayList.add(new AdapterRecordDynamicConnection((DynamicConnectionRecord)object22, object3));
                continue block0;
            }
        }
        if (!arrayList.isEmpty()) {
            return arrayList.toArray(new DynamicConnection[0]);
        }
        List list2 = this.ROLE.getAllParentGroupsNameByUser(string3);
        block2: for (Iterator iterator : list) {
            for (DynamicConnectionUserMapping dynamicConnectionUserMapping : ((DynamicConnectionRecord)((Object)iterator)).getUserMapping()) {
                if (dynamicConnectionUserMapping.getPrincipalType() != APIEnums.PrincipalType.GROUP || !list2.contains(dynamicConnectionUserMapping.getPrincipal())) continue;
                arrayList.add(new AdapterRecordDynamicConnection((DynamicConnectionRecord)((Object)iterator), dynamicConnectionUserMapping));
                continue block2;
            }
        }
        if (!arrayList.isEmpty()) {
            return arrayList.toArray(new DynamicConnection[0]);
        }
        object22 = this.ROLE.getAllParentRolesNameByUser(string3);
        block4: for (DynamicConnectionRecord dynamicConnectionRecord : list) {
            for (DynamicConnectionUserMapping dynamicConnectionUserMapping : dynamicConnectionRecord.getUserMapping()) {
                if (dynamicConnectionUserMapping.getPrincipalType() != APIEnums.PrincipalType.ROLE || !object22.contains(dynamicConnectionUserMapping.getPrincipal())) continue;
                arrayList.add(new AdapterRecordDynamicConnection(dynamicConnectionRecord, dynamicConnectionUserMapping));
                continue block4;
            }
        }
        if (!arrayList.isEmpty()) {
            return arrayList.toArray(new DynamicConnection[0]);
        }
        return null;
    }
}

