/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver.ibus;

import com.jinfonet.ibus.InformationBus;
import com.jinfonet.ibus.InformationContainer;
import java.util.Hashtable;
import jet.cs.CSUtil;
import jet.server.intf.security.ExSecurityData;
import jet.server.intf.security.SecurityService;
import jet.server.jrc.security.ExCachedSecurityDataImpl;
import jet.server.jrserver.ibus.JRInformationContainer;
import jet.server.log.ServiceLogger;

public class JRInformationBus
implements InformationBus {
    private SecurityService SEDU;
    private ExSecurityData append;
    private Hashtable containsKey;
    private Hashtable equals;
    private Hashtable get;
    private String getOrganization;
    private String getOrganizationInformationContainer;
    private InformationContainer getUser;
    private Hashtable getUserInformationContainer;
    private Hashtable isAdminUser;

    public JRInformationBus(SecurityService securityService, ExSecurityData exSecurityData, Hashtable hashtable, Hashtable hashtable2, Hashtable hashtable3, String string, InformationContainer informationContainer, Hashtable hashtable4, Hashtable hashtable5) {
        this.SEDU = securityService;
        this.append = exSecurityData;
        this.containsKey = hashtable;
        this.equals = hashtable2;
        this.get = hashtable3;
        this.getOrganization = string;
        String[] stringArray = CSUtil.parsePrincipalDisplayName(string);
        this.getOrganizationInformationContainer = stringArray[0] == null ? "" : stringArray[0];
        this.getUser = informationContainer;
        this.getUserInformationContainer = hashtable4;
        this.isAdminUser = hashtable5;
    }

    @Override
    public synchronized InformationContainer getGlobalInformationContainer() {
        if (null == this.append.getUser(this.getOrganization)) {
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException("Failed to get global InformationContainer for user: [" + this.getOrganization + "], there is no the user in JReport server.");
            ServiceLogger.logError(unsupportedOperationException);
            throw unsupportedOperationException;
        }
        return this.getUser;
    }

    @Override
    public InformationContainer getOrganizationInformationContainer() {
        return this.getOrganizationInformationContainer(this.getOrganizationInformationContainer);
    }

    @Override
    public synchronized InformationContainer getOrganizationInformationContainer(String string) throws UnsupportedOperationException {
        if (!this.getOrganizationInformationContainer.equals(string) && !this.SEDU.isAdminUser(this.getOrganization)) {
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException("The user [" + this.getOrganization + "] is not admin user, can not get organization container of organization [" + string + "].");
            ServiceLogger.logError(unsupportedOperationException);
            throw unsupportedOperationException;
        }
        if (null == ((ExCachedSecurityDataImpl)this.append).getOrganization(string) && !"".equals(string)) {
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException("Failed to get InformationContainer for organization: [" + string + "], there is no the organization in JReport server, user=[" + this.getOrganization + "].");
            ServiceLogger.logError(unsupportedOperationException);
            throw unsupportedOperationException;
        }
        if (this.getUserInformationContainer.containsKey(string)) {
            return (InformationContainer)this.getUserInformationContainer.get(string);
        }
        if (this.containsKey.containsKey(string)) {
            this.getUserInformationContainer.put(string, this.containsKey.get(string));
            return (InformationContainer)this.getUserInformationContainer.get(string);
        }
        try {
            JRInformationContainer jRInformationContainer = new JRInformationContainer(string + "#Organization");
            this.getUserInformationContainer.put(string, jRInformationContainer);
            this.containsKey.put(string, jRInformationContainer);
            return jRInformationContainer;
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException("Failed to create InformationContainer for organization: " + string + ", user=" + this.getOrganization + ".");
            ServiceLogger.logError(unsupportedOperationException);
            throw unsupportedOperationException;
        }
    }

    @Override
    public InformationContainer getUserInformationContainer() {
        return this.getUserInformationContainer(this.getOrganization);
    }

    @Override
    public synchronized InformationContainer getUserInformationContainer(String string) throws UnsupportedOperationException {
        String string2;
        String[] stringArray = CSUtil.parsePrincipalDisplayName(string);
        String string3 = string2 = stringArray[0] == null ? "" : stringArray[0];
        if (!(this.getOrganization.equals(string) || this.SEDU.isAdminUser(this.getOrganization) || this.SEDU.isOrganizationAdminUser(this.getOrganization) && this.getOrganizationInformationContainer.equals(string2))) {
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException("The user [" + this.getOrganization + "] is not admin user or organization admin user, user=[" + string + "].");
            ServiceLogger.logError(unsupportedOperationException);
            throw unsupportedOperationException;
        }
        if (null == this.append.getUser(string)) {
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException("Failed to get InformationContainer for user: [" + string + "], there is no the user in JReport server, userId=[" + this.getOrganization + "].");
            ServiceLogger.logError(unsupportedOperationException);
            throw unsupportedOperationException;
        }
        if (this.isAdminUser.containsKey(string)) {
            return (InformationContainer)this.isAdminUser.get(string);
        }
        if (this.equals.containsKey(string)) {
            this.isAdminUser.put(string, this.equals.get(string));
            return (InformationContainer)this.isAdminUser.get(string);
        }
        try {
            JRInformationContainer jRInformationContainer = new JRInformationContainer(string + "#User");
            this.isAdminUser.put(string, jRInformationContainer);
            this.equals.put(string, jRInformationContainer);
            if (!this.get.containsKey(string2)) {
                this.get.put(string2, new Hashtable());
            }
            ((Hashtable)this.get.get(string2)).put(string, jRInformationContainer);
            return jRInformationContainer;
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException("Failed to create InformationContainer for user: " + string + ", userId=" + this.getOrganization + ".");
            ServiceLogger.logError(unsupportedOperationException);
            throw unsupportedOperationException;
        }
    }
}

