/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver.ibus;

import com.jinfonet.ibus.InformationBus;
import com.jinfonet.ibus.InformationBusManager;
import com.jinfonet.ibus.InformationContainer;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import jet.cs.CSUtil;
import jet.server.event.EventHandler;
import jet.server.event.TopicEvent;
import jet.server.intf.security.ExSecurityData;
import jet.server.intf.security.PrincipalListener;
import jet.server.intf.security.SecurityService;
import jet.server.jrserver.ibus.JRInformationBus;
import jet.server.jrserver.ibus.JRInformationContainer;
import jet.server.log.ServiceLogger;

public class JRInformationBusManagerImpl
implements InformationBusManager,
EventHandler,
PrincipalListener {
    private SecurityService SEDU;
    private ExSecurityData append;
    private JRInformationContainer containsKey;
    private Hashtable equals = new Hashtable();
    private Hashtable expire = new Hashtable();
    private Hashtable get = new Hashtable();
    private Hashtable getData = new Hashtable();
    private IBusExpireThread getProperty;

    public JRInformationBusManagerImpl(SecurityService securityService, ExSecurityData exSecurityData) throws Exception {
        this.SEDU = securityService;
        this.append = exSecurityData;
        this.SEDU();
        this.getProperty = new IBusExpireThread();
        this.getProperty.start();
    }

    private void SEDU() throws Exception {
        this.containsKey = new JRInformationContainer("#Global");
    }

    private synchronized void expire() {
        InformationContainer informationContainer;
        ServiceLogger.logDebug("JRInformationBusManagerImpl::expire: begin...", 7);
        this.containsKey.expire();
        for (String string : this.expire.keySet()) {
            ServiceLogger.logDebug("JRInformationBusManagerImpl::expire: org=" + string, 7);
            informationContainer = (InformationContainer)this.expire.get(string);
            ((JRInformationContainer)informationContainer).expire();
        }
        for (String string : this.get.keySet()) {
            ServiceLogger.logDebug("JRInformationBusManagerImpl::expire: user=" + string, 7);
            informationContainer = (InformationContainer)this.get.get(string);
            ((JRInformationContainer)informationContainer).expire();
        }
        ServiceLogger.logDebug("JRInformationBusManagerImpl::expire: end.", 7);
    }

    public synchronized void synchronizeRemoveUser(String string) {
        ServiceLogger.logDebug("JRInformationBusManagerImpl::synchronizeRemoveUser: userName=" + string, 5);
        if (!this.get.containsKey(string)) {
            ServiceLogger.logDebug("JRInformationBusManagerImpl::synchronizeRemoveUser: There is no user of userName=" + string + " in allUserIContainers, return.", 5);
            return;
        }
        String[] stringArray = CSUtil.parsePrincipalDisplayName(string);
        String string2 = stringArray[0] == null ? "" : stringArray[0];
        this.get.remove(string);
        ((Hashtable)this.getData.get(string2)).remove(string);
        for (String string3 : this.equals.keySet()) {
            String string4;
            stringArray = CSUtil.parsePrincipalDisplayName(string3);
            String string5 = string4 = stringArray[0] == null ? "" : stringArray[0];
            if (this.SEDU.isAdminUser(string3)) {
                ((Hashtable)((Object[])this.equals.get(string3))[2]).remove(string);
                continue;
            }
            if (!this.SEDU.isOrganizationAdminUser(string) || !string2.equals(string4)) continue;
            ((Hashtable)((Object[])this.equals.get(string3))[2]).remove(string);
        }
    }

    private void append(Properties properties) {
        String string = properties.getProperty("security_event_para_organization");
        this.synchronizeRemoveOrganization(string);
    }

    public synchronized void synchronizeRemoveOrganization(String string) {
        ServiceLogger.logDebug("JRInformationBusManagerImpl::synchronizeRemoveOrganization: orgName=" + string, 5);
        if (!this.expire.containsKey(string)) {
            ServiceLogger.logDebug("JRInformationBusManagerImpl::synchronizeRemoveOrganization: There is no org of orgName=" + string + " in allOrgIContainers, return.");
            return;
        }
        this.expire.remove(string);
        for (String string2 : this.equals.keySet()) {
            String string3;
            String[] stringArray = CSUtil.parsePrincipalDisplayName(string2);
            String string4 = string3 = stringArray[0] == null ? "" : stringArray[0];
            if (!this.SEDU.isAdminUser(string2)) continue;
            ((Hashtable)((Object[])this.equals.get(string2))[1]).remove(string);
        }
    }

    @Override
    public synchronized InformationBus getInformationBus(String string) {
        ServiceLogger.logDebug("JRInformationBusManagerImpl::getInformationBus: userID=" + string, 5);
        if (null == this.append.getUser(string)) {
            ServiceLogger.logDebug("JRInformationBusManagerImpl::getInformationBus: userID=" + string + ", no the user in JReport server.", 5);
            return null;
        }
        if (this.equals.containsKey(string)) {
            return (InformationBus)((Object[])this.equals.get(string))[0];
        }
        String[] stringArray = CSUtil.parsePrincipalDisplayName(string);
        String string2 = stringArray[0] == null ? "" : stringArray[0];
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        JRInformationContainer jRInformationContainer = this.containsKey;
        if (this.SEDU.isAdminUser(string)) {
            hashtable.putAll(this.expire);
            hashtable2.putAll(this.get);
        } else if (this.SEDU.isOrganizationAdminUser(string)) {
            if (this.expire.containsKey(string2)) {
                hashtable.put(string2, this.expire.get(string2));
            }
            if (this.getData.containsKey(string2)) {
                hashtable2.putAll((Map)this.getData.get(string2));
            }
        } else {
            if (this.expire.containsKey(string2)) {
                hashtable.put(string2, this.expire.get(string2));
            }
            if (this.get.containsKey(string)) {
                hashtable2.put(string, this.get.get(string));
            }
        }
        JRInformationBus jRInformationBus = new JRInformationBus(this.SEDU, this.append, this.expire, this.get, this.getData, string, jRInformationContainer, hashtable, hashtable2);
        Object[] objectArray = new Object[]{jRInformationBus, hashtable, hashtable2};
        this.equals.put(string, objectArray);
        return jRInformationBus;
    }

    @Override
    public void process(TopicEvent topicEvent) {
        int n = topicEvent.getType();
        switch (n) {
            case 2: {
                Properties properties = (Properties)topicEvent.getData();
                this.containsKey(properties);
                break;
            }
            case 8: {
                Properties properties = (Properties)topicEvent.getData();
                this.append(properties);
                break;
            }
        }
    }

    private void containsKey(Properties properties) {
        String string = properties.getProperty("security_event_para_principal");
        if (string == null) {
            return;
        }
        String string2 = properties.getProperty("security_event_para_principal_type");
        if (string2 == null) {
            return;
        }
        int n = 0;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            ServiceLogger.logError(numberFormatException);
            return;
        }
        switch (n) {
            case 1: {
                this.synchronizeRemoveUser(string);
                break;
            }
        }
    }

    public void destroy() {
        if (null != this.getProperty) {
            this.getProperty.shutdown();
        }
    }

    @Override
    public void removePrincipal(String string, int n) {
        if (n == 1) {
            this.synchronizeRemoveUser(string);
        }
    }

    @Override
    public void addOrganization(String string) {
    }

    @Override
    public void removeOrganization(String string) {
        this.synchronizeRemoveOrganization(string);
    }

    class IBusExpireThread
    extends Thread {
        private boolean SEDU;

        IBusExpireThread() {
            super(Thread.currentThread().getThreadGroup(), "IBusExpireThread");
            this.SEDU = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void shutdown() {
            IBusExpireThread iBusExpireThread = this;
            synchronized (iBusExpireThread) {
                this.SEDU = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean bl = true;
            while (bl) {
                try {
                    Thread.sleep(10000L);
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception);
                }
                IBusExpireThread iBusExpireThread = this;
                synchronized (iBusExpireThread) {
                    bl = !this.SEDU;
                }
                if (!bl) continue;
                JRInformationBusManagerImpl.this.expire();
            }
            ServiceLogger.logDebug("InformationBusManager expire thread " + Thread.currentThread().getName() + " is shutting down.", 6);
        }
    }
}

