/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver.monitor;

import java.util.Properties;
import jet.cs.ExProperties;
import jet.cs.util.APIUtil;
import jet.server.ServerEnv;
import jet.server.api.monitor.FinishedReportTable;
import jet.server.api.monitor.MonitorSetting;
import jet.server.jrserver.monitor.JRMonitorService;
import jet.server.log.ServiceLogger;

public class JRMonitorSetting
implements MonitorSetting {
    private ExProperties SEDU = new ExProperties();
    private Properties get = new Properties();
    JRMonitorService monServer = null;

    public JRMonitorSetting(JRMonitorService jRMonitorService) {
        this.monServer = jRMonitorService;
    }

    @Override
    public long getClusterMonitorRefreshInterval() {
        String string = (String)this.get.get("monitor.cluster.refresh.interval");
        if (string != null && string.trim().length() > 0) {
            return APIUtil.parseLong(string);
        }
        return ServerEnv.getClusterMonitorRefreshInterval();
    }

    @Override
    public long getMonitorRefreshInterval() {
        String string = (String)this.get.get("monitor.refresh.interval");
        if (string != null && string.trim().length() > 0) {
            return APIUtil.parseLong(string);
        }
        return ServerEnv.getMonitorRefreshInterval();
    }

    @Override
    public long getMonitorOverTimeRunning() {
        String string = (String)this.get.get("monitor.overtime.running");
        if (string != null && string.trim().length() > 0) {
            return APIUtil.parseLong(string);
        }
        return ServerEnv.getMonitorOverTimeRunning();
    }

    @Override
    public int getMonitorMaxNumberSaveReport() {
        String string = (String)this.get.get("monitor.maxnumber.savereport");
        if (string != null && string.trim().length() > 0) {
            return Integer.parseInt(string);
        }
        return ServerEnv.getMonitorMaxNumberSaveReport();
    }

    @Override
    public int getMonitorNumberSaveReport() {
        String string = (String)this.get.get("monitor.number.savereport");
        if (string != null && string.trim().length() > 0) {
            return Integer.parseInt(string);
        }
        return ServerEnv.getMonitorNumberSaveReport();
    }

    @Override
    public int getMonitorMaxMinuteSaveReport() {
        String string = (String)this.get.get("monitor.maxminute.savereport");
        if (string != null && string.trim().length() > 0) {
            return Integer.parseInt(string);
        }
        return ServerEnv.getMonitorMaxMinuteSaveReport();
    }

    @Override
    public void setClusterMonitorRefreshInterval(long l) {
        try {
            this.SEDU.load(ServerEnv.getServPropName());
            this.SEDU.setProperty("monitor.cluster.refresh.interval", l);
            this.get.put("monitor.cluster.refresh.interval", String.valueOf(l));
            this.SEDU.save(ServerEnv.getServPropName(), null);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    @Override
    public void setMonitorRefreshInterval(long l) {
        try {
            this.SEDU.load(ServerEnv.getServPropName());
            this.SEDU.setProperty("monitor.refresh.interval", l);
            this.SEDU.save(ServerEnv.getServPropName(), null);
            this.get.put("monitor.refresh.interval", String.valueOf(l));
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    @Override
    public void setMonitorOverTimeRunning(long l) {
        try {
            this.SEDU.load(ServerEnv.getServPropName());
            this.SEDU.setProperty("monitor.overtime.running", l);
            this.SEDU.save(ServerEnv.getServPropName(), null);
            this.get.put("monitor.overtime.running", String.valueOf(l));
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    @Override
    public void setMonitorNumberSaveReport(int n) {
        try {
            this.SEDU.load(ServerEnv.getServPropName());
            this.SEDU.setProperty("monitor.number.savereport", n);
            FinishedReportTable finishedReportTable = this.monServer.getFinishedReportTable();
            finishedReportTable.setMaxSaveNumber(n);
            this.SEDU.save(ServerEnv.getServPropName(), null);
            this.get.put("monitor.number.savereport", String.valueOf(n));
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    @Override
    public void setMonitorMaxNumberSaveReport(int n) {
        try {
            this.SEDU.load(ServerEnv.getServPropName());
            this.SEDU.setProperty("monitor.maxnumber.savereport", n);
            this.SEDU.save(ServerEnv.getServPropName(), null);
            this.get.put("monitor.maxnumber.savereport", String.valueOf(n));
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    @Override
    public void setMonitorMaxMinuteSaveReport(int n) {
        try {
            this.SEDU.load(ServerEnv.getServPropName());
            this.SEDU.setProperty("monitor.maxminute.savereport", Integer.toString(n));
            FinishedReportTable finishedReportTable = this.monServer.getFinishedReportTable();
            finishedReportTable.setMaxKeepTime((long)n * 60L * 1000L);
            this.SEDU.save(ServerEnv.getServPropName(), null);
            this.get.put("monitor.maxminute.savereport", String.valueOf(n));
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }
}

