/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver.nls;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jet.server.api.cluster.ClusterException;
import jet.server.api.nls.FontNLSEntry;
import jet.server.api.nls.FormatNLSEntry;
import jet.server.api.nls.GlobalNLSLibrary;
import jet.server.api.nls.NLSEntry;
import jet.server.api.nls.NLSType;
import jet.server.api.nls.TextNLSEntry;
import jet.server.cluster.blocks.ClusterMap;
import jet.server.cluster.blocks.MapAttr;
import jet.server.cluster.blocks.MapFactory;
import jet.server.cluster.blocks.MapFlags;
import jet.server.cluster.blocks.MapListenerAdapter;
import jet.server.db.core.GlobalDataService;
import jet.server.db.nls.GlobalNLSTable;
import jet.server.intf.resource.NLSManager;
import jet.server.jrc.resource.nls.NLSFontInfo;
import jet.server.jrc.resource.nls.NLSFontMap;
import jet.server.jrc.resource.nls.NLSManagerImpl;
import jet.server.jrc.resource.nls.NLSUtil;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.log.ServiceLogger;

public class JRGlobalNLSLibrary
implements GlobalNLSLibrary {
    private NLSManager SEDU = null;
    private GlobalNLSTable add = null;
    private Map addFontNLS;
    private ClusterMap addFormatNLS = null;
    private Hashtable addListener = null;
    private List addNLS = new ArrayList();

    public JRGlobalNLSLibrary() {
        this.SEDU = UserDataToolkit.getNLSManager();
        this.add = GlobalDataService.getInstance().getGlobalNLSTable();
        this.SEDU();
        this.addListener = ((NLSManagerImpl)this.SEDU).getFontMaps();
        if (this.addListener != null && this.addListener.size() > 0) {
            ArrayList<FontNLSEntry> arrayList = new ArrayList<FontNLSEntry>();
            for (NLSFontMap nLSFontMap : this.addListener.values()) {
                Locale locale = nLSFontMap.getLocale();
                Hashtable hashtable = nLSFontMap.getFontInfos();
                for (NLSFontInfo nLSFontInfo : hashtable.values()) {
                    String string = nLSFontInfo.getOriginalFontFace();
                    int n = nLSFontInfo.isIgnoreSize() ? 0 : (int)nLSFontInfo.getOriginalFontSize();
                    String string2 = nLSFontInfo.getTargetFontFace();
                    int n2 = (int)nLSFontInfo.getOriginalFontSize();
                    boolean bl = nLSFontInfo.isRelative();
                    FontNLSEntry fontNLSEntry = new FontNLSEntry(string, n, string2, n2, bl);
                    arrayList.add(fontNLSEntry);
                }
                if (arrayList.size() <= 0) continue;
                ServiceLogger.logDebug("NLSManagerImpl.initGlobalNLSLibrary: merge FontMaps.xml, locale=" + locale);
                this.addNLS(locale, arrayList, false);
            }
        }
    }

    private void SEDU() {
        if (this.addFontNLS != null) {
            return;
        }
        this.addFontNLS = new HashMap();
        try {
            this.addFormatNLS = MapFactory.getMap(MapAttr.globalNLSMap);
            this.addFormatNLS.addListener(new MapListenerAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void afterPut(String string, int n, Locale locale, ArrayList arrayList, ArrayList arrayList2, MapFlags mapFlags) {
                    ServiceLogger.logDebug("GlobalNLSLibrary: listened globalNLSMap.afterPut: key is " + locale + ",value is " + arrayList + ",prev is " + arrayList2, 6);
                    Map map = JRGlobalNLSLibrary.this.addFontNLS;
                    synchronized (map) {
                        JRGlobalNLSLibrary.this.addFontNLS.put(locale, arrayList);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void afterRemove(String string, int n, Locale locale, ArrayList arrayList, MapFlags mapFlags) {
                    ServiceLogger.logDebug("GlobalNLSLibrary: listened globalNLSMap.afterRemove: key is " + locale + ",value is " + arrayList, 6);
                    Map map = JRGlobalNLSLibrary.this.addFontNLS;
                    synchronized (map) {
                        JRGlobalNLSLibrary.this.addFontNLS.remove(locale);
                    }
                }
            });
        }
        catch (ClusterException clusterException) {
            ServiceLogger.logError((Throwable)((Object)clusterException));
        }
        List list = null;
        try {
            list = this.add.availableLocales();
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
        for (Locale locale : list) {
            this.add(locale);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(Locale locale) {
        if (!this.isLegalLocale(locale)) {
            return;
        }
        Map map = this.addFontNLS;
        synchronized (map) {
            if (!this.addFontNLS.containsKey(locale)) {
                this.addFontNLS.put(locale, null);
            }
        }
    }

    public boolean isLegalLocale(Locale locale) {
        return this.getAvailableLocalesOfNLS().contains(locale);
    }

    public void addNLS(Locale locale, List list, boolean bl) {
        if (!this.isLegalLocale(locale)) {
            return;
        }
        ArrayList<NLSEntry> arrayList = this.addFontNLS(locale);
        if (arrayList == null) {
            arrayList = new ArrayList<NLSEntry>();
            for (NLSEntry nLSEntry : list) {
                arrayList.add(nLSEntry);
            }
        } else if (bl) {
            for (NLSEntry nLSEntry : list) {
                if (arrayList.contains(nLSEntry)) {
                    arrayList.remove(nLSEntry);
                }
                arrayList.add(nLSEntry);
            }
        } else {
            for (NLSEntry nLSEntry : list) {
                if (arrayList.contains(nLSEntry)) continue;
                arrayList.add(nLSEntry);
            }
        }
        this.addFormatNLS(locale, arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List addFontNLS(Locale locale) {
        if (!this.isLegalLocale(locale)) {
            return null;
        }
        Map map = this.addFontNLS;
        synchronized (map) {
            if (!this.addFontNLS.containsKey(locale)) {
                return null;
            }
            List list = (List)this.addFontNLS.get(locale);
            if (null != list) {
                return list;
            }
            try {
                list = this.add.queryNLS(locale);
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException);
                return null;
            }
            Map map2 = this.addFontNLS;
            synchronized (map2) {
                this.addFontNLS.put(locale, list);
            }
            this.addFormatNLS.put(locale, (ArrayList)list);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFormatNLS(Locale locale, List list) {
        if (list == null || !this.isLegalLocale(locale)) {
            return;
        }
        ServiceLogger.logDebug("GlobalNLSLibrary.saveLocale(): locale=" + locale, 6);
        Map map = this.addFontNLS;
        synchronized (map) {
            this.addFontNLS.put(locale, list);
        }
        this.addFormatNLS.put(locale, (ArrayList)list);
        try {
            this.add.saveNLS(locale, list);
        }
        catch (SQLException sQLException) {
            ServiceLogger.logError(sQLException);
        }
    }

    public void addNLS(Locale locale, NLSEntry nLSEntry, boolean bl) {
        if (!this.isLegalLocale(locale)) {
            return;
        }
        ArrayList<NLSEntry> arrayList = this.addFontNLS(locale);
        if (arrayList == null) {
            arrayList = new ArrayList<NLSEntry>();
            arrayList.add(nLSEntry);
        } else if (!arrayList.contains(nLSEntry)) {
            arrayList.add(nLSEntry);
        } else if (bl) {
            arrayList.remove(nLSEntry);
            arrayList.add(nLSEntry);
        }
        this.addFormatNLS(locale, arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAvailableLocalesOfNLS() {
        List list = this.addNLS;
        synchronized (list) {
            List<Locale> list2 = Arrays.asList(NLSUtil.sortLocale(Locale.getAvailableLocales()));
            ArrayList<Locale> arrayList = new ArrayList<Locale>(list2);
            Locale locale = new Locale("", "", "");
            if (!arrayList.contains(locale)) {
                arrayList.add(0, locale);
            }
            this.addNLS = arrayList;
        }
        return this.addNLS;
    }

    public List getAvailableLocales() {
        Locale[] localeArray;
        LinkedList<Locale> linkedList = new LinkedList<Locale>();
        for (Locale locale : localeArray = this.addFontNLS.keySet().toArray(new Locale[0])) {
            linkedList.add(locale);
        }
        return linkedList;
    }

    @Override
    public boolean containsLocale(Locale locale) {
        return this.addFontNLS.containsKey(locale);
    }

    public List getLocale(Locale locale) {
        LinkedList<TextNLSEntry> linkedList = new LinkedList<TextNLSEntry>();
        List list = this.addFontNLS(locale);
        if (null == list) {
            return linkedList;
        }
        for (NLSEntry nLSEntry : list) {
            NLSEntry nLSEntry2;
            if (nLSEntry instanceof TextNLSEntry) {
                nLSEntry2 = new TextNLSEntry(((TextNLSEntry)nLSEntry).getType(), ((TextNLSEntry)nLSEntry).getKeyText(), ((TextNLSEntry)nLSEntry).getValueText());
                linkedList.add((TextNLSEntry)nLSEntry2);
                continue;
            }
            if (nLSEntry instanceof FormatNLSEntry) {
                nLSEntry2 = new FormatNLSEntry(((FormatNLSEntry)nLSEntry).getKeyFormat(), ((FormatNLSEntry)nLSEntry).getValueFormat());
                linkedList.add((TextNLSEntry)nLSEntry2);
                continue;
            }
            nLSEntry2 = new FontNLSEntry(((FontNLSEntry)nLSEntry).getOrginalFace(), ((FontNLSEntry)nLSEntry).getOrginalSize(), ((FontNLSEntry)nLSEntry).getTargetFace(), ((FontNLSEntry)nLSEntry).getTargetSize(), ((FontNLSEntry)nLSEntry).isRelative());
            linkedList.add((TextNLSEntry)nLSEntry2);
        }
        return linkedList;
    }

    public List getLocaleTexts(Locale locale) {
        LinkedList<TextNLSEntry> linkedList = new LinkedList<TextNLSEntry>();
        List list = this.addFontNLS(locale);
        if (null == list) {
            return linkedList;
        }
        for (NLSEntry nLSEntry : list) {
            if (!(nLSEntry instanceof TextNLSEntry)) continue;
            TextNLSEntry textNLSEntry = new TextNLSEntry(((TextNLSEntry)nLSEntry).getType(), ((TextNLSEntry)nLSEntry).getKeyText(), ((TextNLSEntry)nLSEntry).getValueText());
            linkedList.add(textNLSEntry);
        }
        return linkedList;
    }

    public List getLocaleFonts(Locale locale) {
        LinkedList<FontNLSEntry> linkedList = new LinkedList<FontNLSEntry>();
        List list = this.addFontNLS(locale);
        if (null == list) {
            return linkedList;
        }
        for (NLSEntry nLSEntry : list) {
            if (!(nLSEntry instanceof FontNLSEntry)) continue;
            FontNLSEntry fontNLSEntry = new FontNLSEntry(((FontNLSEntry)nLSEntry).getOrginalFace(), ((FontNLSEntry)nLSEntry).getOrginalSize(), ((FontNLSEntry)nLSEntry).getTargetFace(), ((FontNLSEntry)nLSEntry).getTargetSize(), ((FontNLSEntry)nLSEntry).isRelative());
            linkedList.add(fontNLSEntry);
        }
        return linkedList;
    }

    @Override
    public TextNLSEntry getTextNLSEntry(Locale locale, NLSType nLSType, String string) {
        List list = this.addFontNLS(locale);
        if (null == list) {
            return null;
        }
        TextNLSEntry textNLSEntry = new TextNLSEntry(nLSType, string, string);
        if (list.contains(textNLSEntry)) {
            textNLSEntry = (TextNLSEntry)list.get(list.indexOf(textNLSEntry));
            return new TextNLSEntry(textNLSEntry.getType(), textNLSEntry.getKeyText(), textNLSEntry.getValueText());
        }
        return null;
    }

    @Override
    public FontNLSEntry getFontNLSEntry(Locale locale, String string, int n) {
        List list = this.addFontNLS(locale);
        if (null == list) {
            return null;
        }
        FontNLSEntry fontNLSEntry = new FontNLSEntry(string, n, string, n, true);
        if (list.contains(fontNLSEntry)) {
            fontNLSEntry = (FontNLSEntry)list.get(list.indexOf(fontNLSEntry));
            return new FontNLSEntry(fontNLSEntry.getOrginalFace(), fontNLSEntry.getOrginalSize(), fontNLSEntry.getTargetFace(), fontNLSEntry.getTargetSize(), fontNLSEntry.isRelative());
        }
        return null;
    }

    public void updateLocale(Locale locale, List list) {
        LinkedList<TextNLSEntry> linkedList = new LinkedList<TextNLSEntry>();
        LinkedList<FontNLSEntry> linkedList2 = new LinkedList<FontNLSEntry>();
        LinkedList<FormatNLSEntry> linkedList3 = new LinkedList<FormatNLSEntry>();
        for (NLSEntry nLSEntry : list) {
            if (nLSEntry instanceof TextNLSEntry) {
                linkedList.add((TextNLSEntry)nLSEntry);
                continue;
            }
            if (nLSEntry instanceof FontNLSEntry) {
                linkedList2.add((FontNLSEntry)nLSEntry);
                continue;
            }
            linkedList3.add((FormatNLSEntry)nLSEntry);
        }
        this.updateLocaleTexts(locale, linkedList);
        this.updateLocaleFonts(locale, linkedList2);
        this.updateLocaleFormats(locale, linkedList3);
    }

    public void updateLocaleTexts(Locale locale, List list) {
        this.addTextNLS(locale, list, true);
    }

    public void updateLocaleFonts(Locale locale, List list) {
        this.addFontNLS(locale, list, true);
    }

    public void addTextNLS(Locale locale, List list, boolean bl) {
        if (!this.isLegalLocale(locale)) {
            return;
        }
        ArrayList<TextNLSEntry> arrayList = this.addFontNLS(locale);
        if (arrayList == null) {
            arrayList = new ArrayList<TextNLSEntry>();
            for (TextNLSEntry textNLSEntry : list) {
                TextNLSEntry textNLSEntry2 = new TextNLSEntry(textNLSEntry.getType(), textNLSEntry.getKeyText(), textNLSEntry.getValueText());
                arrayList.add(textNLSEntry2);
            }
        } else if (bl) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                NLSEntry nLSEntry = (NLSEntry)iterator.next();
                if (!(nLSEntry instanceof TextNLSEntry)) continue;
                iterator.remove();
            }
            for (NLSEntry nLSEntry : list) {
                TextNLSEntry textNLSEntry = new TextNLSEntry(((TextNLSEntry)nLSEntry).getType(), ((TextNLSEntry)nLSEntry).getKeyText(), ((TextNLSEntry)nLSEntry).getValueText());
                arrayList.add(textNLSEntry);
            }
        } else {
            for (TextNLSEntry textNLSEntry : list) {
                if (arrayList.contains(textNLSEntry)) continue;
                TextNLSEntry textNLSEntry3 = new TextNLSEntry(textNLSEntry.getType(), textNLSEntry.getKeyText(), textNLSEntry.getValueText());
                arrayList.add(textNLSEntry3);
            }
        }
        this.addListener(locale, arrayList, list);
    }

    public void addFontNLS(Locale locale, List list, boolean bl) {
        if (!this.isLegalLocale(locale)) {
            return;
        }
        ArrayList<FontNLSEntry> arrayList = this.addFontNLS(locale);
        if (arrayList == null) {
            arrayList = new ArrayList<FontNLSEntry>();
            for (FontNLSEntry fontNLSEntry : list) {
                FontNLSEntry fontNLSEntry2 = new FontNLSEntry(fontNLSEntry.getOrginalFace(), fontNLSEntry.getOrginalSize(), fontNLSEntry.getTargetFace(), fontNLSEntry.getTargetSize(), fontNLSEntry.isRelative());
                arrayList.add(fontNLSEntry2);
            }
        } else if (bl) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                NLSEntry nLSEntry = (NLSEntry)iterator.next();
                if (!(nLSEntry instanceof FontNLSEntry)) continue;
                iterator.remove();
            }
            for (NLSEntry nLSEntry : list) {
                FontNLSEntry fontNLSEntry = new FontNLSEntry(((FontNLSEntry)nLSEntry).getOrginalFace(), ((FontNLSEntry)nLSEntry).getOrginalSize(), ((FontNLSEntry)nLSEntry).getTargetFace(), ((FontNLSEntry)nLSEntry).getTargetSize(), ((FontNLSEntry)nLSEntry).isRelative());
                arrayList.add(fontNLSEntry);
            }
        } else {
            for (FontNLSEntry fontNLSEntry : list) {
                if (arrayList.contains(fontNLSEntry)) continue;
                FontNLSEntry fontNLSEntry3 = new FontNLSEntry(fontNLSEntry.getOrginalFace(), fontNLSEntry.getOrginalSize(), fontNLSEntry.getTargetFace(), fontNLSEntry.getTargetSize(), fontNLSEntry.isRelative());
                arrayList.add(fontNLSEntry3);
            }
        }
        this.addNLS(locale, arrayList, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addListener(Locale locale, List list, List list2) {
        if (list == null || !this.isLegalLocale(locale)) {
            return;
        }
        ServiceLogger.logDebug("GlobalNLSLibrary.saveLocale(): locale=" + locale, 6);
        Object object = this.addFontNLS;
        synchronized (object) {
            this.addFontNLS.put(locale, list);
        }
        this.addFormatNLS.put(locale, (ArrayList)list);
        if (null != list2) {
            object = new ArrayList();
            for (TextNLSEntry textNLSEntry : list2) {
                if (object.contains(textNLSEntry)) continue;
                object.add(textNLSEntry);
            }
            ServiceLogger.logDebug("GlobalNLSLibrary.saveLocale(): locale=" + locale + ", textList.size=" + list2.size() + ", dedupedList.size=" + object.size(), 6);
            try {
                this.add.saveTextNLS(locale, (List)object);
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNLS(Locale locale, List list, List list2) {
        if (list == null || !this.isLegalLocale(locale)) {
            return;
        }
        ServiceLogger.logDebug("GlobalNLSLibrary.saveLocale(): locale=" + locale, 6);
        Map map = this.addFontNLS;
        synchronized (map) {
            this.addFontNLS.put(locale, list);
        }
        this.addFormatNLS.put(locale, (ArrayList)list);
        if (null != list2) {
            try {
                this.add.saveFontNLS(locale, list2);
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException);
            }
        }
    }

    @Override
    public void updateNLSEntry(Locale locale, NLSEntry nLSEntry) {
        this.addNLS(locale, nLSEntry, true);
    }

    @Override
    public void updateTextNLSEntry(Locale locale, TextNLSEntry textNLSEntry) {
        this.addNLS(locale, textNLSEntry, true);
    }

    @Override
    public void updateFontNLSEntry(Locale locale, FontNLSEntry fontNLSEntry) {
        this.addNLS(locale, fontNLSEntry, true);
    }

    @Override
    public boolean removeNLSEntry(Locale locale, NLSEntry nLSEntry) {
        if (nLSEntry instanceof TextNLSEntry) {
            return this.removeTextNLSEntry(locale, (TextNLSEntry)nLSEntry);
        }
        return this.removeFontNLSEntry(locale, (FontNLSEntry)nLSEntry);
    }

    @Override
    public boolean removeTextNLSEntry(Locale locale, TextNLSEntry textNLSEntry) {
        boolean bl = false;
        List list = this.getLocaleTexts(locale);
        if (list.contains(textNLSEntry)) {
            list.remove(textNLSEntry);
            bl = true;
        }
        this.updateLocaleTexts(locale, list);
        return bl;
    }

    @Override
    public boolean removeFontNLSEntry(Locale locale, FontNLSEntry fontNLSEntry) {
        boolean bl = false;
        List list = this.getLocaleFonts(locale);
        if (list.contains(fontNLSEntry)) {
            list.remove(fontNLSEntry);
            bl = true;
        }
        this.updateLocaleFonts(locale, list);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeLocale(Locale locale) {
        if (this.addFontNLS.containsKey(locale)) {
            ServiceLogger.logDebug("GlobalNLSLibrary.remove(): locale=" + locale, 6);
            Map map = this.addFontNLS;
            synchronized (map) {
                this.addFontNLS.remove(locale);
            }
            this.addFormatNLS.remove(locale);
            try {
                this.add.deleteNLS(locale);
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException);
            }
            return true;
        }
        return false;
    }

    public List getLocaleFormats(Locale locale) {
        LinkedList<FormatNLSEntry> linkedList = new LinkedList<FormatNLSEntry>();
        List list = this.addFontNLS(locale);
        if (null == list) {
            return linkedList;
        }
        for (NLSEntry nLSEntry : list) {
            if (!(nLSEntry instanceof FormatNLSEntry)) continue;
            FormatNLSEntry formatNLSEntry = new FormatNLSEntry(((FormatNLSEntry)nLSEntry).getKeyFormat(), ((FormatNLSEntry)nLSEntry).getValueFormat());
            linkedList.add(formatNLSEntry);
        }
        return linkedList;
    }

    @Override
    public FormatNLSEntry getFormatNLSEntry(Locale locale, String string) {
        List list = this.addFontNLS(locale);
        if (null == list) {
            return null;
        }
        FormatNLSEntry formatNLSEntry = new FormatNLSEntry(string, string);
        if (list.contains(formatNLSEntry)) {
            formatNLSEntry = (FormatNLSEntry)list.get(list.indexOf(formatNLSEntry));
            return new FormatNLSEntry(formatNLSEntry.getKeyFormat(), formatNLSEntry.getValueFormat());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTextNLS(Locale locale, List list, List list2) {
        if (list == null || !this.isLegalLocale(locale)) {
            return;
        }
        ServiceLogger.logDebug("GlobalNLSLibrary.saveLocale(): locale=" + locale, 6);
        Map map = this.addFontNLS;
        synchronized (map) {
            this.addFontNLS.put(locale, list);
        }
        this.addFormatNLS.put(locale, (ArrayList)list);
        if (null != list2) {
            try {
                this.add.saveFormatNLS(locale, list2);
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException);
            }
        }
    }

    public void addFormatNLS(Locale locale, List list, boolean bl) {
        if (!this.isLegalLocale(locale)) {
            return;
        }
        ArrayList<FormatNLSEntry> arrayList = this.addFontNLS(locale);
        if (arrayList == null) {
            arrayList = new ArrayList<FormatNLSEntry>();
            for (FormatNLSEntry formatNLSEntry : list) {
                FormatNLSEntry formatNLSEntry2 = new FormatNLSEntry(formatNLSEntry.getKeyFormat(), formatNLSEntry.getValueFormat());
                arrayList.add(formatNLSEntry2);
            }
        } else if (bl) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                NLSEntry nLSEntry = (NLSEntry)iterator.next();
                if (!(nLSEntry instanceof FormatNLSEntry)) continue;
                iterator.remove();
            }
            for (NLSEntry nLSEntry : list) {
                FormatNLSEntry formatNLSEntry = new FormatNLSEntry(((FormatNLSEntry)nLSEntry).getKeyFormat(), ((FormatNLSEntry)nLSEntry).getValueFormat());
                arrayList.add(formatNLSEntry);
            }
        } else {
            for (FormatNLSEntry formatNLSEntry : list) {
                if (arrayList.contains(formatNLSEntry)) continue;
                FormatNLSEntry formatNLSEntry3 = new FormatNLSEntry(formatNLSEntry.getKeyFormat(), formatNLSEntry.getValueFormat());
                arrayList.add(formatNLSEntry3);
            }
        }
        this.addTextNLS(locale, arrayList, list);
    }

    public void updateLocaleFormats(Locale locale, List list) {
        this.addFormatNLS(locale, list, true);
    }

    @Override
    public void updateFormatNLSEntry(Locale locale, FormatNLSEntry formatNLSEntry) {
        this.addNLS(locale, formatNLSEntry, true);
    }

    @Override
    public boolean removeFormatNLSEntry(Locale locale, FormatNLSEntry formatNLSEntry) {
        boolean bl = false;
        List list = this.getLocaleFormats(locale);
        if (list.contains(formatNLSEntry)) {
            list.remove(formatNLSEntry);
            bl = true;
        }
        this.updateLocaleFormats(locale, list);
        return bl;
    }
}

