/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver.rmi;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.List;
import java.util.Vector;
import jet.cs.CSUtil;
import jet.server.ServerEnv;
import jet.server.api.CatConnectionInfo;
import jet.server.api.CatalogInfo;
import jet.server.api.RptServerException;
import jet.server.api.rmi.RemoteCatalogInfo;
import jet.server.api.rmi.RemoteParameterManager;
import jet.server.jrserver.rmi.JRRemoteCatConnectionInfo;
import jet.server.jrserver.rmi.JRRemoteParameterManager;

public class JRRemoteCatalogInfo
extends UnicastRemoteObject
implements RemoteCatalogInfo {
    private CatalogInfo SEDU = null;

    public JRRemoteCatalogInfo(CatalogInfo catalogInfo) throws RemoteException {
        super(CSUtil.parseInt(ServerEnv.getRMIServerFixedPort(), 0));
        this.SEDU = catalogInfo;
    }

    public Vector getCatConnectionInfos() throws RemoteException {
        try {
            Vector<JRRemoteCatConnectionInfo> vector = new Vector<JRRemoteCatConnectionInfo>();
            Vector<CatConnectionInfo> vector2 = this.SEDU.getCatConnectionInfos();
            if (vector2 != null) {
                int n = vector2.size();
                for (int i = 0; i < n; ++i) {
                    vector.addElement(new JRRemoteCatConnectionInfo(vector2.elementAt(i)));
                }
            }
            return vector;
        }
        catch (RptServerException rptServerException) {
            throw new RemoteException("", (Throwable)((Object)rptServerException));
        }
    }

    @Override
    public String[] getAllDataSource() throws RemoteException {
        try {
            return this.SEDU.getAllDataSource();
        }
        catch (RptServerException rptServerException) {
            throw new RemoteException("", (Throwable)((Object)rptServerException));
        }
    }

    @Override
    public boolean canCreateReport() throws RemoteException {
        boolean bl = false;
        try {
            bl = this.SEDU.canCreateReport();
        }
        catch (RptServerException rptServerException) {
            throw new RemoteException("", (Throwable)((Object)rptServerException));
        }
        return bl;
    }

    @Override
    public boolean canCreateStudioReport() throws RemoteException {
        boolean bl = false;
        try {
            bl = this.SEDU.canCreateStudioReport();
        }
        catch (RptServerException rptServerException) {
            throw new RemoteException("", (Throwable)((Object)rptServerException));
        }
        return bl;
    }

    public List getBusinessViewsInDataSource(String string) throws RptServerException {
        return this.SEDU.getBusinessViewsInDataSource(string);
    }

    public List getQueriesInDataSource(String string) throws RptServerException {
        return this.SEDU.getQueriesInDataSource(string);
    }

    public List getParametersInDataSource(String string) throws RemoteException {
        try {
            return this.SEDU.getParametersInDataSource(string);
        }
        catch (RptServerException rptServerException) {
            throw new RemoteException("", (Throwable)((Object)rptServerException));
        }
    }

    @Override
    public Vector[] getAllQueriesByDataSource(String string) throws RemoteException {
        try {
            return this.SEDU.getAllQueriesByDataSource(string);
        }
        catch (RptServerException rptServerException) {
            throw new RemoteException("", (Throwable)((Object)rptServerException));
        }
    }

    @Override
    public RemoteParameterManager getParameterManager(String string, String[] stringArray) throws RemoteException {
        try {
            return new JRRemoteParameterManager(this.SEDU.getParameterManager(string, stringArray));
        }
        catch (RptServerException rptServerException) {
            throw new RemoteException("", (Throwable)((Object)rptServerException));
        }
    }

    public List getAllBVResourceByDataSource(String string) throws RptServerException {
        return this.SEDU.getAllBVResourceByDataSource(string);
    }

    public List getAllRCResourceByDataSource(String string) throws RptServerException {
        return this.SEDU.getAllRCResourceByDataSource(string);
    }

    public List getAllAliasFieldsByDataSource(String string) throws RptServerException, RemoteException {
        return this.SEDU.getAllAliasFieldsByDataSource(string);
    }
}

