/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jrserver.rmi.service;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.List;
import jet.cs.CSUtil;
import jet.server.ServerEnv;
import jet.server.log.ServiceLogger;
import jet.server.service.ManagedService;
import jet.server.service.ServiceManager;
import jet.server.service.annotation.RemoteClass;
import jet.server.service.rmi.RemoteManagedService;
import jet.server.service.rmi.RemoteServiceManager;

public class JRRemoteServiceManager
extends UnicastRemoteObject
implements RemoteServiceManager {
    private static final long serialVersionUID = 6319017100963901146L;
    private ServiceManager SEDU = null;

    public JRRemoteServiceManager(ServiceManager serviceManager) throws RemoteException {
        super(CSUtil.parseInt(ServerEnv.getRMIServerFixedPort(), 0));
        this.SEDU = serviceManager;
    }

    @Override
    public List listServices(String string) throws RemoteException {
        return this.listServices(null, string);
    }

    @Override
    public List listServices(String string, String string2) throws RemoteException {
        ServiceLogger.logDebug("JRRemoteServiceManager: listServices(" + string + ", " + string2 + ")......", 6);
        List list = this.SEDU.listServices(string, string2);
        ArrayList<RemoteManagedService> arrayList = new ArrayList<RemoteManagedService>();
        if (list != null) {
            for (ManagedService managedService : list) {
                RemoteManagedService remoteManagedService = null;
                String string3 = this.SEDU(managedService);
                ServiceLogger.logDebug("JRRemoteServiceManager: getRemoteClassName remoteClass = " + string3, 6);
                remoteManagedService = string3 != null ? this.append(string3) : this.add(managedService);
                if (remoteManagedService == null) continue;
                remoteManagedService.setManagedService(managedService);
                arrayList.add(remoteManagedService);
            }
        }
        ServiceLogger.logDebug("JRRemoteServiceManager: return list size is " + arrayList.size(), 6);
        return arrayList;
    }

    private RemoteClass getRemoteClass(Class clazz) {
        Object object;
        RemoteClass remoteClass = clazz.getAnnotation(RemoteClass.class);
        ServiceLogger.logDebug("JRRemoteServiceManager: getAnnotation(" + clazz.getSimpleName() + ") return = " + remoteClass, 6);
        if (remoteClass != null) {
            return remoteClass;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        if (classArray != null) {
            object = classArray;
            int n = ((Class<?>[])object).length;
            for (int i = 0; i < n; ++i) {
                Class<?> clazz2 = object[i];
                RemoteClass remoteClass2 = this.getRemoteClass(clazz2);
                if (remoteClass2 == null) continue;
                return remoteClass2;
            }
        }
        if ((object = clazz.getSuperclass()) != null) {
            return this.getRemoteClass((Class)object);
        }
        return null;
    }

    private String SEDU(ManagedService managedService) {
        try {
            Method method = managedService.getClass().getMethod("getRemoteClass", null);
            return (String)method.invoke((Object)managedService, (Object[])null);
        }
        catch (Exception exception) {
            ServiceLogger.logError("invoke getRemoteClass error: " + exception);
            return null;
        }
    }

    private RemoteManagedService add(ManagedService managedService) throws RemoteException {
        ServiceLogger.logDebug("JRRemoteServiceManager: buildRemoteService(ManagedService)", 6);
        throw new RemoteException("The remote managed service of class(" + managedService.getClass().getName() + ") cannot be supported.");
    }

    private RemoteManagedService append(String string) throws RemoteException {
        ServiceLogger.logDebug("JRRemoteServiceManager: buildRemoteService(RemoteClass)" + string, 6);
        try {
            Class<?> clazz = Class.forName(string);
            RemoteManagedService remoteManagedService = (RemoteManagedService)clazz.newInstance();
            ServiceLogger.logDebug("JRRemoteServiceManager: buildRemoteService(RemoteClass) success.", 6);
            return remoteManagedService;
        }
        catch (Exception exception) {
            ServiceLogger.logError("buildRemoteService error: " + exception);
            throw new RemoteException("Wrap managed service to remote managed service error.", exception);
        }
    }
}

