/*
 * Decompiled with CFR 0.152.
 */
package jet.server.jsapiservice;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jet.cs.CSUtil;
import jet.server.api.RptServerException;
import jet.server.api.admin.AdminService;
import jet.server.api.admin.DynamicSecurityManager;
import jet.server.api.admin.security.DynamicSecurity;
import jet.server.api.http.HttpRptServer;
import jet.server.api.http.HttpUtil;
import jet.server.jrc.admin.ExtDynamicSecurity;
import jet.server.log.ServiceLogger;
import jet.server.util.FormData;
import jet.server.util.IOUtil;
import jet.server.util.MultiPartFormData;
import jet.server.util.StringUtil;
import jet.server.util.nls.NlsClientResource;
import jet.server.util.nls.PropertyMessageResourcesFactory;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class DynamicSecurityService {
    public static void execute(Writer writer, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, JSONException {
        String string;
        ArrayList arrayList = new ArrayList();
        Enumeration enumeration = httpServletRequest.getParameterNames();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("=============================DynamicSecurityService: Request Parameters===========================\n");
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            String[] stringArray = httpServletRequest.getParameterValues(string);
            stringBuffer.append(string + " = " + StringUtil.toString(stringArray) + "\n");
        }
        stringBuffer.append("==========================================================================");
        ServiceLogger.logDebug(stringBuffer.toString());
        string = httpServletRequest.getParameter("method");
        try {
            if ("getDynamicSecurities".equals(string)) {
                DynamicSecurityService.getDynamicSecurities(writer, httpServletRequest);
            } else if ("getDynamicSecurity".equals(string)) {
                DynamicSecurityService.getDynamicSecurity(writer, httpServletRequest);
            } else if ("saveDynamicSecurity".equals(string)) {
                DynamicSecurityService.saveDynamicSecurity(writer, httpServletRequest, arrayList);
            } else if ("setDynamicSecurityToDefault".equals(string)) {
                DynamicSecurityService.setDynamicSecurityToDefault(writer, httpServletRequest);
            } else if ("deleteDynamicSecurity".equals(string)) {
                DynamicSecurityService.deleteDynamicSecurity(writer, httpServletRequest);
            } else if ("downloadSecurityFile".equals(string)) {
                DynamicSecurityService.downloadSecurityFile(writer, httpServletRequest, httpServletResponse);
            } else {
                writer.write("{}");
            }
        }
        catch (RptServerException rptServerException) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("statusCode", 300);
            String string2 = "" + rptServerException.getErrorKey();
            if (rptServerException.getErrorKey() > 0) {
                if (null != arrayList && !arrayList.isEmpty()) {
                    Object[] objectArray = new Object[arrayList.size()];
                    for (int i = 0; i < objectArray.length; ++i) {
                        objectArray[i] = arrayList.get(i);
                    }
                    jSONObject.put("message", (Object)DynamicSecurityService.getNLSMessage(httpServletRequest, string2, objectArray));
                } else {
                    jSONObject.put("message", (Object)DynamicSecurityService.getNLSMessage(httpServletRequest, string2, new Object[0]));
                }
            } else {
                jSONObject.put("message", (Object)DynamicSecurityService.getMessage((Throwable)((Object)rptServerException)));
            }
            writer.write(jSONObject.toString());
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(stringBuffer.toString());
            ServiceLogger.logError(throwable);
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("statusCode", 300);
            jSONObject.put("message", (Object)DynamicSecurityService.getMessage(throwable));
            writer.write(jSONObject.toString());
        }
    }

    public static void getDynamicSecurities(Writer writer, HttpServletRequest httpServletRequest) throws IOException, JSONException, RptServerException {
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer(httpServletRequest);
        AdminService adminService = httpRptServer.getAdminService();
        DynamicSecurityManager dynamicSecurityManager = adminService.getDynamicSecurityManager();
        String string = HttpUtil.getUser(httpServletRequest);
        List<DynamicSecurity> list = dynamicSecurityManager.getDynamicSecurities(string);
        JSONObject jSONObject = new JSONObject();
        if (list != null) {
            for (DynamicSecurity dynamicSecurity : list) {
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put("catalogPath", (Object)dynamicSecurity.getCatalogPath());
                jSONObject2.put("securityFileName", (Object)dynamicSecurity.getSecurityFileName());
                jSONObject2.put("isDefault", dynamicSecurity.isDefault());
                if (dynamicSecurity instanceof ExtDynamicSecurity) {
                    ExtDynamicSecurity extDynamicSecurity = (ExtDynamicSecurity)dynamicSecurity;
                    jSONObject2.put("id", extDynamicSecurity.getID());
                    jSONObject2.put("dataVersion", extDynamicSecurity.getDataVersion());
                }
                jSONObject.append("list", (Object)jSONObject2);
            }
        }
        jSONObject.put("statusCode", 200);
        ServiceLogger.logDebug("DynamicSecurityService: getDynamicSecurities : " + jSONObject.toString());
        writer.write(jSONObject.toString());
    }

    public static void getDynamicSecurity(Writer writer, HttpServletRequest httpServletRequest) throws IOException, JSONException, RptServerException {
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer(httpServletRequest);
        AdminService adminService = httpRptServer.getAdminService();
        DynamicSecurityManager dynamicSecurityManager = adminService.getDynamicSecurityManager();
        String string = HttpUtil.getUser(httpServletRequest);
        String string2 = httpServletRequest.getParameter("catalogPath");
        String string3 = httpServletRequest.getParameter("securityFileName");
        DynamicSecurity dynamicSecurity = dynamicSecurityManager.getDynamicSecurity(string2, string3, string);
        JSONObject jSONObject = new JSONObject();
        if (dynamicSecurity != null) {
            jSONObject.put("catalogPath", (Object)dynamicSecurity.getCatalogPath());
            jSONObject.put("securityFileName", (Object)dynamicSecurity.getSecurityFileName());
            jSONObject.put("isDefault", dynamicSecurity.isDefault());
            if (dynamicSecurity instanceof ExtDynamicSecurity) {
                ExtDynamicSecurity extDynamicSecurity = (ExtDynamicSecurity)dynamicSecurity;
                jSONObject.put("id", extDynamicSecurity.getID());
                jSONObject.put("dataVersion", extDynamicSecurity.getDataVersion());
            }
            jSONObject.put("statusCode", 200);
        } else {
            jSONObject.put("statusCode", 300);
        }
        ServiceLogger.logDebug("DynamicSecurityService: getDynamicSecurity : " + jSONObject.toString());
        writer.write(jSONObject.toString());
    }

    public static void saveDynamicSecurity(Writer writer, HttpServletRequest httpServletRequest, List list) throws IOException, JSONException, RptServerException {
        String string;
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer(httpServletRequest);
        AdminService adminService = httpRptServer.getAdminService();
        DynamicSecurityManager dynamicSecurityManager = adminService.getDynamicSecurityManager();
        String string2 = HttpUtil.getUser(httpServletRequest);
        Map map = DynamicSecurityService.SEDU(httpServletRequest, httpRptServer);
        String string3 = (String)map.get("id");
        String string4 = (String)map.get("catalogPath");
        String string5 = (String)map.get("oldCatalogPath");
        String string6 = (String)map.get("oldSecurityFileName");
        FormData formData = null;
        Object v = map.get("securityFile");
        if (v instanceof FormData) {
            formData = (FormData)v;
        }
        File file = null;
        String string7 = (String)map.get("securityFileName");
        if (formData != null) {
            string7 = formData.getOriginalFilename();
            string = (String)map.get("remotetmpdir");
            file = string != null ? new File(string, string7) : new File(formData.getFilename());
        }
        string = (String)map.get("isDefault");
        boolean bl = false;
        try {
            bl = Boolean.parseBoolean(string);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String string8 = (String)map.get("isReplaceExisted");
        boolean bl2 = false;
        try {
            bl2 = Boolean.parseBoolean(string8);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        DynamicSecurity dynamicSecurity = new DynamicSecurity();
        dynamicSecurity.setCatalogPath(string4);
        dynamicSecurity.setSecurityFileName(string7);
        dynamicSecurity.setDefault(bl);
        dynamicSecurity.setSecurityFile(file);
        int n = 0;
        JSONObject jSONObject = new JSONObject();
        if (string3 == null || string3.trim().length() == 0) {
            DynamicSecurity dynamicSecurity2 = dynamicSecurityManager.getDynamicSecurity(string4, string7, string2);
            if (dynamicSecurity2 == null || dynamicSecurity2 != null && bl2) {
                n = dynamicSecurityManager.addDynamicSecurity(dynamicSecurity, string2, bl2);
            } else {
                jSONObject.put("message", (Object)DynamicSecurityService.getNLSMessage(httpServletRequest, "22221424", string7));
                jSONObject.put("requiredReplace", true);
            }
        } else {
            n = dynamicSecurityManager.updateDynamicSecurity(string5, string6, dynamicSecurity, string2, list);
        }
        if (n > 0) {
            jSONObject.put("statusCode", 200);
        } else {
            jSONObject.put("statusCode", 300);
        }
        ServiceLogger.logDebug("DynamicSecurityService: saveDynamicSecurity : " + jSONObject.toString());
        writer.write(jSONObject.toString());
    }

    public static void setDynamicSecurityToDefault(Writer writer, HttpServletRequest httpServletRequest) throws IOException, JSONException, RptServerException {
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer(httpServletRequest);
        AdminService adminService = httpRptServer.getAdminService();
        DynamicSecurityManager dynamicSecurityManager = adminService.getDynamicSecurityManager();
        String string = HttpUtil.getUser(httpServletRequest);
        String string2 = httpServletRequest.getParameter("id");
        int n = 0;
        if (string2 != null && string2.trim().length() > 0) {
            n = Integer.parseInt(string2);
        }
        String string3 = httpServletRequest.getParameter("catalogPath");
        String string4 = httpServletRequest.getParameter("securityFileName");
        boolean bl = CSUtil.getBoolean(httpServletRequest.getParameter("isDefault"), false);
        int n2 = 0;
        JSONObject jSONObject = new JSONObject();
        n2 = n > 0 ? dynamicSecurityManager.setDynamicSecurityDefault(n, bl, string) : dynamicSecurityManager.setDynamicSecurityDefault(string3, string4, bl, string);
        if (n2 > 0) {
            jSONObject.put("statusCode", 200);
        } else {
            jSONObject.put("statusCode", 300);
            jSONObject.put("message", (Object)"Set dynamic security to default failed!");
        }
        ServiceLogger.logDebug("DynamicSecurityService: setDynamicSecurityToDefault : id=" + n);
        writer.write(jSONObject.toString());
    }

    public static void deleteDynamicSecurity(Writer writer, HttpServletRequest httpServletRequest) throws IOException, JSONException, RptServerException {
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer(httpServletRequest);
        AdminService adminService = httpRptServer.getAdminService();
        DynamicSecurityManager dynamicSecurityManager = adminService.getDynamicSecurityManager();
        String string = HttpUtil.getUser(httpServletRequest);
        String[] stringArray = httpServletRequest.getParameterValues("id[]");
        int[] nArray = new int[]{};
        if (stringArray != null && stringArray.length > 0) {
            nArray = new int[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                nArray[i] = Integer.parseInt(stringArray[i]);
            }
        }
        String string2 = httpServletRequest.getParameter("catalogPath");
        String string3 = httpServletRequest.getParameter("securityFileName");
        int n = 0;
        JSONObject jSONObject = new JSONObject();
        n = nArray.length > 0 ? dynamicSecurityManager.deleteDynamicSecuritys(nArray, string) : dynamicSecurityManager.deleteDynamicSecurity(string2, string3, string);
        if (n > 0) {
            jSONObject.put("statusCode", 200);
        } else {
            jSONObject.put("statusCode", 300);
            jSONObject.put("message", (Object)"Delete failed!");
        }
        ServiceLogger.logDebug("DynamicSecurityService: deleteDynamicSecurity : " + Arrays.toString(nArray));
        writer.write(jSONObject.toString());
    }

    public static void downloadSecurityFile(Writer writer, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        HttpRptServer httpRptServer = HttpUtil.getHttpRptServer(httpServletRequest);
        AdminService adminService = httpRptServer.getAdminService();
        DynamicSecurityManager dynamicSecurityManager = adminService.getDynamicSecurityManager();
        String string = HttpUtil.getUser(httpServletRequest);
        String string2 = httpServletRequest.getParameter("id");
        int n = 0;
        if (string2 != null && string2.trim().length() > 0) {
            n = Integer.parseInt(string2);
        }
        String string3 = httpServletRequest.getParameter("catalogPath");
        String string4 = httpServletRequest.getParameter("securityFileName");
        DynamicSecurity dynamicSecurity = null;
        dynamicSecurity = n > 0 ? dynamicSecurityManager.getDynamicSecurity(n, string) : dynamicSecurityManager.getDynamicSecurity(string3, string4, string);
        if (dynamicSecurity != null) {
            File file = dynamicSecurity.getSecurityFile();
            if (file != null && file.exists()) {
                HttpUtil.handleFileNameByBrowserTypeForDownload(dynamicSecurity.getSecurityFileName(), httpServletRequest, httpServletResponse);
                httpServletResponse.setContentType("application/octet-stream");
                IOUtil.transfer(file, (OutputStream)httpServletResponse.getOutputStream());
            } else {
                ServiceLogger.logError("Failed to download security file, file " + file.getName() + " is not existed.", 3);
            }
        }
    }

    private static Map SEDU(HttpServletRequest httpServletRequest, HttpRptServer httpRptServer) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string = null;
        String string2 = null;
        String string3 = String.valueOf(System.currentTimeMillis());
        string2 = httpRptServer.getResourceManager().getTempDir();
        if (string2 != null && !string2.endsWith(File.separator)) {
            string2 = string2 + File.separator;
        }
        string2 = string2 + "upload" + string3;
        if (HttpUtil.isRemoteServer()) {
            object4 = System.getProperty("java.io.tmpdir");
            if (object4 != null && !((String)object4).endsWith(File.separator)) {
                object4 = (String)object4 + File.separator;
            }
            object4 = "upload" + string3;
            string = object4;
        } else {
            string = string2;
        }
        object4 = null;
        String string4 = httpServletRequest.getContentType();
        int n = string4.indexOf("multipart/form-data");
        String string5 = string4.substring(n);
        n = string5.indexOf("boundary=");
        if (n >= 0) {
            object3 = string5.substring(n + 9);
            object2 = httpServletRequest.getInputStream();
            object = new File(string);
            if (!((File)object).exists()) {
                ((File)object).mkdirs();
            }
            if (!string.endsWith(File.separator)) {
                string = string + File.separator;
            }
            object4 = new MultiPartFormData((InputStream)object2, string, (String)object3);
        }
        if (object4 != null) {
            object3 = ((MultiPartFormData)object4).getUploadedFiles();
            if (object3 != null) {
                object2 = ((Vector)object3).iterator();
                while (object2.hasNext()) {
                    object = (FormData)object2.next();
                    hashMap.put(((FormData)object).getName(), object);
                }
            }
            if ((object2 = ((MultiPartFormData)object4).getOtherFormData()) != null) {
                for (int i = 0; i < ((Vector)object2).size(); ++i) {
                    FormData formData = (FormData)((Vector)object2).elementAt(i);
                    if (formData.getName() == null || formData.getName().length() <= 0 || formData.getContent() == null) continue;
                    hashMap.put(formData.getName(), formData.getContent());
                }
            }
        }
        if (HttpUtil.isRemoteServer()) {
            object3 = HttpUtil.getRemoteFileService(httpServletRequest);
            object3.copyToRemote(string + File.separator, string2 + File.separator);
            hashMap.put("remotetmpdir", string2);
        }
        return hashMap;
    }

    public static String getNLSMessage(HttpServletRequest httpServletRequest, String string, Object ... objectArray) {
        NlsClientResource nlsClientResource = new NlsClientResource(httpServletRequest);
        PropertyMessageResourcesFactory propertyMessageResourcesFactory = nlsClientResource.getServerResourceFactory();
        return propertyMessageResourcesFactory.getMessage(string, objectArray);
    }

    public static String getMessage(Throwable throwable) {
        if (throwable.getCause() != null) {
            return DynamicSecurityService.getMessage(throwable.getCause());
        }
        if (throwable.getClass().equals(NullPointerException.class)) {
            return throwable.toString();
        }
        return throwable.getMessage();
    }
}

