/*
 * Decompiled with CFR 0.152.
 */
package jet.server.lease;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import jet.cs.CSUtil;
import jet.server.lease.JRLease;
import jet.server.lease.JRLeaseAction;
import jet.server.lease.JRLeaseImpl;
import jet.server.lease.JRLeaseThread;
import jet.server.lease.LeaseTransceiver;

public class JRLeaseBasicThread
extends Thread
implements JRLeaseThread {
    private boolean SEDU = false;
    private boolean activate = false;
    private Hashtable activeDeadLease;
    private Hashtable add;
    private Hashtable addLease;
    private Hashtable contains;
    private Hashtable containsKey;
    private LeaseTransceiver currentTimeMillis;
    private Object equalsIgnoreCase = new Object();
    private Properties generateSchedulerLease;
    private long get = 10000L;
    protected int maxActivatingLeasesCount = 2;
    protected long validTime = 300L;
    protected long deadLeaseCheckInterval = 30L;
    public static final String PRO_VALID_TIME = "valid_time";
    public static final String PRO_MAX_LEASE_COUNT = "max_lease_count";
    public static final String PRO_DEAD_LEASE_CHECK_INTERVAL = "dead_lease_check_interval";

    public JRLeaseBasicThread(Properties properties) {
        this.generateSchedulerLease = properties;
        this.maxActivatingLeasesCount = CSUtil.parseInt(properties.getProperty(PRO_MAX_LEASE_COUNT), this.maxActivatingLeasesCount);
        this.validTime = CSUtil.parseLong(properties.getProperty(PRO_VALID_TIME), this.validTime);
        this.deadLeaseCheckInterval = CSUtil.parseLong(properties.getProperty(PRO_DEAD_LEASE_CHECK_INTERVAL), this.deadLeaseCheckInterval);
        if (this.validTime > this.deadLeaseCheckInterval) {
            this.deadLeaseCheckInterval = this.validTime;
        }
        this.activeDeadLease = new Hashtable();
        this.add = new Hashtable();
        this.containsKey = new Hashtable();
        this.addLease = new Hashtable();
        this.contains = new Hashtable();
        this.currentTimeMillis = new LeaseTransceiver(this);
    }

    @Override
    public Properties getConfig() {
        return this.generateSchedulerLease;
    }

    @Override
    public boolean addLease(JRLease jRLease, boolean bl) {
        int n = jRLease.getType();
        if (bl) {
            int n2 = this.currentTimeMillis.getActivatingLeasesResponses(n).size();
            if (n2 < this.maxActivatingLeasesCount && !this.activeDeadLease.containsKey(n)) {
                this.add.put(n, System.currentTimeMillis());
                this.activeDeadLease.put(n, jRLease);
                return true;
            }
        } else if (!this.activeDeadLease.containsKey(n)) {
            this.add.put(n, System.currentTimeMillis());
            this.activeDeadLease.put(n, jRLease);
            return true;
        }
        return false;
    }

    @Override
    public boolean registerAction(int n, String string) {
        JRLeaseAction jRLeaseAction = (JRLeaseAction)this.contains.get(string);
        if (jRLeaseAction == null) {
            return false;
        }
        return this.SEDU(n, jRLeaseAction, true);
    }

    @Override
    public boolean registerAction(int n, JRLeaseAction jRLeaseAction) {
        String string = jRLeaseAction.getActionID();
        if (this.contains.get(string) == null) {
            this.contains.put(string, jRLeaseAction);
        }
        return this.SEDU(n, jRLeaseAction, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean SEDU(int n, JRLeaseAction jRLeaseAction, boolean bl) {
        JRLease jRLease = (JRLease)this.activeDeadLease.get(n);
        if (jRLease == null) {
            return false;
        }
        LinkedList<JRLeaseAction> linkedList = (LinkedList<JRLeaseAction>)this.addLease.get(n);
        if (linkedList == null) {
            linkedList = new LinkedList<JRLeaseAction>();
            linkedList.add(jRLeaseAction);
            jRLeaseAction.activate();
            this.addLease.put(n, linkedList);
            return true;
        }
        if (!linkedList.contains(jRLeaseAction)) {
            linkedList.add(jRLeaseAction);
            jRLeaseAction.activate();
            return true;
        }
        if (!bl) return false;
        jRLeaseAction.activate();
        return true;
    }

    @Override
    public void unregisterAction(int n, String string) {
        if (this.addLease.size() > 0) {
            List list = (List)this.addLease.get(n);
            for (JRLeaseAction jRLeaseAction : list) {
                if (!jRLeaseAction.getActionID().equalsIgnoreCase(string)) continue;
                list.remove(jRLeaseAction);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.SEDU) {
            try {
                Enumeration enumeration = this.equalsIgnoreCase;
                synchronized (enumeration) {
                    while (this.activate && !this.SEDU) {
                        try {
                            this.equalsIgnoreCase.wait(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (this.SEDU) {
                        break;
                    }
                }
                if (this.addLease.size() > 0) {
                    enumeration = this.equalsIgnoreCase;
                    synchronized (enumeration) {
                        try {
                            this.equalsIgnoreCase.wait(this.get);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    enumeration = this.activeDeadLease.keys();
                    ArrayList<Integer> arrayList = new ArrayList<Integer>();
                    while (enumeration.hasMoreElements()) {
                        int n = (Integer)enumeration.nextElement();
                        JRLease jRLease = (JRLease)this.activeDeadLease.get(n);
                        if (jRLease.isChecked() || !jRLease.isExpired()) continue;
                        jRLease.setChecked(true);
                        arrayList.add(n);
                    }
                    this.activeDeadLease(arrayList);
                    for (Integer n : arrayList) {
                        this.currentTimeMillis.transferLease(n, (List)this.addLease.get(n));
                    }
                    long l = System.currentTimeMillis();
                    enumeration = this.add.keys();
                    while (enumeration.hasMoreElements()) {
                        int n = (Integer)enumeration.nextElement();
                        long l2 = (Long)this.add.get(n);
                        if (l - l2 <= this.deadLeaseCheckInterval || this.activeDeadLease.containsKey(n)) continue;
                        this.activeDeadLease(n);
                    }
                    continue;
                }
                enumeration = this.equalsIgnoreCase;
                synchronized (enumeration) {
                    try {
                        this.equalsIgnoreCase.wait(this.get);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            catch (RuntimeException runtimeException) {
            }
        }
    }

    @Override
    public boolean hasActivatingLease(int n) {
        JRLease jRLease = (JRLease)this.activeDeadLease.get(n);
        return jRLease != null && !jRLease.isExpired();
    }

    public void activeDeadLease(int n) {
        List list;
        JRLeaseImpl jRLeaseImpl;
        boolean bl;
        if (n == 1 && (bl = this.addLease(jRLeaseImpl = JRLeaseImpl.generateSchedulerLease(this.validTime), true)) && (list = (List)this.addLease.get(jRLeaseImpl.getType())) != null && list.size() > 0) {
            for (JRLeaseAction jRLeaseAction : list) {
                if (jRLeaseAction == null) continue;
                jRLeaseAction.activate();
            }
        }
    }

    @Override
    public void stopWaitingLeases() {
        Enumeration enumeration = this.containsKey.keys();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (enumeration.hasMoreElements()) {
            int n = (Integer)enumeration.nextElement();
            JRLease jRLease = (JRLease)this.containsKey.get(n);
            if (!jRLease.isChecked() || !jRLease.isExpired() || this.activeDeadLease.containsKey(n)) continue;
            List list = (List)this.addLease.get(n);
            if (list != null && list.size() > 0) {
                for (JRLeaseAction jRLeaseAction : list) {
                    if (jRLeaseAction == null) continue;
                    jRLeaseAction.pause();
                }
            }
            arrayList.add(n);
        }
        this.add(arrayList);
    }

    @Override
    public void refreshWaitingLeases() {
        Enumeration enumeration = this.containsKey.keys();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (enumeration.hasMoreElements()) {
            int n = (Integer)enumeration.nextElement();
            JRLease jRLease = (JRLease)this.containsKey.get(n);
            if (!jRLease.isChecked() || !jRLease.isExpired()) continue;
            arrayList.add(n);
            jRLease.refresh(jRLease.getValidPeriod());
            jRLease.setChecked(false);
        }
        this.activate(arrayList);
    }

    @Override
    public void refreshWaitingLease(int n) {
        JRLease jRLease = (JRLease)this.containsKey.get(n);
        if (jRLease != null) {
            if (jRLease.isChecked() && jRLease.isExpired()) {
                jRLease.refresh(jRLease.getValidPeriod());
                jRLease.setChecked(false);
            }
            this.activeDeadLease.put(n, jRLease);
            this.containsKey.remove(n);
        }
    }

    @Override
    public void stopWaitingLease(int n) {
        JRLease jRLease = (JRLease)this.containsKey.get(n);
        if (jRLease != null) {
            List list;
            if (jRLease.isChecked() && jRLease.isExpired() && !this.activeDeadLease.containsKey(n) && (list = (List)this.addLease.get(n)) != null && list.size() > 0) {
                for (JRLeaseAction jRLeaseAction : list) {
                    if (jRLeaseAction == null) continue;
                    jRLeaseAction.pause();
                }
            }
            this.containsKey.remove(n);
        }
    }

    private void activate(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            JRLease jRLease = (JRLease)this.containsKey.get(n);
            this.activeDeadLease.put(n, jRLease);
            this.containsKey.remove(n);
        }
    }

    private void activeDeadLease(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            JRLease jRLease = (JRLease)this.activeDeadLease.get(n);
            this.containsKey.put(n, jRLease);
            this.activeDeadLease.remove(n);
        }
    }

    private void add(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            this.containsKey.remove(n);
        }
    }
}

