/*
 * Decompiled with CFR 0.152.
 */
package jet.server.lease;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jet.server.api.cluster.ClusterException;
import jet.server.cluster.core.JRMessage;
import jet.server.cluster.core.Response;
import jet.server.cluster.core.Topic;
import jet.server.cluster.core.Transceiver;
import jet.server.lease.JRLeaseAction;
import jet.server.lease.JRLeaseBasicThread;
import jet.server.lease.JRLeaseImpl;
import jet.server.lease.JRLeaseMessage;
import jet.server.lease.JRLeaseMessageImpl;
import jet.server.lease.JRLeaseThread;
import jet.server.log.ServiceLogger;

public class LeaseTransceiver
extends Transceiver {
    public static final int TYPE_ACTIVATE_LEASE = 0;
    public static final int TYPE_GET_LEASE_INFO = 1;
    public static final int TYPE_SEND_LEASE_INFO = 2;
    protected int maxActivatingLeasesCount = 5;
    protected long validTime = 600000L;
    private JRLeaseThread LEASE;

    public LeaseTransceiver(JRLeaseThread jRLeaseThread) {
        super(Topic.LEASE);
        this.LEASE = jRLeaseThread;
        this.validTime = ((JRLeaseBasicThread)jRLeaseThread).validTime;
        this.maxActivatingLeasesCount = ((JRLeaseBasicThread)jRLeaseThread).maxActivatingLeasesCount;
    }

    @Override
    public Serializable handleRequest(JRMessage jRMessage) {
        JRLeaseMessage jRLeaseMessage = (JRLeaseMessage)jRMessage.getObject();
        String string = (String)jRLeaseMessage.getProperties().get("lease_type");
        int n = 0;
        try {
            n = Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            ServiceLogger.logError(numberFormatException);
        }
        JRLeaseMessageImpl jRLeaseMessageImpl = new JRLeaseMessageImpl();
        Map map = jRLeaseMessageImpl.getProperties();
        switch (jRMessage.getFlag()) {
            case 0: {
                if (n == 1) {
                    JRLeaseImpl jRLeaseImpl = JRLeaseImpl.generateSchedulerLease(this.validTime);
                    this.LEASE.addLease(jRLeaseImpl, false);
                    Set set = jRLeaseMessage.getProperties().keySet();
                    for (String string2 : set) {
                        if (string2 == null || !string2.startsWith("jr_action_")) continue;
                        String string3 = (String)jRLeaseMessage.getProperties().get(string2);
                        this.LEASE.registerAction(jRLeaseImpl.getType(), string3);
                    }
                }
                map.put("lease_type", string);
                map.put("activated_successful", String.valueOf(true));
                return jRLeaseMessageImpl;
            }
            case 1: {
                boolean bl = this.LEASE.hasActivatingLease(n);
                map.put("lease_type", string);
                map.put("is_activated", String.valueOf(bl));
                return jRLeaseMessageImpl;
            }
        }
        return null;
    }

    public void transferLease(int n, List list) {
        if (list == null || list.size() == 0) {
            this.LEASE.stopWaitingLease(n);
            return;
        }
        JRLeaseMessageImpl jRLeaseMessageImpl = new JRLeaseMessageImpl();
        Map map = jRLeaseMessageImpl.getProperties();
        map.put("lease_type", String.valueOf(1));
        List list2 = null;
        try {
            list2 = super.castRequest(new JRMessage(1, jRLeaseMessageImpl), 5000L);
        }
        catch (ClusterException clusterException) {
            ServiceLogger.logError((Throwable)((Object)clusterException));
        }
        ArrayList<Response> arrayList = new ArrayList<Response>();
        ArrayList<Response> arrayList2 = new ArrayList<Response>();
        if (list2 != null) {
            Object object;
            for (Response response : list2) {
                JRLeaseMessage jRLeaseMessage;
                if (response == null || (jRLeaseMessage = (JRLeaseMessage)response.getValue()) == null) continue;
                object = (String)jRLeaseMessage.getProperties().get("is_activated");
                if (((String)object).equalsIgnoreCase("true")) {
                    arrayList.add(response);
                    continue;
                }
                arrayList2.add(response);
            }
            if (arrayList.size() >= this.maxActivatingLeasesCount) {
                this.LEASE.stopWaitingLease(n);
                return;
            }
            if (arrayList2.size() == 0) {
                this.LEASE.refreshWaitingLease(n);
                return;
            }
            int n2 = 0;
            boolean bl = false;
            int n3 = 0;
            for (JRLeaseAction jRLeaseAction : list) {
                map.put("jr_action_" + jRLeaseAction.getActionID(), jRLeaseAction.getActionID());
            }
            while (n2 <= 2) {
                ++n2;
                object = null;
                try {
                    int n4 = ((Response)arrayList2.get(n3)).getMember();
                    object = (JRLeaseMessage)super.sendRequest(n4, new JRMessage(0, jRLeaseMessageImpl), 3000L);
                }
                catch (ClusterException clusterException) {
                    ServiceLogger.logError((Throwable)((Object)clusterException));
                    ++n3;
                    continue;
                }
                if (object == null) {
                    ++n3;
                    continue;
                }
                String string = (String)object.getProperties().get("activated_successful");
                if (string != null && string.equalsIgnoreCase("true")) {
                    bl = true;
                    break;
                }
                ++n3;
            }
            if (bl) {
                this.LEASE.stopWaitingLease(n);
            }
        } else {
            this.LEASE.refreshWaitingLease(n);
        }
    }

    public List getActivatingLeasesResponses(int n) {
        JRLeaseMessageImpl jRLeaseMessageImpl = new JRLeaseMessageImpl();
        Map map = jRLeaseMessageImpl.getProperties();
        map.put("lease_type", String.valueOf(n));
        List list = null;
        try {
            list = super.castRequest(new JRMessage(1, jRLeaseMessageImpl), 5000L);
        }
        catch (ClusterException clusterException) {
            ServiceLogger.logError((Throwable)((Object)clusterException));
        }
        ArrayList<Response> arrayList = new ArrayList<Response>();
        if (list != null) {
            for (Response response : list) {
                JRLeaseMessage jRLeaseMessage;
                String string;
                if (response == null || response.getValue() == null || !(string = (String)(jRLeaseMessage = (JRLeaseMessage)response.getValue()).getProperties().get("is_activated")).equalsIgnoreCase("true")) continue;
                arrayList.add(response);
            }
        }
        return arrayList;
    }
}

