/*
 * Decompiled with CFR 0.152.
 */
package jet.server.log;

import com.jinfonet.util.JRLogger;
import java.io.File;
import java.util.List;
import java.util.Properties;
import jet.server.log.JRLoggerUtility;
import jet.server.log.LogConfigFactory;

public class JRLoggerConfigFile {
    private String LOG_NAMES;
    private List SEDU;
    private long append;
    private boolean endsWith;

    JRLoggerConfigFile(String string) {
        this.LOG_NAMES = string;
    }

    public boolean load() {
        boolean bl = false;
        if (this.isFileChanged()) {
            this.SEDU = JRLoggerUtility.readLines(this.LOG_NAMES, false);
            this.endsWith = false;
            bl = true;
        }
        return bl;
    }

    public List getContents() {
        return this.SEDU;
    }

    boolean isFileChanged() {
        boolean bl = false;
        File file = new File(this.LOG_NAMES);
        long l = file.lastModified();
        if (l > this.append) {
            this.append = l;
            bl = true;
        }
        return bl;
    }

    public String getValue(String string) {
        if (string == null) {
            return null;
        }
        String string22 = null;
        for (String string22 : this.SEDU) {
            String string3;
            int n;
            if (string22.indexOf(string) < 0 || (n = string22.indexOf("=")) <= 0 || !(string3 = string22.substring(0, n)).trim().endsWith(string.trim())) continue;
            string22 = string22.substring(n + 1).trim();
            return string22;
        }
        return null;
    }

    public void setValue(String string, String string2) {
        if (string == null || string2 == null) {
            return;
        }
        int n = this.SEDU.size();
        for (int i = 0; i < n; ++i) {
            int n2;
            String string3 = (String)this.SEDU.get(i);
            if (string3.indexOf(string) < 0 || (n2 = string3.indexOf("=")) <= 0 || !string3.substring(0, n2).trim().endsWith(string.trim()) || string2.trim().equals(string3.substring(n2 + 1).trim())) continue;
            string3 = string3.substring(0, n2 + 1) + string2;
            this.SEDU.set(i, string3);
            this.endsWith = true;
        }
    }

    public boolean save() {
        if (this.endsWith) {
            JRLoggerUtility.saveToFile(this.LOG_NAMES, this.SEDU);
            this.endsWith = false;
            return true;
        }
        return false;
    }

    public void convertOldConfig(Properties properties) {
        if (properties == null || properties.size() == 0) {
            return;
        }
        this.load();
        this.LOG_NAMES(properties, "log.access.level", "log.access.destination", "log4j.logger.com.jinfonet.server.logAccess", 0);
        this.LOG_NAMES(properties, "log.debug.level", "log.debug.destination", "log4j.logger.com.jinfonet.server.logDebug", 4);
        this.LOG_NAMES(properties, "log.engine.level", "log.engine.destination", "log4j.logger.com.jinfonet.server.logPerformance", 5);
        this.LOG_NAMES(properties, "log.error.level", "log.error.destination", "log4j.logger.com.jinfonet.server.logError", 2);
        this.LOG_NAMES(properties, "log.event.level", "log.event.destination", "log4j.logger.com.jinfonet.server.logEvent", 3);
        this.LOG_NAMES(properties, "log.manage.level", "log.manage.destination", "log4j.logger.com.jinfonet.server.logManage", 1);
        this.convert(properties, "log.access.file.filename", "log4j.appender." + LogConfigFactory.LOG_NAMES[0] + "File" + ".File");
        this.convert(properties, "log.debug.file.filename", "log4j.appender." + LogConfigFactory.LOG_NAMES[4] + "File" + ".File");
        this.convert(properties, "log.engine.file.filename", "log4j.appender." + LogConfigFactory.LOG_NAMES[5] + "File" + ".File");
        this.convert(properties, "log.error.file.filename", "log4j.appender." + LogConfigFactory.LOG_NAMES[2] + "File" + ".File");
        this.convert(properties, "log.event.file.filename", "log4j.appender." + LogConfigFactory.LOG_NAMES[3] + "File" + ".File");
        this.convert(properties, "log.manage.file.filename", "log4j.appender." + LogConfigFactory.LOG_NAMES[1] + "File" + ".File");
        this.convert(properties, "log.access.rolling_logfile.filename", "log4j.appender." + LogConfigFactory.LOG_NAMES[0] + "RollingFile" + ".File");
        this.convert(properties, "log.debug.rolling_logfile.filename", "log4j.appender." + LogConfigFactory.LOG_NAMES[4] + "RollingFile" + ".File");
        this.convert(properties, "log.engine.rolling_logfile.filename", "log4j.appender." + LogConfigFactory.LOG_NAMES[5] + "RollingFile" + ".File");
        this.convert(properties, "log.error.rolling_logfile.filename", "log4j.appender." + LogConfigFactory.LOG_NAMES[2] + "RollingFile" + ".File");
        this.convert(properties, "log.event.rolling_logfile.filename", "log4j.appender." + LogConfigFactory.LOG_NAMES[3] + "RollingFile" + ".File");
        this.convert(properties, "log.manage.rolling_logfile.filename", "log4j.appender." + LogConfigFactory.LOG_NAMES[1] + "RollingFile" + ".File");
        this.convert(properties, "log.access.rolling_logfile.buffer", "log4j.appender." + LogConfigFactory.LOG_NAMES[0] + "RollingFile" + ".BufferSize");
        this.convert(properties, "log.debug.rolling_logfile.buffer", "log4j.appender." + LogConfigFactory.LOG_NAMES[4] + "RollingFile" + ".BufferSize");
        this.convert(properties, "log.engine.rolling_logfile.buffer", "log4j.appender." + LogConfigFactory.LOG_NAMES[5] + "RollingFile" + ".BufferSize");
        this.convert(properties, "log.error.rolling_logfile.buffer", "log4j.appender." + LogConfigFactory.LOG_NAMES[2] + "RollingFile" + ".BufferSize");
        this.convert(properties, "log.event.rolling_logfile.buffer", "log4j.appender." + LogConfigFactory.LOG_NAMES[3] + "RollingFile" + ".BufferSize");
        this.convert(properties, "log.manage.rolling_logfile.buffer", "log4j.appender." + LogConfigFactory.LOG_NAMES[1] + "RollingFile" + ".BufferSize");
        this.convert(properties, "log.access.rolling_logfile.rollover", "log4j.appender." + LogConfigFactory.LOG_NAMES[0] + "RollingFile" + ".MaxFileSize");
        this.convert(properties, "log.debug.rolling_logfile.rollover", "log4j.appender." + LogConfigFactory.LOG_NAMES[4] + "RollingFile" + ".MaxFileSize");
        this.convert(properties, "log.engine.rolling_logfile.rollover", "log4j.appender." + LogConfigFactory.LOG_NAMES[5] + "RollingFile" + ".MaxFileSize");
        this.convert(properties, "log.error.rolling_logfile.rollover", "log4j.appender." + LogConfigFactory.LOG_NAMES[2] + "RollingFile" + ".MaxFileSize");
        this.convert(properties, "log.event.rolling_logfile.rollover", "log4j.appender." + LogConfigFactory.LOG_NAMES[3] + "RollingFile" + ".MaxFileSize");
        this.convert(properties, "log.manage.rolling_logfile.rollover", "log4j.appender." + LogConfigFactory.LOG_NAMES[1] + "RollingFile" + ".MaxFileSize");
        this.convert(properties, "log.access.socket.host", "log4j.appender." + LogConfigFactory.LOG_NAMES[0] + "Socket" + ".RemoteHost");
        this.convert(properties, "log.debug.socket.host", "log4j.appender." + LogConfigFactory.LOG_NAMES[4] + "Socket" + ".RemoteHost");
        this.convert(properties, "log.engine.socket.host", "log4j.appender." + LogConfigFactory.LOG_NAMES[5] + "Socket" + ".RemoteHost");
        this.convert(properties, "log.error.socket.host", "log4j.appender." + LogConfigFactory.LOG_NAMES[2] + "Socket" + ".RemoteHost");
        this.convert(properties, "log.event.socket.host", "log4j.appender." + LogConfigFactory.LOG_NAMES[3] + "Socket" + ".RemoteHost");
        this.convert(properties, "log.manage.socket.host", "log4j.appender." + LogConfigFactory.LOG_NAMES[1] + "Socket" + ".RemoteHost");
        this.convert(properties, "log.access.socket.port", "log4j.appender." + LogConfigFactory.LOG_NAMES[0] + "Socket" + ".Port");
        this.convert(properties, "log.debug.socket.port", "log4j.appender." + LogConfigFactory.LOG_NAMES[4] + "Socket" + ".Port");
        this.convert(properties, "log.engine.socket.port", "log4j.appender." + LogConfigFactory.LOG_NAMES[5] + "Socket" + ".Port");
        this.convert(properties, "log.error.socket.port", "log4j.appender." + LogConfigFactory.LOG_NAMES[2] + "Socket" + ".Port");
        this.convert(properties, "log.event.socket.port", "log4j.appender." + LogConfigFactory.LOG_NAMES[3] + "Socket" + ".Port");
        this.convert(properties, "log.manage.socket.port", "log4j.appender." + LogConfigFactory.LOG_NAMES[1] + "Socket" + ".Port");
        this.save();
    }

    private void convert(Properties properties, String string, String string2) {
        String string3 = properties.getProperty(string);
        this.setValue(string2, string3);
    }

    private void LOG_NAMES(Properties properties, String string, String string2, String string3, int n) {
        String string4 = properties.getProperty(string);
        String string5 = properties.getProperty(string2);
        String string6 = null;
        String string7 = this.getValue(string3);
        if (string4 != null) {
            string4 = this.append(Integer.parseInt(string4));
        }
        if (string5 != null && (string5 = this.endsWith(string5)) != null) {
            if ("stderr".equals(string5)) {
                string6 = "System.err";
            } else if ("stdout".equals(string5)) {
                string6 = "System.out";
            }
            string5 = LogConfigFactory.LOG_NAMES[n] + string5;
        }
        if (string5 != null && this.SEDU(string5)) {
            if (string4 != null) {
                this.setValue(string3, string4 + "," + string5);
            } else {
                int n2 = string7.indexOf(",");
                this.setValue(string3, string7.substring(0, n2 + 1) + string5);
            }
            if (string6 != null) {
                this.setValue("log4j.appender." + string5 + ".target", string6);
            }
        } else if (string4 != null) {
            int n3 = string7.indexOf(",");
            this.setValue(string3, string4 + string7.substring(n3));
        }
    }

    private boolean SEDU(String string) {
        String string2 = "log4j.appender." + string;
        for (String string3 : this.SEDU) {
            if (!string3.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    private String append(int n) {
        int n2 = n <= 0 ? 0 : (n == 1 ? 5 : (n == 2 ? 5 : 6));
        return JRLogger.getMappedLevel((int)n2).toString();
    }

    private String endsWith(String string) {
        if ("file".equals(string)) {
            return "File";
        }
        if ("rolling_logfile".equals(string)) {
            return "RollingFile";
        }
        if ("socket".equals(string)) {
            return "Socket";
        }
        if ("stderr".equals(string) || "stdout".equals(string)) {
            return "Console";
        }
        return null;
    }
}

