/*
 * Decompiled with CFR 0.152.
 */
package jet.server.log;

import com.jinfonet.util.JRRepositorySelector;
import java.util.Properties;
import jet.server.log.JRLoggerConfigFile;
import jet.server.log.JRLoggerUtility;
import jet.server.log.JRPropertyConfigurator;

public class JRLoggerConfigService {
    public static final String CONFIG_FILE_NAME_KEY = "log.config.filename";
    public static final String DEFULT_CONFIG_FILE_NAME = "LogConfig.properties";
    public static final String CONFIG_AUTO_WATCH_KEY = "log.config.update";
    public static final boolean DEFAULT_CONFIG_AUTO_WATCH = Boolean.valueOf("false");
    public static final String AUTO_WATCH_INTERVAL_KEY = "log.config.update.interval";
    public static final long DEFAULT_AUTO_WATCH_INTERVAL = Long.valueOf("60000");
    private static JRLoggerConfigService SEDU = new JRLoggerConfigService();
    private JRLoggerConfigFile booleanValue;
    private String configure;
    private boolean configureAndWatch;
    private long convertOldConfig;
    private Thread create;
    private boolean destroy;
    private boolean getConfigAutoWatch;
    private boolean getConfigPropName;

    private JRLoggerConfigService() {
    }

    public static JRLoggerConfigService instance() {
        return SEDU;
    }

    public void create() {
        this.create(System.getProperties());
    }

    public synchronized void create(Properties properties) {
        this.create(properties, null);
    }

    public synchronized void create(Properties properties, Properties properties2) {
        if (!this.destroy) {
            this.configure = JRLoggerUtility.getConfigPropName(properties, DEFULT_CONFIG_FILE_NAME);
            this.configureAndWatch = JRLoggerUtility.getConfigAutoWatch(properties, DEFAULT_CONFIG_AUTO_WATCH);
            this.convertOldConfig = JRLoggerUtility.getConfigWatchInterval(properties, DEFAULT_AUTO_WATCH_INTERVAL);
            JRRepositorySelector.setInvokerContext((String)"com.jinfonet");
            this.booleanValue = new JRLoggerConfigFile(this.configure);
            this.booleanValue.convertOldConfig(properties2);
            this.destroy = true;
        }
    }

    public JRLoggerConfigFile getConfigFile() {
        return this.booleanValue;
    }

    public synchronized void start() {
        if (!this.getConfigAutoWatch) {
            if (!this.destroy) {
                this.create();
            }
            this.getConfigAutoWatch = true;
            if (this.configureAndWatch) {
                this.create = JRPropertyConfigurator.configureAndWatch(this.configure, this.convertOldConfig);
            } else {
                JRPropertyConfigurator.configure(this.configure);
            }
        }
    }

    public synchronized void stop() {
        if (this.getConfigAutoWatch && this.configureAndWatch) {
            this.create.destroy();
            this.create.interrupt();
            this.create = null;
        }
        this.getConfigAutoWatch = false;
    }

    public void update() {
        if (this.getConfigAutoWatch) {
            if (this.configureAndWatch) {
                this.create.interrupt();
            } else {
                JRPropertyConfigurator.configure(this.configure);
            }
        }
    }

    public void destroy() {
        this.stop();
        JRRepositorySelector.removeInvokerContext((String)"com.jinfonet");
        this.destroy = false;
    }

    void setFromMonitor(boolean bl) {
        if (!bl && this.getConfigPropName) {
            this.stop();
            this.destroy = false;
        }
        if (!this.destroy || !bl) {
            this.getConfigPropName = bl;
        }
    }

    boolean isFromMonitor() {
        return this.getConfigPropName;
    }

    boolean isStarted() {
        return this.getConfigAutoWatch;
    }
}

