/*
 * Decompiled with CFR 0.152.
 */
package jet.server.log;

import com.jinfonet.util.JRLoggerReg;
import com.jinfonet.util.JRRepositorySelector;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Properties;
import jet.JSvrResource;
import jet.cs.ExProperties;
import jet.server.log.JRLoggerConfigService;
import jet.server.log.JRLoggerUtility;
import jet.server.log.ServiceLogger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.helpers.FileWatchdog;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggerRepository;

public class JRPropertyConfigurator {
    public static void configure(String string) {
        JRPropertyConfigurator.configure(string, JRRepositorySelector.getRepository((String)"com.jinfonet"));
    }

    public static void configure(URL uRL) {
        JRPropertyConfigurator.configure(uRL, JRRepositorySelector.getRepository((String)"com.jinfonet"));
    }

    public static void configure(ExProperties exProperties) {
        JRPropertyConfigurator.configure(exProperties, JRRepositorySelector.getRepository((String)"com.jinfonet"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void configure(String string, LoggerRepository loggerRepository) {
        ExProperties exProperties = new ExProperties();
        LogLog.debug((String)JSvrResource.getMessage("LOGGING_M_00001", "'" + string + "'"));
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            exProperties.load(fileInputStream);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            LogLog.error((String)JSvrResource.getMessage("LOGGING_M_00002", "'" + string + "'"), (Throwable)iOException);
            LogLog.error((String)JSvrResource.getMessage("LOGGING_M_00005", "'" + string + "'"));
            return;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    ServiceLogger.logError(iOException);
                }
            }
        }
        JRPropertyConfigurator.configure(exProperties, loggerRepository);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void configure(URL uRL, LoggerRepository loggerRepository) {
        ExProperties exProperties = new ExProperties();
        LogLog.debug((String)JSvrResource.getMessage("LOGGING_M_00006", "'" + uRL + "'"));
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
            exProperties.load(inputStream);
        }
        catch (IOException iOException) {
            LogLog.error((String)JSvrResource.getMessage("LOGGING_M_00007", "'" + uRL + "'"), (Throwable)iOException);
            LogLog.error((String)JSvrResource.getMessage("LOGGING_M_00008", "'" + uRL + "'"));
            return;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    ServiceLogger.logError(iOException);
                }
            }
        }
        JRPropertyConfigurator.configure(exProperties, loggerRepository);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void configure(ExProperties exProperties, LoggerRepository loggerRepository) {
        if (!JRLoggerReg.hasReg()) {
            if (JRLoggerConfigService.instance().isStarted()) {
                JRLoggerUtility.validLog4jProps(exProperties);
            }
            if (exProperties.getProperty("log4j.debug") != null && exProperties.getProperty("log4j.debug").equalsIgnoreCase("true")) {
                PrintStream printStream = null;
                try {
                    printStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(JRLoggerUtility.getLogPath() + "log4jprops.log")));
                    exProperties.list(printStream);
                }
                catch (Exception exception) {
                }
                finally {
                    if (printStream != null) {
                        printStream.flush();
                        printStream.close();
                    }
                }
                LogLog.setQuietMode((boolean)false);
            } else {
                LogLog.setQuietMode((boolean)true);
            }
            JRLoggerReg.setHasReg();
            try {
                new PropertyConfigurator().doConfigure((Properties)exProperties, loggerRepository);
            }
            catch (Throwable throwable) {
                LogLog.error((String)JSvrResource.getMessage("LOGGING_M_00009"), (Throwable)throwable);
                return;
            }
        }
        ServiceLogger.update(exProperties);
        if (!JRLoggerConfigService.instance().isFromMonitor()) {
            JRLoggerReg.updateForServer((Properties)exProperties);
        }
    }

    public static Thread configureAndWatch(String string) {
        return JRPropertyConfigurator.configureAndWatch(string, 60000L);
    }

    public static Thread configureAndWatch(String string, long l) {
        PropertyWatchdog propertyWatchdog = new PropertyWatchdog(string);
        propertyWatchdog.setDelay(l);
        propertyWatchdog.start();
        Thread.currentThread();
        Thread.yield();
        return propertyWatchdog;
    }

    static final class PropertyWatchdog
    extends FileWatchdog {
        volatile boolean isStoped;

        PropertyWatchdog(String string) {
            super(string);
        }

        public void doOnChange() {
            JRPropertyConfigurator.configure(this.filename);
        }

        public void destroy() {
            this.isStoped = true;
        }

        public void run() {
            while (!this.isStoped) {
                this.checkAndConfigure();
                try {
                    Thread.sleep(this.delay);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

