/*
 * Decompiled with CFR 0.152.
 */
package jet.server.log;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Date;
import jet.server.util.Alarm;
import jet.server.util.AlarmHandler;
import jet.server.util.AlarmManager;
import jet.server.util.ErrorMessages;

public class LogOutputStream
extends OutputStream
implements AlarmHandler {
    protected byte[] buf;
    protected int count;
    long written;
    File outfile;
    long rollover;
    final int NUMFILES = 9;
    protected static final String lineSeparator = System.getProperty("line.separator", "\n");
    private FileOutputStream SEDU;
    private static AlarmManager append = new AlarmManager();
    private int arraycopy;
    private Date canWrite = new Date();

    public LogOutputStream(File file, long l, int n, int n2) throws IOException {
        this.buf = new byte[n];
        this.rollover = l;
        this.outfile = file;
        this.arraycopy = n2;
        File file2 = new File(file.getParent());
        if (!file2.exists() && !file2.mkdirs()) {
            throw new FileNotFoundException("Cannot create log directory " + file2 + ". " + "Make sure that the parent directory has the " + "correct permissions.");
        }
        if (file.exists() && !file.canWrite()) {
            throw new FileNotFoundException("Cannot write to log file " + file + ". " + "Make sure that the file has the correct permissions.");
        }
        if (l != 0L && file.length() >= l) {
            this.rolloverFile();
        }
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "rw");
        }
        catch (IOException iOException) {
            throw new FileNotFoundException("Cannot write to log file " + file + ". " + "Make sure that the file has the correct permissions.");
        }
        randomAccessFile.seek(randomAccessFile.length());
        this.SEDU = new FileOutputStream(randomAccessFile.getFD());
        if (n2 > 0) {
            Alarm alarm = new Alarm(this);
            alarm.setTimeFromNow(n2 * 1000);
            append.schedule(alarm);
        }
    }

    public LogOutputStream(File file) throws IOException {
        this(file, 100000L, 512, 0);
    }

    public LogOutputStream(File file, long l, int n) throws IOException {
        this(file, l, n, 0);
    }

    @Override
    public synchronized void write(int n) throws IOException {
        long l;
        ++this.written;
        if (this.buf.length > 0) {
            if (this.count == this.buf.length) {
                this.flush();
            }
            this.buf[this.count++] = (byte)n;
        } else {
            this.SEDU.write(n);
        }
        if (this.rollover != 0L && (l = this.outfile.length()) >= this.rollover) {
            this.flush();
            this.rolloverFile();
        }
    }

    @Override
    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        long l;
        int n3 = this.buf.length - this.count;
        this.written += (long)n2;
        if (n2 <= n3) {
            System.arraycopy(byArray, n, this.buf, this.count, n2);
            this.count += n2;
        } else {
            this.flush();
            this.SEDU.write(byArray, n, n2);
        }
        if (this.rollover != 0L && (l = this.outfile.length()) >= this.rollover) {
            this.flush();
            this.rolloverFile();
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.arraycopy == 0) {
            this.canWrite = new Date();
        }
        this.SEDU.write(this.buf, 0, this.count);
        this.SEDU.flush();
        this.count = 0;
    }

    @Override
    public void handleAlarm(Alarm alarm) {
        if (this.arraycopy == 0) {
            return;
        }
        if (alarm.getTime() >= this.canWrite.getTime() + (long)(this.arraycopy * 1000)) {
            try {
                this.flush();
            }
            catch (IOException iOException) {
                ErrorMessages.error("Autoflush: error writing to log file " + this.outfile, iOException);
            }
        }
        alarm.setTimeFromNow(this.arraycopy * 1000);
        append.schedule(alarm);
    }

    void rolloverFile() throws IOException {
        File file;
        if (this.SEDU != null) {
            this.SEDU.flush();
            this.SEDU.close();
        }
        if ((file = new File(this.outfile.getAbsolutePath() + "." + 9)).exists()) {
            file.delete();
        }
        for (int i = 8; i > 0; --i) {
            File file2 = new File(this.outfile.getAbsolutePath() + "." + i);
            if (!file2.exists()) continue;
            file2.renameTo(new File(this.outfile.getAbsolutePath() + "." + (i + 1)));
        }
        File file3 = new File(this.outfile.getAbsolutePath() + "." + 1);
        this.outfile.renameTo(file3);
        this.SEDU = new FileOutputStream(this.outfile);
        this.written = 0L;
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.SEDU != null) {
            this.SEDU.close();
        }
    }

    static {
        new Thread((Runnable)append, "Logging Alarm Manager").start();
    }
}

