/*
 * Decompiled with CFR 0.152.
 */
package jet.server.log;

import com.jinfonet.util.JRLogger;
import com.jinfonet.util.JRLoggerReg;
import java.rmi.RemoteException;
import java.sql.Timestamp;
import java.util.Properties;
import jet.JSvrResource;
import jet.Resource;
import jet.cs.ExProperties;
import jet.server.intf.security.SecurityAdapter;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.log.JRLoggerConfigService;
import jet.server.util.ServerUtil;

public class ServiceLogger {
    private static JRLogger SEDU;
    private static JRLogger append;
    private static JRLogger create;
    private static JRLogger currentTimeMillis;
    private static JRLogger deIndent;
    private static JRLogger destroy;
    private static JRLogger equals;
    public static final int ACCESS = 0;
    public static final int MANAGE = 1;
    public static final int ERROR = 2;
    public static final int EVENT = 3;
    public static final int DEBUG = 4;
    public static final int ENGINE = 5;
    public static final int DUMP = 6;
    public static final String LOG_ACCESS_NAME = "com.jinfonet.server.logAccess";
    public static final String LOG_MANAGE_NAME = "com.jinfonet.server.logManage";
    public static final String LOG_ERROR_NAME = "com.jinfonet.server.logError";
    public static final String LOG_EVENT_NAME = "com.jinfonet.server.logEvent";
    public static final String LOG_DEBUG_NAME = "com.jinfonet.server.logDebug";
    public static final String LOG_PERFORMANCE_NAME = "com.jinfonet.server.logPerformance";
    public static final String LOG_DUMP_NAME = "com.jinfonet.server.logDump";
    private static JRLogger[] equalsIgnoreCase;
    public static final int F = 1;
    public static final int E = 2;
    public static final int W = 3;
    public static final int O = 4;
    public static final int I = 5;
    public static final int T = 6;
    public static final int OFF = 0;
    public static final int ALL = 7;
    public static final int LEVEL_NONE = 0;
    public static final int LEVEL_IMPORTANT = 4;
    public static final int LEVEL_CONSIDERABLE = 5;
    public static final int LEVEL_TRIVIAL = 6;
    private static boolean error;
    private static boolean filterLogSecretInfo;
    private static final String format = "resource/JSDebug";

    protected ServiceLogger() {
    }

    static void update(Properties properties) {
        Object object;
        if (error && ((object = properties.getProperty("config.overwrite")) == null || !((String)object).equalsIgnoreCase("true"))) {
            return;
        }
        object = properties.keys();
        block0: while (object.hasMoreElements()) {
            String string = (String)object.nextElement();
            String string2 = null;
            int n = 0;
            if (string.toUpperCase().startsWith("TRACELEVEL.")) {
                n = 1;
                string2 = string.substring("TRACELEVEL.".length());
            } else if (string.toUpperCase().startsWith("ERRORLEVEL.")) {
                n = 2;
                string2 = string.substring("ERRORLEVEL.".length());
            }
            if (string2 == null) continue;
            for (int i = 0; i < equalsIgnoreCase.length; ++i) {
                if (equalsIgnoreCase[i] == null || !string2.equals(equalsIgnoreCase[i].getName())) continue;
                String string3 = (String)properties.get(string);
                equalsIgnoreCase[i].setLevel(JRLogger.getLevelValue((String)string3), n);
                continue block0;
            }
        }
    }

    public static void setDebug() {
        error = true;
        if (filterLogSecretInfo && JRLoggerReg.hasSetGDBGLevel()) {
            int n = JRLoggerReg.getGDBGTrace();
            int n2 = JRLoggerReg.getGDBGError();
            for (int i = 0; i < equalsIgnoreCase.length; ++i) {
                equalsIgnoreCase[i].setLevel(n2, 2);
                equalsIgnoreCase[i].setLevel(n, 1);
            }
        }
    }

    public static void indentAccess(String string) {
        if (SEDU == null) {
            return;
        }
        SEDU.indent(string);
    }

    public static void deIndentAccess(String string) {
        if (SEDU == null) {
            return;
        }
        SEDU.deIndent(string);
    }

    public static void indentManager(String string) {
        if (append == null) {
            return;
        }
        append.indent(string);
    }

    public static void deIndentManager(String string) {
        if (append == null) {
            return;
        }
        append.deIndent(string);
    }

    public static void indentEvent(String string) {
        if (currentTimeMillis == null) {
            return;
        }
        currentTimeMillis.indent(string);
    }

    public static void deIndentEvent(String string) {
        if (currentTimeMillis == null) {
            return;
        }
        currentTimeMillis.deIndent(string);
    }

    public static void indentDebug(String string) {
        if (deIndent == null) {
            return;
        }
        deIndent.indent(string);
    }

    public static void deIndentDebug(String string) {
        if (deIndent == null) {
            return;
        }
        deIndent.deIndent(string);
    }

    public static void indentEngine(String string) {
        if (destroy == null) {
            return;
        }
        destroy.indent(string);
    }

    public static void deIndentEngine(String string) {
        if (destroy == null) {
            return;
        }
        destroy.deIndent(string);
    }

    public static void indentError(String string) {
        if (create == null) {
            return;
        }
        create.indent(string);
    }

    public static void deIndentError(String string) {
        if (create == null) {
            return;
        }
        create.deIndent(string);
    }

    public static void indentDump(String string) {
        if (equals == null) {
            return;
        }
        equals.indent(string);
    }

    public static void deIndentDump(String string) {
        if (equals == null) {
            return;
        }
        equals.deIndent(string);
    }

    public static void print(Object object) {
        ServiceLogger.print(object, null);
    }

    public static void print(Throwable throwable) {
        ServiceLogger.print(null, throwable);
    }

    public static void print(Object object, Throwable throwable) {
        if (deIndent == null) {
            return;
        }
        deIndent.trace(object, throwable, 7);
    }

    public static void print(int n) {
        ServiceLogger.print(n, (Throwable)null);
    }

    public static void print(int n, Object object) {
        ServiceLogger.print(n, new Object[]{object});
    }

    public static void print(int n, Object[] objectArray) {
        if (deIndent == null) {
            return;
        }
        deIndent.trace(n, objectArray, null, 7);
    }

    public static void print(int n, Throwable throwable) {
        if (deIndent == null) {
            return;
        }
        deIndent.trace(n, throwable, 7);
    }

    public static void initErrorLog(ExProperties exProperties) {
        JRLoggerConfigService.instance().setFromMonitor(true);
        JRLoggerConfigService.instance().create(exProperties);
        create = (JRLogger)JRLogger.getLogger((String)LOG_ERROR_NAME);
        deIndent = (JRLogger)JRLogger.getLogger((String)LOG_DEBUG_NAME);
        SEDU = (JRLogger)JRLogger.getLogger((String)LOG_ACCESS_NAME);
        currentTimeMillis = (JRLogger)JRLogger.getLogger((String)LOG_EVENT_NAME);
        ServiceLogger.equalsIgnoreCase[0] = SEDU;
        ServiceLogger.equalsIgnoreCase[2] = create;
        ServiceLogger.equalsIgnoreCase[3] = currentTimeMillis;
        ServiceLogger.equalsIgnoreCase[4] = deIndent;
        JRLoggerConfigService.instance().start();
        SEDU.setFQCN(ServiceLogger.class.getName());
        create.setFQCN(ServiceLogger.class.getName());
        currentTimeMillis.setFQCN(ServiceLogger.class.getName());
        deIndent.setFQCN(ServiceLogger.class.getName());
        SEDU.setResourceBundle(Resource.getResourceBundle((String)format));
        create.setResourceBundle(Resource.getResourceBundle((String)format));
        currentTimeMillis.setResourceBundle(Resource.getResourceBundle((String)format));
        deIndent.setResourceBundle(Resource.getResourceBundle((String)format));
    }

    public static void init(ExProperties exProperties) {
        ServiceLogger.init(exProperties, null);
    }

    public static void init(ExProperties exProperties, Properties properties) {
        JRLoggerConfigService.instance().setFromMonitor(false);
        JRLoggerConfigService.instance().create(exProperties, properties);
        deIndent = (JRLogger)JRLogger.getLogger((String)LOG_DEBUG_NAME);
        SEDU = (JRLogger)JRLogger.getLogger((String)LOG_ACCESS_NAME);
        append = (JRLogger)JRLogger.getLogger((String)LOG_MANAGE_NAME);
        create = (JRLogger)JRLogger.getLogger((String)LOG_ERROR_NAME);
        currentTimeMillis = (JRLogger)JRLogger.getLogger((String)LOG_EVENT_NAME);
        destroy = (JRLogger)JRLogger.getLogger((String)LOG_PERFORMANCE_NAME);
        ServiceLogger.equalsIgnoreCase[6] = equals = (JRLogger)JRLogger.getLogger((String)LOG_DUMP_NAME);
        ServiceLogger.equalsIgnoreCase[0] = SEDU;
        ServiceLogger.equalsIgnoreCase[1] = append;
        ServiceLogger.equalsIgnoreCase[2] = create;
        ServiceLogger.equalsIgnoreCase[3] = currentTimeMillis;
        ServiceLogger.equalsIgnoreCase[4] = deIndent;
        ServiceLogger.equalsIgnoreCase[5] = destroy;
        JRLoggerConfigService.instance().start();
        filterLogSecretInfo = true;
        for (int i = 0; i < equalsIgnoreCase.length; ++i) {
            equalsIgnoreCase[i].setFQCN(ServiceLogger.class.getName());
            equalsIgnoreCase[i].setResourceBundle(Resource.getResourceBundle((String)format));
        }
        if (error) {
            ServiceLogger.setDebug();
        }
    }

    public static void logAuditEvent(String string, String string2, String string3, int n, boolean bl, String string4, int n2) {
        SecurityAdapter securityAdapter;
        if (string == null || string.trim().length() == 0) {
            string = "-";
        }
        if (string2 == null || string2.trim().length() == 0) {
            string2 = "-";
        }
        if (!string.equals("-") && !string2.equals("-")) {
            securityAdapter = UserDataToolkit.securityAdapter;
            try {
                if (!securityAdapter.getAuditState(string, string2, n, bl)) {
                    return;
                }
            }
            catch (RemoteException remoteException) {
                return;
            }
        }
        securityAdapter = null;
        securityAdapter = n == 1 ? append : SEDU;
        if (securityAdapter != null) {
            securityAdapter.trace(4670004, new Object[]{string, string2, string3, ServerUtil.filterLogSecretInfo(string4), String.valueOf(bl)}, null, n2);
        }
    }

    private static void SEDU(String string, String string2, String string3, int n, boolean bl, int n2, Object[] objectArray, int n3) {
        ServiceLogger.logAuditEvent(string, string2, string3, n, bl, JSvrResource.getDebug(n2, objectArray), n3);
    }

    public static void logAccessSuccessEvent(String string, String string2, String string3, String string4) {
        ServiceLogger.logAccessSuccessEvent(string, string2, string3, string4, 4);
    }

    public static void logAccessSuccessEvent(String string, String string2, String string3, String string4, int n) {
        ServiceLogger.logAuditEvent(string, string2, string3, 0, true, string4, n);
    }

    public static void logAccessFailEvent(String string, String string2, String string3, String string4) {
        ServiceLogger.logAccessFailEvent(string, string2, string3, string4, 4);
    }

    public static void logAccessFailEvent(String string, String string2, String string3, String string4, int n) {
        ServiceLogger.logAuditEvent(string, string2, string3, 0, false, string4, n);
    }

    public static void logAccessSuccessEvent(String string, String string2, String string3, int n, int n2) {
        ServiceLogger.logAccessSuccessEvent(string, string2, string3, n, (Object)null, n2);
    }

    public static void logAccessSuccessEvent(String string, String string2, String string3, int n, Object object, int n2) {
        ServiceLogger.logAccessSuccessEvent(string, string2, string3, n, new Object[]{object}, n2);
    }

    public static void logAccessSuccessEvent(String string, String string2, String string3, int n, Object[] objectArray, int n2) {
        ServiceLogger.SEDU(string, string2, string3, 0, true, n, objectArray, n2);
    }

    public static void logAccessFailEvent(String string, String string2, String string3, int n, int n2) {
        ServiceLogger.logAccessFailEvent(string, string2, string3, n, (Object)null, n2);
    }

    public static void logAccessFailEvent(String string, String string2, String string3, int n, Object object, int n2) {
        ServiceLogger.logAccessFailEvent(string, string2, string3, n, new Object[]{object}, n2);
    }

    public static void logAccessFailEvent(String string, String string2, String string3, int n, Object[] objectArray, int n2) {
        ServiceLogger.SEDU(string, string2, string3, 0, false, n, objectArray, n2);
    }

    public static void logAccess(int n, int n2) {
        ServiceLogger.logAccess(n, (Throwable)null, n2);
    }

    public static void logAccess(int n, Object object, int n2) {
        ServiceLogger.logAccess(n, new Object[]{object}, n2);
    }

    public static void logAccess(int n, Object[] objectArray, int n2) {
        if (SEDU == null) {
            return;
        }
        if (ServiceLogger.isLoggable(0, n2)) {
            SEDU.trace(n, objectArray, null, n2);
        }
    }

    public static void logAccess(int n, Throwable throwable, int n2) {
        if (SEDU == null) {
            return;
        }
        SEDU.trace(n, throwable, n2);
    }

    public static void logManageSuccessEvent(String string, String string2, String string3) {
        ServiceLogger.logManageSuccessEvent(string, string2, string3, 4);
    }

    public static void logManageSuccessEvent(String string, String string2, String string3, int n) {
        ServiceLogger.logAuditEvent(string, string2, null, 1, true, string3, n);
    }

    public static void logManageFailEvent(String string, String string2, String string3) {
        ServiceLogger.logManageFailEvent(string, string2, string3, 4);
    }

    public static void logManageFailEvent(String string, String string2, String string3, int n) {
        ServiceLogger.logAuditEvent(string, string2, null, 1, false, string3, n);
    }

    public static void logManageSuccessEvent(String string, String string2, int n, int n2) {
        ServiceLogger.logManageSuccessEvent(string, string2, n, (Object)null, n2);
    }

    public static void logManageSuccessEvent(String string, String string2, int n, Object object, int n2) {
        ServiceLogger.logManageSuccessEvent(string, string2, n, new Object[]{object}, n2);
    }

    public static void logManageSuccessEvent(String string, String string2, int n, Object[] objectArray, int n2) {
        ServiceLogger.SEDU(string, string2, null, 1, true, n, objectArray, n2);
    }

    public static void logManageFailEvent(String string, String string2, int n, int n2) {
        ServiceLogger.logManageFailEvent(string, string2, n, (Object)null, n2);
    }

    public static void logManageFailEvent(String string, String string2, int n, Object object, int n2) {
        ServiceLogger.logManageFailEvent(string, string2, n, new Object[]{object}, n2);
    }

    public static void logManageFailEvent(String string, String string2, int n, Object[] objectArray, int n2) {
        ServiceLogger.SEDU(string, string2, null, 1, false, n, objectArray, n2);
    }

    public static void logManage(int n, int n2) {
        ServiceLogger.logManage(n, (Throwable)null, n2);
    }

    public static void logManage(int n, Object object, int n2) {
        ServiceLogger.logManage(n, new Object[]{object}, n2);
    }

    public static void logManage(int n, Object[] objectArray, int n2) {
        if (append == null) {
            return;
        }
        if (ServiceLogger.isLoggable(1, n2)) {
            append.trace(n, objectArray, null, n2);
        }
    }

    public static void logManage(int n, Throwable throwable, int n2) {
        if (append == null) {
            return;
        }
        append.trace(n, throwable, n2);
    }

    public static void logDebug(String string) {
        ServiceLogger.logDebug(string, 4);
    }

    public static void logDebug(String string, int n) {
        if (deIndent == null) {
            return;
        }
        deIndent.trace((Object)string, n);
    }

    public static void logDebug(int n, int n2) {
        ServiceLogger.logDebug(n, (Throwable)null, n2);
    }

    public static void logDebug(int n, Object object, int n2) {
        ServiceLogger.logDebug(n, new Object[]{object}, n2);
    }

    public static void logDebug(int n, Object[] objectArray, int n2) {
        if (deIndent == null) {
            return;
        }
        if (ServiceLogger.isLoggable(4, n2)) {
            deIndent.trace(n, objectArray, null, n2);
        }
    }

    public static void logDebug(int n, Throwable throwable, int n2) {
        if (deIndent == null) {
            return;
        }
        deIndent.trace(n, throwable, n2);
    }

    public static void logEvent(String string) {
        ServiceLogger.logEvent(string, 4);
    }

    public static void logEvent(String string, int n) {
        if (currentTimeMillis == null) {
            return;
        }
        currentTimeMillis.trace((Object)string, n);
    }

    public static void logEvent(int n, int n2) {
        ServiceLogger.logEvent(n, (Throwable)null, n2);
    }

    public static void logEvent(int n, Object object, int n2) {
        ServiceLogger.logEvent(n, new Object[]{object}, n2);
    }

    public static void logEvent(int n, Object[] objectArray, int n2) {
        if (currentTimeMillis == null) {
            return;
        }
        if (ServiceLogger.isLoggable(3, n2)) {
            currentTimeMillis.trace(n, objectArray, null, n2);
        }
    }

    public static void logEvent(int n, Throwable throwable, int n2) {
        if (currentTimeMillis == null) {
            return;
        }
        currentTimeMillis.trace(n, throwable, n2);
    }

    public static void logEngine(String string) {
        ServiceLogger.logEngine(string, 4);
    }

    public static void logEngine(String string, int n) {
        if (destroy == null) {
            return;
        }
        destroy.trace((Object)string, n);
    }

    public static void logEngine(int n, int n2) {
        ServiceLogger.logEngine(n, (Throwable)null, n2);
    }

    public static void logEngine(int n, Object object, int n2) {
        ServiceLogger.logEngine(n, new Object[]{object}, n2);
    }

    public static void logEngine(int n, Object[] objectArray, int n2) {
        if (destroy == null) {
            return;
        }
        if (ServiceLogger.isLoggable(5, n2)) {
            destroy.trace(n, objectArray, null, n2);
        }
    }

    public static void logEngine(int n, Throwable throwable, int n2) {
        if (destroy == null) {
            return;
        }
        destroy.trace(n, throwable, n2);
    }

    public static void logDump(String string) {
        ServiceLogger.logDump(string, 4);
    }

    public static void logDump(String string, int n) {
        if (equals == null) {
            return;
        }
        equals.trace((Object)string, n);
    }

    public static void logDump(int n, int n2) {
        ServiceLogger.logDump(n, (Throwable)null, n2);
    }

    public static void logDump(int n, Object object, int n2) {
        ServiceLogger.logDump(n, new Object[]{object}, n2);
    }

    public static void logDump(int n, Object[] objectArray, int n2) {
        if (equals == null) {
            return;
        }
        if (ServiceLogger.isLoggable(6, n2)) {
            equals.trace(n, objectArray, null, n2);
        }
    }

    public static void logDump(int n, Throwable throwable, int n2) {
        if (equals == null) {
            return;
        }
        equals.trace(n, throwable, n2);
    }

    public static void logError(String string) {
        ServiceLogger.logError(string, 2);
    }

    public static void logError(String string, int n) {
        if (create == null) {
            ServiceLogger.append(string);
            return;
        }
        create.error((Object)string, null, n);
    }

    public static void logError(Throwable throwable) {
        ServiceLogger.logError(throwable, 2);
    }

    public static void logError(Throwable throwable, int n) {
        if (create == null || throwable == null) {
            ServiceLogger.create(throwable);
            return;
        }
        create.error(null, throwable, n);
    }

    public static void logError(int n, int n2) {
        ServiceLogger.logError(n, (Throwable)null, n2);
    }

    public static void logError(int n, Object object, int n2) {
        ServiceLogger.logError(n, new Object[]{object}, n2);
    }

    public static void logError(int n, Object[] objectArray, int n2) {
        if (create == null) {
            return;
        }
        create.error(n, objectArray, null, n2);
    }

    public static void logError(int n, Throwable throwable, int n2) {
        if (create == null) {
            return;
        }
        create.error(n, throwable, n2);
    }

    private static void append(String string) {
        long l = System.currentTimeMillis();
        Timestamp timestamp = new Timestamp(l);
        if (string != null) {
            System.out.println("[" + timestamp + "] LogError " + string);
        }
    }

    private static void create(Throwable throwable) {
        long l = System.currentTimeMillis();
        Timestamp timestamp = new Timestamp(l);
        if (throwable != null) {
            System.out.println("[" + timestamp + "] LogError ");
            throwable.printStackTrace(System.out);
        } else {
            System.out.println("[" + timestamp + "]");
        }
    }

    public static void closeAll() {
        JRLoggerConfigService.instance().destroy();
        JRLogger.shutdown((String)"com.jinfonet");
        for (int i = 0; i < equalsIgnoreCase.length; ++i) {
            ServiceLogger.equalsIgnoreCase[i] = null;
        }
    }

    public static JRLogger getLog(int n) {
        if (n < 0 || n >= equalsIgnoreCase.length) {
            throw new IllegalArgumentException(JSvrResource.getMessage("LOGGING_M_00010", "type = " + n));
        }
        return equalsIgnoreCase[n];
    }

    public static JRLogger getLog(String string) {
        if ("Access".equals(string)) {
            return SEDU;
        }
        if ("Manage".equals(string)) {
            return append;
        }
        if ("Error".equals(string)) {
            return create;
        }
        if ("Event".equals(string)) {
            return currentTimeMillis;
        }
        if ("Debug".equals(string)) {
            return deIndent;
        }
        if ("Performance".equals(string)) {
            return destroy;
        }
        if ("Dump".equals(string)) {
            return equals;
        }
        throw new IllegalArgumentException(JSvrResource.getMessage("LOGGING_M_00010", "name = " + string));
    }

    public static boolean isLoggable(int n, int n2) {
        JRLogger jRLogger = ServiceLogger.getLog(n);
        return jRLogger != null && (n == 2 ? jRLogger.isErrorFor(n2) : jRLogger.isTraceFor(n2));
    }

    public static void trace(String string, Object ... objectArray) {
        if (deIndent == null) {
            return;
        }
        if (ServiceLogger.isLoggable(4, 6)) {
            deIndent.trace((Object)String.format(string, objectArray), 6);
        }
    }

    public static void error(Throwable throwable, String string, Object ... objectArray) {
        if (create == null) {
            return;
        }
        if (ServiceLogger.isLoggable(2, 2)) {
            create.error((Object)String.format(string, objectArray), throwable, 2);
        }
    }

    public static void error(String string, Object ... objectArray) {
        if (create == null) {
            return;
        }
        if (ServiceLogger.isLoggable(2, 2)) {
            create.error((Object)String.format(string, objectArray));
        }
    }

    static {
        equalsIgnoreCase = new JRLogger[7];
        error = false;
        filterLogSecretInfo = false;
    }
}

