/*
 * Decompiled with CFR 0.152.
 */
package jet.server.monitor.jmx.mbeans;

import java.io.Serializable;
import java.util.Vector;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import jet.server.api.cluster.Member;
import jet.server.monitor.api.MonitorServer;
import jet.server.monitor.api.ServerStatus;
import jet.server.monitor.api.jmx.mbeans.ClusterRuntimeMBean;
import jet.server.monitor.jmx.exception.InstantiateFailedException;
import jet.server.monitor.jmx.utils.MBeanConstants;
import jet.server.monitor.jrmon.JRMonitorServer;
import jet.server.monitor.jrmon.MonitorEnv;

public class ClusterRuntime
extends StandardMBean
implements ClusterRuntimeMBean,
MBeanConstants,
Serializable {
    private static final long serialVersionUID = 438788676640413698L;
    private MonitorServer monitorServer;

    public ClusterRuntime() throws NotCompliantMBeanException {
        this((MonitorServer)null);
    }

    public ClusterRuntime(MonitorServer monitorServer) throws InstantiateFailedException, NotCompliantMBeanException {
        super(ClusterRuntimeMBean.class);
        this.monitorServer = monitorServer != null ? monitorServer : MonitorEnv.getHttpMonitorServer();
        if (this.monitorServer == null) {
            throw new InstantiateFailedException("There occurs an error to create ClusterRuntime MBean, Can't obtain the underlying managed objects");
        }
    }

    @Override
    public boolean isClusterEnable() {
        return this.monitorServer.isCluster();
    }

    @Override
    public String getClusterName() {
        return this.monitorServer.getClusterName();
    }

    @Override
    public Member[] getPredefinedServers() {
        return this.monitorServer.getClusteredServers();
    }

    @Override
    public Member[] getClusteredServers() {
        return this.monitorServer.getClusteredServers();
    }

    public String[] getPredefinedServersToString() {
        Member[] memberArray = this.monitorServer.getPredefinedServers();
        String[] stringArray = new String[memberArray.length];
        ServerStatus serverStatus = null;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < memberArray.length; ++i) {
            stringBuffer.setLength(0);
            serverStatus = this.monitorServer.getServerStatus(memberArray[i].getHost(), Integer.parseInt(memberArray[i].getPort()));
            stringBuffer.append("serverName").append("=").append(serverStatus.getName()).append(",").append("serverHost").append("=").append(serverStatus.getHost()).append(",").append("serverPort").append("=").append(serverStatus.getPort()).append(",").append("serverType").append("=").append(serverStatus.getType()).append(",").append("serverStatus").append("=").append(serverStatus.getStatus());
            stringArray[i] = stringBuffer.toString();
        }
        return stringArray;
    }

    @Override
    public ServerStatus[] getPredefinedServerStatus() {
        return this.getClusteredServerStatus();
    }

    @Override
    public ServerStatus[] getClusteredServerStatus() {
        Vector vector = ((JRMonitorServer)this.monitorServer).getClusterMonitor().getAllServerStatus();
        int n = vector.size();
        ServerStatus[] serverStatusArray = new ServerStatus[n];
        for (int i = 0; i < n; ++i) {
            serverStatusArray[i] = (ServerStatus)vector.elementAt(i);
        }
        return serverStatusArray;
    }

    @Override
    public ServerStatus getServerStatus(String string, int n) {
        return this.monitorServer.getServerStatus(string, n);
    }

    @Override
    public void stopServer(String string, int n) {
        this.monitorServer.stopServer(string, n);
    }

    @Override
    public String getDescription(MBeanInfo mBeanInfo) {
        return "This <B><code>ClusterRuntime</code></B> MBean provides the ability to expose JREntServer Cluster's attributes and operations.";
    }

    @Override
    public String getDescription(MBeanAttributeInfo mBeanAttributeInfo) {
        String string = "";
        String string2 = mBeanAttributeInfo.getName();
        string = "ClusterEnable".equalsIgnoreCase(string2) ? "Judge whether the JREntServer is a Cluster enable or not?" : ("ClusterName".equalsIgnoreCase(string2) ? "The JREntServer Cluster\\'s name." : ("PredefinedServers".equalsIgnoreCase(string2) ? "All of the predefined JREntServer Members within the Cluster." : ("PredefinedServerStatus".equalsIgnoreCase(string2) ? "All of the predefined JREntServer Status infos within the Cluster." : this.getDescription((MBeanFeatureInfo)mBeanAttributeInfo))));
        return string;
    }

    @Override
    public String getDescription(MBeanConstructorInfo mBeanConstructorInfo) {
        return "The Constructor of <code>ClusterRuntime</code> with the specified underlying managed object of <code>MonitorServer</code> or without any arguments.";
    }

    @Override
    public String getDescription(MBeanConstructorInfo mBeanConstructorInfo, MBeanParameterInfo mBeanParameterInfo, int n) {
        return "The underlying managed object instance of <code>MonitorServer</code>.";
    }

    @Override
    public String getDescription(MBeanOperationInfo mBeanOperationInfo) {
        String string = "";
        String string2 = mBeanOperationInfo.getName();
        string = "getServerStatus".equalsIgnoreCase(string2) ? "Get the SeverStatus according to the Server\\'s host and port." : ("stopServer".equalsIgnoreCase(string2) ? "Stop a JREntServer within the Cluster according to its host address and RMI port value." : this.getDescription((MBeanFeatureInfo)mBeanOperationInfo));
        return string;
    }

    @Override
    public String getDescription(MBeanOperationInfo mBeanOperationInfo, MBeanParameterInfo mBeanParameterInfo, int n) {
        String string = "";
        String string2 = mBeanOperationInfo.getName();
        if ("getServerStatus".equalsIgnoreCase(string2) || "stopServer".equalsIgnoreCase(string2)) {
            if (n == 0) {
                string = "The specified JREntServer\\'s host address.";
            } else if (n == 1) {
                string = "The specified JREntServer\\'s RMI port value.";
            }
        } else {
            string = mBeanParameterInfo.getDescription();
        }
        return string;
    }

    @Override
    public String getParameterName(MBeanConstructorInfo mBeanConstructorInfo, MBeanParameterInfo mBeanParameterInfo, int n) {
        return "monitorServer";
    }

    @Override
    public String getParameterName(MBeanOperationInfo mBeanOperationInfo, MBeanParameterInfo mBeanParameterInfo, int n) {
        String string = "";
        String string2 = mBeanOperationInfo.getName();
        if ("getServerStatus".equalsIgnoreCase(string2) || "stopServer".equalsIgnoreCase(string2)) {
            if (n == 0) {
                string = "host";
            } else if (n == 1) {
                string = "port";
            }
        } else {
            string = mBeanParameterInfo.getName();
        }
        return string;
    }
}

