/*
 * Decompiled with CFR 0.152.
 */
package jet.server.monitor.jmx.mbeans;

import java.io.Serializable;
import java.util.Properties;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import jet.server.monitor.api.database.DatabaseMonitor;
import jet.server.monitor.api.jmx.mbeans.DatabaseRuntimeMBean;
import jet.server.monitor.jmx.exception.InstantiateFailedException;
import jet.server.monitor.jmx.exception.InvalidArgumentsException;
import jet.server.monitor.jmx.utils.MBeanConstants;
import jet.server.monitor.jrmon.MonitorEnv;
import jet.server.monitor.jrmon.database.JRDatabaseMonitor;

public class DatabaseRuntime
extends StandardMBean
implements DatabaseRuntimeMBean,
MBeanConstants,
Serializable {
    private static final long serialVersionUID = -5570049518868406404L;
    private String host;
    private int port;
    private DatabaseMonitor databaseMonitor;

    public DatabaseRuntime() throws InvalidArgumentsException, NotCompliantMBeanException {
        super(DatabaseRuntimeMBean.class);
        throw new InvalidArgumentsException("Can't construct DatabaseRuntime MBean, Please specify the host and port as parameter!");
    }

    public DatabaseRuntime(String string, int n) throws InstantiateFailedException, NotCompliantMBeanException {
        super(DatabaseRuntimeMBean.class);
        this.host = string;
        this.port = n;
        this.databaseMonitor = MonitorEnv.getHttpMonitorServer().getMonitorService(string, n).getDatabaseMonitor();
        if (this.databaseMonitor == null) {
            throw new InstantiateFailedException("There occurs an error to create DatabaseRuntime MBean, Can't obtain the underlying managed objects");
        }
    }

    public DatabaseRuntime(DatabaseMonitor databaseMonitor) throws InstantiateFailedException, NotCompliantMBeanException {
        super(DatabaseRuntimeMBean.class);
        if (databaseMonitor == null) {
            throw new InstantiateFailedException("There occurs an error to create DatabaseRuntime MBean, Can't obtain the underlying managed objects");
        }
        this.databaseMonitor = databaseMonitor;
        this.host = ((JRDatabaseMonitor)databaseMonitor).getMonitorService().getHost();
        this.port = ((JRDatabaseMonitor)databaseMonitor).getMonitorService().getPort();
    }

    public String[] getAllConnectionsToString() {
        Properties[] propertiesArray = this.databaseMonitor.getConnectionProperties();
        String[] stringArray = new String[propertiesArray.length];
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < propertiesArray.length; ++i) {
            stringBuffer.setLength(0);
            Properties properties = propertiesArray[i];
            stringBuffer.append("id").append("=").append(properties.getProperty("id")).append(",").append("user").append("=").append(properties.getProperty("User")).append(",").append("url").append("=").append(properties.getProperty("URL")).append(",").append("expiringTime").append("=").append(properties.getProperty("Expiring_Time")).append(",").append("idleExpiringTime").append("=").append(properties.getProperty("Idle_Expiring_Time")).append(",").append("maxConnectionCount").append("=").append(properties.getProperty("Maximal_Connection_Count")).append(",").append("maxShareCount").append("=").append(properties.getProperty("Maximal_Share_Count")).append(",").append("attempt").append("=").append(properties.getProperty("Attempt")).append(",").append("interval").append("=").append(properties.getProperty("Interval")).append(",").append("lastUserConnectingTime").append("=").append(properties.getProperty("Last_User_Connecting_Time")).append(",").append("currentIdleTime").append("=").append(properties.getProperty("Current_Idle_Time")).append(",").append("currentShareCount").append("=").append(properties.getProperty("Current_Share_Count"));
            stringArray[i] = stringBuffer.toString();
        }
        return stringArray;
    }

    @Override
    public Properties[] getConnectionProperties() {
        return this.databaseMonitor.getConnectionProperties();
    }

    @Override
    public void disconnect(String string) {
        this.databaseMonitor.disconnect(string);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public String getDescription(MBeanInfo mBeanInfo) {
        return "This <B><code>DatabaseRuntime</code></B> MBean provides the ability to expose JREntServer Database Connection's attributes and operations.";
    }

    @Override
    public String getDescription(MBeanAttributeInfo mBeanAttributeInfo) {
        String string = "";
        String string2 = mBeanAttributeInfo.getName();
        string = "ConnectionProperties".equalsIgnoreCase(string2) ? "All currently active Database Connection contents." : this.getDescription((MBeanFeatureInfo)mBeanAttributeInfo);
        return string;
    }

    @Override
    public String getDescription(MBeanConstructorInfo mBeanConstructorInfo) {
        return "The Constructor of <code>DatabaseRuntime</code> with the specified host and port or the underlying managed objects. Without any arguments will throw exceptions.";
    }

    @Override
    public String getDescription(MBeanConstructorInfo mBeanConstructorInfo, MBeanParameterInfo mBeanParameterInfo, int n) {
        String string = "";
        String string2 = mBeanParameterInfo.getType();
        if (n == 0) {
            if (String.class.getName().equalsIgnoreCase(string2)) {
                string = "The specified JREntServer\\'s host value (IP Address).";
            } else if (DatabaseMonitor.class.getName().equalsIgnoreCase(string2)) {
                string = "The underlying managed object of DatabaseMonitor";
            }
        } else {
            string = n == 1 ? "The specified JREntServer\\'s RMI port value." : mBeanParameterInfo.getDescription();
        }
        return string;
    }

    @Override
    public String getDescription(MBeanOperationInfo mBeanOperationInfo) {
        String string = "";
        String string2 = mBeanOperationInfo.getName();
        string = "disconnect".equalsIgnoreCase(string2) ? "Disconnect a Database Connection according to its Database Connection identifier." : this.getDescription((MBeanFeatureInfo)mBeanOperationInfo);
        return string;
    }

    @Override
    public String getDescription(MBeanOperationInfo mBeanOperationInfo, MBeanParameterInfo mBeanParameterInfo, int n) {
        String string = "";
        String string2 = mBeanOperationInfo.getName();
        string = n == 0 && "disconnect".equalsIgnoreCase(string2) ? "The specified Database Connection identifier assigned to identify a Database Connection." : mBeanParameterInfo.getDescription();
        return string;
    }

    @Override
    public String getParameterName(MBeanConstructorInfo mBeanConstructorInfo, MBeanParameterInfo mBeanParameterInfo, int n) {
        String string = "";
        String string2 = mBeanParameterInfo.getType();
        if (n == 0) {
            if (String.class.getName().equalsIgnoreCase(string2)) {
                string = "host";
            } else if (DatabaseMonitor.class.getName().equalsIgnoreCase(string2)) {
                string = "databaseMonitor";
            }
        } else {
            string = n == 1 ? "port" : mBeanParameterInfo.getName();
        }
        return string;
    }

    @Override
    public String getParameterName(MBeanOperationInfo mBeanOperationInfo, MBeanParameterInfo mBeanParameterInfo, int n) {
        String string = "";
        String string2 = mBeanOperationInfo.getName();
        string = n == 0 && "disconnect".equalsIgnoreCase(string2) ? "connectionInfoID" : mBeanParameterInfo.getName();
        return string;
    }
}

