/*
 * Decompiled with CFR 0.152.
 */
package jet.server.monitor.jmx.mbeans;

import java.io.Serializable;
import java.rmi.Naming;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import jet.server.monitor.api.MonitorCounter;
import jet.server.monitor.api.ServerStatus;
import jet.server.monitor.api.jmx.mbeans.ServerRuntimeMBean;
import jet.server.monitor.jmx.exception.InstantiateFailedException;
import jet.server.monitor.jmx.exception.InvalidArgumentsException;
import jet.server.monitor.jrmon.MonitorEnv;
import jet.server.rmi.RemoteObjectFactory;
import jet.server.rmi.RemoteObjectProxy;

public class ServerRuntime
extends StandardMBean
implements ServerRuntimeMBean,
Serializable {
    private static final long serialVersionUID = 6754258981506231192L;
    private ServerStatus serverStatus;
    private MonitorCounter monitorCounter;
    private String bindName;
    private String rmiName;

    public ServerRuntime() throws InvalidArgumentsException, NotCompliantMBeanException {
        super(ServerRuntimeMBean.class);
        throw new InvalidArgumentsException("Can't construct ServerRuntime MBean, Please specify the host and port as parameter!");
    }

    public ServerRuntime(String string, int n) throws InstantiateFailedException, NotCompliantMBeanException {
        super(ServerRuntimeMBean.class);
        MonitorEnv.getHttpMonitorServer().getMonitorService(string, n);
        this.serverStatus = MonitorEnv.getHttpMonitorServer().getServerStatus(string, n);
        this.bindName = "//" + MonitorEnv.getMonitorServerHostName() + ":" + MonitorEnv.getMonitorServerRMIPort() + "/" + "JReportRemoteObjectProxy";
        this.rmiName = MonitorEnv.getMonitorCounterName() + "_" + string + "_" + n;
        this.SEDU();
        if (this.serverStatus == null) {
            throw new InstantiateFailedException("There occurs an error to create ServerRuntime MBean, Can't obtain the underlying managed objects");
        }
    }

    private MonitorCounter SEDU() {
        if (this.monitorCounter == null) {
            try {
                RemoteObjectProxy remoteObjectProxy = (RemoteObjectProxy)Naming.lookup(this.bindName);
                this.monitorCounter = (MonitorCounter)remoteObjectProxy.getRemoteObject(this.rmiName, RemoteObjectFactory.getRandomAuthString());
            }
            catch (Exception exception) {
                this.monitorCounter = null;
            }
        }
        return this.monitorCounter;
    }

    public ServerRuntime(ServerStatus serverStatus) throws NotCompliantMBeanException {
        this(serverStatus.getHost(), serverStatus.getPort());
    }

    @Override
    public String getName() {
        return this.serverStatus.getName();
    }

    @Override
    public String getHost() {
        return this.serverStatus.getHost();
    }

    @Override
    public int getPort() {
        return this.serverStatus.getPort();
    }

    @Override
    public String getStatus() {
        return this.serverStatus.getStatus();
    }

    @Override
    public String getType() {
        return this.serverStatus.getType();
    }

    @Override
    public int getWaitingRptNums() throws Exception {
        this.monitorCounter = this.SEDU();
        if (this.monitorCounter == null) {
            return 0;
        }
        return this.monitorCounter.getWaitingRptNums();
    }

    @Override
    public int getRunningRptNums() throws Exception {
        this.monitorCounter = this.SEDU();
        if (this.monitorCounter == null) {
            return 0;
        }
        return this.monitorCounter.getRunningRptNums();
    }

    @Override
    public int getFinishedRptNums() throws Exception {
        this.monitorCounter = this.SEDU();
        if (this.monitorCounter == null) {
            return 0;
        }
        return this.monitorCounter.getFinishedRptNums();
    }

    @Override
    public int getFinishedRptPages() throws Exception {
        this.monitorCounter = this.SEDU();
        if (this.monitorCounter == null) {
            return 0;
        }
        return this.monitorCounter.getFinishedRptPages();
    }

    @Override
    public int getAvgProcessTimeByRpt() throws Exception {
        this.monitorCounter = this.SEDU();
        if (this.monitorCounter == null) {
            return 0;
        }
        return this.monitorCounter.getAvgProcessTimeByRpt();
    }

    @Override
    public int getAvgWaitTimeByRpt() throws Exception {
        this.monitorCounter = this.SEDU();
        if (this.monitorCounter == null) {
            return 0;
        }
        return this.monitorCounter.getAvgWaitTimeByRpt();
    }

    @Override
    public int getValidUserSessionNums() throws Exception {
        this.monitorCounter = this.SEDU();
        if (this.monitorCounter == null) {
            return 0;
        }
        return this.monitorCounter.getValidUserSessionNums();
    }

    @Override
    public int getAvgRptNumsSubmittedByUser() throws Exception {
        this.monitorCounter = this.SEDU();
        if (this.monitorCounter == null) {
            return 0;
        }
        return this.monitorCounter.getAvgRptNumsSubmittedByUser();
    }

    @Override
    public int getCurrentConnectionNums() throws Exception {
        this.monitorCounter = this.SEDU();
        if (this.monitorCounter == null) {
            return 0;
        }
        return this.monitorCounter.getCurrentConnectionNums();
    }

    @Override
    public void stop() {
        MonitorEnv.getHttpMonitorServer().stopServer(this.serverStatus.getHost(), this.serverStatus.getPort());
    }

    @Override
    public String getDescription(MBeanInfo mBeanInfo) {
        return "This <B><code>ServerRuntime</code></B> MBean provides the ability to expose JREntServer's attributes and operations.";
    }

    @Override
    public String getDescription(MBeanAttributeInfo mBeanAttributeInfo) {
        String string = "";
        String string2 = mBeanAttributeInfo.getName();
        string = "Name".equalsIgnoreCase(string2) ? "The JREntServer\\'s alias name." : ("Host".equalsIgnoreCase(string2) ? "The JREntServer\\'s Host address (IP address)." : ("Port".equalsIgnoreCase(string2) ? "The JREntServer\\'s RMI Port value." : ("Status".equalsIgnoreCase(string2) ? "The JREntServer\\'s status value." : ("Type".equalsIgnoreCase(string2) ? "The JREntServer\\'s type value." : ("WaitingRptNums".equalsIgnoreCase(string2) ? "The number of currently Waiting Reports." : ("RunningRptNums".equalsIgnoreCase(string2) ? "The number of currently Running Reports." : ("FinishedRptNums".equalsIgnoreCase(string2) ? "The number of Completed Reports within the specified monitored duration." : ("FinishedRptPages".equalsIgnoreCase(string2) ? "The total number of Completed Reports\\' pages within the specified monitored duration." : ("AvgProcessTimeByRpt".equalsIgnoreCase(string2) ? "Average processed time value of all Completed Reports." : ("AvgWaitTimeByRpt".equalsIgnoreCase(string2) ? "Average waited time value of all Completed Reports." : ("ValidUserSessionNums".equalsIgnoreCase(string2) ? "The number of currently valid User Sessions." : ("AvgRptNumsSubmittedByUser".equalsIgnoreCase(string2) ? "Average number of Reports submitted by every users." : ("CurrentConnectionNums".equalsIgnoreCase(string2) ? "The number of Connections currently active in Database Connection Pool." : this.getDescription((MBeanFeatureInfo)mBeanAttributeInfo))))))))))))));
        return string;
    }

    @Override
    public String getDescription(MBeanConstructorInfo mBeanConstructorInfo) {
        return "The Constructor of <code>ServerRuntime</code> with the specified host and port. Without any arguments will throw exceptions.";
    }

    @Override
    public String getDescription(MBeanConstructorInfo mBeanConstructorInfo, MBeanParameterInfo mBeanParameterInfo, int n) {
        String string = "";
        string = n == 0 ? "The specified JREntServer\\'s host address." : (n == 1 ? "The specified JREntServer\\'s RMI port value." : mBeanParameterInfo.getDescription());
        return string;
    }

    @Override
    public String getDescription(MBeanOperationInfo mBeanOperationInfo) {
        String string = "";
        String string2 = mBeanOperationInfo.getName();
        string = "stop".equalsIgnoreCase(string2) ? "Stop the JREntServer associated with this ServerRuntime MBean." : this.getDescription((MBeanFeatureInfo)mBeanOperationInfo);
        return string;
    }

    @Override
    public String getDescription(MBeanOperationInfo mBeanOperationInfo, MBeanParameterInfo mBeanParameterInfo, int n) {
        return mBeanParameterInfo.getDescription();
    }

    @Override
    public String getParameterName(MBeanConstructorInfo mBeanConstructorInfo, MBeanParameterInfo mBeanParameterInfo, int n) {
        String string = "";
        string = n == 0 ? "host" : (n == 1 ? "port" : mBeanParameterInfo.getName());
        return string;
    }

    @Override
    public String getParameterName(MBeanOperationInfo mBeanOperationInfo, MBeanParameterInfo mBeanParameterInfo, int n) {
        return mBeanParameterInfo.getName();
    }
}

