/*
 * Decompiled with CFR 0.152.
 */
package jet.server.monitor.jmx.utils;

import com.sun.jdmk.comm.HtmlAdaptorServer;
import javax.management.ObjectName;
import jet.server.api.cluster.Member;
import jet.server.log.ServiceLogger;
import jet.server.monitor.jmx.mbeans.ClusterRuntime;
import jet.server.monitor.jmx.mbeans.DatabaseRuntime;
import jet.server.monitor.jmx.mbeans.ServerRuntime;
import jet.server.monitor.jmx.mbeans.TaskRuntime;
import jet.server.monitor.jmx.mbeans.UserSessionRuntime;
import jet.server.monitor.jmx.utils.MBeanUtils;
import jet.server.monitor.jrmon.MonitorEnv;

public class MBeanFactory {
    private static MBeanFactory SEDU = null;
    private static boolean addShutdownHook = false;

    private MBeanFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MBeanFactory getInstance() {
        if (SEDU != null) return SEDU;
        Class<MBeanFactory> clazz = MBeanFactory.class;
        synchronized (MBeanFactory.class) {
            if (SEDU != null) return SEDU;
            SEDU = new MBeanFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return SEDU;
        }
    }

    public void registerAllMBeans() {
        if (addShutdownHook) {
            return;
        }
        try {
            System.out.println("Creating all MBeans and registering them into the MBeanServer...");
            ClusterRuntime clusterRuntime = new ClusterRuntime();
            ObjectName objectName = MBeanUtils.createObjectName(clusterRuntime);
            if (!MBeanUtils.getMBeanServer().isRegistered(objectName)) {
                MBeanUtils.getMBeanServer().registerMBean(clusterRuntime, objectName);
            }
            Member[] memberArray = clusterRuntime.getPredefinedServers();
            for (int i = 0; i < memberArray.length; ++i) {
                String string = memberArray[i].getHost();
                int n = Integer.parseInt(memberArray[i].getPort());
                this.SEDU(string, n).start();
            }
        }
        catch (Exception exception) {
            System.err.println("\t>>>Failed to create and register JReport Server MBeans into MBeanServer: " + exception);
            ServiceLogger.logError(exception);
        }
        addShutdownHook = true;
    }

    public void unregisterAllMBeans() {
        if (!addShutdownHook) {
            return;
        }
        try {
            ClusterRuntime clusterRuntime = new ClusterRuntime();
            ObjectName objectName = MBeanUtils.createObjectName(clusterRuntime);
            if (MBeanUtils.getMBeanServer().isRegistered(objectName)) {
                MBeanUtils.getMBeanServer().unregisterMBean(objectName);
            }
            Member[] memberArray = clusterRuntime.getPredefinedServers();
            for (int i = 0; i < memberArray.length; ++i) {
                String string = memberArray[i].getHost();
                int n = Integer.parseInt(memberArray[i].getPort());
                ServerRuntime serverRuntime = new ServerRuntime(string, n);
                objectName = MBeanUtils.createObjectName(serverRuntime);
                if (MBeanUtils.getMBeanServer().isRegistered(objectName)) {
                    MBeanUtils.getMBeanServer().unregisterMBean(objectName);
                }
                TaskRuntime taskRuntime = new TaskRuntime(string, n);
                objectName = MBeanUtils.createObjectName(taskRuntime);
                if (MBeanUtils.getMBeanServer().isRegistered(objectName)) {
                    MBeanUtils.getMBeanServer().unregisterMBean(objectName);
                }
                UserSessionRuntime userSessionRuntime = new UserSessionRuntime(string, n);
                objectName = MBeanUtils.createObjectName(userSessionRuntime);
                if (MBeanUtils.getMBeanServer().isRegistered(objectName)) {
                    MBeanUtils.getMBeanServer().unregisterMBean(objectName);
                }
                DatabaseRuntime databaseRuntime = new DatabaseRuntime(string, n);
                objectName = MBeanUtils.createObjectName(databaseRuntime);
                if (!MBeanUtils.getMBeanServer().isRegistered(objectName)) continue;
                MBeanUtils.getMBeanServer().unregisterMBean(objectName);
            }
            System.out.println("<<<Unregistered all MBeans from MBeanServer successfully...!");
        }
        catch (Exception exception) {
            System.err.println("\t<<<Failed to unregister MBeans from MBeanServer: " + exception);
            ServiceLogger.logError(exception);
        }
        addShutdownHook = false;
    }

    private Thread SEDU(final String string, final int n) {
        return new Thread(){

            @Override
            public void run() {
                try {
                    ServerRuntime serverRuntime = new ServerRuntime(string, n);
                    ObjectName objectName = MBeanUtils.createObjectName(serverRuntime);
                    if (!MBeanUtils.getMBeanServer().isRegistered(objectName)) {
                        MBeanUtils.getMBeanServer().registerMBean(serverRuntime, objectName);
                    }
                    while (!MonitorEnv.getHttpMonitorServer().isStarting(string, n)) {
                        Thread.sleep(10000L);
                    }
                    TaskRuntime taskRuntime = new TaskRuntime(string, n);
                    objectName = MBeanUtils.createObjectName(taskRuntime);
                    if (!MBeanUtils.getMBeanServer().isRegistered(objectName)) {
                        MBeanUtils.getMBeanServer().registerMBean(taskRuntime, objectName);
                    }
                    UserSessionRuntime userSessionRuntime = new UserSessionRuntime(string, n);
                    objectName = MBeanUtils.createObjectName(userSessionRuntime);
                    if (!MBeanUtils.getMBeanServer().isRegistered(objectName)) {
                        MBeanUtils.getMBeanServer().registerMBean(userSessionRuntime, objectName);
                    }
                    DatabaseRuntime databaseRuntime = new DatabaseRuntime(string, n);
                    objectName = MBeanUtils.createObjectName(databaseRuntime);
                    if (!MBeanUtils.getMBeanServer().isRegistered(objectName)) {
                        MBeanUtils.getMBeanServer().registerMBean(databaseRuntime, objectName);
                    }
                }
                catch (Exception exception) {
                    System.err.println("\t<<<Failed to create and register JReport MBeans into MBeanServer: " + exception);
                    ServiceLogger.logError(exception);
                }
            }
        };
    }

    public boolean startHtmlAdaptorServer() {
        return this.startHtmlAdaptorServer(MBeanUtils.getHtmlAdaptor().getPort());
    }

    public boolean startHtmlAdaptorServer(int n) {
        final HtmlAdaptorServer htmlAdaptorServer = MBeanUtils.getHtmlAdaptor(n);
        final ObjectName objectName = MBeanUtils.getHtmlAdaptorObjectName();
        try {
            if (MBeanUtils.getMBeanServer().isRegistered(objectName)) {
                return true;
            }
            System.out.println("Creating a new HTML protocol adaptor and registering it into the MBeanServer...");
            MBeanUtils.getMBeanServer().registerMBean(htmlAdaptorServer, objectName);
        }
        catch (Exception exception) {
            System.err.println("\n\t>>>Failed to register HTML protocol adaptor into MBeanServer!");
            ServiceLogger.logError(exception);
            return false;
        }
        htmlAdaptorServer.start();
        System.out.println("HTML adaptor has been successfully started [listening to port " + htmlAdaptorServer.getPort() + "]\n");
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                MBeanFactory.this.unregisterAllMBeans();
                if (htmlAdaptorServer != null && MBeanUtils.getMBeanServer().isRegistered(objectName)) {
                    try {
                        MBeanUtils.getMBeanServer().unregisterMBean(objectName);
                        System.out.println("<<<Unregistered HtmlAdaptorServer from MBeanServer successfully...!");
                    }
                    catch (Exception exception) {
                        System.err.println("\t<<<Failed to unregister HtmlAdaptorServer from MBeanServer!");
                    }
                }
            }
        });
        return true;
    }
}

