/*
 * Decompiled with CFR 0.152.
 */
package jet.server.monitor.jrmon;

import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import jet.server.api.cluster.Member;
import jet.server.intf.jrs.RemoteMonitorService;
import jet.server.log.ServiceLogger;
import jet.server.monitor.api.MonitorServer;
import jet.server.monitor.api.MonitorService;
import jet.server.monitor.api.MonitorSetting;
import jet.server.monitor.api.ServerStatus;
import jet.server.monitor.api.UserSessionManager;
import jet.server.monitor.event.EventSubscriber;
import jet.server.monitor.jrmon.JRMonitorService;
import jet.server.monitor.jrmon.JRMonitorSetting;
import jet.server.monitor.jrmon.JRUserSessionManager;
import jet.server.monitor.jrmon.MonitorEnv;
import jet.server.monitor.jrmon.cluster.JRClusterMonitor;
import jet.server.monitor.jrmon.intf.ClusterMonitor;
import jet.server.rmi.RemoteObjectFactory;

public class JRMonitorServer
implements MonitorServer {
    private Hashtable SEDU = null;
    private Hashtable addElement = null;
    private Vector append = null;
    private UserSessionManager clear = null;
    private boolean deleteAllSubscribers = false;
    private boolean elements = false;
    private ClusterMonitor err = null;
    private MonitorSetting exit = null;

    @Override
    public void init(Properties properties) {
        if (this.deleteAllSubscribers) {
            return;
        }
        this.SEDU = new Hashtable();
        this.append = new Vector();
        this.addElement = new Hashtable();
        if (MonitorEnv.getAdminRemoteMonitorService() != null) {
            this.addElement.put(MonitorEnv.getAdminAddress(), MonitorEnv.getAdminRemoteMonitorService());
        }
        this.exit = new JRMonitorSetting();
        this.deleteAllSubscribers = true;
    }

    @Override
    public void start() {
        if (this.clear == null) {
            this.clear = new JRUserSessionManager();
        }
        this.elements = true;
        this.SEDU();
    }

    @Override
    public boolean isStarted() {
        return this.elements;
    }

    @Override
    public void restart(Properties properties) {
        if (this.elements) {
            this.shutdown();
        }
        this.init(properties);
        this.start();
    }

    @Override
    public void shutdown() {
        this.elements = false;
        this.deleteAllSubscribers = false;
        MonitorService monitorService = null;
        Enumeration enumeration = this.SEDU.elements();
        while (enumeration.hasMoreElements()) {
            monitorService = (MonitorService)enumeration.nextElement();
            monitorService.stopAll();
        }
        this.err.stop();
        EventSubscriber.getEventSubscriber().deleteAllSubscribers();
        this.addElement.clear();
        this.SEDU.clear();
        ((JRUserSessionManager)this.clear).saveLoginTime();
        if (MonitorEnv.isInternalHttpServer()) {
            System.exit(1);
        }
    }

    @Override
    public MonitorService getMonitorService(String string, int n) {
        MonitorService monitorService = (MonitorService)this.SEDU.get(string + ":" + n);
        if (this.elements && this.isStarting(string, n)) {
            if (monitorService == null) {
                monitorService = new JRMonitorService(this, string, n);
                this.SEDU.put(string + ":" + n, monitorService);
                monitorService.startAll();
            } else if (((JRMonitorService)monitorService).isStoped()) {
                monitorService.startAll();
            }
        }
        return monitorService;
    }

    @Override
    public boolean isCluster() {
        boolean bl = false;
        try {
            RemoteMonitorService remoteMonitorService = (RemoteMonitorService)this.addElement.get(MonitorEnv.getAdminAddress());
            bl = remoteMonitorService.isClusterEnable();
        }
        catch (Exception exception) {
            ServiceLogger.logError(3660006, new Object[]{MonitorEnv.getAdminHost(), String.valueOf(MonitorEnv.getAdminPort())}, 3);
            ServiceLogger.logError(exception);
        }
        return bl;
    }

    @Override
    public String getClusterName() {
        String string = null;
        try {
            RemoteMonitorService remoteMonitorService = (RemoteMonitorService)this.addElement.get(MonitorEnv.getAdminAddress());
            string = remoteMonitorService.getClusterName();
        }
        catch (Exception exception) {
            ServiceLogger.logError(3660006, new Object[]{MonitorEnv.getAdminHost(), String.valueOf(MonitorEnv.getAdminPort())}, 3);
            ServiceLogger.logError(exception);
        }
        return string;
    }

    @Override
    public Member[] getPredefinedServers() {
        Member[] memberArray = null;
        try {
            RemoteMonitorService remoteMonitorService = (RemoteMonitorService)this.addElement.get(MonitorEnv.getAdminAddress());
            memberArray = remoteMonitorService.getPredefinedServers();
        }
        catch (Exception exception) {
            ServiceLogger.logError(3660006, new Object[]{MonitorEnv.getAdminHost(), String.valueOf(MonitorEnv.getAdminPort())}, 3);
            ServiceLogger.logError(exception);
            memberArray = new Member[]{};
        }
        return memberArray;
    }

    @Override
    public Member[] getClusteredServers() {
        Member[] memberArray = null;
        try {
            RemoteMonitorService remoteMonitorService = (RemoteMonitorService)this.addElement.get(MonitorEnv.getAdminAddress());
            memberArray = remoteMonitorService.getClusteredServers();
        }
        catch (Exception exception) {
            ServiceLogger.logError(3660006, new Object[]{MonitorEnv.getAdminHost(), String.valueOf(MonitorEnv.getAdminPort())}, 3);
            ServiceLogger.logError(exception);
            memberArray = new Member[]{};
        }
        return memberArray;
    }

    @Override
    public boolean isStarted(String string, int n) {
        boolean bl = false;
        try {
            RemoteMonitorService remoteMonitorService = (RemoteMonitorService)this.addElement.get(MonitorEnv.getAdminAddress());
            bl = remoteMonitorService.isStarted(string, n);
        }
        catch (Exception exception) {
            ServiceLogger.logError(3660007, new Object[]{MonitorEnv.getAdminHost(), String.valueOf(MonitorEnv.getAdminPort())}, 3);
        }
        return bl;
    }

    @Override
    public boolean isStarting(String string, int n) {
        boolean bl = false;
        try {
            RemoteMonitorService remoteMonitorService = this.getRemoteMonitorService(string, n);
            if (remoteMonitorService != null) {
                bl = remoteMonitorService.isStarting();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    @Override
    public ServerStatus getServerStatus(String string, int n) {
        return this.err.getServerStatus(string, n);
    }

    @Override
    public UserSessionManager getUserSessionManager() {
        return this.clear;
    }

    @Override
    public void setUserSessionManager(UserSessionManager userSessionManager) {
        this.clear = userSessionManager;
    }

    @Override
    public MonitorSetting getMonitorSettings() {
        return this.exit;
    }

    @Override
    public void stopServer(String string, int n) {
        try {
            RemoteMonitorService remoteMonitorService = this.getRemoteMonitorService(string, n);
            remoteMonitorService.stopServer(string, n);
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        if (this.isStarting(string, n)) {
            System.err.println("You can't stop the Server: " + string + ":" + n + " now!");
            ServiceLogger.logError(3660008, new Object[]{string, String.valueOf(n)}, 3);
        }
    }

    public void appendBindCounterName(String string) {
        this.append.addElement(string);
    }

    public RemoteMonitorService getRemoteMonitorService(String string, int n) throws Exception {
        RemoteMonitorService remoteMonitorService = (RemoteMonitorService)this.addElement.get(string + ":" + n);
        if (remoteMonitorService == null && (remoteMonitorService = (RemoteMonitorService)RemoteObjectFactory.getRemoteObject(string, n, MonitorEnv.getRemoteMonitorServiceName())) != null) {
            this.addElement.put(string + ":" + n, remoteMonitorService);
        }
        return remoteMonitorService;
    }

    public void deleteRemoteMonitorService(String string, int n) {
        this.addElement.remove(string + ":" + n);
    }

    public void stopMonitorService(String string, int n) {
        MonitorService monitorService = (MonitorService)this.SEDU.get(string + ":" + n);
        if (monitorService != null) {
            monitorService.stopAll();
        }
    }

    public ClusterMonitor getClusterMonitor() {
        return this.err;
    }

    private void SEDU() {
        this.err = new JRClusterMonitor(this);
        this.err.setInterval(2000);
        this.err.setDuration(600000);
        this.err.start();
    }
}

