/*
 * Decompiled with CFR 0.152.
 */
package jet.server.monitor.jrmon;

import java.util.Enumeration;
import java.util.Hashtable;
import jet.server.event.SelectorImpl;
import jet.server.event.Subscriber;
import jet.server.intf.jrs.RemoteMonitorService;
import jet.server.log.ServiceLogger;
import jet.server.monitor.api.Monitor;
import jet.server.monitor.api.MonitorCounter;
import jet.server.monitor.api.MonitorServer;
import jet.server.monitor.api.MonitorService;
import jet.server.monitor.api.adhoc.AdhocMonitor;
import jet.server.monitor.api.database.DatabaseMonitor;
import jet.server.monitor.api.task.TaskMonitor;
import jet.server.monitor.api.user.UserMonitor;
import jet.server.monitor.event.EventSubscriber;
import jet.server.monitor.event.EventType;
import jet.server.monitor.event.MonitorEventHandler;
import jet.server.monitor.jrmon.JRMonitorCounter;
import jet.server.monitor.jrmon.JRMonitorServer;
import jet.server.monitor.jrmon.MonitorEnv;
import jet.server.monitor.jrmon.database.JRDatabaseMonitor;
import jet.server.monitor.jrmon.intf.ClusterMonitor;
import jet.server.monitor.jrmon.task.JRTaskMonitor;
import jet.server.monitor.jrmon.user.JRUserMonitor;
import jet.server.rmi.RemoteObjectFactory;

public class JRMonitorService
implements MonitorService,
EventType {
    private static int SEDU = MonitorEnv.getDefaultRefreshInterval();
    private static int activate = MonitorEnv.getMaxTimeSaveReport() * 60 * 1000;
    public static final int TASK_MONITOR = 1;
    public static final int USER_MONITOR = 2;
    public static final int DATABASE_MONITOR = 3;
    public static final int ADHOC_MONITOR = 4;
    public static final int ALL_MONITOR = 5;
    public static final int NO_MONITOR = 0;
    private static final String[] addSelector = new String[]{"", "monitor.task", "monitor.user", "monitor.database", "monitor.adhoc"};
    private MonitorServer addSubscriber = null;
    private String append = null;
    private int appendBindCounterName = 0;
    private Hashtable createSubscriber = null;
    private RemoteMonitorService createSubscribers = null;
    private MonitorCounter deleteSubscribers = null;
    private boolean elements = true;

    public JRMonitorService(MonitorServer monitorServer, String string, int n) {
        this.addSubscriber = monitorServer;
        this.append = string;
        this.appendBindCounterName = n;
        this.createSubscriber = new Hashtable();
        try {
            this.deleteSubscribers = new JRMonitorCounter(this);
        }
        catch (Exception exception) {
            ServiceLogger.logError("Can't create Monitor Counter's instance!");
            ServiceLogger.logError(exception);
        }
        String string2 = "//" + MonitorEnv.getMonitorServerHostName() + ":" + MonitorEnv.getMonitorServerRMIPort() + "/" + MonitorEnv.getMonitorCounterName() + "_" + string + "_" + n;
        try {
            RemoteObjectFactory.register(MonitorEnv.getMonitorCounterName() + "_" + string + "_" + n, this.deleteSubscribers);
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        ((JRMonitorServer)monitorServer).appendBindCounterName(string2);
    }

    public RemoteMonitorService getRemoteMonitorService() {
        return this.createSubscribers;
    }

    public void start(int n) {
        this.start(n, SEDU);
    }

    public void start(int n, int n2) {
        Monitor monitor = null;
        String string = null;
        boolean bl = false;
        if (n == 1) {
            monitor = (Monitor)this.createSubscriber.get(addSelector[n]);
            if (monitor == null) {
                monitor = new JRTaskMonitor(this, n2);
            }
            string = "TaskManager";
        } else if (n == 2) {
            monitor = new JRUserMonitor(this, n2);
            if (n2 < 10000) {
                monitor.setInterval(10000);
            }
        } else if (n == 3) {
            monitor = new JRDatabaseMonitor(this, n2);
            if (n2 < 10000) {
                monitor.setInterval(10000);
            }
        } else if (n != 4) {
            System.err.println("Without this monitor!");
        }
        if (monitor != null) {
            monitor.setDuration(activate);
            this.createSubscriber.put(addSelector[n], monitor);
            monitor.start();
            if (string != null) {
                this.createSubscribers(string, 12, -1);
                this.createSubscribers("TaskAuditor", 12, -1);
            }
            if (bl) {
                this.createSubscribers("adhoc_task_topic", 4, -1);
                this.createSubscribers("adhoc_engine_topic", 7, -1);
                this.createSubscribers("adhoc_service_topic", 4, -1);
            }
        }
    }

    public void restart(int n) {
        ((Monitor)this.createSubscriber.get(addSelector[n])).restart();
    }

    @Override
    public void startAll() {
        try {
            this.createSubscribers = ((JRMonitorServer)this.addSubscriber).getRemoteMonitorService(this.append, this.appendBindCounterName);
        }
        catch (Exception exception) {
            ServiceLogger.logError("Report Server: " + this.append + ":" + this.appendBindCounterName + " is closed!");
            ServiceLogger.logError(exception);
        }
        for (int i = 1; i < 5; ++i) {
            this.start(i);
        }
        this.elements = false;
    }

    public void stop(int n) {
        Monitor monitor = (Monitor)this.createSubscriber.get(addSelector[n]);
        if (monitor != null && monitor.isStarted()) {
            monitor.stop();
        }
    }

    @Override
    public void stopAll() {
        this.createSubscribers = null;
        for (int i = 1; i < 5; ++i) {
            this.stop(i);
        }
        this.SEDU();
        this.elements = true;
    }

    public boolean isStoped() {
        return this.elements;
    }

    @Override
    public String getHost() {
        return this.append;
    }

    @Override
    public int getPort() {
        return this.appendBindCounterName;
    }

    public boolean hasMonitorStarted() {
        Enumeration enumeration = this.createSubscriber.elements();
        while (enumeration.hasMoreElements()) {
            if (!((Monitor)enumeration.nextElement()).isStarted()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setDefaultInterval(int n) {
        SEDU = n;
    }

    @Override
    public int getDefaultInterval() {
        return SEDU;
    }

    @Override
    public void setDefaultDuration(int n) {
        activate = n;
    }

    @Override
    public int getDefaultDuration() {
        return activate;
    }

    @Override
    public TaskMonitor getTaskMonitor() {
        return (TaskMonitor)this.createSubscriber.get(addSelector[1]);
    }

    @Override
    public UserMonitor getUserMonitor() {
        return (UserMonitor)this.createSubscriber.get(addSelector[2]);
    }

    @Override
    public DatabaseMonitor getDatabaseMonitor() {
        return (DatabaseMonitor)this.createSubscriber.get(addSelector[3]);
    }

    public ClusterMonitor getClusterMonitor() {
        return ((JRMonitorServer)this.addSubscriber).getClusterMonitor();
    }

    public AdhocMonitor getAdhocMonitor() {
        return (AdhocMonitor)this.createSubscriber.get(addSelector[4]);
    }

    private void SEDU() {
        EventSubscriber.getEventSubscriber().deleteSubscribers(this.append + ":" + this.appendBindCounterName);
    }

    public void createSubscribers(String string, int n, int n2) {
        Subscriber subscriber = this.createSubscriber(string);
        SelectorImpl selectorImpl = new SelectorImpl(string, n);
        if (n2 >= 0) {
            selectorImpl.enable(n2);
        } else {
            selectorImpl.enableAll();
        }
        subscriber.addSelector(selectorImpl);
        try {
            subscriber.activate();
            subscriber.update();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public Subscriber createSubscriber(String string) {
        Subscriber subscriber = EventSubscriber.getEventSubscriber().getSubscriber(this.append + ":" + this.appendBindCounterName + "_" + string);
        if (subscriber == null) {
            subscriber = EventSubscriber.getEventSubscriber().getEventService().createSubscriber(this.append, this.appendBindCounterName, new MonitorEventHandler(this));
            EventSubscriber.getEventSubscriber().addSubscriber(this.append + ":" + this.appendBindCounterName + "_" + string, subscriber);
        }
        return subscriber;
    }

    public void createSubscribers(String string, int n) {
        Subscriber subscriber = EventSubscriber.getEventSubscriber().getSubscriber(this.append + ":" + this.appendBindCounterName + "_" + string);
        if (subscriber == null) {
            subscriber = EventSubscriber.getEventSubscriber().getEventService().createSubscriber(this.append, this.appendBindCounterName, new MonitorEventHandler(this));
            EventSubscriber.getEventSubscriber().addSubscriber(this.append + ":" + this.appendBindCounterName + "_" + string, subscriber);
        }
        SelectorImpl selectorImpl = new SelectorImpl(string, 8);
        if (n >= 0) {
            selectorImpl.enable(n);
        } else {
            selectorImpl.enableAll();
        }
        subscriber.addSelector(selectorImpl);
        try {
            subscriber.activate();
            subscriber.update();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public JRMonitorServer getJRMonitorServer() {
        return (JRMonitorServer)this.addSubscriber;
    }
}

