/*
 * Decompiled with CFR 0.152.
 */
package jet.server.monitor.jrmon;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import jet.Env;
import jet.JSRuntimeException;
import jet.cs.CSUtil;
import jet.cs.ExProperties;
import jet.cs.util.APIUtil;
import jet.server.ServerEnv;
import jet.server.api.exception.InvalidUserException;
import jet.server.api.http.HttpUtil;
import jet.server.intf.jrs.RemoteMonitorService;
import jet.server.log.ServiceLogger;
import jet.server.monitor.api.UserSession;
import jet.server.monitor.api.http.HttpMonitorServer;
import jet.server.monitor.jmx.utils.MBeanFactory;
import jet.server.monitor.jrmon.http.JRHttpMonitorServer;
import jet.server.rmi.RemoteObjectFactory;
import jet.server.util.CreateDefExProperties;
import jet.server.util.MIMETypeTable;

public class MonitorEnv {
    public static final String ALL_MONITOR = "monitor.all";
    public static final String TASK_MONITOR = "monitor.task";
    public static final String USER_MONITOR = "monitor.user";
    public static final String CLUSTER_MONITOR = "monitor.cluster";
    public static final String DATABASE_MONITOR = "monitor.database";
    public static final String ADHOC_MONITOR = "monitor.adhoc";
    public static final String SERVLET_PROPERTY = "servlet.property";
    public static final String SERVER_PROPERTY = "server.property";
    public static final String MONITOR_SERVER = "monitor.report.server";
    public static final String MONITOR_CLUSTER = "monitor.cluster.server";
    public static final String WEB_ROOT = "web.root";
    public static final String MONITOR_SERVICE_PORT = "monitor.service.port";
    public static final String MONITOR_HOMEPAGE = "monitor.homepage";
    public static final String MONITOR_HOME = "monitor.home";
    public static final String INSTALL_ROOT = "monitor.install.root";
    public static final String MONITOR_RMI_PORT = "monitor.rmi.port";
    public static final int DEFAULT_MONITOR_RMI_PORT = 1248;
    public static final int DEFAULT_MONITOR_SERVICE_PORT = 8848;
    public static final String ADMIN_SERVER_HOST = "admin.server.host";
    public static final String ADMIN_SERVER_PORT = "admin.server.port";
    public static final String CLUSTER_MEMBERS = "cluster.Members";
    public static final String MONITOR_REFRESH_INTERVAL = "monitor.refresh.interval";
    public static final String MONITOR_MAX_REPORT_SAVE_NUMBER = "monitor.max.report.save.number";
    public static final String MONITOR_MAX_REPORT_SAVE_TIME = "monitor.max.report.save.time";
    public static final String STARTUP_MONITORING_JMX_FEATURES = "monitor.jmx.startup";
    public static final boolean DEFAULT_STARTUP_JMX_MONITORING = false;
    private static boolean SEDU = false;
    public static final String STARTUP_MONITOR_JMX_ADAPTOR = "monitor.jmx.htmladaptor.startup";
    public static final boolean DEFAULT_STARTUP_JMX_ADAPTOR = true;
    private static boolean addElement = true;
    public static final String JMX_HTMLADAPTOR_PORT = "monitor.jmx.htmladaptor.port";
    public static final int DEFAULT_JMX_HTMLADAPTOR_PORT = 8849;
    private static int append = 8849;
    public static final int DEFAULT_REFRESH_INTERVAL = 10000;
    public static final int DEFAULT_MAX_REPORT_SAVE_NUMBER = 2000;
    public static final int DEFAULT_MAX_REPORT_SAVE_TIME = 5;
    public static final String AUTH_SCHEME_BASIC = "Basic";
    public static final String AUTH_SCHEME_DIGEST = "Digest";
    public static final String IS_INTERNAL_SERVER = "isInternalServer";
    private static final String close = "MonitorCounter";
    private static int createNewFile = 1248;
    public static final String SVRPROP_HTTP_OUTPUT_ENCODING = "server.http.output_encoding";
    public static final String PROP_OUTPUT_ENCODING = "output_encoding";
    private static String elementAt = null;
    private static boolean endsWith = false;
    private static String equals = null;
    private static String equalsIgnoreCase = null;
    private static boolean err = false;
    private static HttpMonitorServer exists = null;
    private static ExProperties exit = null;
    private static boolean getAbsolutePath = true;
    private static boolean getActiveRealm = false;
    public static final int DEFAULT_ADMIN_PORT = 1129;
    private static String getAdminAddress = null;
    private static int getAdminHost = -1;
    private static RemoteMonitorService getAdminPort = null;
    private static boolean getAdminRemoteMonitorService = false;
    private static MIMETypeTable getBoolean;
    private static boolean getByName;
    private static boolean getBytes;
    public static final String MONITOR_ISWAITFORADMIN = "monitor.server.is_wait_for_admin";
    public static final boolean DEFAULT_ISWAITFORADMIN = true;
    public static final boolean ADHOC_MONITOR_ENABLE = false;
    private static String getDefaultMIMETypeTable;
    private static String getHomePath;
    private static String getHostAddress;

    public static void initMon(ExProperties exProperties) {
        Object object;
        if (err || getBytes) {
            return;
        }
        if (exProperties != null && exProperties.size() > 0) {
            exit.merge(exProperties);
        }
        if (exit.size() == 0) {
            object = System.getProperties();
            String string = null;
            Enumeration<Object> enumeration = ((Properties)object).keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                exit.setProperty(string, ((Properties)object).getProperty(string));
            }
        }
        getByName = (object = System.getProperty(IS_INTERNAL_SERVER)) != null && ((String)object).equals("true");
        MonitorEnv.SEDU();
        RemoteObjectFactory.setIsMonitorServer(true);
        RemoteObjectFactory.init(MonitorEnv.getMonitorServerRMIPort(), MonitorEnv.getHomePath());
        System.getProperties().put("jrs.remote.host", MonitorEnv.getAdminHost());
        System.getProperties().put("jrs.remote.rmiport", String.valueOf(MonitorEnv.getAdminPort()));
        System.getProperties().put("jrs.remote.dispatcher", "jet.server.monitor.RemoteDispatcherImpl");
        HttpUtil.initEnv(System.getProperties());
        if (MonitorEnv.getAdminRemoteMonitorService() == null) {
            System.out.println("JReport Server has not been started. Please start it before launching JReport Server Monitor.");
            getBytes = true;
            if (getByName) {
                System.out.println("JReport Server Monitor will try 10 times to look for Standalone Admin Server...");
                boolean bl = false;
                for (int i = 1; i <= 10; ++i) {
                    try {
                        Thread.sleep(6000L);
                        System.out.print("Attempt " + i + ".\r");
                        if (MonitorEnv.getAdminRemoteMonitorService() == null) continue;
                        break;
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    catch (Exception exception) {
                        if (bl) continue;
                        bl = true;
                        ServiceLogger.logError(exception);
                    }
                }
                if (getAdminPort == null && !MonitorEnv.isWaitForAdmin()) {
                    System.out.println("JReport Server Monitor can't connect to JReport Server [" + getAdminAddress + ":" + getAdminHost + "]\n" + "Please make sure that JReport Server has been started and is set up properly. Then, try again.\n" + "You can also set up 'monitor.server.is_wait_for_admin=true' in the file server.properties to enable JReport Server Monitor to wait until JREntServer has been started.");
                    System.exit(1);
                }
            } else {
                do {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    System.out.print("JReport Server Monitor is trying to look for Admin Server or Standalone Server...\r");
                } while (MonitorEnv.getAdminRemoteMonitorService() == null);
            }
        }
        exists = new JRHttpMonitorServer();
        exists.init(exit);
        exists.start();
        getBytes = false;
        err = true;
        if (getAdminPort == null) {
            System.out.println("JReport Server Monitor can't connect to JReport Server [" + getAdminAddress + ":" + getAdminHost + "]\n" + "JReport Server Monitor will wait until JReport Server starts.\n");
            do {
                try {
                    Thread.sleep(6000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (MonitorEnv.getAdminRemoteMonitorService() == null);
        }
        System.out.println("JReport Server Monitor has successfully connected to JReport Server [" + getAdminAddress + ":" + getAdminHost + "]");
        MonitorEnv.close();
        if (SEDU) {
            MBeanFactory.getInstance().registerAllMBeans();
            if (addElement) {
                MBeanFactory.getInstance().startHtmlAdaptorServer(append);
            }
        }
        MonitorEnv.savePropToFile();
    }

    public static boolean isInternalHttpServer() {
        return getByName;
    }

    public static RemoteMonitorService getAdminRemoteMonitorService() {
        if (getAdminPort == null) {
            try {
                getAdminPort = (RemoteMonitorService)RemoteObjectFactory.getRemoteObject(getAdminAddress, getAdminHost, MonitorEnv.getRemoteMonitorServiceName());
            }
            catch (Exception exception) {
                ServiceLogger.logError(2660219, new Object[]{getAdminAddress, String.valueOf(getAdminHost), exception.getMessage()}, 2);
                ServiceLogger.logError(exception);
            }
        }
        return getAdminPort;
    }

    private static void SEDU() {
        if (getActiveRealm) {
            return;
        }
        exit.merge(MonitorEnv.getServerProperties());
        exit.setProperty("monitor.server.bin.path", MonitorEnv.getHomePath() + "bin");
        ServiceLogger.initErrorLog(exit);
        createNewFile = CSUtil.parseInt(exit.getProperty(MONITOR_RMI_PORT), 1248);
        exit.setProperty(MONITOR_RMI_PORT, createNewFile);
        exit.setProperty(SERVER_PROPERTY, MonitorEnv.getServPropName());
        if (equalsIgnoreCase != null) {
            if (equalsIgnoreCase.endsWith("\\")) {
                exit.setProperty(WEB_ROOT, equalsIgnoreCase.substring(0, equalsIgnoreCase.length() - 1));
            } else {
                exit.setProperty(WEB_ROOT, equalsIgnoreCase);
            }
        }
        if (exit.getProperty(MONITOR_HOMEPAGE) == null) {
            exit.setProperty(MONITOR_HOMEPAGE, "");
        }
        SEDU = exit.getProperty(STARTUP_MONITORING_JMX_FEATURES, false);
        exit.setProperty(STARTUP_MONITORING_JMX_FEATURES, SEDU);
        if (SEDU) {
            addElement = exit.getProperty(STARTUP_MONITOR_JMX_ADAPTOR, true);
            exit.setProperty(STARTUP_MONITOR_JMX_ADAPTOR, addElement);
            append = exit.getProperty(JMX_HTMLADAPTOR_PORT, 8849);
            exit.setProperty(JMX_HTMLADAPTOR_PORT, append);
        }
        MonitorEnv.getAdminAddress();
        MonitorEnv.getOutputEncoding();
        getActiveRealm = true;
    }

    public static HttpMonitorServer getHttpMonitorServer() {
        if (exists == null) {
            MonitorEnv.initMon(exit);
        }
        return exists;
    }

    public static void restartMonitorServer() {
        exists.restart(exit);
    }

    public static void shutdownMonitorServer() {
        err = false;
        getActiveRealm = false;
        RemoteObjectFactory.quit();
        exists.shutdown();
    }

    public static String getPassword(String string, String string2) {
        String string3 = null;
        try {
            if (getAdminPort != null) {
                string3 = getAdminPort.getPassword(string, string2);
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(3660011, new Object[]{getAdminAddress, String.valueOf(getAdminHost)}, 3);
        }
        return string3;
    }

    public static boolean isAdminUser(String string, String string2, String string3) {
        boolean bl = false;
        try {
            if (getAdminPort != null) {
                bl = getAdminPort.isAdminUser(string, string2, string3);
                if (!bl) {
                    ServiceLogger.logError("Only admin user can login JReport Server Monitor! user: " + string2, 3);
                }
                return bl;
            }
        }
        catch (Exception exception) {
            System.err.print("Admin Server is closed now!\r");
            ServiceLogger.logError(3660006, new Object[]{getAdminAddress, String.valueOf(getAdminHost)}, 3);
        }
        return false;
    }

    public static boolean isValidAdminUserEx(String string, String string2, String string3) throws InvalidUserException {
        boolean bl = false;
        try {
            if (getAdminPort != null) {
                bl = getAdminPort.isValidAdminUserEx(string, string2, string3);
                if (!bl) {
                    ServiceLogger.logError("Only admin user can login JReport Server Monitor! user: " + string2, 3);
                }
                return bl;
            }
        }
        catch (InvalidUserException invalidUserException) {
            throw invalidUserException;
        }
        catch (Exception exception) {
            System.err.print("Admin Server is closed now!\r");
            ServiceLogger.logError(3660006, new Object[]{getAdminAddress, String.valueOf(getAdminHost)}, 3);
        }
        return false;
    }

    public static String getActiveRealm() {
        String string = null;
        try {
            if (getAdminPort != null) {
                string = getAdminPort.getActiveRealm();
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(3660012, new Object[]{getAdminAddress, String.valueOf(getAdminHost)}, 3);
        }
        return string;
    }

    public static String getServPropName() {
        String string = System.getProperty(SERVER_PROPERTY);
        if (string == null) {
            string = "server.properties";
            string = MonitorEnv.getHomePath() + "bin" + File.separator + string;
        } else if (string.indexOf(File.separator) == -1) {
            string = MonitorEnv.getHomePath() + "bin" + File.separator + string;
        }
        return string;
    }

    public static String getWebPath() {
        return equalsIgnoreCase;
    }

    public static void setWebPath(String string) {
        File file = new File(string);
        if (file.isDirectory() && file.exists() && !(equalsIgnoreCase = string).endsWith(File.separator)) {
            equalsIgnoreCase = equalsIgnoreCase + File.separator;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getHomePath() {
        if (equals == null && (equals = System.getProperty(MONITOR_HOME)) == null) {
            equals = System.getProperty(INSTALL_ROOT);
        }
        if (equals == null) {
            System.err.println("Monitor properties have not been defined, please try with \"java -Dmonitor.home=path\"");
            if (!MonitorEnv.isInternalHttpServer()) throw new JSRuntimeException(600028);
            ServiceLogger.logError(3660013, 3);
            System.exit(1);
            return equals;
        } else {
            if (equals.endsWith(File.separator)) return equals;
            Env.homePath = equals = equals + File.separator;
        }
        return equals;
    }

    public static String getAdminAddress() {
        if (getAdminAddress == null) {
            getAdminAddress = exit.getProperty(ADMIN_SERVER_HOST);
            if (getAdminAddress == null) {
                getAdminAddress = MonitorEnv.getMonitorServerHostName();
                exit.setProperty(ADMIN_SERVER_HOST, getAdminAddress);
                System.err.println("Warning: Admin host properties have not been set! \n\tJReport Server Monitor will use the default value 'localhost' to lookup Admin Server.");
                if (ServiceLogger.isLoggable(2, 3)) {
                    ServiceLogger.logError(3660014, 3);
                }
            } else if (getAdminAddress.equalsIgnoreCase("localhost")) {
                getAdminAddress = MonitorEnv.getMonitorServerHostName();
                exit.setProperty(ADMIN_SERVER_HOST, getAdminAddress);
            }
        }
        if (getAdminHost == -1 && (getAdminHost = exit.getProperty(ADMIN_SERVER_PORT, -1)) == -1) {
            getAdminHost = 1129;
            exit.setProperty(ADMIN_SERVER_PORT, getAdminHost);
            System.err.println("Warning: Admin RMI port properties have not been set! \n\tJReport Server Monitor will use the default value '1129' to lookup Admin Server.");
            if (ServiceLogger.isLoggable(2, 3)) {
                ServiceLogger.logError(3660015, 3);
            }
        }
        return getAdminAddress + ":" + getAdminHost;
    }

    public static String getAdminHost() {
        return getAdminAddress;
    }

    public static int getAdminPort() {
        return getAdminHost;
    }

    public static void setAdminHost(String string) {
        getAdminAddress = string;
    }

    public static void setAdminPort(int n) {
        getAdminHost = n;
    }

    public static void savePropToFile() {
        String string = MonitorEnv.getServPropName();
        String string2 = null;
        try {
            PrintStream printStream = new PrintStream(new FileOutputStream(string));
            Vector vector = new Vector();
            Enumeration<Object> enumeration = exit.keys();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
            vector = APIUtil.sortAsCol(vector, null, true);
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                string2 = (String)vector.elementAt(i);
                printStream.println(string2 + "=" + exit.getProperty(string2));
            }
        }
        catch (Exception exception) {
            ServiceLogger.logError(3660016, 3);
            ServiceLogger.logError(exception);
        }
    }

    public static void setProperties(ExProperties exProperties) {
        exit = exProperties;
    }

    public static ExProperties getProperties() {
        return exit;
    }

    public static int getDefaultRefreshInterval() {
        if (exit == null) {
            return 10000;
        }
        String string = exit.getProperty(MONITOR_REFRESH_INTERVAL);
        if (string != null) {
            return Integer.parseInt(string);
        }
        exit.setProperty(MONITOR_REFRESH_INTERVAL, 10000);
        return 10000;
    }

    public static void setDefaultRefreshInterval(int n) {
        if (n < 1000) {
            System.err.println("Please set default refresh interval value >= 1000 ms!");
            n = 1000;
        }
        try {
            exit.setProperty(MONITOR_REFRESH_INTERVAL, String.valueOf(n));
            MonitorEnv.savePropToFile();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public static int getMaxNumberSaveReport() {
        String string = exit.getProperty(MONITOR_MAX_REPORT_SAVE_NUMBER);
        if (string != null) {
            return Integer.parseInt(string);
        }
        exit.setProperty(MONITOR_MAX_REPORT_SAVE_NUMBER, 2000);
        return 2000;
    }

    public static void setMaxNumberSaveReport(int n) {
        if (n <= 0) {
            System.err.println("You set max report save number <= 0, it will be unlimited value!");
            n = 0;
        }
        try {
            exit.setProperty(MONITOR_MAX_REPORT_SAVE_NUMBER, String.valueOf(n));
            MonitorEnv.savePropToFile();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public static int getMaxTimeSaveReport() {
        String string = exit.getProperty(MONITOR_MAX_REPORT_SAVE_TIME);
        if (string != null) {
            return Integer.parseInt(string);
        }
        exit.setProperty(MONITOR_MAX_REPORT_SAVE_TIME, 5);
        return 5;
    }

    public static void setMaxTimeSaveReport(int n) {
        if (n <= 0) {
            System.err.println("You set max report save time <= 0, it will be unlimited value!");
            n = 0;
        }
        try {
            exit.setProperty(MONITOR_MAX_REPORT_SAVE_TIME, String.valueOf(n));
            MonitorEnv.savePropToFile();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public static ExProperties getServerProperties() {
        ExProperties exProperties = new ExProperties();
        try {
            String string = MonitorEnv.getServPropName();
            File file = new File(string);
            if (!file.exists()) {
                file.createNewFile();
            }
            exProperties.load(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            ServiceLogger.logError(3660017, 3);
            ServiceLogger.logError(fileNotFoundException);
        }
        catch (IOException iOException) {
            ServiceLogger.logError(3660018, 3);
            ServiceLogger.logError(iOException);
        }
        return exProperties;
    }

    public static boolean isJspEnable() {
        return getAbsolutePath;
    }

    public static String getMonitorServerHostName() {
        String string = null;
        try {
            string = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            string = "localhost";
            ServiceLogger.logError(unknownHostException);
        }
        return string;
    }

    public static int getMonitorServerRMIPort() {
        return createNewFile;
    }

    public static String getUser(HttpServletRequest httpServletRequest) {
        String string = null;
        UserSession userSession = exists.getHttpUserSessionManager().getUserSession(httpServletRequest);
        if (userSession != null) {
            string = userSession.getUserID();
        }
        return string == null ? "" : string;
    }

    public static String encodeEsc(String string, boolean bl) {
        return CSUtil.replWithEsc(string, bl);
    }

    public static String encodeEsc(String string) {
        return CSUtil.replWithEsc(string);
    }

    public static MIMETypeTable getMimeTypeTable() {
        return getBoolean;
    }

    private static void addElement() {
        String string = equals + "bin" + File.separator + "content-type.properties";
        try {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(string);
                getBoolean = new MIMETypeTable(fileInputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                getBoolean = MIMETypeTable.getDefaultMIMETypeTable();
                FileOutputStream fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(string);
                    getBoolean.save(fileOutputStream);
                }
                catch (IOException iOException) {
                    ServiceLogger.logError(iOException);
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {
                System.err.println("Failed on loading content-type file " + string + ". Default mime type table will be created.");
                ServiceLogger.logError(3660019, string, 2);
                getBoolean = MIMETypeTable.getDefaultMIMETypeTable();
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        catch (IOException iOException) {
            ServiceLogger.logError(iOException);
        }
    }

    private static String append() {
        if (equals == null && (equals = System.getProperty(MONITOR_HOME)) == null) {
            equals = System.getProperty(INSTALL_ROOT);
        }
        if (equals == null) {
            return "monitor properties have not been defined, please try with \"java -Dmonitor.home=path\"";
        }
        if (!equals.endsWith(File.separator)) {
            equals = equals + File.separator;
        }
        return null;
    }

    public static void check() {
        if (getAdminRemoteMonitorService) {
            return;
        }
        String string = MonitorEnv.append();
        if (string != null) {
            System.err.println(string);
            throw new JSRuntimeException(string);
        }
        MonitorEnv.addElement();
        if (equalsIgnoreCase == null && equals != null) {
            File file;
            String string2 = System.getProperty(WEB_ROOT);
            if (string2 != null && (file = new File(string2)).isDirectory() && file.exists() && !(equalsIgnoreCase = file.getAbsolutePath()).endsWith(File.separator)) {
                equalsIgnoreCase = equalsIgnoreCase + File.separator;
            }
            if (equalsIgnoreCase == null) {
                equalsIgnoreCase = equals + "public_html" + File.separator;
            }
            ServerEnv.htmlPath = equalsIgnoreCase;
        }
        MonitorEnv.SEDU();
        getAdminRemoteMonitorService = true;
    }

    public static String getRemoteMonitorServiceName() {
        return "RemoteMonitorService";
    }

    public static String getMonitorCounterName() {
        return close;
    }

    public static String getOutputEncoding() {
        if (!endsWith) {
            String string = null;
            try {
                string = exit.getProperty(SVRPROP_HTTP_OUTPUT_ENCODING, "");
                if (string == null) {
                    exit.setProperty(SVRPROP_HTTP_OUTPUT_ENCODING, "");
                }
                endsWith = true;
                if (string == null || string.trim().length() == 0) {
                    string = System.getProperty(PROP_OUTPUT_ENCODING);
                }
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
            if (string != null && string.length() > 0) {
                try {
                    "a".getBytes(string);
                    elementAt = string;
                }
                catch (Throwable throwable) {
                    ServiceLogger.logError(throwable);
                }
            }
            if (ServiceLogger.isLoggable(4, 6)) {
                ServiceLogger.logDebug(6660020, new Object[]{SVRPROP_HTTP_OUTPUT_ENCODING, elementAt}, 6);
            }
        }
        return elementAt;
    }

    public static boolean isAdminServerStarted() {
        return MonitorEnv.getHttpMonitorServer().isStarting(getAdminAddress, getAdminHost);
    }

    public static boolean isWaitForAdmin() {
        boolean bl = exit.getProperty(MONITOR_ISWAITFORADMIN, true);
        return bl;
    }

    public static String getLogsPath() {
        return MonitorEnv.getHomePath() + "logs";
    }

    public static boolean isAdminServer(String string, int n) {
        return getAdminAddress.equals(string) && getAdminHost == n;
    }

    public static void setAdminRemoteMonService(RemoteMonitorService remoteMonitorService) {
        getAdminPort = remoteMonitorService;
        MonitorEnv.close();
    }

    public static void setMonitorWebEntry(String string) {
        if (!string.equals(getDefaultMIMETypeTable)) {
            getDefaultMIMETypeTable = string;
            MonitorEnv.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void close() {
        if (getAdminPort == null) return;
        if (getDefaultMIMETypeTable.equals("")) {
            getDefaultMIMETypeTable = exit.getProperty(MONITOR_HOMEPAGE);
            if (getDefaultMIMETypeTable == null || getDefaultMIMETypeTable.trim().length() == 0) {
                getDefaultMIMETypeTable = System.getProperty(MONITOR_HOMEPAGE);
            }
            if (getDefaultMIMETypeTable == null || getDefaultMIMETypeTable.trim().length() == 0) {
                System.err.println("Warning: The monitor homepage of the web entry has not been set!");
                if (ServiceLogger.isLoggable(2, 3)) {
                    ServiceLogger.logError(3660220, new Object[]{MONITOR_HOMEPAGE, MONITOR_HOMEPAGE}, 3);
                }
                if (!getByName) {
                    System.err.println("\tSo the JReport Server Monitor won't be possibly registered into JReport Server.");
                    return;
                }
                getDefaultMIMETypeTable = "http://" + MonitorEnv.getMonitorServerHostName() + ":" + exit.getProperty(MONITOR_SERVICE_PORT, 8848) + "/monitor/index.jsp";
                System.err.println("\tJReport Server Monitor will use the default value '" + getDefaultMIMETypeTable + "' to register into its JReport Servers.");
                if (ServiceLogger.isLoggable(2, 3)) {
                    ServiceLogger.logError(3660221, getDefaultMIMETypeTable, 3);
                }
            } else {
                int n = getDefaultMIMETypeTable.indexOf(":", "http://".length());
                if (n > 0) {
                    String string = getDefaultMIMETypeTable.substring("http://".length(), n);
                    getDefaultMIMETypeTable = "http://" + MonitorEnv.getHostAddress(string) + getDefaultMIMETypeTable.substring(n);
                }
            }
        }
        try {
            getAdminPort.setMonitorServerURL(getDefaultMIMETypeTable);
            if (!ServiceLogger.isLoggable(4, 6)) return;
            ServiceLogger.logDebug(6660222, new Object[]{getDefaultMIMETypeTable, getAdminAddress, String.valueOf(getAdminHost)}, 6);
            return;
        }
        catch (Exception exception) {
            if (!ServiceLogger.isLoggable(2, 3)) return;
            ServiceLogger.logError(3660222, new Object[]{getAdminAddress, String.valueOf(getAdminHost), exception.getMessage()}, 3);
        }
    }

    public static String getHostAddress(String string) {
        String string2 = null;
        try {
            string2 = string.equalsIgnoreCase("localhost") || string.equals("127.0.0.1") ? MonitorEnv.getMonitorServerHostName() : InetAddress.getByName(string).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            string2 = string;
        }
        return string2;
    }

    public static boolean isDisplayUserLastLoginTime() {
        String string = exit.getProperty(getHomePath);
        if (string != null && string.trim().length() > 0) {
            return APIUtil.getBoolean(string, true);
        }
        exit.setProperty(getHomePath, "true");
        try {
            MonitorEnv.savePropToFile();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        return true;
    }

    public static boolean isDisplayUserLastLogoutTime() {
        String string = exit.getProperty(getHostAddress);
        if (string != null && string.trim().length() > 0) {
            return APIUtil.getBoolean(string, false);
        }
        exit.setProperty(getHostAddress, "false");
        try {
            MonitorEnv.savePropToFile();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        return false;
    }

    public static void setDisplayUserLastLoginTime(boolean bl) {
        try {
            exit.setProperty(getHomePath, String.valueOf(bl));
            MonitorEnv.savePropToFile();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public static void setDisplayUserLastLogoutTime(boolean bl) {
        try {
            exit.setProperty(getHostAddress, String.valueOf(bl));
            MonitorEnv.savePropToFile();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public static boolean getShowVirtualApplianceWelcomePage() {
        return VirtualApplianceEnv.getShowVirtualApplianceWelcomePage();
    }

    public static void setShowVirtualApplianceWelcomePage(boolean bl) {
        VirtualApplianceEnv.setShowVirtualApplianceWelcomePage(bl);
    }

    static {
        getByName = false;
        getBytes = false;
        getDefaultMIMETypeTable = "";
        getHomePath = "last.user.login.time";
        getHostAddress = "last.user.logout.time";
        exit = new CreateDefExProperties(true);
    }

    static class VirtualApplianceEnv {
        private static final String SEDU = "virtualAppliance.properties";
        private static final String append = "show_welcome_page";
        private static Properties close = new Properties();
        private static long exists = 0L;

        VirtualApplianceEnv() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void SEDU() {
            File file = new File(MonitorEnv.getHomePath() + "bin", SEDU);
            if (file.exists() && file.lastModified() > exists) {
                try {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    try {
                        close.load(fileInputStream);
                    }
                    finally {
                        ((InputStream)fileInputStream).close();
                    }
                }
                catch (IOException iOException) {
                    ServiceLogger.logError(iOException);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void append() {
            try {
                File file = new File(MonitorEnv.getHomePath() + "bin", SEDU);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                try {
                    close.store(fileOutputStream, null);
                }
                finally {
                    ((OutputStream)fileOutputStream).close();
                }
                exists = file.lastModified();
            }
            catch (IOException iOException) {
                ServiceLogger.logError(iOException);
            }
        }

        public static boolean getShowVirtualApplianceWelcomePage() {
            VirtualApplianceEnv.SEDU();
            return APIUtil.getBoolean(close.getProperty(append), false);
        }

        public static void setShowVirtualApplianceWelcomePage(boolean bl) {
            close.setProperty(append, String.valueOf(bl));
            VirtualApplianceEnv.append();
        }
    }
}

