/*
 * Decompiled with CFR 0.152.
 */
package jet.server.monitor.jrmon.adhoc;

import java.io.Serializable;
import java.util.Date;
import jet.server.log.ServiceLogger;
import jet.server.monitor.api.adhoc.AdhocEngineInfo;
import jet.server.monitor.jrmon.adhoc.AdhocConstants;

public class JRAdhocEngineInfo
implements AdhocEngineInfo,
AdhocConstants,
Serializable,
Cloneable {
    private static final long serialVersionUID = 308732196243815093L;
    private String engineID;
    private String sessionID;
    private int runningStatus;
    private String[] reports;
    private String runningReport;
    private long createTime;
    private long runTime;

    public JRAdhocEngineInfo() {
    }

    public JRAdhocEngineInfo(String string, String string2, String[] stringArray, String string3) {
        this(string, string2, stringArray, string3, 0L, 0L, 0);
    }

    public JRAdhocEngineInfo(String string, String string2, String[] stringArray, String string3, long l, long l2, int n) {
        this.engineID = string;
        this.sessionID = string2;
        this.reports = stringArray;
        this.runningReport = string3;
        this.createTime = l;
        this.runTime = l2;
        this.runningStatus = n;
    }

    public JRAdhocEngineInfo(AdhocEngineInfo adhocEngineInfo) {
        this(adhocEngineInfo.getEngineID(), adhocEngineInfo.getSessionID(), adhocEngineInfo.getReports(), adhocEngineInfo.getRunningReport(), adhocEngineInfo.getCreatedTime(), adhocEngineInfo.getRunningTime(), ((JRAdhocEngineInfo)adhocEngineInfo).getStatusIntValue());
    }

    @Override
    public String getEngineID() {
        return this.engineID;
    }

    public void setEngineID(String string) {
        this.engineID = string;
    }

    @Override
    public String getSessionID() {
        return this.sessionID;
    }

    public void setSessionID(String string) {
        this.sessionID = string;
    }

    @Override
    public String getRunningStatus() {
        boolean bl;
        boolean bl2 = bl = this.runningStatus < 0 || this.runningStatus >= ENGINE_STATUS_VALUES.length;
        if (bl) {
            ServiceLogger.logDebug(6660009, String.valueOf(this.runningStatus), 3);
            return ENGINE_STATUS_VALUES[0];
        }
        return ENGINE_STATUS_VALUES[this.runningStatus];
    }

    public void setRunningStatus(int n) {
        this.runningStatus = n;
    }

    public int getStatusIntValue() {
        return this.runningStatus;
    }

    @Override
    public String[] getReports() {
        return this.reports;
    }

    public void setReports(String[] stringArray) {
        this.reports = stringArray;
    }

    @Override
    public String getRunningReport() {
        return this.runningReport;
    }

    public void setRunningReport(String string) {
        this.runningReport = string;
    }

    @Override
    public long getCreatedTime() {
        return this.createTime;
    }

    public void setCreateTime(long l) {
        this.createTime = l;
    }

    @Override
    public long getRunningTime() {
        return this.runTime;
    }

    public void setRunningTime(long l) {
        this.runTime = l;
    }

    public Object clone() {
        return new JRAdhocEngineInfo(this);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Adhoc Engine Info [engine ID:").append(this.engineID);
        stringBuffer.append(";service session ID:").append(this.sessionID);
        stringBuffer.append(";engine status:").append(this.getRunningStatus());
        stringBuffer.append(";reports:<");
        for (int i = 0; i < this.reports.length; ++i) {
            stringBuffer.append(this.reports[i]);
            if (i >= this.reports.length - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(">;running report:").append(this.runningReport);
        stringBuffer.append(";created time:").append(new Date(this.createTime));
        stringBuffer.append(";running time:").append(new Date(this.runTime));
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

