/*
 * Decompiled with CFR 0.152.
 */
package jet.server.monitor.jrmon.adhoc;

import java.io.Serializable;
import java.util.Date;
import jet.server.log.ServiceLogger;
import jet.server.monitor.api.adhoc.AdhocTaskInfo;
import jet.server.monitor.jrmon.adhoc.AdhocConstants;

public class JRAdhocTaskInfo
implements AdhocTaskInfo,
AdhocConstants,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1494807308203970410L;
    private static final String SEDU = "Schedule";
    private String taskID = null;
    private String rptSet = null;
    private String[] rptNames = null;
    private String userName = null;
    private int taskStatus = 0;
    private String taskType = null;
    private String runHost = null;
    private int runPort = -1;
    private String[] dsoSets = null;
    private String[] rstFiles = null;
    private int rptPages = -1;
    private String reason = null;
    private long submitTime = -1L;
    private long startTime = -1L;
    private long completeTime = -1L;
    private String failedInfo = null;
    private boolean failedToRun = false;

    public JRAdhocTaskInfo() {
    }

    public JRAdhocTaskInfo(String string, String string2, String[] stringArray, String string3, long l, String[] stringArray2, String string4) {
        this(string, string2, stringArray, string3, l, stringArray2, string4, 0);
    }

    public JRAdhocTaskInfo(String string, String string2, String[] stringArray, String string3, long l, String[] stringArray2, String string4, int n) {
        this(string, string2, stringArray, string3, l, stringArray2, string4, n, null, -1, -1L);
    }

    public JRAdhocTaskInfo(String string, String string2, String string3, String string4, int n, long l, int n2) {
        this(string, string2, string3, string4, n, l, n2, null, null, -1L, null);
    }

    public JRAdhocTaskInfo(String string, String string2, String[] stringArray, String string3, long l, String[] stringArray2, String string4, int n, String string5, int n2, long l2) {
        this(string, string2, stringArray, string3, l, stringArray2, string4, n, string5, n2, l2, -1L, -1, null, null, null);
    }

    public JRAdhocTaskInfo(String string, String string2, String string3, String string4, int n, long l, int n2, String[] stringArray, String[] stringArray2, long l2, String[] stringArray3) {
        this(string, null, stringArray, string3, l, stringArray2, string2, n2, string4, n, l2, -1L, -1, stringArray3, null, null);
    }

    public JRAdhocTaskInfo(String string, String string2, String[] stringArray, String string3, long l, String[] stringArray2, String string4, int n, String string5, int n2, long l2, long l3, int n3, String[] stringArray3, String string6, String string7) {
        this.taskID = string;
        this.rptSet = string2;
        this.rptNames = stringArray == null ? new String[]{} : stringArray;
        this.taskType = string3;
        this.submitTime = l;
        this.dsoSets = stringArray2 == null ? new String[]{} : stringArray2;
        this.userName = string4;
        this.taskStatus = n;
        this.runHost = string5;
        this.runPort = n2;
        this.startTime = l2;
        this.completeTime = l3;
        this.rptPages = n3;
        this.rstFiles = stringArray3 == null ? new String[]{} : stringArray3;
        this.reason = string6;
        this.failedInfo = string7;
    }

    public JRAdhocTaskInfo(AdhocTaskInfo adhocTaskInfo) {
        this(adhocTaskInfo.getTaskID(), adhocTaskInfo.getReportSet(), adhocTaskInfo.getReports(), adhocTaskInfo.getTaskType(), adhocTaskInfo.getSubmittedTime(), adhocTaskInfo.getDSOs(), adhocTaskInfo.getUserName(), ((JRAdhocTaskInfo)adhocTaskInfo).getTaskStatusIntValue(), adhocTaskInfo.getRunHost(), adhocTaskInfo.getRunPort(), adhocTaskInfo.getStartedTime(), adhocTaskInfo.getCompletedTime(), adhocTaskInfo.getReportPages(), adhocTaskInfo.getResultFiles(), adhocTaskInfo.getReason(), adhocTaskInfo.getFailedInfo());
    }

    @Override
    public String getTaskID() {
        return this.taskID;
    }

    public void setTaskID(String string) {
        this.taskID = string;
    }

    @Override
    public String getReportSet() {
        return this.rptSet;
    }

    public void setReportSet(String string) {
        this.rptSet = string;
    }

    @Override
    public String[] getReports() {
        return this.rptNames == null ? new String[]{} : this.rptNames;
    }

    public void setReports(String[] stringArray) {
        this.rptNames = stringArray == null ? new String[]{} : stringArray;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    @Override
    public String getTaskStatus() {
        boolean bl;
        boolean bl2 = bl = this.taskStatus < 0 || this.taskStatus >= TASK_STATUS_VALUES.length;
        if (bl) {
            ServiceLogger.logEvent(6660026, String.valueOf(this.taskStatus), 6);
            return TASK_STATUS_VALUES[0];
        }
        return TASK_STATUS_VALUES[this.taskStatus];
    }

    public void setTaskStatus(int n) {
        this.taskStatus = n;
    }

    public int getTaskStatusIntValue() {
        return this.taskStatus;
    }

    @Override
    public String getTaskType() {
        return SEDU;
    }

    public void setTaskType(String string) {
        this.taskType = string;
    }

    @Override
    public String getRunHost() {
        return this.runHost;
    }

    public void setRunHost(String string) {
        this.runHost = string;
    }

    @Override
    public int getRunPort() {
        return this.runPort;
    }

    public void setRunPort(int n) {
        this.runPort = n;
    }

    @Override
    public String[] getDSOs() {
        return this.dsoSets;
    }

    public void setDSOs(String[] stringArray) {
        this.dsoSets = stringArray == null ? new String[]{} : stringArray;
    }

    @Override
    public String[] getResultFiles() {
        return this.rstFiles;
    }

    public void setResultFiles(String[] stringArray) {
        this.rstFiles = stringArray;
        this.rstFiles = stringArray == null ? new String[]{} : stringArray;
    }

    @Override
    public int getReportPages() {
        return this.rptPages;
    }

    public void setReportPages(int n) {
        this.rptPages = n;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    public void setReason(String string) {
        this.reason = string;
    }

    @Override
    public long getSubmittedTime() {
        return this.submitTime;
    }

    public void setSubmittedTime(long l) {
        this.submitTime = l;
    }

    @Override
    public long getStartedTime() {
        return this.startTime;
    }

    public void setStartedTime(long l) {
        this.startTime = l;
    }

    @Override
    public long getCompletedTime() {
        return this.completeTime;
    }

    public void setCompletedTime(long l) {
        this.completeTime = l;
    }

    @Override
    public boolean isFailedToRun() {
        return this.failedToRun | (this.reason != null && this.reason.trim().length() != 0) | (this.failedInfo != null && this.failedInfo.trim().length() != 0);
    }

    public void setFailedToRun() {
        this.failedToRun = true;
    }

    @Override
    public String getFailedInfo() {
        return this.failedInfo;
    }

    public void setFailedInfo(String string) {
        this.failedInfo = string;
    }

    public int getTotalPages() {
        int n = 0;
        if (this.rptPages > 0 && this.rstFiles != null) {
            n += this.rstFiles.length * this.rptPages;
        }
        return n;
    }

    public Object clone() {
        return new JRAdhocTaskInfo(this);
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Adhoc Task Info [task ID:").append(this.taskID);
        if (this.rptSet != null) {
            stringBuffer.append(";report set:").append(this.rptSet);
        }
        if (this.rptNames != null && this.rptNames.length > 0) {
            stringBuffer.append(";reports:<");
            for (n = 0; n < this.rptNames.length; ++n) {
                stringBuffer.append(this.rptNames[n]);
                if (n >= this.rptNames.length - 1) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append(">");
        }
        if (this.dsoSets != null && this.dsoSets.length > 0) {
            stringBuffer.append(";dsos:<");
            for (n = 0; n < this.dsoSets.length; ++n) {
                stringBuffer.append(this.dsoSets[n]);
                if (n >= this.dsoSets.length - 1) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append(">");
        }
        stringBuffer.append(";user name:").append(this.userName);
        stringBuffer.append(";task status:").append(this.getTaskStatus());
        stringBuffer.append(";task type:").append(this.taskType);
        if (this.submitTime != -1L) {
            stringBuffer.append(";submit time:").append(new Date(this.submitTime));
        }
        if (this.startTime != -1L) {
            stringBuffer.append(";start time:").append(new Date(this.startTime));
        }
        if (this.runHost != null && this.runPort > 0) {
            stringBuffer.append(";run host:").append(this.runHost);
            stringBuffer.append(";run port:").append(this.runPort);
        }
        if (this.completeTime != -1L) {
            stringBuffer.append(";completed time:").append(new Date(this.completeTime));
        }
        if (this.rstFiles != null && this.rstFiles.length > 0) {
            stringBuffer.append(";result files:<");
            for (n = 0; n < this.rstFiles.length; ++n) {
                stringBuffer.append(this.rstFiles[n]);
                if (n >= this.rstFiles.length - 1) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append(">");
        }
        if (this.rptPages > 0) {
            stringBuffer.append(">;report pages:").append(this.rptPages);
        }
        if (this.reason != null) {
            stringBuffer.append(";reason:").append(this.reason);
        }
        if (this.isFailedToRun() && this.failedInfo != null) {
            stringBuffer.append(";failed info:").append(this.failedInfo);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

