/*
 * Decompiled with CFR 0.152.
 */
package jet.server.monitor.jrmon.task;

import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import jet.server.api.profiling.AuditTaskRecord;
import jet.server.intf.jrs.RemoteMonitorService;
import jet.server.log.ServiceLogger;
import jet.server.monitor.api.MonitorService;
import jet.server.monitor.api.task.TaskInfo;
import jet.server.monitor.api.task.TaskMonitor;
import jet.server.monitor.api.task.TaskStatistic;
import jet.server.monitor.jrmon.JRMonitorService;
import jet.server.monitor.jrmon.MonitorEnv;
import jet.server.monitor.jrmon.task.JRTaskInfo;
import jet.server.monitor.jrmon.task.JRTaskStatistic;
import jet.server.monitor.jrmon.task.TaskMonitorThread;
import jet.server.util.CSVCreater;

public class JRTaskMonitor
implements TaskMonitor {
    private static final String SEDU = "taskID";
    private static final String Task_Type = "rptName";
    private static final String addElement = "taskType";
    private static final String addFailedTask = "taskStatus";
    private static final String addFinishedTask = "serverName";
    private static final String addReportSource = "runHost";
    private static final String addRunningTask = "runPort";
    private static final String addWaitingTask = "submitTime";
    private static final String append = "startTime";
    private static final String clone = "finishTime";
    private static final String close = "rptPages";
    private static final String containsKey = "rptSource";
    private static final String currentTimeMillis = "rstFileName";
    private static final String elementAt = "userName";
    private static final String elements = "reason";
    private static final String equals = "engineInfo";
    public static final String FAILED_INFO = "failedInfo";
    public static final String FIRST_SUBMIT_TIME = "firstSubmitTime";
    public static final String RUN_TIMES_NUMBER = "runTimesNumber";
    public static final String PARAMETER = "parameter";
    private MonitorService equalsIgnoreCase = null;
    private int get = 2000;
    private int getAllAuditTasks = 180000;
    private int getAllFinishedTasks = 50;
    private boolean getAllTaskStatistics = false;
    private Hashtable getCatalogName = new Hashtable();
    private Hashtable getCatalogNames = null;
    private Hashtable getCompleteTime = null;
    private Hashtable getContent = null;
    private Hashtable getDefaultInterval = null;
    private Hashtable getFailReason = null;
    private boolean getFailedAuditTasks = true;
    private int getFinishedAuditTasks = 0;
    private int getFinishedTime = 0;
    private int getFirstSubmittedTime = 0;
    private TaskMonitorThread getMaxNumberSaveReport = null;
    private long getMaxTimeSaveReport = 0L;
    private Hashtable getPageNumber = null;

    public JRTaskMonitor() {
    }

    public JRTaskMonitor(MonitorService monitorService) {
        this(monitorService, monitorService.getDefaultInterval());
    }

    public JRTaskMonitor(MonitorService monitorService, int n) {
        this.equalsIgnoreCase = monitorService;
        this.get = n;
        this.init();
    }

    public void init() {
        this.getCatalogNames = new Hashtable();
        this.getCompleteTime = new Hashtable();
        this.getContent = new Hashtable();
        this.getDefaultInterval = new Hashtable();
        this.getCatalogName = new Hashtable();
        this.getFailReason = new Hashtable();
        this.getFailedAuditTasks = true;
        this.getFinishedAuditTasks = 0;
        this.getFinishedTime = 0;
        this.getFirstSubmittedTime = 0;
        this.SEDU();
    }

    private void SEDU() {
        this.getPageNumber = new Hashtable();
        RemoteMonitorService remoteMonitorService = ((JRMonitorService)this.equalsIgnoreCase).getRemoteMonitorService();
        try {
            Vector vector = remoteMonitorService.getAllTaskStatistics();
            for (int i = 0; i < vector.size(); ++i) {
                Properties properties = (Properties)vector.get(i);
                JRTaskStatistic jRTaskStatistic = new JRTaskStatistic(properties.getProperty(Task_Type), Long.parseLong(properties.getProperty(FIRST_SUBMIT_TIME)), Integer.parseInt(properties.getProperty(RUN_TIMES_NUMBER)));
                jRTaskStatistic.setLastCatalogName(properties.getProperty(containsKey));
                jRTaskStatistic.setLastSubmittedTime(Long.parseLong(properties.getProperty(addWaitingTask)));
                jRTaskStatistic.setLastTaskID(properties.getProperty(SEDU));
                jRTaskStatistic.setLastUser(properties.getProperty(elementAt));
                jRTaskStatistic.setLastPageeNumber(Integer.parseInt(properties.getProperty(close)));
                this.getPageNumber.put(jRTaskStatistic.getReportName(), jRTaskStatistic);
            }
        }
        catch (RemoteException remoteException) {
            ServiceLogger.logError(remoteException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector getAllRunningTasks() {
        Vector vector = new Vector();
        Hashtable hashtable = this.getCompleteTime;
        synchronized (hashtable) {
            Enumeration enumeration = this.getCompleteTime.elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector getRunningTasksByUser(String string) {
        Vector<TaskInfo> vector = new Vector<TaskInfo>();
        TaskInfo taskInfo = null;
        Hashtable hashtable = this.getCompleteTime;
        synchronized (hashtable) {
            Enumeration enumeration = this.getCompleteTime.elements();
            while (enumeration.hasMoreElements()) {
                taskInfo = (TaskInfo)enumeration.nextElement();
                if (!taskInfo.getUserName().equalsIgnoreCase(string)) continue;
                vector.addElement(taskInfo);
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector getAllWaitingTasks() {
        Vector vector = new Vector();
        Hashtable hashtable = this.getCatalogNames;
        synchronized (hashtable) {
            Enumeration enumeration = this.getCatalogNames.elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector getWaitingTasksByUser(String string) {
        Vector<TaskInfo> vector = new Vector<TaskInfo>();
        TaskInfo taskInfo = null;
        Hashtable hashtable = this.getCatalogNames;
        synchronized (hashtable) {
            Enumeration enumeration = this.getCatalogNames.elements();
            while (enumeration.hasMoreElements()) {
                taskInfo = (TaskInfo)enumeration.nextElement();
                if (!taskInfo.getUserName().equalsIgnoreCase(string)) continue;
                vector.addElement(taskInfo);
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector getAllFinishedTasks() {
        Vector<TaskInfo> vector = new Vector<TaskInfo>();
        TaskInfo taskInfo = null;
        Hashtable hashtable = this.getContent;
        synchronized (hashtable) {
            Enumeration enumeration = this.getContent.elements();
            while (enumeration.hasMoreElements()) {
                taskInfo = (TaskInfo)enumeration.nextElement();
                vector.addElement(taskInfo);
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector getFinishedTasksByUser(String string) {
        Vector<TaskInfo> vector = new Vector<TaskInfo>();
        TaskInfo taskInfo = null;
        Hashtable hashtable = this.getContent;
        synchronized (hashtable) {
            Enumeration enumeration = this.getContent.elements();
            while (enumeration.hasMoreElements()) {
                taskInfo = (TaskInfo)enumeration.nextElement();
                if (!taskInfo.getUserName().equalsIgnoreCase(string)) continue;
                vector.addElement(taskInfo);
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector getAllFinishedTasks(int n) {
        Vector<TaskInfo> vector = new Vector<TaskInfo>();
        TaskInfo taskInfo = null;
        Hashtable hashtable = this.getContent;
        synchronized (hashtable) {
            Enumeration enumeration = this.getContent.elements();
            while (enumeration.hasMoreElements()) {
                taskInfo = (TaskInfo)enumeration.nextElement();
                if (System.currentTimeMillis() - taskInfo.getFinishedTime() >= (long)(n * 60 * 1000)) continue;
                vector.addElement(taskInfo);
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector getFinishedTasksByUser(String string, int n) {
        Vector<TaskInfo> vector = new Vector<TaskInfo>();
        TaskInfo taskInfo = null;
        Hashtable hashtable = this.getContent;
        synchronized (hashtable) {
            Enumeration enumeration = this.getContent.elements();
            while (enumeration.hasMoreElements()) {
                taskInfo = (TaskInfo)enumeration.nextElement();
                if (!taskInfo.getUserName().equalsIgnoreCase(string) || System.currentTimeMillis() - taskInfo.getFinishedTime() >= (long)(n * 60 * 1000)) continue;
                vector.addElement(taskInfo);
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector getAllFailedTasks() {
        Vector vector = new Vector();
        Hashtable hashtable = this.getDefaultInterval;
        synchronized (hashtable) {
            Enumeration enumeration = this.getDefaultInterval.elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector getFailedTasksByUser(String string) {
        Vector<TaskInfo> vector = new Vector<TaskInfo>();
        TaskInfo taskInfo = null;
        Hashtable hashtable = this.getDefaultInterval;
        synchronized (hashtable) {
            Enumeration enumeration = this.getDefaultInterval.elements();
            while (enumeration.hasMoreElements()) {
                taskInfo = (TaskInfo)enumeration.nextElement();
                if (!taskInfo.getUserName().equalsIgnoreCase(string)) continue;
                vector.addElement(taskInfo);
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWaitingTask(TaskInfo taskInfo) {
        this.getCatalogNames.put(taskInfo.getTaskID(), taskInfo);
        if (null != taskInfo.getReportName()) {
            JRTaskStatistic jRTaskStatistic = null;
            Hashtable hashtable = this.getPageNumber;
            synchronized (hashtable) {
                jRTaskStatistic = (JRTaskStatistic)this.getPageNumber.get(taskInfo.getReportName());
                if (jRTaskStatistic == null) {
                    jRTaskStatistic = new JRTaskStatistic(taskInfo.getReportName(), taskInfo.getSubmittedTime(), 0);
                    this.getPageNumber.put(jRTaskStatistic.getReportName(), jRTaskStatistic);
                }
            }
            jRTaskStatistic.setLastUser(taskInfo.getUserName());
            jRTaskStatistic.setLastSubmittedTime(taskInfo.getSubmittedTime());
            jRTaskStatistic.setLastCatalogName(taskInfo.getReportSource());
            jRTaskStatistic.setLastTaskID(taskInfo.getTaskID());
            jRTaskStatistic.runOnce();
        }
    }

    public void addRunningTask(TaskInfo taskInfo) {
        this.getCatalogNames.remove(taskInfo.getTaskID());
        this.getCompleteTime.put(taskInfo.getTaskID(), taskInfo);
    }

    public void addFinishedTask(TaskInfo taskInfo) {
        this.getCompleteTime.remove(taskInfo.getTaskID());
        this.getContent.put(taskInfo.getTaskID(), taskInfo);
        if (this.getFailedAuditTasks) {
            this.getFinishedAuditTasks = (int)((long)this.getFinishedAuditTasks + (taskInfo.getFinishedTime() - taskInfo.getStartedTime()));
            this.getFinishedTime = (int)((long)this.getFinishedTime + (taskInfo.getStartedTime() - taskInfo.getSubmittedTime()));
            ++this.getFirstSubmittedTime;
        }
        String string = taskInfo.getUserName();
        int n = 0;
        if (this.getCatalogName.get(string) != null) {
            n = (Integer)this.getCatalogName.get(string);
        }
        this.getCatalogName.put(string, new Integer(++n));
        String string2 = taskInfo.getReportName();
        if (null != string2) {
            JRTaskStatistic jRTaskStatistic = (JRTaskStatistic)this.getPageNumber.get(string2);
            jRTaskStatistic.setLastPageeNumber(taskInfo.getReportPages());
        }
    }

    public void addFailedTask(TaskInfo taskInfo) {
        this.getCatalogNames.remove(taskInfo.getTaskID());
        this.getCompleteTime.remove(taskInfo.getTaskID());
        this.getContent.remove(taskInfo.getTaskID());
        this.getDefaultInterval.put(taskInfo.getTaskID(), taskInfo);
        JRTaskStatistic jRTaskStatistic = (JRTaskStatistic)this.getPageNumber.get(taskInfo.getReportName());
        jRTaskStatistic.setLastPageeNumber(taskInfo.getReportPages());
    }

    private int Task_Type(Hashtable hashtable, String string) {
        int n = 0;
        if (hashtable.containsKey(string)) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                if (!((String)enumeration.nextElement()).startsWith(string)) continue;
                ++n;
            }
        }
        return n;
    }

    private String addElement(String string) {
        int n;
        String string2 = null;
        int n2 = this.Task_Type(this.getCatalogNames, string);
        if (n2 < (n = this.Task_Type(this.getCompleteTime, string))) {
            n2 = n;
        }
        if (n2 < (n = this.Task_Type(this.getContent, string))) {
            n2 = n;
        }
        if (n2 == 0) {
            string2 = string;
            if (this.getFailReason.get(string) != null) {
                this.getFailReason.remove(string);
            }
        } else {
            if (this.getFailReason.get(string) != null) {
                n2 = (Integer)this.getFailReason.get(string) + 1;
            }
            string2 = string + "_uid_" + n2;
            this.getFailReason.put(string, new Integer(n2));
        }
        return string2;
    }

    private TaskInfo addFailedTask(Hashtable hashtable, String string) {
        TaskInfo taskInfo = null;
        if (this.getFailReason.containsKey(string)) {
            int n = (Integer)this.getFailReason.get(string);
            for (int i = 1; i <= n && (taskInfo = (TaskInfo)hashtable.get(string + "_uid_" + i)) == null; ++i) {
            }
        }
        return taskInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(int n, Properties properties) {
        TaskInfo taskInfo = null;
        ServiceLogger.logDebug("type=" + n + ",taskID=" + properties.getProperty(SEDU), 6);
        switch (n) {
            case 0: {
                taskInfo = (TaskInfo)this.getCatalogNames.get(properties.getProperty(SEDU));
                int n2 = Integer.parseInt(properties.getProperty(addFailedTask));
                Map map = (Map)properties.get(PARAMETER);
                if (taskInfo == null && n2 == 3) {
                    return;
                }
                if (taskInfo == null || n2 == 1 || n2 == 2) {
                    taskInfo = new JRTaskInfo(properties.getProperty(SEDU), properties.getProperty(Task_Type), Integer.parseInt(properties.getProperty(addElement)), properties.getProperty(addFinishedTask), Long.parseLong(properties.getProperty(addWaitingTask)), properties.getProperty(containsKey), properties.getProperty(elementAt));
                    if (Integer.parseInt(properties.getProperty(addElement)) == 2) {
                        ((JRTaskInfo)taskInfo).setTaskID(this.addElement(properties.getProperty(SEDU)));
                    }
                    long l = Long.parseLong(properties.getProperty(addWaitingTask)) + this.getMaxTimeSaveReport;
                    ((JRTaskInfo)taskInfo).setSubmittedTime(l);
                    ((JRTaskInfo)taskInfo).setParameters(map);
                    this.addWaitingTask(taskInfo);
                }
                ((JRTaskInfo)taskInfo).setTaskStatus(n2);
                break;
            }
            case 1: {
                String string = properties.getProperty(SEDU);
                int n3 = Integer.parseInt(properties.getProperty(addFailedTask));
                if (n3 == 5 || n3 == 4) {
                    taskInfo = (TaskInfo)this.getCatalogNames.get(string);
                    if (taskInfo == null) {
                        taskInfo = this.addFailedTask(this.getCatalogNames, string);
                    }
                    if (taskInfo == null) break;
                    ((JRTaskInfo)taskInfo).setRunHost(properties.getProperty(addReportSource));
                    try {
                        ((JRTaskInfo)taskInfo).setRunPort(Integer.parseInt(properties.getProperty(addRunningTask)));
                    }
                    catch (NumberFormatException numberFormatException) {
                        ((JRTaskInfo)taskInfo).setRunPort(-1);
                    }
                    long l = Long.parseLong(properties.getProperty(append)) + this.getMaxTimeSaveReport;
                    ((JRTaskInfo)taskInfo).setStartedTime(l);
                    ((JRTaskInfo)taskInfo).setTaskStatus(n3);
                    this.addRunningTask(taskInfo);
                    break;
                }
                taskInfo = (TaskInfo)this.getCompleteTime.get(string);
                if (taskInfo == null) {
                    taskInfo = this.addFailedTask(this.getCompleteTime, string);
                }
                if (taskInfo == null) break;
                ((JRTaskInfo)taskInfo).setTaskStatus(n3);
                break;
            }
            case 2: {
                String string = properties.getProperty(SEDU);
                taskInfo = (TaskInfo)this.getCompleteTime.get(string);
                if (taskInfo == null) {
                    taskInfo = this.addFailedTask(this.getCompleteTime, string);
                }
                if (taskInfo == null) break;
                long l = Long.parseLong(properties.getProperty(clone)) + this.getMaxTimeSaveReport;
                ((JRTaskInfo)taskInfo).setFinishedTime(l);
                int n4 = 0;
                try {
                    n4 = Integer.parseInt(properties.getProperty(close));
                }
                catch (NumberFormatException numberFormatException) {
                    n4 = -1;
                }
                if (n4 < 0) {
                    ServiceLogger.logEvent(6660023, String.valueOf(n4), 6);
                    n4 = 0;
                }
                ((JRTaskInfo)taskInfo).setReportPages(n4);
                ((JRTaskInfo)taskInfo).setResultFileName(properties.getProperty(currentTimeMillis));
                ((JRTaskInfo)taskInfo).setReason(properties.getProperty(elements));
                ((JRTaskInfo)taskInfo).setEngineInfo(properties.getProperty(equals));
                ((JRTaskInfo)taskInfo).setTaskStatus(Integer.parseInt(properties.getProperty(addFailedTask)));
                this.addFinishedTask(taskInfo);
                break;
            }
            case 3: {
                String string = properties.getProperty(SEDU);
                taskInfo = (TaskInfo)this.getContent.get(string);
                if (taskInfo == null && (taskInfo = (TaskInfo)this.getCompleteTime.get(string)) == null && (taskInfo = (TaskInfo)this.getCatalogNames.get(string)) == null && (taskInfo = this.addFailedTask(this.getCatalogNames, string)) == null && (taskInfo = this.addFailedTask(this.getCompleteTime, string)) == null) {
                    taskInfo = this.addFailedTask(this.getContent, string);
                }
                if (taskInfo == null) break;
                ((JRTaskInfo)taskInfo).setFailedInfo(properties.getProperty(FAILED_INFO));
                ((JRTaskInfo)taskInfo).setTaskStatus(Integer.parseInt(properties.getProperty(addFailedTask)));
                ((JRTaskInfo)taskInfo).setFailedToRun();
                this.addFailedTask(taskInfo);
                break;
            }
            case 5: {
                String string = properties.getProperty(SEDU);
                taskInfo = (TaskInfo)this.getCatalogNames.get(string);
                if (taskInfo == null && (taskInfo = this.addFailedTask(this.getCatalogNames, string)) == null && (taskInfo = (TaskInfo)this.getContent.get(string)) == null && (taskInfo = this.addFailedTask(this.getContent, string)) == null && (taskInfo = (TaskInfo)this.getCompleteTime.get(string)) == null) {
                    taskInfo = this.addFailedTask(this.getCompleteTime, string);
                }
                String string2 = properties.getProperty(Task_Type);
                if (taskInfo == null || null == string2 || 0 == string2.length()) break;
                String string3 = ((JRTaskInfo)taskInfo).getReportName();
                ((JRTaskInfo)taskInfo).setReportName(string2);
                JRTaskStatistic jRTaskStatistic = null;
                JRTaskStatistic jRTaskStatistic2 = null;
                Hashtable hashtable = this.getPageNumber;
                synchronized (hashtable) {
                    if (null != string3) {
                        jRTaskStatistic2 = (JRTaskStatistic)this.getPageNumber.get(string3);
                    }
                    jRTaskStatistic = null == jRTaskStatistic2 ? (null == (jRTaskStatistic2 = (JRTaskStatistic)this.getPageNumber.get(string2)) ? new JRTaskStatistic(taskInfo.getReportName(), taskInfo.getSubmittedTime(), 0) : new JRTaskStatistic(taskInfo.getReportName(), jRTaskStatistic2.getFirstSubmittedTime(), jRTaskStatistic2.getRunTimesNumber())) : new JRTaskStatistic(taskInfo.getReportName(), jRTaskStatistic2.getFirstSubmittedTime(), jRTaskStatistic2.getRunTimesNumber() - 1);
                    this.getPageNumber.put(jRTaskStatistic.getReportName(), jRTaskStatistic);
                }
                jRTaskStatistic.setLastUser(taskInfo.getUserName());
                jRTaskStatistic.setLastSubmittedTime(taskInfo.getSubmittedTime());
                jRTaskStatistic.setLastCatalogName(taskInfo.getReportSource());
                jRTaskStatistic.setLastTaskID(taskInfo.getTaskID());
                jRTaskStatistic.runOnce();
                break;
            }
            case 6: {
                String string = properties.getProperty(SEDU);
                taskInfo = (TaskInfo)this.getCatalogNames.get(string);
                if (taskInfo == null && (taskInfo = this.addFailedTask(this.getCatalogNames, string)) == null && (taskInfo = (TaskInfo)this.getContent.get(string)) == null && (taskInfo = this.addFailedTask(this.getContent, string)) == null && (taskInfo = (TaskInfo)this.getCompleteTime.get(string)) == null) {
                    taskInfo = this.addFailedTask(this.getCompleteTime, string);
                }
                String string4 = properties.getProperty(containsKey);
                if (taskInfo == null || null == string4 || 0 == string4.length()) break;
                ((JRTaskInfo)taskInfo).setReportSource(string4);
                JRTaskStatistic jRTaskStatistic = null;
                String string5 = taskInfo.getReportName();
                if (null == string5) break;
                Hashtable hashtable = this.getPageNumber;
                synchronized (hashtable) {
                    jRTaskStatistic = (JRTaskStatistic)this.getPageNumber.get(string5);
                }
                if (null == jRTaskStatistic) break;
                jRTaskStatistic.setLastCatalogName(taskInfo.getReportSource());
                break;
            }
            case 7: {
                String string = properties.getProperty(SEDU);
                taskInfo = (TaskInfo)this.getCatalogNames.get(string);
                if (taskInfo == null && (taskInfo = this.addFailedTask(this.getCatalogNames, string)) == null && (taskInfo = (TaskInfo)this.getContent.get(string)) == null && (taskInfo = this.addFailedTask(this.getContent, string)) == null && (taskInfo = (TaskInfo)this.getCompleteTime.get(string)) == null) {
                    taskInfo = this.addFailedTask(this.getCompleteTime, string);
                }
                String string6 = properties.getProperty(containsKey);
                if (taskInfo == null || null == string6 || 0 == string6.length()) break;
                ((JRTaskInfo)taskInfo).addReportSource(string6);
                break;
            }
            case 8: {
                String string = properties.getProperty(SEDU);
                taskInfo = (TaskInfo)this.getCatalogNames.get(string);
                if (taskInfo == null && (taskInfo = this.addFailedTask(this.getCatalogNames, string)) == null && (taskInfo = (TaskInfo)this.getCompleteTime.get(string)) == null) {
                    taskInfo = this.addFailedTask(this.getCompleteTime, string);
                }
                if (taskInfo == null) break;
                Map map = (Map)properties.get(PARAMETER);
                ((JRTaskInfo)taskInfo).setParameters(map);
                break;
            }
            case 9: {
                String string = properties.getProperty(SEDU);
                taskInfo = (TaskInfo)this.getContent.get(string);
                if (taskInfo == null && (taskInfo = (TaskInfo)this.getCompleteTime.get(string)) == null && (taskInfo = (TaskInfo)this.getCatalogNames.get(string)) == null && (taskInfo = this.addFailedTask(this.getContent, string)) == null && (taskInfo = this.addFailedTask(this.getCompleteTime, string)) == null) {
                    taskInfo = this.addFailedTask(this.getCatalogNames, string);
                }
                if (taskInfo == null) break;
                JRTaskInfo jRTaskInfo = (JRTaskInfo)((JRTaskInfo)taskInfo).clone();
                int n5 = ((JRTaskInfo)taskInfo).getTaskStatusIntValue();
                switch (n5) {
                    case 1: {
                        ((JRTaskInfo)taskInfo).setTaskStatus(9);
                        this.addFinishedTask(taskInfo);
                        break;
                    }
                    case 4: {
                        ((JRTaskInfo)taskInfo).setTaskStatus(9);
                        this.addFinishedTask(taskInfo);
                        break;
                    }
                    case 10: {
                        break;
                    }
                    case 9: {
                        break;
                    }
                }
                jRTaskInfo.setParameters((Map)properties.get(PARAMETER));
                jRTaskInfo.setTaskID(this.addElement(jRTaskInfo.getTaskID()));
                this.addWaitingTask(jRTaskInfo);
                break;
            }
            default: {
                ServiceLogger.logEvent(6660024, String.valueOf(n), 6);
            }
        }
    }

    @Override
    public TaskInfo getTask(String string) {
        TaskInfo taskInfo = null;
        taskInfo = this.getCatalogNames.get(string) != null ? (TaskInfo)this.getCatalogNames.get(string) : (this.getCompleteTime.get(string) != null ? (TaskInfo)this.getCompleteTime.get(string) : (TaskInfo)this.getContent.get(string));
        return taskInfo;
    }

    @Override
    public void stopTask(TaskInfo taskInfo) {
        if (taskInfo != null) {
            String string = taskInfo.getTaskID();
            int n = string.indexOf("_uid_");
            if (n != -1) {
                string = string.substring(0, n);
            }
            try {
                ((JRMonitorService)this.equalsIgnoreCase).getRemoteMonitorService().stopTask(string, taskInfo.getTaskType().equals(JRTaskInfo.Task_Type[1]) ? 1 : 2);
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        } else {
            ServiceLogger.logEvent(6660025, 6);
        }
    }

    @Override
    public void killTask(TaskInfo taskInfo) {
        if (taskInfo != null) {
            String string = taskInfo.getTaskID();
            int n = string.indexOf("_uid_");
            if (n != -1) {
                string = string.substring(0, n);
            }
            ServiceLogger.logDebug(4660223, string, 4);
            try {
                ((JRMonitorService)this.equalsIgnoreCase).getRemoteMonitorService().killTask(string, taskInfo.getTaskType().equals(JRTaskInfo.Task_Type[1]) ? 1 : 2);
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
            }
        } else {
            ServiceLogger.logEvent(6660025, 6);
        }
    }

    public int getWaitingRptNums() {
        return this.getCatalogNames.size();
    }

    public int getRunningRptNums() {
        return this.getCompleteTime.size();
    }

    public int getFinishedRptNums() {
        return this.getAllFinishedTasks().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFinishedRptPages() {
        int n = 0;
        TaskInfo taskInfo = null;
        Hashtable hashtable = this.getContent;
        synchronized (hashtable) {
            Vector vector = this.getAllFinishedTasks();
            int n2 = vector.size();
            for (int i = 0; i < n2; ++i) {
                taskInfo = (TaskInfo)vector.elementAt(i);
                n += ((JRTaskInfo)taskInfo).getTotalPages();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFinishedRptNums(int n) {
        int n2 = 0;
        TaskInfo taskInfo = null;
        Hashtable hashtable = this.getContent;
        synchronized (hashtable) {
            Enumeration enumeration = this.getContent.elements();
            while (enumeration.hasMoreElements()) {
                taskInfo = (TaskInfo)enumeration.nextElement();
                if (System.currentTimeMillis() - taskInfo.getFinishedTime() >= (long)(n * 60 * 1000)) continue;
                ++n2;
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFinishedRptPages(int n) {
        int n2 = 0;
        TaskInfo taskInfo = null;
        Hashtable hashtable = this.getContent;
        synchronized (hashtable) {
            Enumeration enumeration = this.getContent.elements();
            while (enumeration.hasMoreElements()) {
                taskInfo = (TaskInfo)enumeration.nextElement();
                if (System.currentTimeMillis() - taskInfo.getFinishedTime() >= (long)(n * 60 * 1000)) continue;
                n2 += ((JRTaskInfo)taskInfo).getTotalPages();
            }
        }
        return n2;
    }

    public int getAvgProcessTimeByRpt() {
        if (this.getFirstSubmittedTime != 0) {
            return this.getFinishedAuditTasks / this.getFirstSubmittedTime;
        }
        return 0;
    }

    public int getAvgWaitTimeByRpt() {
        if (this.getFirstSubmittedTime != 0) {
            return this.getFinishedTime / this.getFirstSubmittedTime;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAvgSubmitRptNumsByUser() {
        int n = 0;
        int n2 = 0;
        Hashtable hashtable = this.getCatalogName;
        synchronized (hashtable) {
            Enumeration enumeration = this.getCatalogName.keys();
            while (enumeration.hasMoreElements()) {
                n += ((Integer)this.getCatalogName.get((String)enumeration.nextElement())).intValue();
                ++n2;
            }
        }
        if (n2 != 0) {
            return n / n2;
        }
        return 0;
    }

    public int getRptNumsSubmittedByUser(String string) {
        return (Integer)this.getCatalogName.get(string);
    }

    @Override
    public void setInterval(int n) {
        this.get = n;
    }

    @Override
    public int getInterval() {
        return this.get;
    }

    @Override
    public void setDuration(int n) {
        this.getAllAuditTasks = n;
    }

    @Override
    public int getDuration() {
        return this.getAllAuditTasks;
    }

    @Override
    public void start() {
        int n = 0;
        this.getMaxTimeSaveReport = 0L;
        while (this.getMaxTimeSaveReport == 0L && n++ < 5) {
            try {
                this.getMaxTimeSaveReport = ((JRMonitorService)this.equalsIgnoreCase).getRemoteMonitorService().getServerCurrentTime();
            }
            catch (RemoteException remoteException) {
                this.getMaxTimeSaveReport = 0L;
            }
        }
        this.getMaxTimeSaveReport = this.getMaxTimeSaveReport == 0L ? 0L : System.currentTimeMillis() - this.getMaxTimeSaveReport;
        this.getMaxNumberSaveReport = new TaskMonitorThread(this);
        this.getMaxNumberSaveReport.start();
        this.getAllTaskStatistics = true;
    }

    @Override
    public void restart() {
        this.getMaxNumberSaveReport.stopRun();
        this.init();
        this.start();
    }

    @Override
    public void stop() {
        this.getMaxNumberSaveReport.stopRun();
        this.getAllTaskStatistics = false;
    }

    @Override
    public boolean isStarted() {
        return this.getAllTaskStatistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update() {
        Object object;
        String string;
        this.getAllAuditTasks = MonitorEnv.getMaxTimeSaveReport() * 60 * 1000;
        this.getAllFinishedTasks = MonitorEnv.getMaxNumberSaveReport();
        if (this.getAllAuditTasks == 0 && this.getAllFinishedTasks == 0) {
            return;
        }
        if (this.getAllAuditTasks > 0) {
            string = null;
            object = null;
            Hashtable hashtable = this.getContent;
            synchronized (hashtable) {
                Enumeration enumeration = this.getContent.keys();
                while (enumeration.hasMoreElements()) {
                    string = (String)enumeration.nextElement();
                    object = (TaskInfo)this.getContent.get(string);
                    if (System.currentTimeMillis() - object.getFinishedTime() <= (long)this.getAllAuditTasks) continue;
                    this.getContent.remove(string);
                }
            }
        }
        if (this.getAllFinishedTasks > 0) {
            string = null;
            object = this.getContent;
            synchronized (object) {
                while (this.getContent.size() > this.getAllFinishedTasks) {
                    string = this.addFinishedTask();
                    this.getContent.remove(string);
                }
            }
        }
    }

    private String addFinishedTask() {
        String string = null;
        String string2 = "";
        TaskInfo taskInfo = null;
        long l = System.currentTimeMillis();
        Enumeration enumeration = this.getContent.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            taskInfo = (TaskInfo)this.getContent.get(string);
            if (taskInfo.getFinishedTime() >= l) continue;
            l = taskInfo.getFinishedTime();
            string2 = string;
        }
        return string2;
    }

    public MonitorService getMonitorService() {
        return this.equalsIgnoreCase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector getAllTaskStatistics() {
        Vector vector = new Vector();
        Hashtable hashtable = this.getPageNumber;
        synchronized (hashtable) {
            Enumeration enumeration = this.getPageNumber.elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
        }
        return vector;
    }

    @Override
    public TaskStatistic getTaskStatistic(String string) {
        return (TaskStatistic)this.getPageNumber.get(string);
    }

    public TaskInfo getTaskInfo(String string) {
        TaskInfo taskInfo = null;
        taskInfo = (TaskInfo)this.getContent.get(string);
        if (taskInfo == null && (taskInfo = (TaskInfo)this.getCompleteTime.get(string)) == null && (taskInfo = (TaskInfo)this.getCatalogNames.get(string)) == null && null == (taskInfo = (TaskInfo)this.getDefaultInterval.get(string)) && (taskInfo = this.addFailedTask(this.getContent, string)) == null && (taskInfo = this.addFailedTask(this.getCompleteTime, string)) == null && null == (taskInfo = this.addFailedTask(this.getCatalogNames, string))) {
            taskInfo = this.addFailedTask(this.getDefaultInterval, string);
        }
        return taskInfo;
    }

    public String exportAllTasks() {
        CSVCreater cSVCreater = null;
        try {
            cSVCreater = new CSVCreater();
            cSVCreater.setConvertFlag(true);
            List list = ((JRMonitorService)this.equalsIgnoreCase).getRemoteMonitorService().getAllAuditTasks();
            for (int i = 0; i < list.size(); ++i) {
                AuditTaskRecord auditTaskRecord = (AuditTaskRecord)list.get(i);
                JRTaskInfo jRTaskInfo = new JRTaskInfo(auditTaskRecord.getTaskID(), auditTaskRecord.getReportName(), auditTaskRecord.getTaskType(), "", "", -1, auditTaskRecord.getSubmitTime(), auditTaskRecord.getStartTime(), auditTaskRecord.getCompleteTime(), auditTaskRecord.getPageNumber(), auditTaskRecord.getCatalogName(), "", auditTaskRecord.getUserName(), "", "", auditTaskRecord.getTaskStatus(), auditTaskRecord.getFailReason(), auditTaskRecord.getCatalogNames(), auditTaskRecord.getParameters());
                cSVCreater.writeTaskInfo(jRTaskInfo);
            }
            cSVCreater.close();
            return cSVCreater.getContent();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            return null;
        }
    }

    public String exportAllTasks(long l, long l2) {
        CSVCreater cSVCreater = null;
        try {
            cSVCreater = new CSVCreater();
            cSVCreater.setConvertFlag(true);
            List list = ((JRMonitorService)this.equalsIgnoreCase).getRemoteMonitorService().getAllAuditTasks(l, l2);
            for (int i = 0; i < list.size(); ++i) {
                AuditTaskRecord auditTaskRecord = (AuditTaskRecord)list.get(i);
                JRTaskInfo jRTaskInfo = new JRTaskInfo(auditTaskRecord.getTaskID(), auditTaskRecord.getReportName(), auditTaskRecord.getTaskType(), "", "", -1, auditTaskRecord.getSubmitTime(), auditTaskRecord.getStartTime(), auditTaskRecord.getCompleteTime(), auditTaskRecord.getPageNumber(), auditTaskRecord.getCatalogName(), "", auditTaskRecord.getUserName(), "", "", auditTaskRecord.getTaskStatus(), auditTaskRecord.getFailReason(), auditTaskRecord.getCatalogNames(), auditTaskRecord.getParameters());
                cSVCreater.writeTaskInfo(jRTaskInfo);
            }
            cSVCreater.close();
            return cSVCreater.getContent();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            return null;
        }
    }

    public String exportWaitingTasks() {
        CSVCreater cSVCreater = null;
        try {
            cSVCreater = new CSVCreater();
            cSVCreater.setConvertFlag(true);
            List list = ((JRMonitorService)this.equalsIgnoreCase).getRemoteMonitorService().getWaitingAuditTasks();
            for (int i = 0; i < list.size(); ++i) {
                AuditTaskRecord auditTaskRecord = (AuditTaskRecord)list.get(i);
                JRTaskInfo jRTaskInfo = new JRTaskInfo(auditTaskRecord.getTaskID(), auditTaskRecord.getReportName(), auditTaskRecord.getTaskType(), "", "", -1, auditTaskRecord.getSubmitTime(), auditTaskRecord.getStartTime(), auditTaskRecord.getCompleteTime(), auditTaskRecord.getPageNumber(), auditTaskRecord.getCatalogName(), "", auditTaskRecord.getUserName(), "", "", auditTaskRecord.getTaskStatus(), auditTaskRecord.getFailReason(), auditTaskRecord.getCatalogNames(), auditTaskRecord.getParameters());
                cSVCreater.writeTaskInfo(jRTaskInfo);
            }
            cSVCreater.close();
            return cSVCreater.getContent();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            return null;
        }
    }

    public String exportWaitingTasks(long l, long l2) {
        CSVCreater cSVCreater = null;
        try {
            cSVCreater = new CSVCreater();
            cSVCreater.setConvertFlag(true);
            List list = ((JRMonitorService)this.equalsIgnoreCase).getRemoteMonitorService().getWaitingAuditTasks(l, l2);
            for (int i = 0; i < list.size(); ++i) {
                AuditTaskRecord auditTaskRecord = (AuditTaskRecord)list.get(i);
                JRTaskInfo jRTaskInfo = new JRTaskInfo(auditTaskRecord.getTaskID(), auditTaskRecord.getReportName(), auditTaskRecord.getTaskType(), "", "", -1, auditTaskRecord.getSubmitTime(), auditTaskRecord.getStartTime(), auditTaskRecord.getCompleteTime(), auditTaskRecord.getPageNumber(), auditTaskRecord.getCatalogName(), "", auditTaskRecord.getUserName(), "", "", auditTaskRecord.getTaskStatus(), auditTaskRecord.getFailReason(), auditTaskRecord.getCatalogNames(), auditTaskRecord.getParameters());
                cSVCreater.writeTaskInfo(jRTaskInfo);
            }
            cSVCreater.close();
            return cSVCreater.getContent();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            return null;
        }
    }

    public String exportRunningTasks() {
        CSVCreater cSVCreater = null;
        try {
            cSVCreater = new CSVCreater();
            cSVCreater.setConvertFlag(true);
            List list = ((JRMonitorService)this.equalsIgnoreCase).getRemoteMonitorService().getRunningAuditTasks();
            for (int i = 0; i < list.size(); ++i) {
                AuditTaskRecord auditTaskRecord = (AuditTaskRecord)list.get(i);
                JRTaskInfo jRTaskInfo = new JRTaskInfo(auditTaskRecord.getTaskID(), auditTaskRecord.getReportName(), auditTaskRecord.getTaskType(), "", "", -1, auditTaskRecord.getSubmitTime(), auditTaskRecord.getStartTime(), auditTaskRecord.getCompleteTime(), auditTaskRecord.getPageNumber(), auditTaskRecord.getCatalogName(), "", auditTaskRecord.getUserName(), "", "", auditTaskRecord.getTaskStatus(), auditTaskRecord.getFailReason(), auditTaskRecord.getCatalogNames(), auditTaskRecord.getParameters());
                cSVCreater.writeTaskInfo(jRTaskInfo);
            }
            cSVCreater.close();
            return cSVCreater.getContent();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            return null;
        }
    }

    public String exportRunningTasks(long l, long l2) {
        CSVCreater cSVCreater = null;
        try {
            cSVCreater = new CSVCreater();
            cSVCreater.setConvertFlag(true);
            List list = ((JRMonitorService)this.equalsIgnoreCase).getRemoteMonitorService().getRunningAuditTasks(l, l2);
            for (int i = 0; i < list.size(); ++i) {
                AuditTaskRecord auditTaskRecord = (AuditTaskRecord)list.get(i);
                JRTaskInfo jRTaskInfo = new JRTaskInfo(auditTaskRecord.getTaskID(), auditTaskRecord.getReportName(), auditTaskRecord.getTaskType(), "", "", -1, auditTaskRecord.getSubmitTime(), auditTaskRecord.getStartTime(), auditTaskRecord.getCompleteTime(), auditTaskRecord.getPageNumber(), auditTaskRecord.getCatalogName(), "", auditTaskRecord.getUserName(), "", "", auditTaskRecord.getTaskStatus(), auditTaskRecord.getFailReason(), auditTaskRecord.getCatalogNames(), auditTaskRecord.getParameters());
                cSVCreater.writeTaskInfo(jRTaskInfo);
            }
            cSVCreater.close();
            return cSVCreater.getContent();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            return null;
        }
    }

    public String exportFinishedTasks() {
        CSVCreater cSVCreater = null;
        try {
            cSVCreater = new CSVCreater();
            cSVCreater.setConvertFlag(true);
            List list = ((JRMonitorService)this.equalsIgnoreCase).getRemoteMonitorService().getFinishedAuditTasks();
            for (int i = 0; i < list.size(); ++i) {
                AuditTaskRecord auditTaskRecord = (AuditTaskRecord)list.get(i);
                JRTaskInfo jRTaskInfo = new JRTaskInfo(auditTaskRecord.getTaskID(), auditTaskRecord.getReportName(), auditTaskRecord.getTaskType(), "", "", -1, auditTaskRecord.getSubmitTime(), auditTaskRecord.getStartTime(), auditTaskRecord.getCompleteTime(), auditTaskRecord.getPageNumber(), auditTaskRecord.getCatalogName(), "", auditTaskRecord.getUserName(), "", "", auditTaskRecord.getTaskStatus(), auditTaskRecord.getFailReason(), auditTaskRecord.getCatalogNames(), auditTaskRecord.getParameters());
                cSVCreater.writeTaskInfo(jRTaskInfo);
            }
            cSVCreater.close();
            return cSVCreater.getContent();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            return null;
        }
    }

    public String exportFinishedTasks(long l, long l2) {
        CSVCreater cSVCreater = null;
        try {
            List list = ((JRMonitorService)this.equalsIgnoreCase).getRemoteMonitorService().getFinishedAuditTasks(l, l2);
            cSVCreater = new CSVCreater();
            cSVCreater.setConvertFlag(true);
            for (int i = 0; i < list.size(); ++i) {
                AuditTaskRecord auditTaskRecord = (AuditTaskRecord)list.get(i);
                JRTaskInfo jRTaskInfo = new JRTaskInfo(auditTaskRecord.getTaskID(), auditTaskRecord.getReportName(), auditTaskRecord.getTaskType(), "", "", -1, auditTaskRecord.getSubmitTime(), auditTaskRecord.getStartTime(), auditTaskRecord.getCompleteTime(), auditTaskRecord.getPageNumber(), auditTaskRecord.getCatalogName(), "", auditTaskRecord.getUserName(), "", "", auditTaskRecord.getTaskStatus(), auditTaskRecord.getFailReason(), auditTaskRecord.getCatalogNames(), auditTaskRecord.getParameters());
                cSVCreater.writeTaskInfo(jRTaskInfo);
            }
            cSVCreater.close();
            return cSVCreater.getContent();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            return null;
        }
    }

    public String exportFailedTasks() {
        CSVCreater cSVCreater = null;
        try {
            cSVCreater = new CSVCreater();
            cSVCreater.setConvertFlag(true);
            List list = ((JRMonitorService)this.equalsIgnoreCase).getRemoteMonitorService().getFailedAuditTasks();
            for (int i = 0; i < list.size(); ++i) {
                AuditTaskRecord auditTaskRecord = (AuditTaskRecord)list.get(i);
                JRTaskInfo jRTaskInfo = new JRTaskInfo(auditTaskRecord.getTaskID(), auditTaskRecord.getReportName(), auditTaskRecord.getTaskType(), "", "", -1, auditTaskRecord.getSubmitTime(), auditTaskRecord.getStartTime(), auditTaskRecord.getCompleteTime(), auditTaskRecord.getPageNumber(), auditTaskRecord.getCatalogName(), "", auditTaskRecord.getUserName(), "", "", auditTaskRecord.getTaskStatus(), auditTaskRecord.getFailReason(), auditTaskRecord.getCatalogNames(), auditTaskRecord.getParameters());
                cSVCreater.writeTaskInfo(jRTaskInfo);
            }
            cSVCreater.close();
            return cSVCreater.getContent();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            return null;
        }
    }

    public String exportFailedTasks(long l, long l2) {
        CSVCreater cSVCreater = null;
        try {
            cSVCreater = new CSVCreater();
            cSVCreater.setConvertFlag(true);
            List list = ((JRMonitorService)this.equalsIgnoreCase).getRemoteMonitorService().getFailedAuditTasks(l, l2);
            for (int i = 0; i < list.size(); ++i) {
                AuditTaskRecord auditTaskRecord = (AuditTaskRecord)list.get(i);
                JRTaskInfo jRTaskInfo = new JRTaskInfo(auditTaskRecord.getTaskID(), auditTaskRecord.getReportName(), auditTaskRecord.getTaskType(), "", "", -1, auditTaskRecord.getSubmitTime(), auditTaskRecord.getStartTime(), auditTaskRecord.getCompleteTime(), auditTaskRecord.getPageNumber(), auditTaskRecord.getCatalogName(), "", auditTaskRecord.getUserName(), "", "", auditTaskRecord.getTaskStatus(), auditTaskRecord.getFailReason(), auditTaskRecord.getCatalogNames(), auditTaskRecord.getParameters());
                cSVCreater.writeTaskInfo(jRTaskInfo);
            }
            cSVCreater.close();
            return cSVCreater.getContent();
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
            return null;
        }
    }
}

