/*
 * Decompiled with CFR 0.152.
 */
package jet.server.monitor.standalone;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jet.server.log.ServiceLogger;
import jet.server.monitor.jrmon.MonitorEnv;
import jet.server.monitor.standalone.HttpMonitorServer;
import jet.server.util.ServerUtil;
import jet.server.util.WebSecurityUtil;
import server.servlet.http.HttpRequest;
import server.servlet.http.HttpResponse;
import server.servlet.http.HttpServerHandlerBase;
import server.servlet.http.MessageBytes;

public class HttpMonitorServerHandler
extends HttpServerHandlerBase {
    protected HttpMonitorServerHandler(HttpMonitorServer httpMonitorServer) {
        super(httpMonitorServer);
    }

    @Override
    protected void service(HttpRequest httpRequest, HttpResponse httpResponse) throws ServletException, IOException {
        MessageBytes messageBytes = httpRequest.getRequestPath();
        String string = this.parsePath(messageBytes, httpRequest);
        ServiceLogger.logDebug(6660215, string, 6);
        String string2 = this.getValidPath(string);
        if (string2 == null) {
            httpResponse.sendError(404, "The requested resource (" + messageBytes.toString() + ") is not available.");
            return;
        }
        string = string2;
        httpRequest.setServletPath(string);
        boolean bl = false;
        Properties properties = ((HttpMonitorServer)this.server).getMappings();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            String string4 = (String)properties.get(string3);
            if (string3.startsWith(".")) {
                if (!string.toLowerCase().endsWith(string3.toLowerCase())) continue;
                Servlet servlet = ((HttpMonitorServer)this.server).getServlet(string4);
                if (servlet == null) {
                    httpResponse.sendError(404, "Cannot load servlet " + string4 + " for serving request");
                    return;
                }
                servlet.service((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                bl = true;
                break;
            }
            if (!string.startsWith(string3 + "/") && !string.startsWith(string3 + "?") && !string.equals(string3)) continue;
            Servlet servlet = ((HttpMonitorServer)this.server).getServlet(string4);
            if (servlet == null) {
                httpResponse.sendError(404, "Cannot load servlet " + string4 + " for serving request");
                return;
            }
            httpRequest.setServletPath(string3);
            String string5 = string.substring(string3.length());
            if (string5.equals("") || string5.equals("/")) {
                string5 = null;
            }
            httpRequest.setPathInfo(string5);
            servlet.service((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            bl = true;
            break;
        }
        if (!bl && MonitorEnv.isJspEnable()) {
            this.SEDU(httpRequest, httpResponse, string);
        }
    }

    private void SEDU(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws IOException {
        Object object;
        ServiceLogger.logDebug(6660216, string, 6);
        if (string == null || string.equals("") || string.equals("/")) {
            string = "/index.htm";
        }
        String string2 = string;
        String string3 = "";
        int n = string2.lastIndexOf(46);
        if (n > 0) {
            string3 = string2.substring(n);
        }
        String[] stringArray = MonitorEnv.getMimeTypeTable().getMimeTypeAndEncoding(string3);
        httpServletResponse.setContentType(stringArray[0]);
        if (stringArray[1] != null) {
            httpServletResponse.setHeader("Content-Encoding", stringArray[1]);
        }
        try {
            string = WebSecurityUtil.validateSubPath(string);
            if (string.endsWith("/") || string.endsWith(File.separator) || string.startsWith("/..") || string.endsWith(".jsp.bak")) {
                httpServletResponse.sendError(404, "File " + string + " not found!");
                return;
            }
            if (string.indexOf("<script>") > 0 || string.indexOf("javascript:") > 0) {
                httpServletResponse.sendError(404, "File not found!");
                return;
            }
            object = new File(this.server.getRealPath(string));
            if (((File)object).isDirectory()) {
                httpServletResponse.sendError(404, "File " + string + " not found!");
                return;
            }
            if (ServerUtil.isFileNotModified((File)object, httpServletRequest, httpServletResponse)) {
                return;
            }
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
        httpServletResponse.setStatus(200);
        object = httpServletResponse.getOutputStream();
        InputStream inputStream = this.server.getResourceAsStream(string);
        if (inputStream == null) {
            httpServletResponse.sendError(404, "File " + string + " not found!");
            return;
        }
        httpServletResponse.setContentLength(inputStream.available());
        byte[] byArray = new byte[65536];
        try {
            int n2 = inputStream.read(byArray);
            while (n2 > 0) {
                ((OutputStream)object).write(byArray, 0, n2);
                n2 = inputStream.read(byArray);
            }
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable);
        }
        inputStream.close();
        ((OutputStream)object).close();
    }
}

