/*
 * Decompiled with CFR 0.152.
 */
package jet.server.objmanager;

import com.jinfonet.api.objectmanager.Cachable;
import com.jinfonet.api.objectmanager.CatalogKey;
import com.jinfonet.api.objectmanager.Constants;
import com.jinfonet.api.objectmanager.Loader;
import com.jinfonet.api.objectmanager.ObjectManager;
import com.jinfonet.api.objectmanager.Preserver;
import com.jinfonet.api.objectmanager.ResourceKey;
import com.jinfonet.api.objectmanager.ResourceWrapper;
import java.io.IOException;
import jet.JException;
import jet.cs.CSUtil;
import jet.server.api.PathInfo;
import jet.server.api.ResourceManager;
import jet.server.api.VersionRecord;
import jet.server.api.admin.AdminService;
import jet.server.api.admin.cfg.ConfigService;
import jet.server.api.admin.cfg.ConfigurationCache;
import jet.server.api.http.HttpRptServer;
import jet.server.api.http.HttpUtil;
import jet.server.db.event.RecordEventListenerManager;
import jet.server.db.event.VersionEventListener;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.objmanager.MemoryCache;
import jet.server.storage.StorageException;
import jet.universe.JetUUniverse;

public final class ObjectManagerImpl
implements ObjectManager,
Constants {
    private MemoryCache SEDU;
    private HttpRptServer append = HttpUtil.getHttpRptServer();
    private static ObjectManagerImpl clear;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectManagerImpl getInstance() {
        Class<ObjectManagerImpl> clazz = ObjectManagerImpl.class;
        synchronized (ObjectManagerImpl.class) {
            if (clear == null) {
                clear = new ObjectManagerImpl();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return clear;
        }
    }

    private ObjectManagerImpl() {
        AdminService adminService = this.append.getAdminService();
        ConfigService configService = adminService.getConfigService();
        ConfigurationCache configurationCache = configService.getConfigurationCache();
        this.SEDU = new MemoryCache(configurationCache.getMaxCacheReportSize());
    }

    @Override
    public void destroy() {
        this.SEDU.clear();
    }

    @Override
    public ResourceWrapper get(ResourceWrapper resourceWrapper) throws JException {
        if (resourceWrapper == null) {
            throw new JException("the resource wrapper is null.");
        }
        Cachable cachable = null;
        ResourceKey resourceKey = resourceWrapper.getKey();
        if (resourceKey == null) {
            throw new JException("the resource wrapper's key is null or empty.");
        }
        cachable = (Cachable)this.SEDU.get(resourceKey);
        Loader loader = resourceWrapper.getLoader();
        if (cachable != null) {
            resourceWrapper.setObject(loader.clone(cachable.getObject()));
            return resourceWrapper;
        }
        String string = this.SEDU(resourceWrapper);
        String string2 = (String)resourceWrapper.getDependentInfo("dep.type");
        Object object = null;
        if ("catalog".equals(string2)) {
            CatalogKey catalogKey = (CatalogKey)resourceWrapper.getKey();
            String string3 = catalogKey.getPath();
            String string4 = CSUtil.parseVirtualResourcePath(string3)[0];
            object = UserDataToolkit.getJDataService(string4).getCatalog(catalogKey);
        }
        if (object == null) {
            object = loader.load(string, resourceWrapper.getDependents());
        } else {
            ((JetUUniverse)object).refer();
        }
        if (object != null && resourceKey != null) {
            cachable = resourceWrapper.getCachable();
            if (cachable != null) {
                cachable.setObject(object);
                this.cache(resourceKey, cachable);
                resourceWrapper.setObject(loader.clone(object));
            } else {
                resourceWrapper.setObject(object);
            }
        }
        return resourceWrapper;
    }

    private void cache(ResourceKey resourceKey, Cachable cachable) {
        this.SEDU.put(resourceKey, cachable);
    }

    @Override
    public void save(ResourceWrapper resourceWrapper) throws JException {
        this.save(resourceWrapper, this.SEDU(resourceWrapper), resourceWrapper.getResourceVersion());
    }

    @Override
    public void saveAs(ResourceWrapper resourceWrapper) throws JException {
        this.save(resourceWrapper, this.SEDU(resourceWrapper), this.append(resourceWrapper));
    }

    protected void save(ResourceWrapper resourceWrapper, String string, int n) throws JException {
        ResourceKey resourceKey = resourceWrapper.getKey();
        Preserver preserver = resourceWrapper.getPreserver();
        preserver.save(this.SEDU(resourceWrapper), resourceWrapper.getObject(), resourceWrapper.getDependents());
        Cachable cachable = resourceWrapper.getCachable();
        if (cachable != null) {
            Object object = preserver.clone(resourceWrapper.getObject());
            cachable.setObject(object);
            this.cache(resourceWrapper.getKey(), cachable);
        }
        this.SEDU.remove(resourceKey);
    }

    private String SEDU(ResourceWrapper resourceWrapper) throws JException {
        if (resourceWrapper.isRealPath()) {
            return resourceWrapper.getResourcePath();
        }
        String string = (String)resourceWrapper.getDependentInfo("dep.user");
        if (string == null) {
            throw new JException("the dependent user id don't existed.");
        }
        ResourceManager resourceManager = this.append.getResourceManager();
        String string2 = (String)resourceWrapper.getDependentInfo("dep.type");
        VersionRecord versionRecord = null;
        String string3 = resourceWrapper.getResourcePath();
        int n = resourceWrapper.getResourceVersion();
        if ("catalog".equals(string2)) {
            versionRecord = resourceManager.getCatalogVersion(string, string3, n);
        } else if ("reportset".equals(string2)) {
            versionRecord = resourceManager.getReportVersion(string, string3, n);
        }
        if (versionRecord != null) {
            PathInfo pathInfo = resourceManager.getPathInfo(string, string3);
            String string4 = versionRecord.getRealPath();
            if (!pathInfo.isDynamic()) {
                String string5 = resourceManager.getHistDir();
                String string6 = string4.substring(string5.length());
                VersionEventListener versionEventListener = RecordEventListenerManager.getActiveInstance().getVersionEventListener();
                try {
                    versionEventListener.get(string6);
                }
                catch (IOException iOException) {
                    throw new JException("get file " + string6 + " failed. " + iOException);
                }
                catch (StorageException storageException) {
                    throw new JException("get file " + string6 + " failed. " + (Object)((Object)storageException));
                }
            }
            return string4;
        }
        return null;
    }

    private int append(ResourceWrapper resourceWrapper) throws JException {
        if (resourceWrapper.isRealPath()) {
            return -1;
        }
        String string = (String)resourceWrapper.getDependentInfo("dep.user");
        if (string == null) {
            throw new JException("the dependent user id don't existed.");
        }
        ResourceManager resourceManager = this.append.getResourceManager();
        String string2 = (String)resourceWrapper.getDependentInfo("dep.type");
        VersionRecord versionRecord = null;
        if ("catalog".equals(string2)) {
            versionRecord = resourceManager.getCatalogVersion(string, resourceWrapper.getResourcePath(), resourceWrapper.getResourceVersion());
        } else if ("reportset".equals(string2)) {
            versionRecord = resourceManager.getReportVersion(string, resourceWrapper.getResourcePath(), resourceWrapper.getResourceVersion());
        }
        if (versionRecord != null) {
            return versionRecord.getVersionNumber() + 1;
        }
        return 0;
    }
}

