/*
 * Decompiled with CFR 0.152.
 */
package jet.server.profiling;

import java.io.Serializable;
import jet.server.profiling.CounterCategory;
import jet.server.profiling.CounterType;

public final class PerformanceCounter
implements Serializable {
    private String counterName;
    private CounterType counterType;
    private PerformanceCounter base;
    private String counterHelp;
    private long rawValue;
    private long maxValue;
    private long minValue;
    private boolean isInit = true;

    protected PerformanceCounter(String string, CounterType counterType, PerformanceCounter performanceCounter) {
        if (counterType == null) {
            throw new IllegalArgumentException("Must specifies counter's type.");
        }
        switch (counterType.toInt()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                if (performanceCounter != null && performanceCounter.getCounterType().isAverageBase()) break;
                throw new IllegalArgumentException(counterType.toString() + " counter needs a CounterType.AverageBase counter" + " as base parameter.");
            }
            case 7: {
                if (performanceCounter != null && performanceCounter.getCounterType().isElapsedTimer()) break;
                throw new IllegalArgumentException(counterType.toString() + " counter needs a CounterType.ElapsedTimer counter" + " as base parameter.");
            }
        }
        this.counterType = counterType;
        this.counterName = string;
        this.base = performanceCounter;
        this.clear();
    }

    public synchronized void clear() {
        this.minValue = 0L;
        this.maxValue = 0L;
        this.rawValue = 0L;
        this.isInit = true;
        if (this.base != null) {
            this.base.clear();
        }
    }

    public CounterType getCounterType() {
        return this.counterType;
    }

    public String getMachineName() {
        int n = this.counterName.indexOf("\\", 2);
        if (n != -1) {
            return this.counterName.substring(2, n);
        }
        return "";
    }

    public String getCategoryName() {
        int n;
        int n2 = this.counterName.indexOf("\\", 2);
        if (n2 != -1 && (n = this.counterName.indexOf("\\", n2 + 1)) != -1) {
            return this.counterName.substring(n2 + 1, n);
        }
        return "";
    }

    public String getCounterName() {
        int n;
        int n2 = this.counterName.indexOf("\\", 2);
        if (n2 != -1 && (n = this.counterName.indexOf("\\", n2 + 1)) != -1) {
            return this.counterName.substring(n + 1);
        }
        return "";
    }

    public String getCounterHelp() {
        return this.counterHelp;
    }

    public void setCounterHelp(String string) {
        this.counterHelp = string == null ? "" : string;
    }

    public long increment() {
        return this.incrementBy(1L);
    }

    public long decrement() {
        return this.incrementBy(-1L);
    }

    public synchronized long incrementBy(long l) {
        long l2 = this.rawValue + l;
        return this.setRawValue(l2);
    }

    public synchronized long getRawValue() {
        return this.rawValue;
    }

    public synchronized long setRawValue(long l) {
        if (!this.isInit) {
            if (l > this.maxValue) {
                this.maxValue = l;
            } else if (l < this.minValue) {
                this.minValue = l;
            }
            this.rawValue = l;
        } else {
            this.maxValue = this.minValue = l;
            this.rawValue = this.minValue;
            this.isInit = false;
        }
        return this.rawValue;
    }

    public synchronized long getMaxValue() {
        return this.maxValue;
    }

    public synchronized long getMinValue() {
        return this.minValue;
    }

    public synchronized float nextValue() {
        float f = 0.0f;
        switch (this.counterType.toInt()) {
            case 6: {
                f = this.maxValue - this.minValue;
                break;
            }
            case 0: 
            case 1: {
                f = this.rawValue;
                break;
            }
            case 2: 
            case 3: {
                f = (double)this.base.nextValue() < 0.001 ? 0.0f : (float)this.rawValue / this.base.nextValue();
                break;
            }
            case 4: 
            case 5: {
                f = (double)this.base.nextValue() < 0.001 ? 0.0f : 100.0f * ((float)this.rawValue / this.base.nextValue());
                break;
            }
            case 7: {
                f = (double)this.base.nextValue() < 0.1 ? 0.0f : 100.0f * ((float)this.rawValue / this.base.nextValue());
                break;
            }
        }
        return f;
    }

    public void close() {
        CounterCategory.removeCounter(this.getMachineName(), this.getCategoryName(), this.getCounterName());
    }

    public String toString() {
        return this.counterName;
    }
}

