/*
 * Decompiled with CFR 0.152.
 */
package jet.server.profiling.jreport;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import jet.server.api.db.Database;
import jet.server.api.db.FieldValue;
import jet.server.api.profiling.CollectingAgency;
import jet.server.log.ServiceLogger;
import jet.server.profiling.jreport.JRAuditTaskRecord;
import jet.server.profiling.jreport.TaskAuditTable;

public final class ReportCollector
implements CollectingAgency {
    private static boolean SEDU = false;
    private TaskAuditTable add = null;
    private Hashtable addAuditTask = new Hashtable();

    @Override
    public void init(Properties properties) {
        if (this.isAlive()) {
            return;
        }
        Database database = (Database)properties.get("database");
        if (database != null) {
            this.add = TaskAuditTable.getInstance(database);
        }
        SEDU = true;
    }

    @Override
    public void destroy() {
        if (this.add != null) {
            this.add.close();
        }
        SEDU = false;
    }

    @Override
    public boolean isAlive() {
        return SEDU;
    }

    @Override
    public void collects(Hashtable hashtable) {
        if (!SEDU) {
            return;
        }
        if (hashtable.size() == 0) {
            ServiceLogger.logError(3600295, 3);
            return;
        }
        int n = Integer.parseInt((String)hashtable.get("TopicType"));
        switch (n) {
            case 0: {
                int n2 = this.add.getID();
                String string = (String)hashtable.get("taskID");
                String string2 = (String)hashtable.get("userName");
                int n3 = Integer.parseInt((String)hashtable.get("taskType"));
                int n4 = Integer.parseInt((String)hashtable.get("taskStatus"));
                long l = Long.parseLong((String)hashtable.get("submitTime"));
                Map map = (Map)hashtable.get("parameter");
                JRAuditTaskRecord jRAuditTaskRecord = new JRAuditTaskRecord(n2, string, string2, n3, n4, l, map);
                jRAuditTaskRecord.setCatalogNames((List)new LinkedList());
                try {
                    this.add.addAuditTask(jRAuditTaskRecord);
                }
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException);
                }
                this.addAuditTask.put(string, jRAuditTaskRecord);
                break;
            }
            case 1: {
                String string = (String)hashtable.get("taskID");
                JRAuditTaskRecord jRAuditTaskRecord = (JRAuditTaskRecord)this.addAuditTask.get(string);
                if (null != jRAuditTaskRecord) {
                    int n5 = jRAuditTaskRecord.getID();
                    FieldValue[] fieldValueArray = new FieldValue[2];
                    fieldValueArray[0] = this.add.fields("TASK_STATUS").createFieldValue();
                    fieldValueArray[0].setValue(Integer.parseInt((String)hashtable.get("taskStatus")));
                    fieldValueArray[1] = this.add.fields("START_TIME").createFieldValue();
                    String string3 = (String)hashtable.get("startTime");
                    fieldValueArray[1].setValue(Long.parseLong(string3));
                    try {
                        this.add.updateAuditTaskByID(n5, fieldValueArray);
                    }
                    catch (SQLException sQLException) {
                        ServiceLogger.logError(sQLException);
                    }
                    jRAuditTaskRecord.setTaskStatus(Integer.parseInt((String)hashtable.get("taskStatus")));
                    break;
                }
                ServiceLogger.logDebug("No task, failed to audit START_TASK: taskID=" + string + ",startTime=" + hashtable.get("startTime"), 6);
                break;
            }
            case 2: {
                String string = (String)hashtable.get("taskID");
                JRAuditTaskRecord jRAuditTaskRecord = (JRAuditTaskRecord)this.addAuditTask.get(string);
                if (null != jRAuditTaskRecord) {
                    int n6 = jRAuditTaskRecord.getID();
                    FieldValue[] fieldValueArray = new FieldValue[3];
                    fieldValueArray[0] = this.add.fields("TASK_STATUS").createFieldValue();
                    fieldValueArray[0].setValue(Integer.parseInt((String)hashtable.get("taskStatus")));
                    fieldValueArray[1] = this.add.fields("PAGE_NUMBER").createFieldValue();
                    fieldValueArray[1].setValue(Integer.parseInt((String)hashtable.get("rptPages")));
                    fieldValueArray[2] = this.add.fields("COMPLETE_TIME").createFieldValue();
                    fieldValueArray[2].setValue(Long.parseLong((String)hashtable.get("finishTime")));
                    try {
                        this.add.updateAuditTaskByID(n6, fieldValueArray);
                    }
                    catch (SQLException sQLException) {
                        ServiceLogger.logError(sQLException);
                    }
                    this.addAuditTask.remove(string);
                    break;
                }
                ServiceLogger.logDebug("No task, failed to audit FINISH_TASK: taskID=" + string + ",pageNumber=" + hashtable.get("rptPages") + ",finishTime=" + hashtable.get("finishTime"), 6);
                break;
            }
            case 3: {
                String string = (String)hashtable.get("taskID");
                JRAuditTaskRecord jRAuditTaskRecord = (JRAuditTaskRecord)this.addAuditTask.get(string);
                if (null != jRAuditTaskRecord) {
                    int n7 = ((JRAuditTaskRecord)this.addAuditTask.get(string)).getID();
                    FieldValue[] fieldValueArray = new FieldValue[3];
                    fieldValueArray[0] = this.add.fields("TASK_STATUS").createFieldValue();
                    fieldValueArray[0].setValue(Integer.parseInt((String)hashtable.get("taskStatus")));
                    fieldValueArray[1] = this.add.fields("COMPLETE_TIME").createFieldValue();
                    fieldValueArray[1].setValue(Long.parseLong((String)hashtable.get("finishTime")));
                    fieldValueArray[2] = this.add.fields("FAIL_REASON").createFieldValue();
                    fieldValueArray[2].setValue((String)hashtable.get("failedInfo"));
                    try {
                        this.add.updateAuditTaskByID(n7, fieldValueArray);
                    }
                    catch (SQLException sQLException) {
                        ServiceLogger.logError(sQLException);
                    }
                    this.addAuditTask.remove(string);
                    break;
                }
                ServiceLogger.logDebug("No task, failed to audit FAILED_TASK: taskID=" + string + ",pageNumber=" + hashtable.get("rptPages") + ",finishTime=" + hashtable.get("finishTime") + ",failReason=" + hashtable.get("failedInfo"), 6);
                break;
            }
            case 8: {
                String string = (String)hashtable.get("taskID");
                JRAuditTaskRecord jRAuditTaskRecord = (JRAuditTaskRecord)this.addAuditTask.get(string);
                if (null != jRAuditTaskRecord) {
                    Map map = (Map)hashtable.get("parameter");
                    int n8 = jRAuditTaskRecord.getID();
                    try {
                        this.add.setTaskParametersByID(n8, map);
                    }
                    catch (SQLException sQLException) {
                        ServiceLogger.logError(sQLException);
                    }
                    jRAuditTaskRecord.setParameters(map);
                    break;
                }
                ServiceLogger.logDebug("No task, failed to audit SET_PARAMETERS: taskID=" + string + ",parameters=" + hashtable.get("parameter"), 6);
                break;
            }
            case 9: {
                String string = (String)hashtable.get("taskID");
                JRAuditTaskRecord jRAuditTaskRecord = (JRAuditTaskRecord)this.addAuditTask.get(string);
                if (null != jRAuditTaskRecord) {
                    int n9 = jRAuditTaskRecord.getTaskType();
                    long l = Long.parseLong((String)hashtable.get("changeTime"));
                    Map map = (Map)hashtable.get("parameter");
                    int n10 = jRAuditTaskRecord.getID();
                    if (5 != n9 && 6 != n9) break;
                    try {
                        FieldValue[] fieldValueArray = new FieldValue[3];
                        fieldValueArray[0] = this.add.fields("TASK_STATUS").createFieldValue();
                        fieldValueArray[0].setValue(9);
                        fieldValueArray[1] = this.add.fields("PAGE_NUMBER").createFieldValue();
                        if (6 == n9) {
                            fieldValueArray[1].setValue(-1);
                        } else {
                            fieldValueArray[1].setValue(Integer.parseInt((String)hashtable.get("rptPages")));
                        }
                        fieldValueArray[2] = this.add.fields("COMPLETE_TIME").createFieldValue();
                        fieldValueArray[2].setValue(l);
                        this.add.updateAuditTaskByID(n10, fieldValueArray);
                        jRAuditTaskRecord.setID(this.add.getID());
                        jRAuditTaskRecord.setSubmitTime(l);
                        jRAuditTaskRecord.setTaskStatus(1);
                        jRAuditTaskRecord.setParameters(map);
                        this.add.addAuditTask(jRAuditTaskRecord);
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception + "; Detail: pageNumber=" + hashtable.get("rptPages") + ", completeTime=" + hashtable.get("changeTime"));
                    }
                    break;
                }
                ServiceLogger.logDebug("No task, failed to audit CHANGE_PARAMETERS: taskID=" + string + ",pageNumber=" + hashtable.get("rptPages") + ",changeTime=" + hashtable.get("changeTime") + ",parameters=" + hashtable.get("parameter"), 6);
                break;
            }
            case 10: {
                String string = (String)hashtable.get("taskID");
                JRAuditTaskRecord jRAuditTaskRecord = (JRAuditTaskRecord)this.addAuditTask.get(string);
                if (null != jRAuditTaskRecord) {
                    int n11 = jRAuditTaskRecord.getID();
                    FieldValue[] fieldValueArray = new FieldValue[2];
                    fieldValueArray[0] = this.add.fields("TASK_STATUS").createFieldValue();
                    fieldValueArray[0].setValue(4);
                    fieldValueArray[1] = this.add.fields("START_TIME").createFieldValue();
                    fieldValueArray[1].setValue(Long.parseLong((String)hashtable.get("startTime")));
                    try {
                        this.add.updateAuditTaskByID(n11, fieldValueArray);
                    }
                    catch (SQLException sQLException) {
                        ServiceLogger.logError(sQLException);
                    }
                    jRAuditTaskRecord.setTaskStatus(Integer.parseInt((String)hashtable.get("taskStatus")));
                    break;
                }
                ServiceLogger.logDebug("No task, failed to audit START_REFRESH_PARAMETERS: taskID=" + string + ",startTime=" + hashtable.get("startTime"), 6);
                break;
            }
            case 11: {
                String string = (String)hashtable.get("taskID");
                JRAuditTaskRecord jRAuditTaskRecord = (JRAuditTaskRecord)this.addAuditTask.get(string);
                if (null != jRAuditTaskRecord) {
                    int n12 = jRAuditTaskRecord.getID();
                    FieldValue[] fieldValueArray = new FieldValue[3];
                    fieldValueArray[0] = this.add.fields("TASK_STATUS").createFieldValue();
                    fieldValueArray[0].setValue(9);
                    fieldValueArray[1] = this.add.fields("PAGE_NUMBER").createFieldValue();
                    fieldValueArray[1].setValue((Integer)hashtable.get("rptPages"));
                    fieldValueArray[2] = this.add.fields("COMPLETE_TIME").createFieldValue();
                    fieldValueArray[2].setValue(Long.parseLong((String)hashtable.get("finishTime")));
                    try {
                        this.add.updateAuditTaskByID(n12, fieldValueArray);
                    }
                    catch (SQLException sQLException) {
                        ServiceLogger.logError(sQLException);
                    }
                    jRAuditTaskRecord.setTaskStatus(Integer.parseInt((String)hashtable.get("taskStatus")));
                    break;
                }
                ServiceLogger.logDebug("No task, failed to audit FINISH_REFRESH_PARAMETERS: taskID=" + string + ",pageNumber=" + hashtable.get("rptPages") + ",finishTime=" + hashtable.get("finishTime"), 6);
                break;
            }
            case 5: {
                String string = (String)hashtable.get("taskID");
                JRAuditTaskRecord jRAuditTaskRecord = (JRAuditTaskRecord)this.addAuditTask.get(string);
                if (null != jRAuditTaskRecord) {
                    int n13 = jRAuditTaskRecord.getID();
                    FieldValue[] fieldValueArray = new FieldValue[]{this.add.fields("REPORT_NAME").createFieldValue()};
                    fieldValueArray[0].setValue((String)hashtable.get("rptName"));
                    try {
                        this.add.updateAuditTaskByID(n13, fieldValueArray);
                    }
                    catch (SQLException sQLException) {
                        ServiceLogger.logError(sQLException);
                    }
                    jRAuditTaskRecord.setReportName((String)hashtable.get("rptName"));
                    break;
                }
                ServiceLogger.logDebug("No task, failed to audit SET_REPORT: taskID=" + string + ",reportName=" + hashtable.get("rptName"), 6);
                break;
            }
            case 6: {
                String string = (String)hashtable.get("taskID");
                JRAuditTaskRecord jRAuditTaskRecord = (JRAuditTaskRecord)this.addAuditTask.get(string);
                if (null != jRAuditTaskRecord) {
                    int n14 = jRAuditTaskRecord.getID();
                    FieldValue[] fieldValueArray = new FieldValue[]{this.add.fields("CATALOG_NAME").createFieldValue()};
                    fieldValueArray[0].setValue((String)hashtable.get("rptSource"));
                    try {
                        this.add.updateAuditTaskByID(n14, fieldValueArray);
                    }
                    catch (SQLException sQLException) {
                        ServiceLogger.logError(sQLException);
                    }
                    jRAuditTaskRecord.setCatalogName((String)hashtable.get("rptSource"));
                    break;
                }
                ServiceLogger.logDebug("No task, failed to audit SET_CATALOG: taskID=" + string + ",catalogName=" + hashtable.get("rptSource"), 6);
                break;
            }
            case 7: {
                String string = (String)hashtable.get("taskID");
                JRAuditTaskRecord jRAuditTaskRecord = (JRAuditTaskRecord)this.addAuditTask.get(string);
                if (null != jRAuditTaskRecord) {
                    String string4 = (String)hashtable.get("rptSource");
                    int n15 = jRAuditTaskRecord.getID();
                    try {
                        this.add.addTaskCatalogByID(n15, string4);
                    }
                    catch (SQLException sQLException) {
                        ServiceLogger.logError(sQLException);
                    }
                    LinkedList<String> linkedList = jRAuditTaskRecord.getAllCatalogNames();
                    if (null == linkedList) {
                        linkedList = new LinkedList<String>();
                    }
                    if (linkedList.contains(string4)) break;
                    linkedList.add(string4);
                    break;
                }
                ServiceLogger.logDebug("No task, failed to audit ADD_CATALOG: taskID=" + string + ",catalogName=" + hashtable.get("rptSource"), 6);
                break;
            }
        }
    }
}

