/*
 * Decompiled with CFR 0.152.
 */
package jet.server.profiling.jreport;

import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import jet.cs.CSUtil;
import jet.server.api.db.Database;
import jet.server.api.db.FieldValue;
import jet.server.api.profiling.CollectingAgency;
import jet.server.db.UpdateDetailsTable;
import jet.server.db.UpdateDetailsTableImpl;
import jet.server.db.core.ParameterMetaInfo;
import jet.server.log.ServiceLogger;
import jet.server.profiling.CounterCategory;
import jet.server.profiling.CounterType;
import jet.server.profiling.PerformanceCounter;
import jet.server.profiling.jreport.TaskContextTable;

public final class RptServerCollectingAgency
implements CollectingAgency {
    private static boolean AverageBase = false;
    private TaskContextTable AverageCount = null;
    private static CounterCategory AverageTimer = CounterCategory.createCategory(null, "RptServerProfile");
    private PerformanceCounter PercentCount;
    private PerformanceCounter SEDU;
    private PerformanceCounter add;
    private PerformanceCounter close;
    private PerformanceCounter containsKey;
    private PerformanceCounter createCategory;
    private PerformanceCounter createCounter;
    private PerformanceCounter destroy;
    private Hashtable endsWith = new Hashtable();
    private Hashtable equals = new Hashtable();

    @Override
    public void init(Properties properties) {
        if (this.isAlive()) {
            return;
        }
        Database database = (Database)properties.get("database");
        if (database != null) {
            Object object;
            try {
                object = UpdateDetailsTableImpl.newInstance(database);
                this.AverageCount = new TaskContextTable(database, (UpdateDetailsTable)object);
            }
            catch (InstantiationException instantiationException) {
                ServiceLogger.logError(instantiationException);
            }
            catch (SQLException sQLException) {
                ServiceLogger.logError(sQLException);
            }
            object = properties.getProperty("restore.profiling");
            if (object != null && ((String)object).trim().length() > 0) {
                try {
                    database.restore((String)object);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception, 3);
                    }
                }
                catch (SQLException sQLException) {
                    ServiceLogger.logError(sQLException);
                }
                catch (IOException iOException) {
                    ServiceLogger.logError(iOException);
                }
            }
        }
        this.AverageBase();
        AverageBase = true;
    }

    @Override
    public void destroy() {
        if (this.AverageCount != null) {
            this.AverageCount.close();
        }
        CounterCategory.destroy();
        AverageBase = false;
    }

    @Override
    public boolean isAlive() {
        return AverageBase;
    }

    @Override
    public void collects(Hashtable hashtable) {
        if (!AverageBase) {
            return;
        }
        if (hashtable.size() == 0) {
            ServiceLogger.logError(3600295, 3);
            return;
        }
        String string = (String)hashtable.get("Task_type");
        if (this.AverageCount != null) {
            if (null != string) {
                String string2;
                int n;
                FieldValue[] fieldValueArray;
                HashMap hashMap = new HashMap();
                Enumeration enumeration = hashtable.keys();
                if (hashtable.containsKey("VS_rpt_name") && "" == hashtable.get("VS_rpt_name")) {
                    return;
                }
                while (enumeration.hasMoreElements()) {
                    fieldValueArray = (FieldValue[])enumeration.nextElement();
                    hashMap.put(fieldValueArray.toUpperCase(), hashtable.get(fieldValueArray));
                }
                fieldValueArray = this.AverageCount.fields().values();
                fieldValueArray[0].setValue(this.AverageCount.getID());
                int n2 = fieldValueArray.length;
                for (n = 1; n < n2; ++n) {
                    string2 = fieldValueArray[n].getName();
                    Object v = hashMap.get(string2);
                    if (string2.startsWith("TS")) {
                        long l = v == null ? 0L : (Long)v;
                        fieldValueArray[n].setValue(new Timestamp(l));
                        continue;
                    }
                    if (v != null) {
                        fieldValueArray[n].setValue(v);
                        continue;
                    }
                    if (!hashMap.containsKey(string2)) continue;
                    ServiceLogger.logError(3600295, 3);
                    return;
                }
                n = -1;
                if ("DHTML".equalsIgnoreCase(string)) {
                    string2 = (String)hashtable.get("TaskID");
                    if (null != string2 && (this.endsWith.containsKey(string2) || this.equals.containsKey(string2))) {
                        n = this.endsWith.containsKey(string2) ? ((Integer)this.endsWith.get(string2)).intValue() : ((FieldValue[])this.equals.get(string2))[0].getInt();
                        fieldValueArray[0].setValue(n);
                        try {
                            this.AverageCount.update(fieldValueArray, " where ID =?", new ParameterMetaInfo().add("id", n));
                        }
                        catch (SQLException sQLException) {
                            ServiceLogger.logError(sQLException);
                        }
                        this.endsWith.remove(string2);
                    } else {
                        n = this.AverageCount.getID();
                        fieldValueArray[0].setValue(n);
                        try {
                            this.AverageCount.insert(fieldValueArray);
                        }
                        catch (SQLException sQLException) {
                            ServiceLogger.logError(sQLException);
                        }
                        if (null != string2) {
                            this.endsWith.put(string2, new Integer(n));
                        }
                    }
                } else {
                    n = this.AverageCount.getID();
                    fieldValueArray[0].setValue(n);
                    try {
                        this.AverageCount.insert(fieldValueArray);
                    }
                    catch (SQLException sQLException) {
                        ServiceLogger.logError(sQLException);
                    }
                }
            } else {
                String string3;
                Object object;
                String string4 = (String)hashtable.get("MessageSource");
                if (null != string4) {
                    if ("jet.server.jrc.JRTaskManager".equals(string4)) {
                        return;
                    }
                    if ("jet.web.dhtml.RunTimeReportInfo".equals(string4)) {
                        object = (String)hashtable.get("taskStatus");
                        if (object == null || !((String)object).equals("1") && !((String)object).equals("9")) {
                            return;
                        }
                        string3 = (String)hashtable.get("rptName");
                        if (string3 != null && string3.endsWith(".cls")) {
                            return;
                        }
                    }
                }
                object = new HashMap();
                string3 = (String)hashtable.get("taskID");
                if (null != this.equals.get(string3)) {
                    FieldValue[] fieldValueArray;
                    if (hashtable.containsKey("taskStatus")) {
                        fieldValueArray = (FieldValue[])hashtable.get("taskStatus");
                        if ("4".equals(fieldValueArray)) {
                            return;
                        }
                    } else {
                        if (hashtable.containsKey("rptName")) {
                            int n;
                            FieldValue[] fieldValueArray2 = (FieldValue[])this.equals.get(string3);
                            int n3 = fieldValueArray2.length;
                            for (n = 1; n < n3; ++n) {
                                String string5 = fieldValueArray2[n].getName();
                                if (!string5.equalsIgnoreCase("VS_RPT_NAME")) continue;
                                fieldValueArray2[n].setValue((String)hashtable.get("rptName"));
                            }
                            n = fieldValueArray2[0].getInt();
                            try {
                                this.AverageCount.update(fieldValueArray2, " where ID =?", new ParameterMetaInfo().add("id", n));
                            }
                            catch (SQLException sQLException) {
                                ServiceLogger.logError(sQLException);
                            }
                        }
                        return;
                    }
                    if (hashtable.containsKey("finishTime")) {
                        String string6;
                        int n;
                        fieldValueArray = (FieldValue[])this.equals.get(string3);
                        int n4 = fieldValueArray.length;
                        long l = 0L;
                        long l2 = 0L;
                        for (n = 1; n < n4; ++n) {
                            long l3;
                            long l4;
                            string6 = fieldValueArray[n].getName();
                            if (string6.equalsIgnoreCase("TS_TSK_COMPLETE")) {
                                Object v = ((HashMap)object).get("finishTime");
                                l4 = new Date().getTime();
                                l2 = l3 = v == null ? l4 : CSUtil.parseLong((String)v);
                                fieldValueArray[n].setValue(new Timestamp(l3));
                                continue;
                            }
                            if (string6.equalsIgnoreCase("TS_ENG_EXITS")) {
                                Object v = ((HashMap)object).get("finishTime");
                                l4 = new Date().getTime();
                                l2 = l3 = v == null ? l4 : CSUtil.parseLong((String)v);
                                fieldValueArray[n].setValue(new Timestamp(l3));
                                continue;
                            }
                            if (string6.equalsIgnoreCase("VI_TSK_STATUS")) {
                                int n5 = CSUtil.parseInt((String)hashtable.get("taskStatus"));
                                n5 = n5 == 9 ? 1 : (n5 == 10 ? 0 : 2);
                                fieldValueArray[n].setValue(n5);
                                continue;
                            }
                            if (!string6.equalsIgnoreCase("TS_TSK_SUBMIT")) continue;
                            l = fieldValueArray[n].getTimestamp().getTime();
                        }
                        for (n = 1; n < n4; ++n) {
                            string6 = fieldValueArray[n].getName();
                            if (!string6.equalsIgnoreCase("TC_TSK_TOTAL") && !string6.equalsIgnoreCase("TC_ENG_TOTAL")) continue;
                            fieldValueArray[n].setValue(l2 - l);
                        }
                        n = fieldValueArray[0].getInt();
                        try {
                            this.AverageCount.update(fieldValueArray, " where ID =?", new ParameterMetaInfo().add("id", n));
                        }
                        catch (SQLException sQLException) {
                            ServiceLogger.logError(sQLException);
                        }
                        this.equals.remove(string3);
                    }
                } else {
                    int n;
                    FieldValue[] fieldValueArray;
                    Object object2;
                    String string7 = (String)hashtable.get("rptName");
                    if (null != string7 && string7.endsWith(".cls")) {
                        return;
                    }
                    if (hashtable.size() == 3 && hashtable.containsKey("rptSource")) {
                        return;
                    }
                    if (hashtable.containsKey("taskStatus") && "4".equals(object2 = (String)hashtable.get("taskStatus"))) {
                        return;
                    }
                    if (hashtable.containsKey("finishTime")) {
                        return;
                    }
                    ((HashMap)object).put("TASK_TYPE", "Non-DHTML");
                    object2 = hashtable.keys();
                    boolean bl = false;
                    while (object2.hasMoreElements()) {
                        fieldValueArray = (FieldValue[])object2.nextElement();
                        if (fieldValueArray.equalsIgnoreCase("taskID")) continue;
                        if (fieldValueArray.equalsIgnoreCase("submitTime")) {
                            ((HashMap)object).put("TS_TSK_SUBMIT", CSUtil.parseLong((String)hashtable.get(fieldValueArray)));
                            ((HashMap)object).put("TS_ENG_START", CSUtil.parseLong((String)hashtable.get(fieldValueArray)));
                            ((HashMap)object).put("TS_ENG_EXITS", CSUtil.parseLong((String)hashtable.get(fieldValueArray)));
                            ((HashMap)object).put("TS_TSK_COMPLETE", CSUtil.parseLong((String)hashtable.get(fieldValueArray)));
                            continue;
                        }
                        if (fieldValueArray.equalsIgnoreCase("rptSource")) continue;
                        if (fieldValueArray.equalsIgnoreCase("rptName")) {
                            ((HashMap)object).put("VS_RPT_NAME", (String)hashtable.get(fieldValueArray));
                            bl = true;
                            continue;
                        }
                        if (fieldValueArray.equalsIgnoreCase("taskStatus")) {
                            int n6 = CSUtil.parseInt((String)hashtable.get(fieldValueArray));
                            n6 = n6 == 9 ? 1 : (n6 == 10 ? 0 : 2);
                            ((HashMap)object).put("VI_TSK_STATUS", n6);
                            continue;
                        }
                        if (!fieldValueArray.equalsIgnoreCase("taskType")) continue;
                        Object v = hashtable.get(fieldValueArray);
                        if (5 == CSUtil.parseInt((String)hashtable.get(fieldValueArray))) {
                            ((HashMap)object).put("TASK_TYPE", "DHTML");
                        }
                        ((HashMap)object).put("VI_TSK_TYPE", 0);
                    }
                    if (!bl) {
                        ((HashMap)object).put("VS_RPT_NAME", "New");
                    }
                    ((HashMap)object).put("TC_TSK_WAITED", 0);
                    ((HashMap)object).put("TC_TSK_TOTAL", 0);
                    ((HashMap)object).put("TC_ENG_TOTAL", 0);
                    ((HashMap)object).put("TC_ENG_LOAD", 0);
                    ((HashMap)object).put("TC_ENG_EXPORT", 0);
                    ((HashMap)object).put("TC_ENG_OTHER", 0);
                    ((HashMap)object).put("TC_TSK_OTHER", 0);
                    ((HashMap)object).put("NC_RPT_PAGES", 0);
                    ((HashMap)object).put("NC_RPT_FORMATS", 0);
                    ((HashMap)object).put("NC_ENG_CONCURRENT", 0);
                    ((HashMap)object).put("NC_QUE_LENGTH", 0);
                    fieldValueArray = this.AverageCount.fields().values();
                    fieldValueArray[0].setValue(this.AverageCount.getID());
                    int n7 = fieldValueArray.length;
                    for (n = 1; n < n7; ++n) {
                        String string8 = fieldValueArray[n].getName();
                        Object v = ((HashMap)object).get(string8);
                        if (string8.startsWith("TS")) {
                            long l = v == null ? 0L : (Long)v;
                            fieldValueArray[n].setValue(new Timestamp(l));
                            continue;
                        }
                        if (v != null) {
                            fieldValueArray[n].setValue(v);
                            continue;
                        }
                        if (!((HashMap)object).containsKey(string8)) continue;
                        ServiceLogger.logError(3600295, 3);
                        return;
                    }
                    n = -1;
                    n = this.AverageCount.getID();
                    fieldValueArray[0].setValue(n);
                    try {
                        this.AverageCount.insert(fieldValueArray);
                    }
                    catch (SQLException sQLException) {
                        ServiceLogger.logError(sQLException);
                    }
                    this.equals.put(string3, fieldValueArray);
                }
            }
        }
    }

    private void AverageBase() {
        this.PercentCount = AverageTimer.createCounter("TotalTasks", CounterType.AverageBase, null);
        this.PercentCount.setCounterHelp("Total of completed task since this counter initialize.");
        this.SEDU = AverageTimer.createCounter("PercentOfSuccessful", CounterType.PercentCount, this.PercentCount);
        this.SEDU.setCounterHelp("Percent of successful in total complected tasks.");
        this.add = AverageTimer.createCounter("PercentOfOndemand", CounterType.PercentCount, this.PercentCount);
        this.add.setCounterHelp("Percent of on-demand type in total completed tasks.");
        this.close = AverageTimer.createCounter("AverageOfWaited", CounterType.AverageTimer, this.PercentCount);
        this.close.setCounterHelp("Average waited time(ms) before the task is launched.");
        this.containsKey = AverageTimer.createCounter("AverageOfEngine", CounterType.AverageTimer, this.PercentCount);
        this.containsKey.setCounterHelp("Average cost engine time(ms) per report.");
        this.createCategory = AverageTimer.createCounter("AverageOfPages", CounterType.AverageCount, this.PercentCount);
        this.createCategory.setCounterHelp("Average pages per report exports.");
        this.createCounter = AverageTimer.createCounter("AverageOfQueue", CounterType.AverageCount, this.PercentCount);
        this.createCounter.setCounterHelp("Average queue length of this report server.");
        this.destroy = AverageTimer.createCounter("AverageOfConcurrent", CounterType.AverageCount, this.PercentCount);
        this.destroy.setCounterHelp("Average concurrent engines of this report server.");
    }
}

