/*
 * Decompiled with CFR 0.152.
 */
package jet.server.profiling.jreport.performance;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import jet.datasource.JRUserDataSource;
import jet.datasource.JRUserDataSourceException;
import jet.server.api.db.Field;
import jet.server.api.db.FieldValue;
import jet.server.api.db.JDBCType;
import jet.server.db.core.FieldImpl;
import jet.server.db.core.MemResultSet;
import jet.server.log.ServiceLogger;
import jet.server.profiling.jreport.performance.monitor.PerformanceCollector;

public class UDS4PerformanceChart
implements JRUserDataSource {
    public static final String COL_WAITING_RPT_NUM = "Waiting Report Number";
    public static final String COL_RUNNING_RPT_NUMB = "Running Report Number";
    public static final String COL_FINISHED_RPT_NUM = "Finished Report Number";
    public static final String COL_FINISHED_RPT_PAGES = "Finished Report Pages";
    public static final String COL_AVG_WAITING_TIME = "Report Average Waiting Time";
    public static final String COL_AVG_PROCESSING_TIME = "Report Average Processing Time";
    public static final String COL_AVG_SUBMIT_NUM = "Average Submit Task Number";
    public static final String COL_SESSION_NUM = "Valid User Session Number";
    public static final String COL_DBCONNECTION_NUM = "Database Connection Number";

    public ResultSet getResultSet(String string) throws JRUserDataSourceException {
        ServiceLogger.logDebug("UDS4PerformanceChart:: getResultSet: " + this, 6);
        PerformanceCollector performanceCollector = PerformanceCollector.getInstance();
        ArrayList<FieldImpl> arrayList = new ArrayList<FieldImpl>();
        arrayList.add(new FieldImpl(COL_WAITING_RPT_NUM, JDBCType.INTEGER, 0, 0));
        arrayList.add(new FieldImpl(COL_RUNNING_RPT_NUMB, JDBCType.INTEGER, 0, 0));
        arrayList.add(new FieldImpl(COL_FINISHED_RPT_NUM, JDBCType.INTEGER, 0, 0));
        arrayList.add(new FieldImpl(COL_FINISHED_RPT_PAGES, JDBCType.INTEGER, 0, 0));
        arrayList.add(new FieldImpl(COL_AVG_WAITING_TIME, JDBCType.INTEGER, 0, 0));
        arrayList.add(new FieldImpl(COL_AVG_PROCESSING_TIME, JDBCType.INTEGER, 0, 0));
        arrayList.add(new FieldImpl(COL_AVG_SUBMIT_NUM, JDBCType.INTEGER, 0, 0));
        arrayList.add(new FieldImpl(COL_SESSION_NUM, JDBCType.INTEGER, 0, 0));
        arrayList.add(new FieldImpl(COL_DBCONNECTION_NUM, JDBCType.INTEGER, 0, 0));
        MemResultSet memResultSet = new MemResultSet(arrayList.toArray(new Field[arrayList.size()]));
        memResultSet.insertRow(this.INTEGER(performanceCollector, arrayList));
        return memResultSet;
    }

    public void releaseResultSet() throws JRUserDataSourceException {
    }

    private FieldValue[] INTEGER(PerformanceCollector performanceCollector, List list) {
        ArrayList<FieldValue> arrayList = new ArrayList<FieldValue>();
        block11: for (int i = 0; i < list.size(); ++i) {
            Field field = (Field)list.get(i);
            FieldValue fieldValue = field.createFieldValue();
            arrayList.add(fieldValue);
            switch (i) {
                case 0: {
                    fieldValue.setValue(performanceCollector.getWaitingRptNums());
                    continue block11;
                }
                case 1: {
                    fieldValue.setValue(performanceCollector.getRunningRptNums());
                    continue block11;
                }
                case 2: {
                    fieldValue.setValue(performanceCollector.getFinishedRptNums());
                    continue block11;
                }
                case 3: {
                    fieldValue.setValue(performanceCollector.getFinishedRptPages());
                    continue block11;
                }
                case 4: {
                    fieldValue.setValue(performanceCollector.getAvgWaitTimeByRpt() / 1000);
                    continue block11;
                }
                case 5: {
                    fieldValue.setValue(performanceCollector.getAvgProcessTimeByRpt() / 1000);
                    continue block11;
                }
                case 6: {
                    fieldValue.setValue(performanceCollector.getAvgSubmitRptNumsByUser());
                    continue block11;
                }
                case 7: {
                    fieldValue.setValue(performanceCollector.getValidUserSessionNums());
                    continue block11;
                }
                case 8: {
                    fieldValue.setValue(performanceCollector.getCurrentConnectionNums());
                }
            }
        }
        return arrayList.toArray(new FieldValue[arrayList.size()]);
    }
}

