/*
 * Decompiled with CFR 0.152.
 */
package jet.server.resstore.impl;

import com.jinfonet.resstore.ResourceLoadException;
import com.jinfonet.resstore.ResourceNotFoundException;
import com.jinfonet.resstore.ResourceStore;
import com.jinfonet.resstore.SpaceAllocator;
import com.jinfonet.resstore.loader.CacheableLoader;
import com.jinfonet.resstore.loader.CatalogIDImpl;
import com.jinfonet.resstore.loader.ImageIDImpl;
import com.jinfonet.resstore.loader.ReportIDImpl;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import jet.cache.Cache;
import jet.cache.CacheImpl;
import jet.cache.CacheManager;
import jet.controls.JetObject;
import jet.cs.CSUtil;
import jet.jetc.JetObjectLoader;
import jet.jetc.UniverseLoader;
import jet.server.ServerEnv;
import jet.server.api.http.HttpUtil;
import jet.server.jrc.resource.ResourceTreeManagerImpl;
import jet.server.jrc.security.UserDataToolkit;
import jet.server.jrc.version.SimpleVersionInfo;
import jet.server.log.ServiceLogger;
import jet.server.resstore.ServerMemoryStore;
import jet.server.resstore.SpaceAllocatorExt;
import jet.server.resstore.impl.JRServerResourceStore;
import jet.server.resstore.impl.JRServerSpaceAllocator;
import jet.server.schedule.JRServerEnv;
import jet.server.util.StringUtils;
import jet.universe.JetUUniverse;
import jet.util.image.ImageResource;
import jet.util.image.ImageResourceLoader;

public class JRServerMemoryStore
implements ServerMemoryStore {
    private static final String SEDU = "CRD";
    private JRServerResourceStore addCache;
    private final String append;
    private final JRServerMemoryStore equals;
    private final JRServerSpaceAllocator getActiveRealm;
    private CacheableLoader getCache;
    private CacheableLoader getCanonicalPath;
    private CacheableLoader getHttpRptServer;
    private CacheManager getRealPath;
    private JRServerSpaceAllocator getResourceManager;

    public JRServerMemoryStore(JRServerResourceStore jRServerResourceStore, String string, JRServerMemoryStore jRServerMemoryStore, JRServerSpaceAllocator jRServerSpaceAllocator) {
        this.addCache = jRServerResourceStore;
        this.append = string;
        this.equals = jRServerMemoryStore;
        this.getActiveRealm = jRServerSpaceAllocator;
        this.getCache = new UniverseLoader();
        this.getCache.setSpaceAllocator((SpaceAllocator)jRServerSpaceAllocator);
        this.getCanonicalPath = new JetObjectLoader();
        this.getCanonicalPath.setSpaceAllocator((SpaceAllocator)jRServerSpaceAllocator);
        this.getHttpRptServer = new ImageResourceLoader();
        this.getHttpRptServer.setSpaceAllocator((SpaceAllocator)jRServerSpaceAllocator);
        this.getRealPath = new CacheManager();
        this.getResourceManager = new JRServerSpaceAllocator("MemoryStore-Cube[" + string + "]", true, this.getActiveRealm);
    }

    public String toString() {
        return "MemoryStore@" + this.append;
    }

    private boolean SEDU(File file, boolean bl) throws ResourceNotFoundException {
        if (this.equals == null) {
            return true;
        }
        try {
            ResourceTreeManagerImpl resourceTreeManagerImpl = UserDataToolkit.getResourceManager(ServerEnv.getActiveRealm());
            SimpleVersionInfo simpleVersionInfo = resourceTreeManagerImpl.getResourceVersionByDiskPath(file.getCanonicalPath());
            if (simpleVersionInfo != null) {
                return this.addCache(simpleVersionInfo.getResourcePath());
            }
            ServiceLogger.logDebug("ResourceStore:: " + this + ":: not found the resource path For the disk path: " + file, 3);
            return true;
        }
        catch (IOException iOException) {
            throw new ResourceNotFoundException((Throwable)iOException);
        }
    }

    private boolean addCache(String string) {
        String[] stringArray = CSUtil.parseVirtualResourcePath(string);
        if (StringUtils.equals(stringArray[0], this.append)) {
            return true;
        }
        if (this.equals == null) {
            ServiceLogger.logDebug("ResourceStore:: " + this + ":: inconsistent organization resource access: " + string, 3);
            return true;
        }
        return false;
    }

    private File append(String string, String string2, int n) throws ResourceNotFoundException {
        try {
            JRServerEnv jRServerEnv = (JRServerEnv)((Object)HttpUtil.getHttpRptServer().getResourceManager());
            return new File(jRServerEnv.getRealPath(string, string2, n));
        }
        catch (Exception exception) {
            throw new ResourceNotFoundException((Throwable)exception);
        }
    }

    private JetUUniverse equals(File file, boolean bl) throws ResourceNotFoundException, ResourceLoadException {
        ServiceLogger.logDebug("ResourceStore:: " + this + ":: loading Catalog: noCache=" + bl + ", catFile=" + file + ", space=" + this.getActiveRealm, 5);
        JetUUniverse jetUUniverse = (JetUUniverse)this.getCache.load((Object)new CatalogIDImpl(file), bl);
        ServiceLogger.logDebug("ResourceStore:: " + this + ":: loaded Catalog: catFile=" + file + ", space=" + this.getActiveRealm, 6);
        if (jetUUniverse != null) {
            jetUUniverse.setResourceStore((ResourceStore)this.addCache);
        }
        return jetUUniverse;
    }

    private JetObject getActiveRealm(File file, String string, Locale locale, boolean bl) throws ResourceNotFoundException, ResourceLoadException {
        ServiceLogger.logDebug("ResourceStore:: " + this + ":: loading Report: noCache=" + bl + ", rptFile=" + file + ", space=" + this.getActiveRealm, 5);
        JetObject jetObject = (JetObject)this.getCanonicalPath.load((Object)new ReportIDImpl(file, string, locale), bl);
        ServiceLogger.logDebug("ResourceStore:: " + this + ":: loaded Report: rptFile=" + file + ", space=" + this.getActiveRealm, 6);
        return jetObject;
    }

    private ImageResource getCache(File file, String string, boolean bl) throws ResourceNotFoundException, ResourceLoadException {
        ServiceLogger.logDebug("ResourceStore:: " + this + ":: loading Image: noCache=" + bl + ", catFile=" + file + ", image=" + string + ", space=" + this.getActiveRealm, 5);
        ImageResource imageResource = (ImageResource)this.getHttpRptServer.load((Object)new ImageIDImpl(file, string), bl);
        ServiceLogger.logDebug("ResourceStore:: " + this + ":: loaded Image: catFile=" + file + ", image=" + string + ", space=" + this.getActiveRealm, 6);
        return imageResource;
    }

    @Override
    public JetUUniverse loadCatalog(String string, String string2, int n) throws ResourceNotFoundException, ResourceLoadException {
        File file = this.append(string, string2, n);
        if (this.addCache(string2)) {
            return this.equals(file, false);
        }
        ServiceLogger.logDebug("ResourceStore:: " + this + ":: delegate parent load: " + string2, 4);
        return this.equals.equals(file, false);
    }

    public JetUUniverse loadCatalog(File file) throws ResourceNotFoundException, ResourceLoadException {
        return this.loadCatalog(file, false);
    }

    public JetUUniverse loadCatalogNoCache(File file) throws ResourceNotFoundException, ResourceLoadException {
        return this.loadCatalog(file, true);
    }

    protected JetUUniverse loadCatalog(File file, boolean bl) throws ResourceNotFoundException, ResourceLoadException {
        if (this.SEDU(file, true)) {
            return this.equals(file, bl);
        }
        ServiceLogger.logDebug("ResourceStore:: " + this + ":: delegate parent load: " + file, 4);
        return this.equals.equals(file, bl);
    }

    @Override
    public JetObject loadReport(String string, String string2, int n, String string3, Locale locale) throws ResourceNotFoundException, ResourceLoadException {
        File file = this.append(string, string2, n);
        if (this.addCache(string2)) {
            return this.getActiveRealm(file, string3, locale, false);
        }
        ServiceLogger.logDebug("ResourceStore:: " + this + ":: delegate parent load cat: " + string2, 4);
        return this.equals.getActiveRealm(file, string3, locale, false);
    }

    public JetObject loadReport(File file, String string, Locale locale) throws ResourceNotFoundException, ResourceLoadException {
        return this.loadReport(file, string, locale, false);
    }

    public JetObject loadReportNoCache(File file, String string, Locale locale) throws ResourceNotFoundException, ResourceLoadException {
        return this.loadReport(file, string, locale, true);
    }

    protected JetObject loadReport(File file, String string, Locale locale, boolean bl) throws ResourceNotFoundException, ResourceLoadException {
        if (this.SEDU(file, false)) {
            return this.getActiveRealm(file, string, locale, bl);
        }
        ServiceLogger.logDebug("ResourceStore:: " + this + ":: delegate to parent load rpt: " + file, 4);
        return this.equals.getActiveRealm(file, string, locale, bl);
    }

    @Override
    public ImageResource loadImage(String string, String string2, int n, String string3) throws ResourceNotFoundException, ResourceLoadException {
        File file = this.append(string, string2, n);
        if (this.addCache(string2)) {
            return this.getCache(file, string3, false);
        }
        ServiceLogger.logDebug("ResourceStore:: " + this + ":: delegate to parent load img: " + string2 + "]" + string3, 4);
        return this.equals.getCache(file, string3, false);
    }

    public ImageResource loadImage(File file, String string) throws ResourceNotFoundException, ResourceLoadException {
        if (this.SEDU(file, true)) {
            return this.getCache(file, string, false);
        }
        ServiceLogger.logDebug("ResourceStore:: " + this + ":: delegate to parent load: " + file + "]" + string, 4);
        return this.equals.getCache(file, string, false);
    }

    @Override
    public SpaceAllocatorExt getSpaceAllocator() {
        return this.getActiveRealm;
    }

    @Override
    public CacheableLoader getCatalogLoader() {
        return this.getCache;
    }

    @Override
    public CacheableLoader getReportLoader() {
        return this.getCanonicalPath;
    }

    @Override
    public CacheableLoader getImageLoader() {
        return this.getHttpRptServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cache getCrdCache() {
        Cache cache = this.getRealPath.getCache(SEDU);
        if (cache == null) {
            CacheManager cacheManager = this.getRealPath;
            synchronized (cacheManager) {
                cache = this.getRealPath.getCache(SEDU);
                if (cache == null) {
                    cache = new CacheImpl(SEDU, this.getActiveRealm);
                    this.getRealPath.addCache(cache);
                }
            }
        }
        return cache;
    }

    @Override
    public SpaceAllocatorExt getCubeSpaceAllocator() {
        return this.getResourceManager;
    }
}

