/*
 * Decompiled with CFR 0.152.
 */
package jet.server.resstore.impl;

import java.util.concurrent.locks.ReentrantLock;
import jet.cache.CacheCeilingSpaceControler;
import jet.server.log.ServiceLogger;
import jet.server.resstore.SpaceAllocatorExt;

class JRServerSpaceAllocator
implements SpaceAllocatorExt,
CacheCeilingSpaceControler {
    private SpaceAllocatorExt SEDU;
    private String allocate;
    private ReentrantLock allocateForce = new ReentrantLock();
    private boolean append;
    private long deallocate;
    private volatile long getFreeSpace;

    public JRServerSpaceAllocator(String string, boolean bl) {
        this(string, bl, null);
    }

    public JRServerSpaceAllocator(String string, boolean bl, SpaceAllocatorExt spaceAllocatorExt) {
        this.allocate = string;
        this.append = bl;
        this.SEDU = spaceAllocatorExt;
    }

    public String toString() {
        return this.allocate + "[" + this.getFreeSpace + "/" + this.deallocate + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxSpace(long l) {
        this.SEDU();
        try {
            if (l < 0L) {
                throw new IllegalArgumentException("the Max Space maust be equal or greater than zero.");
            }
            this.deallocate = l;
            ServiceLogger.logDebug("ResourceStore:: " + this.toString() + ": setMaxSpace to " + l, 4);
        }
        finally {
            this.allocate();
        }
    }

    private void SEDU() {
        this.allocateForce.lock();
    }

    private void allocate() {
        this.allocateForce.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean allocate(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        if (l == 0L) {
            return true;
        }
        this.SEDU();
        try {
            boolean bl = false;
            if (this.getFreeSpace() >= l && (this.SEDU == null || this.SEDU.allocate(l))) {
                this.getFreeSpace += l;
                bl = true;
            }
            if (this.append) {
                ServiceLogger.logDebug("ResourceStore:: " + this.toString() + ": allocate " + l + ", " + bl, 6);
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            this.allocate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deallocate(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        if (l == 0L) {
            return;
        }
        this.SEDU();
        try {
            this.getFreeSpace = l > this.getFreeSpace ? 0L : (this.getFreeSpace -= l);
            if (this.SEDU != null) {
                this.SEDU.deallocate(l);
            }
            if (this.append) {
                ServiceLogger.logDebug("ResourceStore:: " + this.toString() + ": deallocate " + l, 6);
            }
        }
        finally {
            this.allocate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean allocateForce(long l) {
        if (l == 0L) {
            return true;
        }
        this.SEDU();
        try {
            boolean bl;
            boolean bl2;
            this.getFreeSpace += l;
            if (this.getFreeSpace < 0L) {
                this.getFreeSpace = 0L;
            }
            boolean bl3 = bl2 = l < 0L || this.getFreeSpace <= this.deallocate;
            if (this.SEDU != null) {
                bl = this.SEDU.allocateForce(l);
                bl2 = bl2 && bl;
            }
            ServiceLogger.logDebug("ResourceStore:: " + this.toString() + ": allocateForce " + l + ", " + bl2, 6);
            bl = bl2;
            return bl;
        }
        finally {
            this.allocate();
        }
    }

    public long getMaxSpace() {
        return this.deallocate;
    }

    public long getUsedSpace() {
        return this.getFreeSpace;
    }

    public long getFreeSpace() {
        return this.deallocate - this.getFreeSpace;
    }

    public boolean hasFreeSpace() {
        return this.getFreeSpace() > 0L;
    }
}

