/*
 * Decompiled with CFR 0.152.
 */
package jet.server.resstore.impl;

import com.jinfonet.resstore.DiskStore;
import com.jinfonet.resstore.OutOfSpaceException;
import java.io.File;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import jet.server.log.ServiceLogger;
import jet.server.resstore.SpaceAllocatorExt;
import jet.server.resstore.impl.JRServerSpaceAllocator;
import jet.server.util.IOUtil;

public class RealDiskStore
implements DiskStore {
    private ReentrantLock SEDU = new ReentrantLock();
    private final String abs;
    private final File allocateForce;
    private final File append;
    private final JRServerSpaceAllocator containsKey;
    private SecureRandom createNewFile = new SecureRandom();
    private Map createTempFile = new HashMap();

    public RealDiskStore(String string, File file, File file2, JRServerSpaceAllocator jRServerSpaceAllocator) {
        this.abs = string;
        this.allocateForce = file;
        this.append = file2;
        this.containsKey = jRServerSpaceAllocator;
        file.mkdirs();
    }

    public String toString() {
        return "DiskStore@" + this.abs + "[files=" + this.createTempFile.size() + ", spaceAllocator=" + this.containsKey + "]";
    }

    public File getTempRoot() {
        return this.allocateForce;
    }

    public File createTempFile(String string, String string2) throws OutOfSpaceException, IOException {
        return this.SEDU(this.allocateForce, string, string2);
    }

    public File createTempFile(String string, String string2, String string3) throws OutOfSpaceException, IOException {
        return this.SEDU(new File(this.allocateForce, string), string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File SEDU(File file, String string, String string2) throws IOException, OutOfSpaceException {
        this.SEDU.lock();
        try {
            ServiceLogger.logDebug("ResourceStore:: " + this + ": createTempFile, dir=" + file, 6);
            if (!this.containsKey.hasFreeSpace()) {
                throw new OutOfSpaceException();
            }
            string = this.abs(string);
            if (string2 == null) {
                string2 = "";
            }
            File file2 = File.createTempFile(string, string2, file);
            this.fileUpdated(file2);
            ServiceLogger.logDebug("ResourceStore:: " + this + ": createTempFile successed, ret=" + file2, 6);
            File file3 = file2;
            return file3;
        }
        finally {
            this.SEDU.unlock();
        }
    }

    public File createTempFolder(String string) throws OutOfSpaceException, IOException {
        return this.createTempFolder0(this.allocateForce, string);
    }

    public File createTempFolder(String string, String string2) throws OutOfSpaceException, IOException {
        return this.createTempFolder0(new File(this.allocateForce, string), string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File createTempFolder0(File file, String string) throws OutOfSpaceException, IOException {
        this.SEDU.lock();
        try {
            ServiceLogger.logDebug("ResourceStore:: " + this + ": createTempFolder, dir=" + file, 6);
            if (!this.containsKey.hasFreeSpace()) {
                throw new OutOfSpaceException();
            }
            string = this.abs(string);
            File file2 = null;
            while (!(file2 = this.allocateForce(file, string, "")).mkdir()) {
            }
            this.fileUpdated(file2);
            ServiceLogger.logDebug("ResourceStore:: " + this + ": createTempFolder successed, ret=" + file2, 6);
            File file3 = file2;
            return file3;
        }
        finally {
            this.SEDU.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File createFile(String string) throws OutOfSpaceException, IOException {
        this.SEDU.lock();
        try {
            ServiceLogger.logDebug("ResourceStore:: " + this + ": createFile, path=" + string, 6);
            if (!this.containsKey.hasFreeSpace()) {
                throw new OutOfSpaceException();
            }
            File file = new File(string);
            file.getParentFile().mkdirs();
            if (!file.createNewFile()) {
                ServiceLogger.logDebug("ResourceStore:: " + this + ": the file to be create already exists: " + string, 3);
            }
            this.fileUpdated(file);
            ServiceLogger.logDebug("ResourceStore:: " + this + ": createFile successed, ret=" + file, 6);
            File file2 = file;
            return file2;
        }
        finally {
            this.SEDU.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileUpdated(File file) throws OutOfSpaceException, IOException {
        if (IOUtil.isParents(this.append, file)) {
            return;
        }
        this.SEDU.lock();
        try {
            ServiceLogger.logDebug("ResourceStore:: " + this + ": fileUpdated, file=" + file, 6);
            long l = 0L;
            File file2 = this.append(file);
            if (file2 == null) {
                file2 = file;
                l = this.containsKey(file2);
            } else {
                l = (Long)this.createTempFile.get(file2);
            }
            long l2 = 0L;
            if (file2.exists()) {
                long l3 = IOUtil.getFileLength(file2);
                l2 = l3 - l;
                this.createTempFile.put(file2, l3);
            } else {
                l2 = -l;
                this.createTempFile.remove(file2);
            }
            ServiceLogger.logDebug("ResourceStore:: " + this + ": fileUpdated, delta=" + l2 + ", file=" + file, 6);
            if (!this.containsKey.allocateForce(l2)) {
                throw new OutOfSpaceException();
            }
        }
        finally {
            this.SEDU.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(File file) {
        this.SEDU.lock();
        try {
            ServiceLogger.logDebug("ResourceStore:: " + this + ": delete, file=" + file, 6);
            IOUtil.deleteFile(file);
            long l = 0L;
            File file2 = this.append(file);
            if (file2 == null) {
                ServiceLogger.logDebug("ResourceStore:: " + this + ": delete: file is not in the store: " + file, 4);
            } else {
                if (file2 != file) {
                    long l2 = IOUtil.getFileLength(file2);
                    l = l2 - this.createTempFile.put(file2, l2);
                } else {
                    Long l3 = (Long)this.createTempFile.remove(file2);
                    l = -l3.longValue();
                }
                this.containsKey.allocateForce(l);
            }
            ServiceLogger.logDebug("ResourceStore:: " + this + ": deleted, delta=" + l + ", file=" + file, 5);
        }
        finally {
            this.SEDU.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(File file) {
        this.SEDU.lock();
        try {
            ServiceLogger.logDebug("ResourceStore:: " + this + ": remove, file=" + file, 6);
            Long l = (Long)this.createTempFile.remove(file);
            if (l == null) {
                ServiceLogger.logDebug("ResourceStore:: " + this + ": remove: file is not in the store: " + file, 4);
            } else {
                this.containsKey.allocateForce(-l.longValue());
            }
            ServiceLogger.logDebug("ResourceStore:: " + this + ": remove: delta=" + l + ", file=" + file, 5);
        }
        finally {
            this.SEDU.unlock();
        }
    }

    public SpaceAllocatorExt getSpaceAllocator() {
        return this.containsKey;
    }

    private String abs(String string) {
        int n = 3;
        if (string == null) {
            string = String.format("%03d", 0);
        } else if (string.length() < 3) {
            string = String.format("%s%0" + (3 - string.length()) + "d", string, 0);
        }
        return string;
    }

    private File allocateForce(File file, String string, String string2) {
        long l = this.createNewFile.nextLong();
        l = l == Long.MIN_VALUE ? 0L : Math.abs(l);
        return new File(file, string + Long.toString(l) + string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshFiles() {
        this.SEDU.lock();
        try {
            ServiceLogger.logDebug("ResourceStore:: " + this + ": starting refresh files", 4);
            Iterator iterator = this.createTempFile.entrySet().iterator();
            while (iterator.hasNext()) {
                long l;
                Map.Entry entry = iterator.next();
                File file = (File)entry.getKey();
                long l2 = (Long)entry.getValue();
                if (!file.exists()) {
                    l = -l2;
                    this.containsKey.allocateForce(l);
                    iterator.remove();
                    ServiceLogger.logDebug("ResourceStore:: " + this + ": refresh deleted file " + file, 4);
                    continue;
                }
                l = IOUtil.getFileLength(file);
                long l3 = l - l2;
                if (l3 == 0L) continue;
                entry.setValue(l);
                this.containsKey.allocateForce(l3);
                ServiceLogger.logDebug("ResourceStore:: " + this + ": refresh updated file " + file, 4);
            }
            ServiceLogger.logDebug("ResourceStore:: " + this + ": end refresh files", 4);
        }
        finally {
            this.SEDU.unlock();
        }
    }

    private File append(File file) {
        for (File file2 = file; file2 != null; file2 = file2.getParentFile()) {
            if (!this.createTempFile.containsKey(file2)) continue;
            return file2;
        }
        return null;
    }

    private long containsKey(File file) {
        long l = 0L;
        if (!file.isDirectory()) {
            return l;
        }
        Iterator iterator = this.createTempFile.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!IOUtil.isParents(file, (File)entry.getKey())) continue;
            l += ((Long)entry.getValue()).longValue();
            iterator.remove();
        }
        return l;
    }
}

