/*
 * Decompiled with CFR 0.152.
 */
package jet.server.rmi.rpc.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import jet.cs.CSUtil;
import jet.server.ServerEnv;
import jet.server.api.http.HttpUtil;
import jet.server.log.ServiceLogger;
import jet.server.rmi.RemoteObjectFactory;
import jet.server.rmi.rpc.RpcDispatcher;
import jet.server.rmi.rpc.RpcParam;

public abstract class RemotableObjectUtil {
    private RpcDispatcher getClass;
    private String getClassLoader = null;
    private int getInterfaces = -1;

    protected RemotableObjectUtil() {
        if (HttpUtil.isRemoteServer()) {
            this.getClassLoader = System.getProperty("jrs.remote.host");
            this.getInterfaces = CSUtil.parseInt(System.getProperty("jrs.remote.rmiport"));
            try {
                this.getClass = RemoteObjectFactory.getRpcDispatcher(this.getClassLoader, this.getInterfaces);
            }
            catch (Exception exception) {
                ServiceLogger.logError(exception);
                throw new RuntimeException(exception);
            }
        } else {
            this.initLoad();
            if (ServerEnv.isClusterEnabled() || ServerEnv.isRMIServerEnable() || ServerEnv.isRMIMonitorEnable()) {
                RemoteObjectFactory.registerRpcHandler(this.getClass().getName(), this);
            }
        }
    }

    protected Object proxyIfRemote() {
        if (this.getClass == null) {
            return this;
        }
        final RemotableObjectUtil remotableObjectUtil = this;
        return Proxy.newProxyInstance(this.getClass().getClassLoader(), this.getClass().getInterfaces(), new InvocationHandler(){

            @Override
            public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                RpcParam rpcParam = new RpcParam(remotableObjectUtil.getClass().getName(), method.getName(), objectArray);
                rpcParam.setTypes(method.getParameterTypes());
                try {
                    return remotableObjectUtil.getClass.call(rpcParam);
                }
                catch (RemoteException remoteException) {
                    remotableObjectUtil.getClass = RemoteObjectFactory.getRpcDispatcher(RemotableObjectUtil.this.getClassLoader, RemotableObjectUtil.this.getInterfaces);
                    return remotableObjectUtil.getClass.call(rpcParam);
                }
            }
        });
    }

    protected boolean isRemoteServer() {
        return this.getClass != null;
    }

    protected abstract void initLoad();
}

