/*
 * Decompiled with CFR 0.152.
 */
package jet.server.schedule;

import guitools.toolkit.JDebug;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import jet.controls.JetBoolean;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetString;
import jet.cs.CSUtil;
import jet.cs.Schedule;
import jet.server.jrc.quartz.JRRepeatQuartzTrigger;
import jet.server.jrc.quartz.JRTrigger;
import jet.server.schedule.JetTimeLch;
import jet.server.schedule.RepeatLaunchableObj;
import jet.server.schedule.TimeLaunchableObj;

public class JetReptLch
extends JetTimeLch {
    protected JetNumber lastExeTime = new JetNumber((JetObject)this, "lastExeTime");
    protected JetBoolean isSuccessful = new JetBoolean((JetObject)this, "isSuccessful");
    protected JetNumber submitTime = new JetNumber((JetObject)this, "submitTime");
    protected JetNumber daysId = new JetNumber((JetObject)this, "daysId");
    protected JetBoolean isWeekday = new JetBoolean((JetObject)this, "isWeekday");
    protected JetNumber day = new JetNumber((JetObject)this, "day");
    protected JetNumber week = new JetNumber((JetObject)this, "week");
    protected JetString weekdays = new JetString((JetObject)this, "weekdays");
    protected JetBoolean isDay = new JetBoolean((JetObject)this, "isDay");
    protected JetNumber month = new JetNumber((JetObject)this, "month");
    protected JetNumber weekday = new JetNumber((JetObject)this, "weekday");
    protected JetBoolean isHourly = new JetBoolean((JetObject)this, "isHourly");
    protected JetBoolean isBetween = new JetBoolean((JetObject)this, "isBetween");
    protected JetNumber hours = new JetNumber((JetObject)this, "hours");
    protected JetNumber hour = new JetNumber((JetObject)this, "hour");
    protected JetNumber min = new JetNumber((JetObject)this, "min");
    protected JetBoolean isPM = new JetBoolean((JetObject)this, "isPM");
    protected JetNumber hour2 = new JetNumber((JetObject)this, "hour2");
    protected JetNumber min2 = new JetNumber((JetObject)this, "min2");
    protected JetBoolean isPM2 = new JetBoolean((JetObject)this, "isPM2");
    protected JetNumber atMin = new JetNumber((JetObject)this, "atMin");
    protected JetBoolean isMinutely = new JetBoolean((JetObject)this, "isMinutely");
    protected JetNumber minutes = new JetNumber((JetObject)this, "minutes");
    protected JetBoolean isAfter = new JetBoolean((JetObject)this, "isAfter");
    protected JetNumber afterYear = new JetNumber((JetObject)this, "afterYear");
    protected JetNumber afterMonth = new JetNumber((JetObject)this, "afterMonth");
    protected JetNumber afterDay = new JetNumber((JetObject)this, "afterDay");
    protected JetNumber afterHour = new JetNumber((JetObject)this, "afterHour");
    protected JetNumber afterMinute = new JetNumber((JetObject)this, "afterMinute");
    protected JetBoolean isBefore = new JetBoolean((JetObject)this, "isBefore");
    protected JetNumber ceaseYear = new JetNumber((JetObject)this, "ceaseYear");
    protected JetNumber ceaseMonth = new JetNumber((JetObject)this, "ceaseMonth");
    protected JetNumber ceaseDay = new JetNumber((JetObject)this, "ceaseDay");
    protected JetNumber ceaseHour = new JetNumber((JetObject)this, "ceaseHour");
    protected JetNumber ceaseMinute = new JetNumber((JetObject)this, "ceaseMinute");

    public JetReptLch() {
    }

    public JetReptLch(RepeatLaunchableObj repeatLaunchableObj, Vector vector) {
        super(repeatLaunchableObj, vector);
        this.lastExeTime.set(repeatLaunchableObj.getLastExeTime());
        Properties properties = repeatLaunchableObj.getSchedule().toProperties(new Properties());
        this.isSuccessful.set(String.valueOf(repeatLaunchableObj.isSuccessful()));
        try {
            String string = (String)properties.get("jrs.days_id");
            this.daysId.set(CSUtil.parseInt(string, 0));
            string = (String)properties.get("jrs.submit_time");
            this.submitTime.set(CSUtil.parseLong(string, System.currentTimeMillis()));
            switch (this.daysId.get()) {
                case 0: {
                    string = (String)properties.get("jrs.is_weekday");
                    this.isWeekday.set(CSUtil.getBoolean(string));
                    if (this.isWeekday.get()) break;
                    string = (String)properties.get("jrs.day");
                    this.day.set(CSUtil.parseInt(string, 1));
                    break;
                }
                case 1: {
                    string = (String)properties.get("jrs.week");
                    this.week.set(CSUtil.parseInt(string, 1));
                    this.weekdays.set((String)properties.get("jrs.weekdays"));
                    break;
                }
                case 2: {
                    string = (String)properties.get("jrs.is_day");
                    this.isDay.set(CSUtil.getBoolean(string));
                    if (this.isDay.get()) {
                        string = (String)properties.get("jrs.day");
                        this.day.set(CSUtil.parseInt(string, 1));
                    } else {
                        string = (String)properties.get("jrs.week");
                        this.week.set(CSUtil.parseInt(string, 1));
                        string = (String)properties.get("jrs.weekday");
                        this.weekday.set(CSUtil.parseInt(string, 2));
                    }
                    string = (String)properties.get("jrs.month");
                    this.month.set(CSUtil.parseInt(string, 1));
                }
            }
            string = (String)properties.get("jrs.is_hourly");
            this.isHourly.set(CSUtil.getBoolean(string));
            if (this.isHourly.get()) {
                string = (String)properties.get("jrs.hours");
                this.hours.set(CSUtil.parseInt(string, 1));
                string = (String)properties.get("jrs.at_min");
                this.atMin.set(CSUtil.parseInt(string, 0));
            } else {
                string = (String)properties.get("jrs.is_minutely");
                this.isMinutely.set(CSUtil.getBoolean(string));
                if (this.isMinutely.get()) {
                    string = (String)properties.get("jrs.minutes");
                    this.minutes.set(CSUtil.parseInt(string, 5));
                }
            }
            if (this.isHourly.get() || this.isMinutely.get()) {
                string = (String)properties.get("jrs.is_between");
                this.isBetween.set(CSUtil.getBoolean(string));
                if (this.isBetween.get()) {
                    string = (String)properties.get("jrs.hour");
                    this.hour.set(CSUtil.parseInt(string, 9));
                    string = (String)properties.get("jrs.min");
                    this.min.set(CSUtil.parseInt(string, 0));
                    string = (String)properties.get("jrs.is_pm");
                    this.isPM.set(CSUtil.getBoolean(string));
                    string = (String)properties.get("jrs.hour2");
                    this.hour2.set(CSUtil.parseInt(string, 5));
                    string = (String)properties.get("jrs.min2");
                    this.min2.set(CSUtil.parseInt(string, 0));
                    string = (String)properties.get("jrs.is_pm2");
                    this.isPM2.set(CSUtil.getBoolean(string));
                }
            } else {
                string = (String)properties.get("jrs.hour");
                this.hour.set(CSUtil.parseInt(string, 12));
                string = (String)properties.get("jrs.min");
                this.min.set(CSUtil.parseInt(string, 0));
                string = (String)properties.get("jrs.is_pm");
                this.isPM.set(CSUtil.getBoolean(string));
            }
            string = (String)properties.get("jrs.is_after");
            this.isAfter.set(CSUtil.getBoolean(string));
            if (this.isAfter.get()) {
                string = (String)properties.get("jrs.exe_year");
                this.afterYear.set(CSUtil.parseInt(string, 0));
                string = (String)properties.get("jrs.exe_month");
                this.afterMonth.set(CSUtil.parseInt(string, 0));
                string = (String)properties.get("jrs.exe_day");
                this.afterDay.set(CSUtil.parseInt(string, 0));
                string = (String)properties.get("jrs.exe_hour");
                this.afterHour.set(CSUtil.parseInt(string, 0));
                string = (String)properties.get("jrs.exe_min");
                this.afterMinute.set(CSUtil.parseInt(string, 0));
            }
            string = (String)properties.get("jrs.is_before");
            this.isBefore.set(CSUtil.getBoolean(string));
            if (this.isBefore.get()) {
                string = (String)properties.get("jrs.cease_year");
                this.ceaseYear.set(CSUtil.parseInt(string, 0));
                string = (String)properties.get("jrs.cease_month");
                this.ceaseMonth.set(CSUtil.parseInt(string, 0));
                string = (String)properties.get("jrs.cease_day");
                this.ceaseDay.set(CSUtil.parseInt(string, 0));
                string = (String)properties.get("jrs.cease_hour");
                this.ceaseHour.set(CSUtil.parseInt(string, 0));
                string = (String)properties.get("jrs.cease_min");
                this.ceaseMinute.set(CSUtil.parseInt(string, 0));
            }
        }
        catch (Exception exception) {
            JDebug.INFO((String)("!!!setSchedule Exception=" + exception.toString()));
        }
    }

    public long getLastExeTime() {
        return this.lastExeTime.longValue();
    }

    @Override
    public TimeLaunchableObj createLaunchableObj(Hashtable hashtable) {
        RepeatLaunchableObj repeatLaunchableObj = null;
        if (hashtable != null) {
            Properties properties = (Properties)hashtable.get(this.getTaskId());
            if (properties == null) {
                return null;
            }
            JDebug.INFO((String)("createLaunchableObj: id=" + this.getTaskId() + " task=" + properties + " timezone=" + this.getTimeZone() + " jetTimezone=" + this.timezone.get()));
            Schedule schedule = new Schedule();
            if (schedule.setSchedule(this.toHashtable(new Hashtable())) == null) {
                repeatLaunchableObj = new RepeatLaunchableObj(properties, schedule);
                repeatLaunchableObj.setUid(this.getUid());
                repeatLaunchableObj.setLastExeTime(this.getLastExeTime());
                repeatLaunchableObj.setNext(this.createNextLaunchableObj(hashtable));
                repeatLaunchableObj.setSuccessful(this.isSuccessful.get());
                repeatLaunchableObj.setEnabled(this.isEnabled.get());
            }
        }
        return repeatLaunchableObj;
    }

    @Override
    public JRTrigger createTrigger(Hashtable hashtable) {
        JRRepeatQuartzTrigger jRRepeatQuartzTrigger = null;
        if (hashtable != null) {
            Properties properties = (Properties)hashtable.get(this.getTaskId());
            if (properties == null) {
                return null;
            }
            JDebug.INFO((String)("createLaunchableObj: id=" + this.getTaskId() + " task=" + properties + " timezone=" + this.getTimeZone() + "jetTimezone=" + this.timezone.get()));
            String string = "JR_TRG_" + this.getTaskId();
            jRRepeatQuartzTrigger = new JRRepeatQuartzTrigger(string, "JR_DETAULT_GROUP");
            jRRepeatQuartzTrigger.setSchedule(this.toHashtable(new Hashtable()));
            jRRepeatQuartzTrigger.setUid(this.getUid());
            jRRepeatQuartzTrigger.setPreviousFireTime(new Date(this.getLastExeTime()));
            jRRepeatQuartzTrigger.setTaskID(this.getTaskId());
            jRRepeatQuartzTrigger.setEnable(this.isEnabled.get());
            jRRepeatQuartzTrigger.setTask(properties);
        }
        return jRRepeatQuartzTrigger;
    }

    @Override
    public Hashtable toHashtable(Hashtable hashtable) {
        String string;
        Hashtable<String, String> hashtable2 = super.toHashtable(hashtable);
        if (hashtable2 == null) {
            hashtable2 = new Hashtable<String, String>();
        }
        hashtable2.put("jrs.days_id", String.valueOf(this.daysId.get()));
        hashtable2.put("jrs.submit_time", String.valueOf(this.submitTime.get()));
        hashtable2.put("jrs.last_exe_time", String.valueOf(this.getLastExeTime()));
        hashtable2.put("jrs.is_successful", String.valueOf(this.isSuccessful.get()));
        hashtable2.put("jrs.is_enabled", String.valueOf(this.isEnabled.get()));
        switch (this.daysId.get()) {
            case 0: {
                hashtable2.put("jrs.is_weekday", String.valueOf(this.isWeekday.get()));
                if (this.isWeekday.get()) break;
                hashtable2.put("jrs.day", String.valueOf(this.day.get()));
                break;
            }
            case 1: {
                hashtable2.put("jrs.week", String.valueOf(this.week.get()));
                hashtable2.put("jrs.weekdays", this.weekdays.get());
                break;
            }
            case 2: {
                hashtable2.put("jrs.is_day", String.valueOf(this.isDay.get()));
                if (this.isDay.get()) {
                    hashtable2.put("jrs.day", String.valueOf(this.day.get()));
                } else {
                    hashtable2.put("jrs.week", String.valueOf(this.week.get()));
                    hashtable2.put("jrs.weekday", String.valueOf(this.weekday.get()));
                }
                hashtable2.put("jrs.month", String.valueOf(this.month.get()));
            }
        }
        hashtable2.put("jrs.is_hourly", String.valueOf(this.isHourly.get()));
        if (this.isHourly.get()) {
            hashtable2.put("jrs.hours", String.valueOf(this.hours.get()));
            hashtable2.put("jrs.at_min", String.valueOf(this.atMin.get()));
        } else {
            hashtable2.put("jrs.is_minutely", String.valueOf(this.isMinutely.get()));
            if (this.isMinutely.get()) {
                hashtable2.put("jrs.minutes", String.valueOf(this.minutes.get()));
            }
        }
        if (this.isHourly.get() || this.isMinutely.get()) {
            hashtable2.put("jrs.is_between", String.valueOf(this.isBetween.get()));
            if (this.isBetween.get()) {
                hashtable2.put("jrs.hour", String.valueOf(this.hour.get()));
                hashtable2.put("jrs.min", String.valueOf(this.min.get()));
                hashtable2.put("jrs.is_pm", String.valueOf(this.isPM.get()));
                hashtable2.put("jrs.hour2", String.valueOf(this.hour2.get()));
                hashtable2.put("jrs.min2", String.valueOf(this.min2.get()));
                hashtable2.put("jrs.is_pm2", String.valueOf(this.isPM2.get()));
            }
        } else {
            hashtable2.put("jrs.hour", String.valueOf(this.hour.get()));
            hashtable2.put("jrs.min", String.valueOf(this.min.get()));
            hashtable2.put("jrs.is_pm", String.valueOf(this.isPM.get()));
        }
        hashtable2.put("jrs.is_after", String.valueOf(this.isAfter.get()));
        if (this.isAfter.get()) {
            hashtable2.put("jrs.exe_year", String.valueOf(this.afterYear.get()));
            hashtable2.put("jrs.exe_month", String.valueOf(this.afterMonth.get()));
            hashtable2.put("jrs.exe_day", String.valueOf(this.afterDay.get()));
            hashtable2.put("jrs.exe_hour", String.valueOf(this.afterHour.get()));
            hashtable2.put("jrs.exe_min", String.valueOf(this.afterMinute.get()));
        }
        hashtable2.put("jrs.is_before", String.valueOf(this.isBefore.get()));
        if (this.isBefore.get()) {
            hashtable2.put("jrs.cease_year", String.valueOf(this.ceaseYear.get()));
            hashtable2.put("jrs.cease_month", String.valueOf(this.ceaseMonth.get()));
            hashtable2.put("jrs.cease_day", String.valueOf(this.ceaseDay.get()));
            hashtable2.put("jrs.cease_hour", String.valueOf(this.ceaseHour.get()));
            hashtable2.put("jrs.cease_min", String.valueOf(this.ceaseMinute.get()));
        }
        if ((string = this.getTimeZone()) != null) {
            hashtable2.put("jrs.timezone", string);
        }
        return hashtable2;
    }

    @Override
    public void init(Hashtable hashtable) throws Exception {
        super.init(hashtable);
        this.lastExeTime.set(CSUtil.parseLong(hashtable.get("jrs.last_exe_time").toString()));
        String string = (String)hashtable.get("jrs.days_id");
        this.daysId.set(CSUtil.parseInt(string, 0));
        string = (String)hashtable.get("jrs.is_successful");
        this.isSuccessful.set(CSUtil.getBoolean(string));
        string = (String)hashtable.get("jrs.is_enabled");
        this.isEnabled.set(CSUtil.getBoolean(string));
        string = (String)hashtable.get("jrs.submit_time");
        this.submitTime.set(CSUtil.parseLong(string, System.currentTimeMillis()));
        switch (this.daysId.get()) {
            case 0: {
                string = (String)hashtable.get("jrs.is_weekday");
                this.isWeekday.set(CSUtil.getBoolean(string));
                if (this.isWeekday.get()) break;
                string = (String)hashtable.get("jrs.day");
                this.day.set(CSUtil.parseInt(string, 1));
                break;
            }
            case 1: {
                string = (String)hashtable.get("jrs.week");
                this.week.set(CSUtil.parseInt(string, 1));
                this.weekdays.set((String)hashtable.get("jrs.weekdays"));
                break;
            }
            case 2: {
                string = (String)hashtable.get("jrs.is_day");
                this.isDay.set(CSUtil.getBoolean(string));
                if (this.isDay.get()) {
                    string = (String)hashtable.get("jrs.day");
                    this.day.set(CSUtil.parseInt(string, 1));
                } else {
                    string = (String)hashtable.get("jrs.week");
                    this.week.set(CSUtil.parseInt(string, 1));
                    string = (String)hashtable.get("jrs.weekday");
                    this.weekday.set(CSUtil.parseInt(string, 2));
                }
                string = (String)hashtable.get("jrs.month");
                this.month.set(CSUtil.parseInt(string, 1));
            }
        }
        string = (String)hashtable.get("jrs.is_hourly");
        this.isHourly.set(CSUtil.getBoolean(string));
        if (this.isHourly.get()) {
            string = (String)hashtable.get("jrs.hours");
            this.hours.set(CSUtil.parseInt(string, 1));
            string = (String)hashtable.get("jrs.at_min");
            this.atMin.set(CSUtil.parseInt(string, 0));
        } else {
            string = (String)hashtable.get("jrs.is_minutely");
            this.isMinutely.set(CSUtil.getBoolean(string));
            if (this.isMinutely.get()) {
                string = (String)hashtable.get("jrs.minutes");
                this.minutes.set(CSUtil.parseInt(string, 5));
            }
        }
        if (this.isHourly.get() || this.isMinutely.get()) {
            string = (String)hashtable.get("jrs.is_between");
            this.isBetween.set(CSUtil.getBoolean(string));
            if (this.isBetween.get()) {
                string = (String)hashtable.get("jrs.hour");
                this.hour.set(CSUtil.parseInt(string, 9));
                string = (String)hashtable.get("jrs.min");
                this.min.set(CSUtil.parseInt(string, 0));
                string = (String)hashtable.get("jrs.is_pm");
                this.isPM.set(CSUtil.getBoolean(string));
                string = (String)hashtable.get("jrs.hour2");
                this.hour2.set(CSUtil.parseInt(string, 5));
                string = (String)hashtable.get("jrs.min2");
                this.min2.set(CSUtil.parseInt(string, 0));
                string = (String)hashtable.get("jrs.is_pm2");
                this.isPM2.set(CSUtil.getBoolean(string));
            }
        } else {
            string = (String)hashtable.get("jrs.hour");
            this.hour.set(CSUtil.parseInt(string, 12));
            string = (String)hashtable.get("jrs.min");
            this.min.set(CSUtil.parseInt(string, 0));
            string = (String)hashtable.get("jrs.is_pm");
            this.isPM.set(CSUtil.getBoolean(string));
        }
        string = (String)hashtable.get("jrs.is_after");
        this.isAfter.set(CSUtil.getBoolean(string));
        if (this.isAfter.get()) {
            string = (String)hashtable.get("jrs.exe_year");
            this.afterYear.set(CSUtil.parseInt(string, 0));
            string = (String)hashtable.get("jrs.exe_month");
            this.afterMonth.set(CSUtil.parseInt(string, 0));
            string = (String)hashtable.get("jrs.exe_day");
            this.afterDay.set(CSUtil.parseInt(string, 0));
            string = (String)hashtable.get("jrs.exe_hour");
            this.afterHour.set(CSUtil.parseInt(string, 0));
            string = (String)hashtable.get("jrs.exe_min");
            this.afterMinute.set(CSUtil.parseInt(string, 0));
        }
        string = (String)hashtable.get("jrs.is_before");
        this.isBefore.set(CSUtil.getBoolean(string));
        if (this.isBefore.get()) {
            string = (String)hashtable.get("jrs.cease_year");
            this.ceaseYear.set(CSUtil.parseInt(string, 0));
            string = (String)hashtable.get("jrs.cease_month");
            this.ceaseMonth.set(CSUtil.parseInt(string, 0));
            string = (String)hashtable.get("jrs.cease_day");
            this.ceaseDay.set(CSUtil.parseInt(string, 0));
            string = (String)hashtable.get("jrs.cease_hour");
            this.ceaseHour.set(CSUtil.parseInt(string, 0));
            string = (String)hashtable.get("jrs.cease_min");
            this.ceaseMinute.set(CSUtil.parseInt(string, 0));
        }
    }
}

