/*
 * Decompiled with CFR 0.152.
 */
package jet.server.schedule;

import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import jet.cs.CSUtil;
import jet.cs.Schedulable;
import jet.server.schedule.ExeTimeInfo;
import jet.server.schedule.JetLch;
import jet.server.schedule.JetReptLch;
import jet.server.schedule.Repeatable;
import jet.server.schedule.TimeLaunchableObj;

public class RepeatLaunchableObj
extends TimeLaunchableObj
implements Repeatable {
    private long LINE = 0L;
    private boolean SEDU = true;
    private Schedulable append = null;

    public RepeatLaunchableObj(Properties properties, Schedulable schedulable) {
        super(properties, new ExeTimeInfo(schedulable.getNextTime().getTime(), schedulable.getTimeZone(), 0L, false));
        this.append = schedulable;
    }

    public Schedulable getSchedule() {
        return this.append;
    }

    @Override
    public long getExeTime() {
        return this.getExeTime(true);
    }

    @Override
    public long getExeTime(boolean bl) {
        if (bl) {
            this.updateExeTime();
        }
        return super.getExeTime();
    }

    public boolean isSuccessful() {
        return this.SEDU;
    }

    public void setSuccessful(boolean bl) {
        this.SEDU = bl;
    }

    @Override
    public boolean isExeTimeExpired() {
        return super.getExeTime() <= System.currentTimeMillis();
    }

    @Override
    public void updateExeTime() {
    }

    @Override
    public long getWakenTime() {
        return this.getExeTime();
    }

    private long LINE() {
        Date date;
        if (this.isExeTimeExpired() && (date = this.append.getNextTime()) != null) {
            this.setExeTime(date.getTime());
        }
        return super.getExeTime();
    }

    @Override
    public void wakeUp(long l) {
    }

    @Override
    public boolean isLaunchEvenIfExpired() {
        return false;
    }

    public long getLastExeTime() {
        return this.LINE;
    }

    public void setLastExeTime(long l) {
        this.LINE = l;
    }

    @Override
    public JetLch createJetLaunchable(Vector vector) {
        return new JetReptLch(this, vector);
    }

    @Override
    public int getLaunchType() {
        return 8;
    }

    @Override
    public String getTimeZone() {
        return this.append == null ? CSUtil.getDefaultTimeZone() : this.append.getTimeZone();
    }

    @Override
    public Properties toProperties(Properties properties) {
        Properties properties2 = properties;
        if (properties2 == null) {
            properties2 = new Properties();
        }
        properties2.put("jrs.launch_type", String.valueOf(8));
        properties2.put("jrs.last_exe_time", String.valueOf(this.getLastExeTime()));
        properties2.put("jrs.is_successful", String.valueOf(this.SEDU));
        properties2.put("jrs.is_enabled", String.valueOf(this.isEnabled));
        if (this.append != null) {
            properties2 = this.append.toProperties(properties2);
        }
        return properties2;
    }

    @Override
    public String toString() {
        return super.toString() + ":schedule=\"" + this.append + "\"";
    }

    public static String filterRepeatLaunchableScriptItems(Hashtable hashtable, boolean bl) {
        Vector vector = new Vector();
        CSUtil.appendScript(vector, hashtable, "jrs.launch_type", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.is_enabled", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.last_exe_time", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.is_successful", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.timezone", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.is_after", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.after_year", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.after_month", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.after_day", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.after_hour", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.after_minute", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.exe_year", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.exe_month", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.exe_day", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.exe_hour", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.exe_min", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.is_before", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.before_year", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.before_month", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.before_day", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.before_hour", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.before_minute", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.cease_year", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.cease_month", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.cease_day", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.cease_hour", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.cease_min", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.days_id", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.is_day", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.is_weekday", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.day", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.week", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.weekdays", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.day", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.month", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.is_hourly", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.hours", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.at_min", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.is_minutely", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.minutes", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.is_between", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.hour", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.min", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.is_pm", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.hour2", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.min2", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.is_pm2", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.next_exe_time", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.last_exe_time", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.last_exe_stat", true, bl);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < vector.size(); ++i) {
            stringBuffer.append((String)vector.get(i)).append(CSUtil.LINE);
        }
        return stringBuffer.toString();
    }
}

