/*
 * Decompiled with CFR 0.152.
 */
package jet.server.schedule;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import jet.server.api.PathInfo;
import jet.server.api.RptServerException;
import jet.server.api.exception.UnknownResource;
import jet.server.api.trigger.Trigger;
import jet.server.api.trigger.TriggerManager;
import jet.server.event.EventHandler;
import jet.server.event.SelectorImpl;
import jet.server.event.Subscriber;
import jet.server.event.TopicEvent;
import jet.server.event.TopicEventImpl;
import jet.server.event.subscriber.SubscribeService;
import jet.server.intf.jrs.ScheduleControllerService;
import jet.server.intf.jrs.SchedulingService;
import jet.server.jrc.quartz.JRBasicTrigger;
import jet.server.jrc.quartz.JRRepeatQuartzTrigger;
import jet.server.jrc.quartz.JRSchedulingServiceQuartzImpl;
import jet.server.jrc.quartz.JRTimeQuartzTrigger;
import jet.server.jrc.quartz.JRTrigger;
import jet.server.jrserver.JRResourceManager;
import jet.server.log.ServiceLogger;
import jet.server.schedule.ScheduledTask;
import jet.server.schedule.ScheduledTaskImpl;
import jet.server.trigger.ReferencableObj;
import jet.server.trigger.TriggerManagerImpl;
import org.quartz.Scheduler;

public final class ScheduleController
implements ScheduleControllerService,
EventHandler {
    private static ScheduleController SEDU = null;
    private SchedulingService activate = null;
    private Scheduler add = null;
    private LinkedList addSelector = new LinkedList();
    private TimeReadyFireThread addTask = null;
    private Subscriber addTaskToRefire = null;
    private ScheduleControlBlock addTriggerToReschedule = new ScheduleControlBlock();

    public static ScheduleController getInstance() {
        return SEDU;
    }

    public ScheduleController(SchedulingService schedulingService, Scheduler scheduler) throws RemoteException {
        if (schedulingService == null) {
            throw new IllegalArgumentException("schService can not be null.");
        }
        if (scheduler == null) {
            throw new IllegalArgumentException("scheduler can not be null.");
        }
        this.activate = schedulingService;
        this.add = scheduler;
        SubscribeService subscribeService = SubscribeService.newInstance();
        this.addTaskToRefire = subscribeService.createSubscriber(this);
        SelectorImpl selectorImpl = new SelectorImpl("TRIGGER_FIRE", 32);
        selectorImpl.enableAll();
        this.addTaskToRefire.addSelector(selectorImpl);
        if (this.addTaskToRefire.isValid()) {
            this.start();
        }
        this.addTriggerToReschedule = new ScheduleControlBlock();
        this.addTask = new TimeReadyFireThread();
        SEDU = this;
    }

    public void start() {
        if (this.isStart()) {
            return;
        }
        try {
            this.addTaskToRefire.activate();
            ServiceLogger.logEvent("Subscriber for topic 'TRIGGER_FIRE' is activated.");
            this.addTask.start();
            ServiceLogger.logEvent("Time ready fire thread [" + this.addTask.getName() + "] is starting");
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public boolean isStart() {
        return this.addTaskToRefire.isActive();
    }

    public void stop() {
        if (!this.isStart()) {
            return;
        }
        try {
            this.addTask.shutdown();
            this.addTaskToRefire.deactivate();
            ServiceLogger.logEvent("Subscriber for topic 'TRIGGER_FIRE' is deactivated.");
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
        this.addTriggerToReschedule.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(ScheduledTask scheduledTask) {
        if (scheduledTask != null) {
            ScheduleControlBlock scheduleControlBlock = this.addTriggerToReschedule;
            synchronized (scheduleControlBlock) {
                this.addTriggerToReschedule.addTask(scheduledTask);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delTask(ScheduledTask scheduledTask) {
        if (scheduledTask != null) {
            ScheduleControlBlock scheduleControlBlock = this.addTriggerToReschedule;
            synchronized (scheduleControlBlock) {
                this.addTriggerToReschedule.delTask(scheduledTask);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScheduledTask getTask(String string) {
        ScheduleControlBlock scheduleControlBlock = this.addTriggerToReschedule;
        synchronized (scheduleControlBlock) {
            return this.addTriggerToReschedule.getTask(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllTasks() {
        ArrayList arrayList = new ArrayList();
        ScheduleControlBlock scheduleControlBlock = this.addTriggerToReschedule;
        synchronized (scheduleControlBlock) {
            for (String string : this.addTriggerToReschedule.table.keySet()) {
                if (!string.startsWith("CRONAT_")) continue;
                HashSet hashSet = (HashSet)this.addTriggerToReschedule.table.get(string);
                Iterator iterator = hashSet.iterator();
                arrayList.add(iterator.next());
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllTasksBindTrigger(String string) {
        ArrayList arrayList = new ArrayList();
        ScheduleControlBlock scheduleControlBlock = this.addTriggerToReschedule;
        synchronized (scheduleControlBlock) {
            HashSet hashSet = (HashSet)this.addTriggerToReschedule.table.get(string);
            if (hashSet != null) {
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next());
                }
            }
        }
        return arrayList;
    }

    private boolean SEDU(String string, String string2) {
        boolean bl;
        block2: {
            JRResourceManager jRResourceManager = ((JRSchedulingServiceQuartzImpl)this.activate).getResourceManager();
            bl = false;
            try {
                PathInfo pathInfo;
                bl = string2 != null && string2.trim().length() != 0 ? (pathInfo = jRResourceManager.getPathInfo(string, string2)).getStatus() != 1 : true;
            }
            catch (RptServerException rptServerException) {
                if (!(rptServerException.getCause() instanceof UnknownResource)) break block2;
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void process(TopicEvent topicEvent) {
        Properties properties = (Properties)topicEvent.getData();
        String string = properties.getProperty("trigger.name");
        String string2 = properties.getProperty("trigger.type");
        Object object = properties.get("trigger.data");
        ArrayList arrayList = new ArrayList();
        try {
            Object object2;
            Object object3;
            Object object4 = this.addTriggerToReschedule;
            synchronized (object4) {
                object3 = (HashSet)this.addTriggerToReschedule.table.get(string);
                if (object3 == null) {
                    return;
                }
                arrayList.clear();
                object2 = ((HashSet)object3).iterator();
                while (object2.hasNext()) {
                    arrayList.add(object2.next());
                }
            }
            object4 = arrayList.iterator();
            while (object4.hasNext()) {
                object2 = object3 = (ScheduledTask)object4.next();
                synchronized (object2) {
                    Object[] objectArray;
                    JRTrigger jRTrigger = object3.getJRTrigger();
                    if (string2 != null && string2.equalsIgnoreCase("TimeTrigger")) {
                        jRTrigger.triggered(null);
                        if (!object3.isEnabled()) {
                            long l = System.currentTimeMillis();
                            ((JRSchedulingServiceQuartzImpl)this.activate).getJRTriggersMap().put(jRTrigger.getTaskID(), (Object)jRTrigger);
                            long l2 = System.currentTimeMillis() - l;
                            objectArray = new Object[]{jRTrigger.getTaskID(), l2};
                            ServiceLogger.logDebug(6610023, objectArray, 6);
                        }
                    }
                    Properties properties2 = jRTrigger.getTask();
                    boolean bl = "jet.server.schedule.jrtasks.PublishCRDTask".equals(properties2.getProperty("jrs.task_class"));
                    boolean bl2 = "jet.server.jrc.security.ldap.LDAPSynchronizeTask".equals(properties2.getProperty("jrs.task_class"));
                    String string3 = properties2.getProperty("jrs.report");
                    objectArray = properties2.getProperty("jrs.uid");
                    if (!object3.isEnabled() || !bl && !bl2 && this.SEDU((String)objectArray, string3)) {
                        continue;
                    }
                    object3.setFlag(string, object);
                    boolean bl3 = false;
                    if (object3.isReady()) {
                        long l = System.currentTimeMillis();
                        if (!bl && (jRTrigger instanceof JRTimeQuartzTrigger && !(jRTrigger instanceof JRBasicTrigger) || jRTrigger instanceof JRRepeatQuartzTrigger && null == jRTrigger.getNextFireTime())) {
                            try {
                                this.activate.removeScheduledTask(jRTrigger.getTaskID());
                                bl3 = true;
                            }
                            catch (Exception exception) {
                                ServiceLogger.logError(exception);
                            }
                        } else {
                            if (jRTrigger instanceof JRBasicTrigger) {
                                ((JRBasicTrigger)jRTrigger).setLastExeTime(l);
                            } else if (jRTrigger instanceof JRTimeQuartzTrigger) {
                                ((JRTimeQuartzTrigger)jRTrigger).setLastExeTime(l);
                                ((JRTimeQuartzTrigger)jRTrigger).setStartTime(new Date(-1L));
                            } else {
                                ((JRRepeatQuartzTrigger)jRTrigger).setLastExeTime(l);
                            }
                            ((JRSchedulingServiceQuartzImpl)this.activate).addTriggerToReschedule(jRTrigger);
                        }
                        ((JRSchedulingServiceQuartzImpl)this.activate).runTask(object3.getTaskDetail());
                        object3.resetAllFlags();
                    } else {
                        String string4 = object3.getTaskDetail().getProperty("jrs.triggers.logic", "OR");
                        if (string.startsWith("CRONAT_") && "AND2".equals(string4) && (jRTrigger instanceof JRTimeQuartzTrigger || jRTrigger instanceof JRRepeatQuartzTrigger && null == jRTrigger.getNextFireTime()) && !bl) {
                            try {
                                this.activate.removeScheduledTask(jRTrigger.getTaskID());
                                bl3 = true;
                            }
                            catch (Exception exception) {
                                ServiceLogger.logError(exception);
                            }
                        }
                    }
                    boolean bl4 = object3.getFlags().size() > 1 && !(jRTrigger instanceof JRBasicTrigger);
                    long l = System.currentTimeMillis();
                    if (bl3) {
                        ((JRSchedulingServiceQuartzImpl)this.activate).getJRTriggersMap().remove(jRTrigger.getTaskID());
                        if (bl4) {
                            ((JRSchedulingServiceQuartzImpl)this.activate).getFlagsMap().remove(jRTrigger.getTaskID());
                        }
                    } else {
                        ((JRSchedulingServiceQuartzImpl)this.activate).getJRTriggersMap().put(jRTrigger.getTaskID(), (Object)object3.getJRTrigger());
                        if (bl4) {
                            ((JRSchedulingServiceQuartzImpl)this.activate).getFlagsMap().put(jRTrigger.getTaskID(), object3.getFlags());
                        }
                    }
                    long l3 = System.currentTimeMillis() - l;
                    Object[] objectArray2 = new Object[]{jRTrigger.getTaskID(), l3};
                    ServiceLogger.logDebug(6610023, objectArray2, 6);
                }
            }
            return;
        }
        catch (Exception exception) {
            ServiceLogger.logError(exception);
        }
    }

    public void fireTaskTimeReady(String string) {
        ScheduledTaskImpl scheduledTaskImpl = (ScheduledTaskImpl)this.getTask(string);
        if (scheduledTaskImpl != null) {
            Properties properties = new Properties();
            properties.setProperty("trigger.name", scheduledTaskImpl.getTimeFlagName());
            properties.setProperty("trigger.type", "TimeTrigger");
            TopicEventImpl topicEventImpl = new TopicEventImpl("TRIGGER_FIRE", 0, properties);
            this.process(topicEventImpl);
        } else {
            ((JRSchedulingServiceQuartzImpl)this.activate).addTaskToRefire(string);
            ServiceLogger.logDebug(6610024, string, 6);
        }
    }

    public void finalize() throws Throwable {
        this.addTask = null;
        this.addTaskToRefire.destroy();
        this.addTriggerToReschedule.clear();
        this.addTriggerToReschedule = null;
        this.activate = null;
        this.add = null;
        SEDU = null;
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTaskToFire(String string) {
        LinkedList linkedList = this.addSelector;
        synchronized (linkedList) {
            this.addSelector.add(string);
            this.addSelector.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setCausedByClusterMapSync(boolean bl) {
        ScheduleControlBlock scheduleControlBlock = this.addTriggerToReschedule;
        synchronized (scheduleControlBlock) {
            return this.addTriggerToReschedule.setCausedByClusterMapSync(bl);
        }
    }

    private class ScheduleControlBlock {
        Hashtable table = new Hashtable();
        boolean causedByClusterMapSync = false;

        public boolean setCausedByClusterMapSync(boolean bl) {
            boolean bl2 = this.causedByClusterMapSync;
            this.causedByClusterMapSync = bl;
            return bl2;
        }

        public void addTask(ScheduledTask scheduledTask) {
            for (String string : scheduledTask.getAllFlagsName()) {
                HashSet hashSet = null;
                if (this.table.containsKey(string)) {
                    hashSet = (HashSet)this.table.get(string);
                } else {
                    hashSet = new HashSet();
                    this.table.put(string, hashSet);
                }
                hashSet.add(scheduledTask);
            }
        }

        public void delTask(ScheduledTask scheduledTask) {
            TriggerManager triggerManager = TriggerManagerImpl.getInstance();
            for (String string : scheduledTask.getAllFlagsName()) {
                if (!this.table.containsKey(string)) continue;
                HashSet hashSet = (HashSet)this.table.get(string);
                hashSet.remove(scheduledTask);
                Trigger trigger = triggerManager.getTrigger(string);
                if (trigger != null && !this.causedByClusterMapSync) {
                    ((ReferencableObj)((Object)trigger)).decRef();
                    ((TriggerManagerImpl)triggerManager).getTriggersMap().put(string, trigger);
                }
                if (!hashSet.isEmpty()) continue;
                this.table.remove(string);
            }
        }

        public ScheduledTask getTask(String string) {
            String string2 = "CRONAT_" + Integer.toHexString(string.hashCode());
            HashSet hashSet = (HashSet)this.table.get(string2);
            if (hashSet != null) {
                Iterator iterator = hashSet.iterator();
                return (ScheduledTask)iterator.next();
            }
            return null;
        }

        public void clear() {
            for (HashSet hashSet : this.table.values()) {
                hashSet.clear();
            }
            this.table.clear();
        }
    }

    class TimeReadyFireThread
    extends Thread {
        private boolean SEDU;

        TimeReadyFireThread() {
            super(Thread.currentThread().getThreadGroup(), "TimeReadyFireThread");
            this.SEDU = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void shutdown() {
            TimeReadyFireThread timeReadyFireThread = this;
            synchronized (timeReadyFireThread) {
                this.SEDU = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean bl = true;
            while (bl) {
                String string = null;
                Object object = ScheduleController.this.addSelector;
                synchronized (object) {
                    try {
                        string = (String)ScheduleController.this.addSelector.removeFirst();
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        try {
                            ScheduleController.this.addSelector.wait(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                if (null != string) {
                    ScheduleController.this.fireTaskTimeReady(string);
                }
                object = this;
                synchronized (object) {
                    bl = !this.SEDU;
                }
            }
            ServiceLogger.logDebug(6610016, Thread.currentThread().getName(), 6);
        }
    }
}

