/*
 * Decompiled with CFR 0.152.
 */
package jet.server.schedule.ftp;

import java.util.Hashtable;
import jet.JSvrResource;
import jet.cs.CSUtil;
import jet.server.api.custom.ftp.FTPHandler;
import jet.server.util.ServerUtil;

public class FTPConnectionInfo {
    public static final int FTP_PORT = 21;
    private String SCHEMES;
    private int SEDU;
    private String append;
    private String encode;
    private String get;
    private String getMessage;
    private int initFromHt;

    public FTPConnectionInfo() {
    }

    public FTPConnectionInfo(Hashtable hashtable) {
        this.initFromHt(hashtable);
    }

    public void initFromHt(Hashtable hashtable) {
        if (hashtable == null) {
            return;
        }
        this.SCHEMES = (String)hashtable.get("jrs.ftpHost");
        this.SEDU = CSUtil.parseInt((String)hashtable.get("jrs.ftpPort"), 21);
        this.append = (String)hashtable.get("jrs.ftpUn");
        this.encode = (String)hashtable.get("jrs.ftpPsd");
        this.get = (String)hashtable.get("jrs.ftpAcct");
        this.getMessage = (String)hashtable.get("jrs.ftpLbl");
        this.initFromHt = CSUtil.parseInt((String)hashtable.get("jrs.ftpProt"), 0);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("\r\n\t").append(JSvrResource.getMessage("FTP_CONNECTION_HOST")).append("=").append(this.SCHEMES);
        stringBuffer.append("\r\n\t").append(JSvrResource.getMessage("FTP_CONNECTION_PORT")).append("=").append(this.SEDU);
        stringBuffer.append("\r\n\t").append(JSvrResource.getMessage("FTP_CONNECTION_ACCT")).append("=").append(ServerUtil.encode(this.SCHEMES()));
        stringBuffer.append("\r\n\t").append(JSvrResource.getMessage("FTP_CONNECTION_LBL")).append("=").append(this.getMessage);
        stringBuffer.append("\r\n\t").append(JSvrResource.getMessage("FTP_CONNECTION_PROTO")).append("=").append(this.initFromHt).append(",");
        if (this.initFromHt < 0 || this.initFromHt >= FTPHandler.SCHEMES.length - 1) {
            stringBuffer.append(FTPHandler.SCHEMES[FTPHandler.SCHEMES.length - 1]);
        } else {
            stringBuffer.append(FTPHandler.SCHEMES[this.initFromHt]);
        }
        return stringBuffer.toString();
    }

    public String getHost() {
        return this.SCHEMES;
    }

    public void setHost(String string) {
        this.SCHEMES = string;
    }

    public int getPort() {
        return this.SEDU;
    }

    public void setPort(int n) {
        this.SEDU = n;
    }

    public String getUsername() {
        return this.append;
    }

    public void setUsername(String string) {
        this.append = string;
    }

    public String getPassword() {
        return this.encode;
    }

    public void setPassword(String string) {
        this.encode = string;
    }

    public String getAccount() {
        return this.get;
    }

    public void setAccount(String string) {
        this.get = string;
    }

    public String getLabel() {
        return this.getMessage;
    }

    public void setLabel(String string) {
        this.getMessage = string;
    }

    public int getProto() {
        return this.initFromHt;
    }

    public void setProto(int n) {
        this.initFromHt = n;
    }

    public String getProtoString() {
        if (this.initFromHt < 0 || this.initFromHt >= FTPHandler.SCHEMES.length - 1) {
            return FTPHandler.SCHEMES[FTPHandler.SCHEMES.length - 1];
        }
        return FTPHandler.SCHEMES[this.initFromHt];
    }

    private String SCHEMES() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.append != null && this.append.length() > 0) {
            stringBuffer.append(this.append);
            if (this.encode != null) {
                stringBuffer.append(":").append(this.encode);
            }
            if (this.get != null) {
                stringBuffer.append(":").append(this.get);
            }
        }
        return stringBuffer.toString();
    }
}

