/*
 * Decompiled with CFR 0.152.
 */
package jet.server.schedule.ftp;

import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import jet.JSvrResource;
import jet.cs.CSUtil;
import jet.server.api.custom.ftp.FTPHandler;
import jet.server.schedule.ftp.FTPConnectionInfo;
import jet.server.schedule.ftp.FTPFormatInfo;
import jet.server.schedule.ftp.FTPUtils;
import toolkit.db.SortCompareInterface;

public class FTPExporter
implements SortCompareInterface {
    private int SCHEMES;
    private FTPFormatInfo SEDU;
    private FTPConnectionInfo[] append = new FTPConnectionInfo[0];
    private int equalsIgnoreCase = 0;
    private String get;
    private String[] getFTPConnectionInfo = new String[0];
    private String getIndex;
    private String getMessage;

    public FTPExporter() {
    }

    public FTPExporter(Hashtable hashtable) {
        this.initFromHt(hashtable);
    }

    public FTPExporter(String string) {
        this(string, 0);
    }

    public FTPExporter(String string, int n) {
        this.getMessage = string;
        this.SCHEMES = n;
        this.initFromHt(CSUtil.parseQuery(string));
    }

    public void addSiteFromURL(String string) throws MalformedURLException {
        if (string != null) {
            int n = string.indexOf("://");
            String string2 = "";
            if (n > 0) {
                String string3 = string.substring(0, n);
                int n2 = 3;
                for (int i = 0; i < FTPHandler.SCHEMES.length; ++i) {
                    if (!string3.equalsIgnoreCase(FTPHandler.SCHEMES[i])) continue;
                    n2 = i;
                }
                if (n2 != 3) {
                    int n3;
                    int n4;
                    String string4;
                    String string5 = null;
                    String string6 = null;
                    if ((n = (string = string.substring(n + 3)).indexOf("@")) >= 0) {
                        string4 = string.substring(0, n);
                        n4 = string4.indexOf(":");
                        if (n4 >= 0) {
                            string5 = string4.substring(0, n4);
                            string6 = string4.substring(n4 + 1);
                        }
                        string = string.substring(n + 1);
                    }
                    if (string5 == null || string5.trim().length() == 0) {
                        string5 = "anonymous";
                        string6 = "";
                    }
                    string4 = string;
                    n4 = 21;
                    n = string.indexOf("/");
                    if (n > 0) {
                        string2 = string.substring(n + 1);
                        string4 = string.substring(0, n);
                    }
                    if ((n3 = string4.indexOf(":")) > 0) {
                        try {
                            n4 = Integer.parseInt(string4.substring(n3 + 1));
                        }
                        catch (NumberFormatException numberFormatException) {
                            n4 = 21;
                        }
                        string4 = string4.substring(0, n3);
                    }
                    if (string4.length() > 0) {
                        FTPConnectionInfo fTPConnectionInfo = new FTPConnectionInfo();
                        fTPConnectionInfo.setHost(string4);
                        fTPConnectionInfo.setPort(n4);
                        fTPConnectionInfo.setUsername(string5);
                        fTPConnectionInfo.setPassword(string6);
                        fTPConnectionInfo.setProto(n2);
                        this.SCHEMES(fTPConnectionInfo, string2);
                        return;
                    }
                }
            }
        }
        throw new MalformedURLException(JSvrResource.getMessage("INVALID_FTP_URL", string));
    }

    public void initFromHt(Hashtable hashtable) {
        if (hashtable != null) {
            if (this.getMessage == null) {
                this.getMessage = CSUtil.makeNoHeadQuery(hashtable);
            }
            Properties properties = new Properties();
            int n = "jrs.nonbursting$".length();
            Object object = hashtable.keys();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                if (!string.startsWith("jrs.nonbursting$")) continue;
                Object v = hashtable.remove(string);
                properties.put(string.substring(n), v);
            }
            hashtable.putAll(properties);
            this.getIndex = (String)hashtable.get("jrs.ftpHdlCls");
            object = (String)hashtable.get("jrs.ftpLoc");
            this.SEDU = new FTPFormatInfo(hashtable);
            FTPConnectionInfo fTPConnectionInfo = FTPUtils.getFTPConnectionInfo(hashtable);
            this.SCHEMES(fTPConnectionInfo, (String)object);
        }
    }

    public Properties toRawProperties(Properties properties) {
        Properties properties2 = properties;
        if (properties2 == null) {
            properties2 = new Properties();
        }
        if (this.getMessage != null) {
            properties2.setProperty("jrs.ftp" + this.SCHEMES, this.getMessage);
        }
        return properties2;
    }

    public FTPFormatInfo getFmtInfo() {
        return this.SEDU;
    }

    public FTPConnectionInfo getConnInfo(int n) {
        return this.append[n];
    }

    public int getIndex() {
        return this.SCHEMES;
    }

    public void setIndex(int n) {
        this.SCHEMES = n;
    }

    public String getLocalPath() {
        return this.get;
    }

    public void setLocalPath(String string) {
        this.get = string;
    }

    public String getRemotePath(int n) {
        return this.getFTPConnectionInfo[n];
    }

    public void setRemotePath(int n, String string) {
        this.getFTPConnectionInfo[n] = string;
    }

    public int getSiteNumber() {
        return this.equalsIgnoreCase;
    }

    private void SCHEMES(FTPConnectionInfo fTPConnectionInfo, String string) {
        ++this.equalsIgnoreCase;
        FTPConnectionInfo[] fTPConnectionInfoArray = new FTPConnectionInfo[this.equalsIgnoreCase];
        String[] stringArray = new String[this.equalsIgnoreCase];
        for (int i = 0; i < this.equalsIgnoreCase - 1; ++i) {
            fTPConnectionInfoArray[i] = this.append[i];
            stringArray[i] = this.getFTPConnectionInfo[i];
        }
        fTPConnectionInfoArray[i] = fTPConnectionInfo;
        stringArray[i] = string;
        this.append = fTPConnectionInfoArray;
        this.getFTPConnectionInfo = stringArray;
    }

    public void clearSites() {
        this.append = new FTPConnectionInfo[0];
        this.getFTPConnectionInfo = new String[0];
        this.equalsIgnoreCase = 0;
    }

    public String getHandlerClass() {
        return this.getIndex;
    }

    public void setHandlerClass(String string) {
        this.getIndex = string;
    }

    public static Hashtable getFTPExporters(Hashtable hashtable) {
        Hashtable<String, FTPExporter> hashtable2 = new Hashtable<String, FTPExporter>();
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string;
                String string2;
                Object object = enumeration.nextElement();
                if (!(object instanceof String) || !((object = hashtable.get(string2 = (String)object)) instanceof String) || (string = (String)object).trim().length() <= 0 || !string2.startsWith("jrs.ftp")) continue;
                hashtable2.put(string2, new FTPExporter(string, CSUtil.parseInt(string2.substring("jrs.ftp".length()).trim(), 0)));
            }
        }
        return hashtable2;
    }

    public String toRawString() {
        return this.getMessage;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("\r\n").append(JSvrResource.getMessage("FTP_INDEX")).append("=").append(this.SCHEMES).append("\r\n").append(JSvrResource.getMessage("FTP_HANDLER_CLASS")).append("=").append(this.getIndex).append("\r\n").append(JSvrResource.getMessage("FTP_LOCAL_PATH")).append("=").append(this.get);
        if (this.SEDU != null) {
            stringBuffer.append("\r\n").append(JSvrResource.getMessage("FTP_FORMAT_INFO")).append("=").append(this.SEDU.toString());
        }
        for (int i = 0; i < this.equalsIgnoreCase; ++i) {
            stringBuffer.append("\r\n").append(JSvrResource.getMessage("FTP_REMOTE_PATH")).append("=").append(this.getFTPConnectionInfo[i]);
            if (this.append[i] == null) continue;
            stringBuffer.append("\r\n").append(JSvrResource.getMessage("FTP_CONN_INFO")).append("=").append(this.append[i].toString());
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean isExchangeSortOrder(Object object, Object object2) {
        return object != null && object2 != null && ((FTPExporter)object).getIndex() < ((FTPExporter)object2).getIndex();
    }

    @Override
    public boolean isLargerOrEqual(Object object, Object object2) {
        return false;
    }

    @Override
    public boolean isLessOrEqual(Object object, Object object2) {
        return false;
    }
}

