/*
 * Decompiled with CFR 0.152.
 */
package jet.server.schedule.ftp;

import java.util.Hashtable;
import jet.JSvrResource;
import jet.cs.CSUtil;
import jet.server.log.ServiceLogger;
import jet.server.schedule.ftp.FTPConnectionInfo;

public class FTPSConnectionInfo
extends FTPConnectionInfo {
    public static final int EXPLICIT = 0;
    public static final int IMPLICIT = 1;
    public static final int PASSIVE = 0;
    public static final int ACTIVE = 1;
    public static final int IMPLICIT_FTPS_PORT = 990;
    public static final int TLS = 0;
    public static final int SSL = 1;
    private int SEDU;
    private int append;
    private int booleanValue;
    private boolean get = true;
    private String getMessage;
    private String getProto;
    private String initFromHt;
    private String isLoggable;
    private String logError;
    private String parseInt;
    private String setPort;
    private String setProto;

    public FTPSConnectionInfo() {
    }

    public FTPSConnectionInfo(Hashtable hashtable) {
        this.initFromHt(hashtable);
    }

    @Override
    public void initFromHt(Hashtable hashtable) {
        if (hashtable == null) {
            return;
        }
        super.initFromHt(hashtable);
        this.SEDU = CSUtil.parseInt((String)hashtable.get("jrs.ftpsConType"), -1);
        if (this.SEDU != 0 && this.SEDU != 1) {
            this.SEDU = this.getProto() == 3 ? 0 : 1;
        } else if (this.SEDU == 1) {
            this.setProto(4);
        }
        if (this.SEDU == 1) {
            this.setPort(CSUtil.parseInt((String)hashtable.get("jrs.ftpPort"), 990));
        }
        this.append = CSUtil.parseInt((String)hashtable.get("jrs.ftpsTransMode"), 0);
        if (this.append < 0 || this.append > 1) {
            if (ServiceLogger.isLoggable(2, 3)) {
                ServiceLogger.logError(2600244, new Integer(this.append), 3);
            }
            this.append = 0;
        }
        this.booleanValue = CSUtil.parseInt((String)hashtable.get("jrs.ftpsTransMode"), -1);
        String string = (String)hashtable.get("jrs.ftpsEnNoSec");
        if (string != null) {
            this.get = Boolean.valueOf(string);
        }
        if (this.SEDU == 1) {
            this.get = false;
        }
        this.initFromHt = (String)hashtable.get("jrs.ftpsKSType");
        this.getMessage = (String)hashtable.get("jrs.ftpsKSFile");
        this.getProto = (String)hashtable.get("jrs.ftpsKSPsd");
        this.isLoggable = (String)hashtable.get("jrs.ftpsKMAlg");
        this.setPort = (String)hashtable.get("jrs.ftpsTSType");
        this.logError = (String)hashtable.get("jrs.ftpsTSFile");
        this.parseInt = (String)hashtable.get("jrs.ftpsTSPsd");
        this.setProto = (String)hashtable.get("jrs.ftpsTMAlg");
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("\r\n\t").append(JSvrResource.getMessage("FTPS_CONNECTION_TYPE")).append("=").append(this.SEDU);
        stringBuffer.append("\r\n\t").append(JSvrResource.getMessage("FTPS_TRANSFER_MODE")).append("=").append(this.append);
        stringBuffer.append("\r\n\t").append(JSvrResource.getMessage("FTPS_SECURITY_PROTO")).append("=").append(this.booleanValue);
        stringBuffer.append("\r\n\t").append(JSvrResource.getMessage("FTPS_NO_SECURITY_ENABLE")).append("=").append(this.get);
        stringBuffer.append("\r\n\t").append(JSvrResource.getMessage("FTPS_KS_TYPE")).append("=").append(this.initFromHt);
        stringBuffer.append("\r\n\t").append(JSvrResource.getMessage("FTPS_KS_FILE")).append("=").append(this.getMessage);
        stringBuffer.append("\r\n\t").append(JSvrResource.getMessage("FTPS_KS_PSD")).append("=").append(this.getProto);
        stringBuffer.append("\r\n\t").append(JSvrResource.getMessage("FTPS_KM_ALG")).append("=").append(this.isLoggable);
        stringBuffer.append("\r\n\t").append(JSvrResource.getMessage("FTPS_TS_TYPE")).append("=").append(this.setPort);
        stringBuffer.append("\r\n\t").append(JSvrResource.getMessage("FTPS_TS_FILE")).append("=").append(this.logError);
        stringBuffer.append("\r\n\t").append(JSvrResource.getMessage("FTPS_TS_PSD")).append("=").append(this.parseInt);
        stringBuffer.append("\r\n\t").append(JSvrResource.getMessage("FTPS_TM_ALG")).append("=").append(this.setProto);
        return stringBuffer.toString();
    }

    public int getConnectionType() {
        return this.SEDU;
    }

    public void setConnectionType(int n) {
        this.SEDU = n;
    }

    public int getTransferMode() {
        return this.append;
    }

    public void setTransferMode(int n) {
        this.append = n;
    }

    public int getSecureProt() {
        return this.booleanValue;
    }

    public String getSecureProtString() {
        String string = null;
        if (this.booleanValue == 0) {
            string = "TLS";
        } else if (this.booleanValue == 1) {
            string = "SSL";
        }
        return string;
    }

    public void setSecureProt(int n) {
        this.booleanValue = n;
    }

    public boolean isEnableNoSecurity() {
        return this.get;
    }

    public void setEnableNoSecurity(boolean bl) {
        this.get = bl;
    }

    public String getKeyStoreFile() {
        return this.getMessage;
    }

    public void setKeyStoreFile(String string) {
        this.getMessage = string;
    }

    public String getKeyStorePsd() {
        return this.getProto;
    }

    public void setKeyStorePsd(String string) {
        this.getProto = string;
    }

    public String getKeyStoreType() {
        return this.initFromHt;
    }

    public void setKeyStoreType(String string) {
        this.initFromHt = string;
    }

    public String getKeyManAlg() {
        return this.isLoggable;
    }

    public void setKeyManAlg(String string) {
        this.isLoggable = string;
    }

    public String getTrustStoreFile() {
        return this.logError;
    }

    public void setTrustStoreFile(String string) {
        this.logError = string;
    }

    public String getTrustStorePsd() {
        return this.parseInt;
    }

    public void setTrustStorePsd(String string) {
        this.parseInt = string;
    }

    public String getTrustStoreType() {
        return this.setPort;
    }

    public void setTrustStoreType(String string) {
        this.setPort = string;
    }

    public String getTrustManAlg() {
        return this.setProto;
    }

    public void setTrustManAlg(String string) {
        this.setProto = string;
    }
}

