/*
 * Decompiled with CFR 0.152.
 */
package jet.server.schedule.ftp;

import java.io.File;
import java.io.IOException;
import jet.server.log.ServiceLogger;
import jet.server.schedule.ftp.FTPHandlerException;
import jet.server.schedule.ftp.FTPUtils;
import jet.server.schedule.ftp.SCPHandler;

public class SFTPHandler
extends SCPHandler {
    private boolean SEDU;
    private Object exists;
    private Class getAbsolutePath;

    public SFTPHandler() {
        this.scheme = SCHEMES[1];
    }

    @Override
    public boolean uploadFile(String string) throws IOException {
        return this.uploadFile(new File(".").getAbsolutePath(), string);
    }

    @Override
    public boolean uploadFile(String string, String string2) throws IOException {
        return this.uploadFile(string, string2, null);
    }

    @Override
    public boolean uploadFile(String string, String string2, String string3) throws IOException {
        File file = new File(string2);
        if (!file.isAbsolute()) {
            file = new File(string, string2);
        }
        if (!file.exists()) {
            throw new FTPHandlerException(600048, new String[]{file.getAbsolutePath()});
        }
        if (!file.isFile() && !file.isDirectory()) {
            throw new FTPHandlerException(600049, new String[]{file.getAbsolutePath()});
        }
        string2 = file.getAbsolutePath();
        string3 = string3 == null ? file.getName() : FTPUtils.getValidFTPPath(string3);
        this.SCHEMES("put", new Class[]{String.class, String.class}, new String[]{string2, string3});
        return true;
    }

    @Override
    public boolean deleteFile(String string) {
        try {
            this.SCHEMES("rm", new Class[]{String.class}, new String[]{string});
        }
        catch (Exception exception) {
            if (ServiceLogger.isLoggable(2, 3)) {
                ServiceLogger.logError(2600246, string, 3);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean makeDirectory(String string) {
        try {
            this.SCHEMES("mkdir", new Class[]{String.class}, new String[]{string});
        }
        catch (Exception exception) {
            if (ServiceLogger.isLoggable(2, 3)) {
                ServiceLogger.logError(2600247, string, 3);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean changeDirectory(String string) {
        try {
            this.SCHEMES("cd", new Class[]{String.class}, new String[]{string});
        }
        catch (Exception exception) {
            if (ServiceLogger.isLoggable(2, 3)) {
                ServiceLogger.logError(2600248, string, 3);
            }
            return false;
        }
        return true;
    }

    @Override
    public String getCurrentDirectory() throws IOException {
        return (String)this.SEDU("pwd", new Class[0], new Object[0]);
    }

    @Override
    public boolean login(String string, String string2) throws IOException {
        boolean bl = super.login(string, string2);
        this.exists = this.invoke("openChannel", new Class[]{String.class}, new String[]{"sftp"});
        this.getAbsolutePath = this.exists.getClass();
        this.SCHEMES("connect", new Class[0], new String[0]);
        this.SEDU = true;
        return bl;
    }

    @Override
    public boolean logout() throws IOException {
        if (this.SEDU) {
            this.SCHEMES("disconnect", new Class[0], new Object[0]);
        }
        return super.logout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void SCHEMES(String string, Class[] classArray, Object[] objectArray) {
        Object object = this.proxy;
        Class clazz = this.proxyCls;
        this.proxy = this.exists;
        this.proxyCls = this.getAbsolutePath;
        try {
            this.invokeTo(string, classArray, objectArray);
        }
        finally {
            this.proxy = object;
            this.proxyCls = clazz;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object SEDU(String string, Class[] classArray, Object[] objectArray) throws IOException {
        Object object = this.proxy;
        Class clazz = this.proxyCls;
        this.proxy = this.exists;
        this.proxyCls = this.getAbsolutePath;
        try {
            Object object2 = this.invoke(string, classArray, objectArray);
            return object2;
        }
        finally {
            this.proxy = object;
            this.proxyCls = clazz;
        }
    }
}

