/*
 * Decompiled with CFR 0.152.
 */
package jet.server.schedule.ftp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import jet.server.api.custom.ftp.FTPHandler;
import jet.server.schedule.ftp.FTPHandlerException;

public class StandardFTPHandler
implements FTPHandler {
    private static final String downloadFile = "org.apache.commons.net.ftp.FTPClient";
    private int endsWith = -1;
    protected String scheme = SCHEMES[0];
    protected Class proxyCls;
    protected Object proxy;

    protected void initFTPClient() {
        try {
            this.proxyCls = Class.forName(downloadFile);
            this.proxy = this.proxyCls.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new FTPHandlerException(600055, new String[]{downloadFile});
        }
        catch (Exception exception) {
            throw new FTPHandlerException(exception.getCause());
        }
    }

    @Override
    public boolean uploadFile(String string) throws IOException {
        return this.uploadFile(".", string);
    }

    @Override
    public boolean uploadFile(String string, String string2) throws IOException {
        return this.uploadFile(string, string2, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean uploadFile(String string, String string2, String string3) throws IOException {
        boolean bl = false;
        int n = 0;
        if (this.SCHEMES(string2)) {
            n = 2;
        }
        if (this.endsWith != n) {
            this.endsWith = n;
            this.invokeTo("setFileType", new Class[]{Integer.TYPE}, new Integer[]{new Integer(n)});
        }
        FileInputStream fileInputStream = null;
        try {
            File file = new File(string, string2);
            fileInputStream = new FileInputStream(file);
            bl = (Boolean)this.invoke("storeFile", new Class[]{String.class, InputStream.class}, new Object[]{string3, fileInputStream});
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        return bl;
    }

    @Override
    public boolean downloadFile(String string) throws IOException {
        return this.downloadFile(string, ".");
    }

    @Override
    public boolean downloadFile(String string, String string2) throws IOException {
        return this.downloadFile(string, string2, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean downloadFile(String string, String string2, String string3) throws IOException {
        boolean bl = false;
        int n = 0;
        if (this.SCHEMES(string)) {
            n = 2;
        }
        if (this.endsWith != n) {
            this.endsWith = n;
            this.invokeTo("setFileType", new Class[]{Integer.TYPE}, new Integer[]{new Integer(n)});
        }
        FileOutputStream fileOutputStream = null;
        try {
            File file = new File(string2, string3);
            fileOutputStream = new FileOutputStream(file);
            bl = (Boolean)this.invoke("retrieveFile", new Class[]{String.class, OutputStream.class}, new Object[]{string, fileOutputStream});
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        return bl;
    }

    @Override
    public boolean deleteFile(String string) throws IOException {
        return (Boolean)this.invoke("deleteFile", new Class[]{String.class}, new String[]{string});
    }

    @Override
    public boolean makeDirectory(String string) throws IOException {
        return (Boolean)this.invoke("makeDirectory", new Class[]{String.class}, new String[]{string});
    }

    @Override
    public boolean changeDirectory(String string) throws IOException {
        return (Boolean)this.invoke("changeWorkingDirectory", new Class[]{String.class}, new String[]{string});
    }

    @Override
    public boolean parentDirectory() throws IOException {
        return (Boolean)this.invoke("changeToParentDirectory", new Class[0], new Object[0]);
    }

    @Override
    public String getCurrentDirectory() throws IOException {
        return (String)this.invoke("printWorkingDirectory", new Class[0], new Object[0]);
    }

    @Override
    public void connect(String string) throws IOException {
        this.initFTPClient();
        this.invokeTo("connect", new Class[]{String.class}, new String[]{string});
    }

    @Override
    public void connect(String string, int n) throws IOException {
        this.initFTPClient();
        this.invokeTo("connect", new Class[]{String.class, Integer.TYPE}, new Object[]{string, new Integer(n)});
    }

    @Override
    public boolean login(String string, String string2) throws IOException {
        return (Boolean)this.invoke("login", new Class[]{String.class, String.class}, new String[]{string, string2});
    }

    @Override
    public boolean login(String string, String string2, String string3) throws IOException {
        return (Boolean)this.invoke("login", new Class[]{String.class, String.class, String.class}, new String[]{string, string2, string3});
    }

    @Override
    public boolean logout() throws IOException {
        return (Boolean)this.invoke("logout", new Class[0], new Object[0]);
    }

    @Override
    public void disconnect() throws IOException {
        this.invokeTo("disconnect", new Class[0], new Object[0]);
    }

    @Override
    public void setReadTimeout(int n) {
        this.invokeTo("setDataTimeout", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)});
    }

    @Override
    public void setConnectTimeout(int n) {
        this.invokeTo("setDefaultTimeout", new Class[]{Integer.TYPE}, new Object[]{new Integer(n)});
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    private boolean SCHEMES(String string) {
        String string2 = string.toLowerCase();
        return !string2.endsWith(".txt") && !string2.endsWith(".htm") && !string2.endsWith(".html") && !string2.endsWith(".xml") && !string2.endsWith(".xsd") && !string2.endsWith(".csv") && !string2.endsWith(".css") && !string2.endsWith(".ps") && !string2.endsWith(".rtf") && !string2.endsWith(".js");
    }

    protected void invokeTo(String string, Class[] classArray, Object[] objectArray) {
        try {
            Method method = this.proxyCls.getMethod(string, classArray);
            method.invoke(this.proxy, objectArray);
        }
        catch (Exception exception) {
            throw new FTPHandlerException(exception);
        }
    }

    protected Object invoke(String string, Class[] classArray, Object[] objectArray) throws IOException {
        try {
            Method method = this.proxyCls.getMethod(string, classArray);
            return method.invoke(this.proxy, objectArray);
        }
        catch (Exception exception) {
            Throwable throwable = exception.getCause();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw new FTPHandlerException(throwable);
        }
    }
}

