/*
 * Decompiled with CFR 0.152.
 */
package jet.server.schedule.jrtasks;

import com.jinfonet.common.impl.DriverConfigFactory;
import com.jinfonet.resstore.ResourceStore;
import guitools.toolkit.JDebug;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import jet.JCliResource;
import jet.ReportEnv;
import jet.bean.EngineProperties;
import jet.bean.ExcelParameter;
import jet.bean.ExportInfo;
import jet.bean.HtmlParameter;
import jet.bean.JREngine;
import jet.bean.PDFParameter;
import jet.bean.PSParameter;
import jet.bean.RtfParameter;
import jet.bean.TextParameter;
import jet.bean.XmlParameter;
import jet.cs.CSUtil;
import jet.datastream.Communicator;
import jet.exception.EngingPreinitException;
import jet.export.ExportAuxInfo;
import jet.export.print.JReportSwingPrinter;
import jet.rptengine.EngineListener;
import jet.security.PageACL;
import jet.server.ServerEnv;
import jet.server.api.PageSecurityException;
import jet.server.api.RptServerException;
import jet.server.api.ServerInfo;
import jet.server.api.TaskListenerException;
import jet.server.api.http.HttpUtil;
import jet.server.jrc.resource.nls.NLSUtil;
import jet.server.log.ServiceLogger;
import jet.server.resstore.ServerResourceStoreFactory;
import jet.server.schedule.SchdTools;
import jet.server.schedule.jrtasks.JRTask;
import jet.server.schedule.jrtasks.RunningReportSheets;
import jet.server.util.WebSecurityUtil;
import jet.util.EngineErrorListener;

public class ExportTask
extends JRTask
implements EngineListener,
EngineErrorListener {
    protected String result = null;
    protected String rstFile = null;
    protected String htmlFile = null;
    protected String pdfFile = null;
    protected String txtFile = null;
    protected String xlsFile = null;
    protected String psFile = null;
    protected String rtfFile = null;
    protected String xmlFile = null;
    protected String sheet = null;
    protected boolean isNormalText = false;
    protected boolean isCsv = false;
    protected boolean isTab = false;
    protected boolean isRepeat = false;
    protected String delimiter = " ";
    public int charWidth = -1;
    public int charHeight = -1;
    public boolean isQuoteMark = true;
    public boolean hasHeadFoot = true;
    public boolean forWindows = true;
    public boolean bTxtCompress = false;
    protected boolean isChartApplet = true;
    protected boolean isMultiFiles = true;
    protected boolean embeddedCSS = true;
    protected boolean hasHyperlink = true;
    protected boolean hasPageNumber = true;
    protected boolean drilldown = false;
    protected boolean useSection508 = false;
    protected boolean useHtmlTable = false;
    protected boolean useScope = false;
    protected boolean useTable = false;
    protected boolean relFontSize = false;
    protected int browser = 0;
    protected int overflow = 0;
    protected int chartFormat = -1;
    public boolean noMarginHtml = false;
    protected int htmResolution = -1;
    public boolean isDhtml = false;
    protected boolean noMarginPdf = false;
    protected boolean printModePdf = false;
    protected int compressImagePdf = -1;
    protected boolean isGifTrans = false;
    protected boolean isToc = false;
    protected boolean isDrilldown = false;
    protected String pdfPassword = null;
    protected boolean noMarginPs = false;
    protected boolean noMarginRtf = false;
    protected boolean isOnlyData = false;
    protected String xsdFile = null;
    protected int isWordWrapXls = 0;
    protected boolean excel2000 = false;
    protected boolean hasShapes = true;
    protected boolean excelLayout = true;
    protected int excelFormat = 0;
    protected boolean excelAdvanced = false;
    protected String printHeader = null;
    protected String printFooter = null;
    protected boolean printGridlines = false;
    protected boolean isLinkReport_rst = false;
    protected boolean isLinkReport_html = false;
    protected boolean isLinkReport_rtf = false;
    protected boolean isLinkReport_xml = false;
    protected boolean isLinkReport_txt = false;
    protected boolean isLinkReport_ps = false;
    protected boolean isLinkReport_pdf = false;
    protected boolean isLinkReport_xls = false;
    protected String rhost = null;
    private Object[] SEDU = new Object[]{null, null, null, null, null, null, null, null};
    protected boolean errId = false;
    protected boolean isThrowExcp = false;
    protected JREngine jrengine = null;
    protected Throwable thrdThrow = null;
    protected String errmsg = null;
    protected boolean isHtmlBodyStream = false;
    protected String htmlExportPath = null;
    protected OutputStream htmlBodyOut = null;
    protected OutputStream cssOut = null;
    protected String htmlNavNlsLanguage = null;

    private String SEDU(String string) {
        File file;
        String string2 = string;
        String string3 = ServerEnv.getResourceRoot();
        if (string3.endsWith(File.separator)) {
            string3 = string3.substring(0, string3.length() - 1);
        }
        if ((string3 = string3 + string2.replace('/', File.separator.charAt(0))).endsWith(File.separator)) {
            string3 = string3.substring(0, string3.length() - 1);
        }
        if ((file = WebSecurityUtil.validateFilePath(string3)) != null && !file.exists()) {
            file.mkdirs();
        }
        return file == null ? null : file.getAbsolutePath();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String WARNING(String string, String string2) throws Exception {
        File file;
        String string3 = null;
        String string4 = string;
        int n = CSUtil.parseInt(string2, 1);
        if (string == null || string.trim().length() == 0) {
            string4 = this.getJRTaskManager().getResourceManager().getTempDir();
        } else if (n == 0) {
            if (!string4.startsWith("/")) {
                throw new Exception(JCliResource.getMessage("CS_ERR_67", new String[]{string4, string}));
            }
            string4 = this.getJRTaskManager().getResourceManager().getRealPath(this.uid, string);
            if (string4 == null || string4.length() == 0) {
                string4 = this.SEDU(string);
            }
        }
        if (string4 == null) throw new Exception(JCliResource.getMessage("CS_ERR_35", string));
        if (!string4.endsWith(File.separator)) {
            string4 = string4 + File.separator;
        }
        if (!(file = new File(string4)).exists()) throw new Exception(JCliResource.getMessage("CS_ERR_34", new String[]{string4, string}));
        string3 = file.getCanonicalPath();
        if (!file.isDirectory()) {
            int n2 = string3.lastIndexOf(CSUtil.fileSep);
            if (n2 < 0) throw new Exception(JCliResource.getMessage("CS_ERR_33", new String[]{string4, string}));
            string3 = string3.substring(0, n2);
        }
        if (string3.endsWith(CSUtil.fileSep)) return string3;
        return string3 + CSUtil.fileSep;
    }

    @Override
    public void init(Properties properties) throws Exception {
        Enumeration enumeration;
        Serializable serializable;
        Object object;
        String string;
        super.init(properties);
        this.uid = (String)properties.get("jrs.uid");
        this.rhost = (String)properties.get("jrs.remote_host");
        String string2 = SchdTools.getTempFilePrefix();
        this.result = WebSecurityUtil.validateFilePathStr((String)properties.get("jrs.result"));
        if (CSUtil.getBoolean((String)properties.get("jrs.rst"), false)) {
            string = this.WARNING(properties.getProperty("jrs.rst_dir"), properties.getProperty("jrs.rst_dir_type"));
            this.rstFile = SchdTools.getTempFileName(string, string2, ".rst");
            if (this.rstFile != null) {
                this.rstFile = string + this.rstFile;
            }
        }
        this.htmlFile = (String)properties.get("jrs.html");
        if (this.htmlFile != null) {
            string = this.WARNING(properties.getProperty("jrs.html_dir"), properties.getProperty("jrs.html_dir_type"));
            object = (String)properties.get("jrs.html_temp_dir");
            if (object != null) {
                serializable = WebSecurityUtil.validateFilePath(string + (String)object);
                if (!((File)serializable).exists()) {
                    ((File)serializable).mkdir();
                }
                this.htmlFile = string + (String)object + File.separator + this.htmlFile;
            } else {
                this.htmlFile = string + this.htmlFile;
            }
            this.isMultiFiles = CSUtil.getBoolean((String)properties.get("jrs.is_multi_files"), true);
            this.embeddedCSS = CSUtil.getBoolean((String)properties.get("jrs.embedded_css"), false);
            this.isChartApplet = CSUtil.getBoolean((String)properties.get("jrs.is_applet_chart"), false);
            this.hasHyperlink = CSUtil.getBoolean((String)properties.get("jrs.has_hyperlink"), true);
            this.hasPageNumber = CSUtil.getBoolean((String)properties.get("jrs.has_page_number"), true);
            this.useTable = CSUtil.getBoolean((String)properties.get("jrs.use_table"), false);
            this.drilldown = CSUtil.getBoolean((String)properties.get("jrs.drilldown"), false);
            this.useSection508 = CSUtil.getBoolean((String)properties.get("jrs.use_section508_output"), false);
            this.useHtmlTable = CSUtil.getBoolean((String)properties.get("jrs.use_html_table"), false);
            this.useScope = CSUtil.getBoolean((String)properties.get("jrs.use_scope"), false);
            this.relFontSize = CSUtil.getBoolean((String)properties.get("jrs.relative_font_size"), false);
            this.browser = CSUtil.parseInt((String)properties.get("jrs.web_browser"), 0);
            this.overflow = CSUtil.parseInt((String)properties.get("jrs.text_overflow"), 1);
            this.chartFormat = CSUtil.parseInt((String)properties.get("jrs.format_chart"), -1);
            this.noMarginHtml = CSUtil.getBoolean((String)properties.get("jrs.no_margin_html"), false);
            this.htmResolution = CSUtil.parseInt((String)properties.get("jrs.html_resolution"), -1);
            this.isDhtml = CSUtil.getBoolean((String)properties.get("jrs.is_dhtml"), false);
            this.isHtmlBodyStream = CSUtil.getBoolean((String)properties.get("jrs.htm_is_body_stream"), false);
            if (this.isHtmlBodyStream) {
                this.htmlExportPath = WebSecurityUtil.validateFilePathStr(properties.getProperty("jrs.html_export_path"));
                this.htmlBodyOut = (OutputStream)properties.get("jrs.html_body_outstream");
                this.cssOut = (OutputStream)properties.get("jrs.html_css_outstream");
            }
            try {
                serializable = HttpUtil.getHttpRptServer().getUserPreferenceManager().getUserPreference(this.uid);
                boolean bl = CSUtil.getBoolean(((Properties)serializable).getProperty("enable_setting_display_language"), false);
                if (bl) {
                    this.htmlNavNlsLanguage = ((Properties)serializable).getProperty("locale_nls");
                }
            }
            catch (Throwable throwable) {
                ServiceLogger.logError(throwable);
            }
            this.htmlNavNlsLanguage = this.htmlNavNlsLanguage == null ? Locale.getDefault().toString() : this.htmlNavNlsLanguage;
        }
        string = this.WARNING(properties.getProperty("jrs.pdf_dir"), properties.getProperty("jrs.pdf_dir_type"));
        this.pdfFile = CSUtil.getBoolean((String)properties.get("jrs.pdf"), false) ? SchdTools.getTempFileName(string, string2, ".pdf") : (String)properties.get("jrs.pdf");
        if (this.pdfFile != null) {
            object = (String)properties.get("jrs.pdf_temp_dir");
            if (object != null) {
                serializable = new File(string + (String)object);
                if (!((File)serializable).exists()) {
                    ((File)serializable).mkdir();
                }
                this.pdfFile = serializable + File.separator + this.pdfFile;
            } else {
                this.pdfFile = string + this.pdfFile;
            }
            this.noMarginPdf = CSUtil.getBoolean((String)properties.get("jrs.no_margin_pdf"), false);
            this.printModePdf = CSUtil.getBoolean((String)properties.get("jrs.print_mode_pdf"), false);
            this.compressImagePdf = CSUtil.parseInt((String)properties.get("jrs.compress_image_pdf"), -1);
            this.isGifTrans = CSUtil.getBoolean((String)properties.get("jrs.gif_transparent_pdf"), false);
            this.isToc = CSUtil.getBoolean((String)properties.get("jrs.toc_pdf"), false);
            this.isDrilldown = CSUtil.getBoolean((String)properties.get("jrs.drilldown_pdf"), false);
            this.pdfPassword = (String)properties.get("jrs.password_pdf");
        }
        if (CSUtil.getBoolean((String)properties.get("jrs.text"), false)) {
            this.isNormalText = CSUtil.getBoolean((String)properties.get("jrs.is_norm_txt"), true);
            this.delimiter = (String)properties.get("jrs.delimiter");
            object = (String)properties.get("jrs.is_text_delimiter");
            if (object != null) {
                if (((String)object).equals("jrs.is_csv")) {
                    this.isCsv = true;
                    this.delimiter = ",";
                } else if (((String)object).equals("jrs.is_tab")) {
                    this.isTab = true;
                } else if (((String)object).equals("jrs.delimiter")) {
                    this.delimiter = (String)properties.get("jrs.delimiter");
                }
            }
            string = this.WARNING(properties.getProperty("jrs.text_dir"), properties.getProperty("jrs.text_dir_type"));
            this.txtFile = SchdTools.getTempFileName(string, string2, !this.isNormalText && this.isCsv ? ".csv" : ".txt");
            if (this.txtFile != null) {
                this.txtFile = string + this.txtFile;
            }
            this.isRepeat = CSUtil.getBoolean((String)properties.get("jrs.is_repeat"), false);
            this.charWidth = CSUtil.parseInt((String)properties.get("jrs.udchar_width"), -1);
            this.charHeight = CSUtil.parseInt((String)properties.get("jrs.udchar_height"), -1);
            this.isQuoteMark = CSUtil.getBoolean((String)properties.get("jrs.is_quotemark"), false);
            this.hasHeadFoot = CSUtil.getBoolean((String)properties.get("jrs.hasHeadFoot"), false);
            this.forWindows = CSUtil.getBoolean((String)properties.get("jrs.txt_windows"), false);
            this.bTxtCompress = CSUtil.getBoolean((String)properties.get("jrs.txt_compress"), false);
        }
        if (CSUtil.getBoolean((String)properties.get("jrs.excel"), false)) {
            string = this.WARNING(properties.getProperty("jrs.excel_dir"), properties.getProperty("jrs.excel_dir_type"));
            object = ".xls";
            int n = CSUtil.parseInt((String)properties.get("jrs.excel_format"), 1);
            this.excelFormat = n == 1 ? 0 : 1;
            if (this.excelFormat == 1) {
                object = ".xlsx";
            }
            this.xlsFile = SchdTools.getTempFileName(string, string2, (String)object);
            if (this.xlsFile != null) {
                this.xlsFile = string + this.xlsFile;
            }
            this.isWordWrapXls = CSUtil.parseInt((String)properties.get("jrs.is_wordwrap"), 0);
            this.excel2000 = CSUtil.getBoolean((String)properties.get("jrs.excel2000"), false);
            this.hasShapes = CSUtil.getBoolean((String)properties.get("jrs.has_shapes"), false);
            this.excelLayout = CSUtil.getBoolean((String)properties.get("jrs.excel_layout"), true);
            this.excelAdvanced = CSUtil.getBoolean((String)properties.get("jrs.excel_advanced"), false);
            this.printHeader = (String)properties.get("jrs.print_header");
            this.printFooter = (String)properties.get("jrs.print_footer");
            this.printGridlines = CSUtil.getBoolean((String)properties.get("jrs.print_gridlines"), false);
        }
        if (CSUtil.getBoolean((String)properties.get("jrs.ps"), false)) {
            string = this.WARNING(properties.getProperty("jrs.ps_dir"), properties.getProperty("jrs.ps_dir_type"));
            this.psFile = SchdTools.getTempFileName(string, string2, ".ps");
            if (this.psFile != null) {
                this.psFile = string + this.psFile;
            }
            this.noMarginPs = CSUtil.getBoolean((String)properties.get("jrs.no_margin_ps"), false);
        }
        this.rtfFile = (String)properties.get("jrs.rtf");
        if (this.rtfFile != null) {
            string = this.WARNING(properties.getProperty("jrs.rtf_dir"), properties.getProperty("jrs.rtf_dir_type"));
            object = (String)properties.get("jrs.rtf_temp_dir");
            if (object != null) {
                File file = new File(string + (String)object);
                if (!file.exists()) {
                    file.mkdir();
                }
                this.rtfFile = file + File.separator + this.rtfFile;
            } else {
                this.rtfFile = string + this.rtfFile;
            }
            this.noMarginRtf = CSUtil.getBoolean((String)properties.get("jrs.no_margin_rtf"), false);
        }
        this.xmlFile = (String)properties.get("jrs.xml");
        if (this.xmlFile != null) {
            string = this.WARNING(properties.getProperty("jrs.xml_dir"), properties.getProperty("jrs.xml_dir_type"));
            object = (String)properties.get("jrs.xml_temp_dir");
            if (object != null) {
                File file = new File(string + (String)object);
                if (!file.exists()) {
                    file.mkdir();
                }
                this.xmlFile = file + File.separator + this.xmlFile;
            } else {
                this.xmlFile = string + this.xmlFile;
            }
            this.isOnlyData = CSUtil.getBoolean((String)properties.get("jrs.is_only_data"), false);
            this.xsdFile = (String)properties.get("jrs.xsdfile");
        }
        this.isLinkReport_rst = CSUtil.getBoolean((String)properties.get("jrs.to_rst_runLinkedReport"), false);
        this.isLinkReport_pdf = CSUtil.getBoolean((String)properties.get("jrs.to_pdf_runLinkedReport"), false);
        this.isLinkReport_xls = CSUtil.getBoolean((String)properties.get("jrs.to_excel_runLinkedReport"), false);
        this.isLinkReport_xml = CSUtil.getBoolean((String)properties.get("jrs.to_xml_runLinkedReport"), false);
        this.isLinkReport_ps = CSUtil.getBoolean((String)properties.get("jrs.to_ps_runLinkedReport"), false);
        this.isLinkReport_txt = CSUtil.getBoolean((String)properties.get("jrs.to_text_runLinkedReport"), false);
        this.isLinkReport_rtf = CSUtil.getBoolean((String)properties.get("jrs.to_rtf_runLinkedReport"), false);
        this.isLinkReport_html = CSUtil.getBoolean((String)properties.get("jrs.to_html_runLinkedReport"), false);
        object = new RunningReportSheets(properties);
        if (((RunningReportSheets)object).hasReportSheets() && (enumeration = ((RunningReportSheets)object).getAllReportSheets()) != null && enumeration.hasMoreElements()) {
            this.sheet = (String)enumeration.nextElement();
        }
        this.setServerInfo(properties);
    }

    public String getUid() {
        return this.uid;
    }

    public String getRemoteHost() {
        return this.rhost;
    }

    public Object[] getExportList() {
        return this.SEDU;
    }

    @Override
    public void run() {
        try {
            this.export();
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable, 3);
        }
    }

    public String getRunTaskKey() {
        String string = this.getId();
        return this.getClass().getName() + "@" + this.hashCode() + "#ID=" + string + "(" + string + ")";
    }

    public void export() throws Throwable {
        block137: {
            Object object;
            if (this.hasListener) {
                try {
                    ServiceLogger.logDebug(6600043, this.listenerClass, 6);
                }
                catch (Throwable throwable) {
                    JDebug.WARNING((Throwable)throwable);
                }
                if (!this.taskListener.beforeRun(this.serverInfo)) {
                    try {
                        ServiceLogger.logDebug(6600073, 6);
                    }
                    catch (Throwable throwable) {
                        JDebug.WARNING((Throwable)throwable);
                    }
                    throw new TaskListenerException(196609, (Object[])new String[]{this.listenerClass}, null);
                }
            }
            try {
                ServiceLogger.logDebug(6600036, this, 6);
            }
            catch (Throwable throwable) {
                JDebug.WARNING((Throwable)throwable);
            }
            try {
                String[] stringArray;
                Object object2;
                Object object3;
                object = DriverConfigFactory.getJdbcDriversConfig();
                EngineProperties engineProperties = new EngineProperties(ReportEnv.getuid(), ReportEnv.gp(), "89Sfdswer470eGs190dfew324C", object, false);
                engineProperties.setResourceStore((ResourceStore)ServerResourceStoreFactory.getInstance().getResourceStoreByUser(this.uid));
                this.jrengine = new JREngine(engineProperties);
                this.jrengine.setAllowFFP(this.addEngineListener());
                ServiceLogger.logEngine(4600226, new Object[]{this.getRunTaskKey(), this.jrengine}, 4);
                this.jrengine.setSingleThread(ServerEnv.getEngineSingleThread());
                this.jrengine.setPriority(ServerEnv.getEnginePriority());
                this.jrengine.setUserName(this.getUid());
                if (this.getRemoteHost() != null) {
                    this.jrengine.setClientName(this.getRemoteHost());
                }
                this.jrengine.setThrowException(true);
                this.jrengine.addEngineListener((EngineErrorListener)this);
                this.jrengine.setServerInfo((ServerInfo)this.serverInfo);
                boolean bl = false;
                File file = new File(CSUtil.removeExtName(this.result) + ".pgn");
                try {
                    ServiceLogger.logDebug(6600074, file, 6);
                }
                catch (Throwable throwable) {
                    JDebug.WARNING((Throwable)throwable);
                }
                if (file.exists()) {
                    try {
                        ServiceLogger.logDebug(6600075, file, 6);
                    }
                    catch (Throwable throwable) {
                        JDebug.WARNING((Throwable)throwable);
                    }
                    PageACL pageACL = new PageACL();
                    pageACL.read((InputStream)new FileInputStream(file));
                    object3 = this.jrengine.getPages(pageACL);
                    try {
                        ServiceLogger.logDebug(6600076, object3, 6);
                    }
                    catch (Throwable throwable) {
                        JDebug.WARNING((Throwable)throwable);
                    }
                    if (object3 == null) {
                        throw new PageSecurityException(196610);
                    }
                    if (((int[])object3).length == 0) {
                        throw new PageSecurityException(196611);
                    }
                    this.jrengine.setPageNumbers(object3);
                    bl = true;
                }
                if (this.rstFile != null && !bl) {
                    try {
                        ServiceLogger.logEngine(6600077, new Object[]{this.result, this.rstFile, this.sheet}, 6);
                    }
                    catch (Throwable throwable) {
                        JDebug.WARNING((Throwable)throwable);
                    }
                    this.jrengine.setIsLinkReport(this.sheet, this.isLinkReport_rst);
                    boolean bl2 = this.jrengine.exportToRst(this.result, this.rstFile);
                    try {
                        if (bl2) {
                            ServiceLogger.logEngine(6600078, new Object[]{String.valueOf(bl2), this.result, this.rstFile, this.sheet}, 6);
                        } else {
                            ServiceLogger.logEngine(6600079, new Object[]{String.valueOf(bl2), this.jrengine.getReason(), this.result, this.rstFile, this.sheet}, 6);
                        }
                    }
                    catch (Throwable throwable) {
                        JDebug.WARNING((Throwable)throwable);
                    }
                    if (!bl2) {
                        this.appendError("\n" + JCliResource.getMessage("CS_ERR_25") + " " + this.jrengine.getReason());
                    } else {
                        this.SEDU[0] = this.rstFile;
                    }
                }
                if (this.txtFile != null) {
                    char c = ' ';
                    boolean bl3 = true;
                    if (this.delimiter != null && this.delimiter.length() > 0) {
                        c = this.delimiter.charAt(0);
                    } else {
                        bl3 = false;
                    }
                    try {
                        ServiceLogger.logEngine(6600080, new Object[]{this.result, this.txtFile, this.sheet, String.valueOf(this.isNormalText), String.valueOf(this.isRepeat), String.valueOf(c), String.valueOf(this.charWidth), String.valueOf(this.charHeight), String.valueOf(this.bTxtCompress), String.valueOf(this.isQuoteMark), String.valueOf(this.forWindows), String.valueOf(this.hasHeadFoot)}, 6);
                    }
                    catch (Throwable throwable) {
                        JDebug.WARNING((Throwable)throwable);
                    }
                    boolean bl4 = false;
                    this.jrengine.setIsLinkReport(this.sheet, this.isLinkReport_txt);
                    if (this.sheet == null) {
                        bl4 = this.jrengine.exportToText(this.result, this.txtFile, this.isNormalText, this.isRepeat, c, this.charWidth, this.charHeight, this.bTxtCompress, -1, this.isQuoteMark, this.hasHeadFoot, this.forWindows);
                    } else {
                        object2 = new TextParameter();
                        object2.setNormalTextFile(this.isNormalText);
                        object2.setRepeat(this.isRepeat);
                        if (this.isTab) {
                            c = HttpUtil.decodeEsc("%09").charAt(0);
                            object2.setDelimiter(c);
                        } else if (bl3) {
                            object2.setDelimiter(c);
                        }
                        object2.setUDCHWidth(this.charWidth);
                        object2.setUDCHHeight(this.charHeight);
                        object2.setCompress(this.bTxtCompress);
                        object2.setUseQuoteMark(this.isQuoteMark);
                        object2.setHasHeadFoot(this.hasHeadFoot);
                        object2.setForWinExport(this.forWindows);
                        ExportInfo exportInfo = new ExportInfo();
                        exportInfo.setRstName(this.result);
                        exportInfo.setFileName(this.txtFile);
                        exportInfo.setReportName(this.sheet);
                        bl4 = this.jrengine.exportToText(exportInfo, (TextParameter)object2);
                    }
                    if (!bl4) {
                        this.appendError("\n" + JCliResource.getMessage("CS_ERR_26") + " " + this.jrengine.getReason());
                    } else {
                        this.SEDU[3] = this.txtFile;
                    }
                    try {
                        if (bl4) {
                            ServiceLogger.logEngine(6600081, new Object[]{String.valueOf(bl4), this.result, this.txtFile, this.sheet, String.valueOf(this.isNormalText), String.valueOf(this.isRepeat), String.valueOf(c), String.valueOf(this.charWidth), String.valueOf(this.charHeight), String.valueOf(this.bTxtCompress), String.valueOf(this.isQuoteMark), String.valueOf(this.forWindows), String.valueOf(this.hasHeadFoot)}, 6);
                        } else {
                            ServiceLogger.logEngine(6600082, new Object[]{String.valueOf(bl4), this.jrengine.getReason(), this.result, this.txtFile, this.sheet, String.valueOf(this.isNormalText), String.valueOf(this.isRepeat), String.valueOf(c), String.valueOf(this.charWidth), String.valueOf(this.charHeight), String.valueOf(this.bTxtCompress), String.valueOf(this.isQuoteMark), String.valueOf(this.forWindows), String.valueOf(this.hasHeadFoot)}, 6);
                        }
                    }
                    catch (Throwable throwable) {
                        JDebug.WARNING((Throwable)throwable);
                    }
                }
                if (this.pdfFile != null) {
                    try {
                        ServiceLogger.logEngine(6600083, new Object[]{this.result, this.pdfFile, this.sheet, String.valueOf(this.noMarginPdf), String.valueOf(this.printModePdf), String.valueOf(this.compressImagePdf), String.valueOf(this.isGifTrans), String.valueOf(this.isToc), String.valueOf(this.isDrilldown), this.pdfPassword}, 6);
                    }
                    catch (Throwable throwable) {
                        JDebug.WARNING((Throwable)throwable);
                    }
                    boolean bl5 = false;
                    this.jrengine.setIsLinkReport(this.sheet, this.isLinkReport_pdf);
                    if (this.sheet == null) {
                        bl5 = this.jrengine.exportToPdf(this.result, this.pdfFile, this.noMarginPdf, this.printModePdf, this.compressImagePdf, this.isGifTrans, this.isToc, this.isDrilldown, this.pdfPassword);
                    } else {
                        object3 = new PDFParameter();
                        object3.setNoMargin(this.noMarginPdf);
                        object3.setImageCompressRatio(this.compressImagePdf);
                        object3.setToc(this.isToc);
                        object3.setDrill(this.isDrilldown);
                        object3.setIsSimPrintMode(this.printModePdf);
                        object3.setPassword(this.pdfPassword);
                        stringArray = new ExportInfo();
                        stringArray.setRstName(this.result);
                        stringArray.setFileName(this.pdfFile);
                        stringArray.setReportName(this.sheet);
                        object2 = HttpUtil.getHttpRptServer().getUserPreferenceManager().getUserPreference(this.uid);
                        boolean bl6 = CSUtil.getBoolean(((Properties)object2).getProperty("jrs.pdf_clipping_area"), true);
                        object3.setClippingArea(bl6);
                        bl5 = this.jrengine.exportToPDF((ExportInfo)stringArray, (PDFParameter)object3);
                    }
                    if (!bl5) {
                        this.appendError("\n" + JCliResource.getMessage("CS_ERR_27") + " " + this.jrengine.getReason());
                    } else {
                        this.SEDU[2] = this.jrengine.getAllPdfFile();
                    }
                    try {
                        if (bl5) {
                            ServiceLogger.logEngine(6600084, new Object[]{String.valueOf(bl5), this.result, this.pdfFile, this.sheet}, 6);
                        } else {
                            ServiceLogger.logEngine(6600085, new Object[]{String.valueOf(bl5), this.jrengine.getReason(), this.result, this.pdfFile, this.sheet}, 6);
                        }
                    }
                    catch (Throwable throwable) {
                        JDebug.WARNING((Throwable)throwable);
                    }
                }
                if (this.htmlFile != null) {
                    boolean bl7;
                    try {
                        ServiceLogger.logEngine(6600086, new Object[]{this.result, this.htmlFile, this.sheet, String.valueOf(this.isChartApplet), String.valueOf(this.isMultiFiles), String.valueOf(this.embeddedCSS), String.valueOf(this.hasHyperlink), String.valueOf(this.hasPageNumber), String.valueOf(this.drilldown), String.valueOf(this.useSection508), String.valueOf(this.useHtmlTable), String.valueOf(this.useScope), String.valueOf(this.useTable), String.valueOf(this.relFontSize), String.valueOf(this.browser), String.valueOf(this.overflow), String.valueOf(this.htmResolution), String.valueOf(this.noMarginHtml)}, 6);
                    }
                    catch (Throwable throwable) {
                        JDebug.WARNING((Throwable)throwable);
                    }
                    if (this.isDhtml) {
                        bl7 = this.jrengine.exportToDhtml(this.result, this.htmlFile, this.isChartApplet, this.isMultiFiles, this.useTable, this.hasHyperlink, this.hasPageNumber, !this.relFontSize, this.browser, this.drilldown, this.noMarginHtml, null, this.htmResolution, this.overflow);
                    } else if (this.sheet == null && !this.isHtmlBodyStream) {
                        bl7 = this.jrengine.exportToHtml(this.result, this.htmlFile, this.isChartApplet, this.isMultiFiles, this.useTable, this.hasHyperlink, this.hasPageNumber, !this.relFontSize, this.browser, this.drilldown, this.noMarginHtml, null, this.htmResolution, this.overflow, this.chartFormat);
                    } else {
                        object3 = new HtmlParameter();
                        object3.setIsExportAppletChart(this.isChartApplet);
                        object3.setExportImageType(this.chartFormat);
                        object3.setIsExportToMultiFiles(this.isMultiFiles);
                        object3.setEmbededCSS(this.embeddedCSS);
                        object3.setIsTableFormatHtml(this.useTable);
                        object3.setHasHyperlink(this.hasHyperlink);
                        object3.setHasPageNumber(this.hasPageNumber);
                        object3.setIsAbsoluteFontSize(!this.relFontSize);
                        object3.setBrowserType(this.browser);
                        object3.setIsIncludeDrillDownFile(this.drilldown);
                        object3.setIsSect508Html(this.useSection508);
                        object3.setUseHtmlTable(this.useHtmlTable);
                        object3.setUseScope(this.useScope);
                        object3.setIsNoMargin(this.noMarginHtml);
                        object3.setResolution(this.htmResolution);
                        object3.setOverflowType(this.overflow);
                        stringArray = this.htmlNavNlsLanguage.split("_", 3);
                        object2 = NLSUtil.getHtmlNavNLS(new Locale(stringArray[0], stringArray.length > 1 ? stringArray[1] : ""));
                        object3.setNLSProperties((Properties)object2);
                        ExportInfo exportInfo = new ExportInfo();
                        exportInfo.setRstName(this.result);
                        exportInfo.setFileName(this.htmlFile);
                        exportInfo.setReportName(this.sheet);
                        if (this.isHtmlBodyStream) {
                            exportInfo.setStream(this.htmlBodyOut);
                            bl7 = this.jrengine.exportHtmlBodyToStream(exportInfo, this.cssOut, (HtmlParameter)object3, this.htmlExportPath);
                        } else {
                            bl7 = this.jrengine.exportToHtml(exportInfo, (HtmlParameter)object3);
                        }
                    }
                    if (!bl7) {
                        this.appendError("\n" + JCliResource.getMessage("CS_ERR_28") + " " + this.jrengine.getReason());
                    } else {
                        this.SEDU[1] = this.jrengine.getAllHtmlFile();
                    }
                    try {
                        if (bl7) {
                            ServiceLogger.logEngine(6600087, new Object[]{String.valueOf(bl7), this.result, this.htmlFile, this.sheet, String.valueOf(this.isChartApplet), String.valueOf(this.isMultiFiles), String.valueOf(this.hasHyperlink), String.valueOf(this.hasPageNumber), String.valueOf(this.drilldown), String.valueOf(this.useTable), String.valueOf(this.relFontSize), String.valueOf(this.browser), String.valueOf(this.overflow), String.valueOf(this.htmResolution), String.valueOf(this.noMarginHtml)}, 6);
                        } else {
                            ServiceLogger.logEngine(6600088, new Object[]{String.valueOf(bl7), this.jrengine.getReason(), this.result, this.htmlFile, this.sheet, String.valueOf(this.isChartApplet), String.valueOf(this.isMultiFiles), String.valueOf(this.hasHyperlink), String.valueOf(this.hasPageNumber), String.valueOf(this.drilldown), String.valueOf(this.useTable), String.valueOf(this.relFontSize), String.valueOf(this.browser), String.valueOf(this.overflow), String.valueOf(this.htmResolution), String.valueOf(this.noMarginHtml)}, 6);
                        }
                    }
                    catch (Throwable throwable) {
                        JDebug.WARNING((Throwable)throwable);
                    }
                }
                if (this.xlsFile != null) {
                    try {
                        ServiceLogger.logEngine(6600089, new Object[]{this.result, this.xlsFile, this.sheet, String.valueOf(this.isWordWrapXls), String.valueOf(this.excel2000), String.valueOf(this.hasShapes), String.valueOf(this.excelLayout), String.valueOf(this.excelAdvanced), this.printHeader, this.printFooter, String.valueOf(this.printGridlines)}, 6);
                    }
                    catch (Throwable throwable) {
                        JDebug.WARNING((Throwable)throwable);
                    }
                    boolean bl8 = false;
                    this.jrengine.setIsLinkReport(this.sheet, this.isLinkReport_xls);
                    object3 = new ExcelParameter();
                    object3.setWordWrapType(this.isWordWrapXls);
                    object3.setBiff8(this.excel2000);
                    object3.setParam(this.hasShapes ? 1 : 0);
                    object3.setNewExcelLayout(this.excelLayout);
                    if (this.excelAdvanced) {
                        object3.setPrintPageHeaderAndFooter(this.printHeader, this.printFooter);
                        object3.setPrintGridlinesAble(this.printGridlines);
                    }
                    object3.setFileFormat(this.excelFormat);
                    stringArray = new ExportInfo();
                    stringArray.setRstName(this.result);
                    stringArray.setFileName(this.xlsFile);
                    stringArray.setReportName(this.sheet);
                    bl8 = this.jrengine.exportToXls((ExportInfo)stringArray, (ExcelParameter)object3);
                    if (!bl8) {
                        this.appendError("\n" + JCliResource.getMessage("CS_ERR_29") + " " + this.jrengine.getReason());
                    } else {
                        this.SEDU[4] = this.xlsFile;
                    }
                    try {
                        if (bl8) {
                            ServiceLogger.logEngine(6600090, new Object[]{String.valueOf(bl8), this.result, this.xlsFile, this.sheet, String.valueOf(this.isWordWrapXls), String.valueOf(this.excel2000), String.valueOf(this.hasShapes)}, 6);
                        } else {
                            ServiceLogger.logEngine(6600091, new Object[]{String.valueOf(bl8), this.jrengine.getReason(), this.result, this.xlsFile, this.sheet, String.valueOf(this.isWordWrapXls), String.valueOf(this.excel2000), String.valueOf(this.hasShapes)}, 6);
                        }
                    }
                    catch (Throwable throwable) {
                        JDebug.WARNING((Throwable)throwable);
                    }
                }
                if (this.psFile != null) {
                    try {
                        ServiceLogger.logEngine(6600092, new Object[]{this.result, this.psFile, this.sheet, String.valueOf(this.noMarginPs)}, 6);
                    }
                    catch (Throwable throwable) {
                        JDebug.WARNING((Throwable)throwable);
                    }
                    boolean bl9 = false;
                    this.jrengine.setIsLinkReport(this.sheet, this.isLinkReport_ps);
                    if (this.sheet == null) {
                        bl9 = this.jrengine.exportToPS(this.result, this.psFile, this.noMarginPs);
                    } else {
                        object3 = new PSParameter();
                        object3.setNoMargin(this.noMarginPs);
                        stringArray = new ExportInfo();
                        stringArray.setRstName(this.result);
                        stringArray.setFileName(this.psFile);
                        stringArray.setReportName(this.sheet);
                        bl9 = this.jrengine.exportToPS((ExportInfo)stringArray, (PSParameter)object3);
                    }
                    if (!bl9) {
                        this.appendError("\n" + JCliResource.getMessage("CS_ERR_30") + " " + this.jrengine.getReason());
                    } else {
                        this.SEDU[5] = this.psFile;
                    }
                    try {
                        if (bl9) {
                            ServiceLogger.logEngine(6600093, new Object[]{String.valueOf(bl9), this.result, this.psFile, this.sheet, String.valueOf(this.noMarginPs)}, 6);
                        } else {
                            ServiceLogger.logEngine(6600094, new Object[]{String.valueOf(bl9), this.jrengine.getReason(), this.result, this.psFile, this.sheet, String.valueOf(this.noMarginPs)}, 6);
                        }
                    }
                    catch (Throwable throwable) {
                        JDebug.WARNING((Throwable)throwable);
                    }
                }
                if (this.rtfFile != null) {
                    try {
                        ServiceLogger.logEngine(6600095, new Object[]{this.result, this.rtfFile, this.sheet, String.valueOf(this.noMarginRtf)}, 6);
                    }
                    catch (Throwable throwable) {
                        JDebug.WARNING((Throwable)throwable);
                    }
                    boolean bl10 = false;
                    this.jrengine.setIsLinkReport(this.sheet, this.isLinkReport_rtf);
                    if (this.sheet == null) {
                        bl10 = this.jrengine.exportToRtf(this.result, this.rtfFile, this.noMarginRtf);
                    } else {
                        object3 = new RtfParameter();
                        object3.setNoMargin(this.noMarginRtf);
                        stringArray = new ExportInfo();
                        stringArray.setRstName(this.result);
                        stringArray.setFileName(this.rtfFile);
                        stringArray.setReportName(this.sheet);
                        bl10 = this.jrengine.exportToRtf((ExportInfo)stringArray, (RtfParameter)object3);
                    }
                    if (!bl10) {
                        this.appendError("\n" + JCliResource.getMessage("CS_ERR_62") + " " + this.jrengine.getReason());
                    } else {
                        this.SEDU[6] = this.jrengine.getAllRtfFile();
                    }
                    try {
                        if (bl10) {
                            ServiceLogger.logEngine(6600096, new Object[]{String.valueOf(bl10), this.result, this.rtfFile, this.sheet, String.valueOf(this.noMarginRtf)}, 6);
                        } else {
                            ServiceLogger.logEngine(6600097, new Object[]{String.valueOf(bl10), this.jrengine.getReason(), this.result, this.rtfFile, this.sheet, String.valueOf(this.noMarginRtf)}, 6);
                        }
                    }
                    catch (Throwable throwable) {
                        JDebug.WARNING((Throwable)throwable);
                    }
                }
                if (this.xmlFile != null) {
                    try {
                        ServiceLogger.logEngine(6600098, new Object[]{this.result, this.xmlFile, this.sheet, String.valueOf(this.isOnlyData), this.xsdFile}, 6);
                    }
                    catch (Throwable throwable) {
                        JDebug.WARNING((Throwable)throwable);
                    }
                    boolean bl11 = false;
                    this.jrengine.setIsLinkReport(this.sheet, this.isLinkReport_xml);
                    if (this.sheet == null) {
                        bl11 = this.jrengine.exportToXML(this.result, this.xmlFile, this.isOnlyData, this.xsdFile);
                    } else {
                        object3 = new XmlParameter();
                        object3.setOnlyData(this.isOnlyData);
                        object3.setSchemaFile(this.xsdFile);
                        stringArray = new ExportInfo();
                        stringArray.setRstName(this.result);
                        stringArray.setFileName(this.xmlFile);
                        stringArray.setReportName(this.sheet);
                        bl11 = this.jrengine.exportToXML((ExportInfo)stringArray, (XmlParameter)object3);
                    }
                    if (!bl11) {
                        this.appendError("\n" + JCliResource.getMessage("CS_ERR_64") + " " + this.jrengine.getReason());
                    } else {
                        this.SEDU[7] = this.jrengine.getAllXMLFile();
                    }
                    try {
                        if (bl11) {
                            ServiceLogger.logEngine(6600099, new Object[]{String.valueOf(bl11), this.result, this.xmlFile, this.sheet, String.valueOf(this.isOnlyData), this.xsdFile}, 6);
                        } else {
                            ServiceLogger.logEngine(6600100, new Object[]{String.valueOf(bl11), this.jrengine.getReason(), this.result, this.xmlFile, this.sheet, String.valueOf(this.isOnlyData), this.xsdFile}, 6);
                        }
                    }
                    catch (Throwable throwable) {
                        JDebug.WARNING((Throwable)throwable);
                    }
                }
                if (this.ifPrint) {
                    Communicator communicator = this.jrengine.getCommunicator(this.result, this.jrengine.getPageNumbers());
                    try {
                        ServiceLogger.logEngine(6600101, new Object[]{communicator, this.printer, this.jrengine}, 6);
                    }
                    catch (Throwable throwable) {
                        JDebug.WARNING((Throwable)throwable);
                    }
                    if (communicator != null) {
                        JReportSwingPrinter.printInSameProcess(null, (Communicator)communicator, null, (boolean)false, null, (boolean)true, null, (int)this.useJDK, (boolean)true, (boolean)true, null, (Vector)this.printAttr, (String)this.printer, (ExportAuxInfo)new ExportAuxInfo(this.getResourceStore().getDiskStore()));
                    }
                    try {
                        ServiceLogger.logEngine(6600102, new Object[]{communicator, this.jrengine}, 6);
                    }
                    catch (Throwable throwable) {
                        JDebug.WARNING((Throwable)throwable);
                    }
                }
                this.jrengine.exit();
                ServiceLogger.logEngine(6600103, this.jrengine, 6);
            }
            catch (Throwable throwable) {
                try {
                    ServiceLogger.logDebug(SchdTools.getStackTraceString(throwable), 6);
                }
                catch (Throwable throwable2) {
                    JDebug.WARNING((Throwable)throwable2);
                }
                if (this.jrengine != null) {
                    // empty if block
                }
                if (throwable instanceof ThreadDeath) {
                    this.jrengine = null;
                    throw throwable;
                }
                if (throwable instanceof EngingPreinitException && ((EngingPreinitException)throwable).getException() instanceof OutOfMemoryError) {
                    object = ((EngingPreinitException)throwable).getException();
                }
                if (object instanceof OutOfMemoryError) {
                    if (this.jrengine != null) {
                        this.jrengine.stopReport();
                        this.jrengine.exit();
                        ServiceLogger.logEngine(6600104, this.jrengine, 4);
                        this.jrengine = null;
                    }
                    System.gc();
                    Runtime runtime = Runtime.getRuntime();
                    int n = 0;
                    while (runtime.freeMemory() < 1000000L) {
                        try {
                            System.gc();
                            if (n++ > 5) break;
                            Thread.currentThread().wait(1000L);
                        }
                        catch (Exception exception) {
                            ServiceLogger.logError(exception, 3);
                        }
                    }
                }
                this.appendError(SchdTools.getStackTraceString((Throwable)object));
                if (!this.isThrowExcp) break block137;
                this.jrengine = null;
                throw object;
            }
        }
        this.jrengine = null;
        if (ServerEnv.exeGC) {
            System.gc();
        }
        if (this.thrdThrow != null) {
            this.appendError(SchdTools.getStackTraceString(this.thrdThrow));
            if (this.isThrowExcp) {
                throw this.thrdThrow;
            }
        }
        if (this.isThrowExcp && this.getErrorMsg() != null) {
            throw new RptServerException(this.getErrorMsg());
        }
        try {
            ServiceLogger.logDebug(6600040, this, 6);
        }
        catch (Throwable throwable) {
            JDebug.WARNING((Throwable)throwable);
        }
        if (this.hasListener && this.taskListener != null) {
            this.taskListener.afterRun(this.serverInfo);
        }
    }

    public void appendError(String string) {
        this.errId = true;
        this.errmsg = this.errmsg != null ? this.errmsg + "\r\n" + string : string;
        ServiceLogger.logError(this + "\r\n" + string);
    }

    @Override
    public boolean hasError() {
        return this.errId;
    }

    public void setThrow(boolean bl) {
        this.isThrowExcp = bl;
    }

    public void started() {
    }

    public void finished() {
    }

    public void ThreadException(Thread thread, Throwable throwable) {
        if (throwable instanceof ThreadDeath) {
            return;
        }
        this.thrdThrow = throwable;
    }

    public void noteError(Thread thread, Throwable throwable, int n, String string) {
        if (throwable instanceof ThreadDeath) {
            return;
        }
        this.thrdThrow = throwable;
    }

    public void notifyReceiver(EngineErrorListener engineErrorListener) {
    }

    @Override
    public String toString() {
        return super.toString() + "\r\nresult=" + this.result + "\r\nrst file=" + this.rstFile + "\r\nhtml file=" + this.htmlFile + "\r\npdf file=" + this.pdfFile + "\r\ntxt file=" + this.txtFile + "\r\nis Normal Text=" + this.isNormalText + "\r\nxls file=" + this.xlsFile + "\r\nps file=" + this.psFile + "\r\nrtf file=" + this.rtfFile + "\r\nxml file=" + this.xmlFile;
    }

    @Override
    public Properties toProperties(Properties properties) {
        Properties properties2 = super.toProperties(properties);
        if (properties2 == null) {
            properties2 = new Properties();
        }
        properties2.put("jrs.result", this.result);
        if (this.errmsg != null) {
            properties2.put("jrs.error", this.errmsg);
        }
        return properties2;
    }

    @Override
    public String getErrorMsg() {
        return this.errmsg;
    }

    @Override
    public void stopExec() {
        this.stopExec(false);
    }

    @Override
    public void stopExec(boolean bl) {
        if (this.jrengine != null && !bl) {
            this.jrengine.exit();
            ServiceLogger.logEngine(6600005, this.jrengine, 4);
        }
    }

    private boolean addEngineListener() {
        if (this.rstFile != null) {
            return false;
        }
        if (this.htmlFile != null) {
            return false;
        }
        if (this.pdfFile != null) {
            return false;
        }
        if (this.xlsFile != null) {
            return false;
        }
        if (this.psFile != null) {
            return false;
        }
        if (this.rtfFile != null) {
            return false;
        }
        if (this.xmlFile != null) {
            return false;
        }
        return this.txtFile != null && !this.isNormalText;
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
    }
}

