/*
 * Decompiled with CFR 0.152.
 */
package jet.server.schedule.jrtasks;

import com.jinfonet.resstore.ResourceStore;
import java.io.File;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import jet.JSvrResource;
import jet.ReportEnv;
import jet.bean.CustomJobName;
import jet.bean.CustomJobPriority;
import jet.bean.CustomMediaCopies;
import jet.bean.CustomMediaMargin;
import jet.bean.CustomMediaTray;
import jet.bean.CustomPageRanges;
import jet.bean.CustomToFile;
import jet.bean.CustomUserName;
import jet.bean.MailInformation;
import jet.cs.CSMail;
import jet.cs.CSUtil;
import jet.cs.util.APIUtil;
import jet.datasource.InputStreamFactory;
import jet.export.ExportAuxInfo;
import jet.export.mail.mail;
import jet.export.print.JReportSwingPrinter;
import jet.server.ServerEnv;
import jet.server.api.RptServerException;
import jet.server.api.TaskListener;
import jet.server.api.admin.cfg.ConfigurationMail;
import jet.server.api.http.HttpUtil;
import jet.server.jrc.JRTaskManager;
import jet.server.log.ServiceLogger;
import jet.server.resstore.impl.JRServerResourceStoreFactory;
import jet.server.schedule.CustomTask;
import jet.server.schedule.JRServerInfo;
import jet.server.schedule.SchdTools;
import jet.server.schedule.jrtasks.JRTUtil;
import jet.server.schedule.jrtasks.ViewRptTask;
import jet.server.util.WebSecurityUtil;
import jet.util.NLSBundleInfo;

public abstract class JRTask
extends CustomTask {
    private static int LINE = ReportEnv.getR();
    JRTaskManager taskManager = null;
    protected String run_task_id = null;
    protected boolean successNotify = false;
    protected boolean failNotify = false;
    protected Vector notifyMails = null;
    protected boolean ifPrint = false;
    protected String printer = null;
    protected boolean hasListener = false;
    protected String listenerClass = null;
    protected TaskListener taskListener = null;
    private Properties add = new Properties();
    private boolean addElement = false;
    protected int useJDK = -1;
    protected String printOrientation = null;
    protected String printChromaticity = null;
    protected String printQuality = null;
    protected String printSides = null;
    protected String printCollate = null;
    protected String size = null;
    protected int[] begin = new int[1];
    protected int[] end = new int[1];
    protected String jobname = null;
    protected String username = null;
    protected int priority = 0;
    protected File toFile;
    protected int copies = 1;
    protected float leftMargin = -1.0f;
    protected float rightMargin = -1.0f;
    protected float topMargin = -1.0f;
    protected float bottomMargin = -1.0f;
    protected int unit = -1;
    protected String customMediaTray = null;
    protected Vector customMedias = new Vector();
    protected Vector printAttr = new Vector();
    protected int recoverTaskMaxtimes = 0;
    protected long recoverTaskInterval = 0L;
    protected boolean recoverTaskRedoAll = false;
    protected int recoverTaskCount = 0;
    protected boolean fatalError = false;
    protected Properties initht = new Properties();
    protected String taskStstus = "";
    protected boolean hasHandleDuration = false;
    protected boolean hasNLSBundleInfo = false;
    protected NLSBundleInfo nlsBundleInfo = null;
    protected boolean hasXMLDatasource = false;
    protected String xmlDatasourceName = null;
    protected InputStreamFactory xmlInstreamFactory = null;
    protected boolean hasHDSDatasource = false;
    protected String hdsDatasourceName = null;
    protected String hdsName = null;
    protected InputStreamFactory hdsInstreamFactory = null;
    protected int queuePriority = -1;
    private Throwable append = null;
    protected String uid = null;
    protected String organization = null;

    @Override
    public void init(Properties properties) throws Exception {
        super.init(properties);
        this.uid = (String)properties.get("jrs.uid");
        this.organization = CSUtil.parsePrincipalDisplayName(this.uid)[0];
        this.initht = (Properties)properties.clone();
        this.recoverTaskMaxtimes = APIUtil.parseInt((String)properties.get("jrs.auto_recover_task.maxtimes"), -1);
        this.recoverTaskInterval = CSUtil.parseLong((String)properties.get("jrs.auto_recover_task.interval"), -1L);
        this.recoverTaskRedoAll = APIUtil.getBoolean((String)properties.get("jrs.auto_recover_task.redo_all_subtasks"), ServerEnv.getAutoRecoverTaskRedoAll());
        this.recoverTaskCount = APIUtil.parseInt((String)properties.get("jrs.auto_recover_task.count"), 0);
        if (this.recoverTaskMaxtimes < 0 || this.recoverTaskMaxtimes > Integer.MAX_VALUE) {
            if (ServiceLogger.isLoggable(4, 6)) {
                ServiceLogger.logDebug(6600146, new Object[]{"recoverTaskMaxtimes", String.valueOf(this.recoverTaskMaxtimes), String.valueOf(ServerEnv.getAutoRecoverTaskMaxTimes())}, 6);
            }
            this.recoverTaskMaxtimes = ServerEnv.getAutoRecoverTaskMaxTimes();
        }
        if (this.recoverTaskInterval < 0L || this.recoverTaskInterval > 9223372036854775L) {
            if (ServiceLogger.isLoggable(4, 6)) {
                ServiceLogger.logDebug(6600146, new Object[]{"recoverTaskInterval", String.valueOf(this.recoverTaskInterval), String.valueOf(ServerEnv.getAutoRecoverTaskInterval())}, 6);
            }
            this.recoverTaskInterval = ServerEnv.getAutoRecoverTaskInterval();
        }
        this.recoverTaskInterval *= 1000L;
        this.add = this.findUserDefinedProperties(properties);
        this.run_task_id = (String)properties.get("jrs.run_task_id");
        this.run_task_id = this.run_task_id == null ? SchdTools.getIdBase() : this.run_task_id;
        this.successNotify = CSUtil.getBoolean((String)properties.get("jrs.success_notify"), false);
        this.failNotify = CSUtil.getBoolean((String)properties.get("jrs.fail_notify"), false);
        this.notifyMails = CSMail.parseMails((String)properties.get("jrs.notification_emails"));
        this.printer = (String)properties.get("jrs.printer");
        this.ifPrint = CSUtil.getBoolean((String)properties.get("jrs.if_print"), false);
        this.addElement = CSUtil.getBoolean((String)properties.get("jrs.to_printer"), false);
        this.LINE(properties);
        this.hasListener = CSUtil.getBoolean((String)properties.get("jrs.has_task_listener"), false);
        if (this.hasListener) {
            this.listenerClass = (String)properties.get("jrs.task_listener_class");
            if (this.taskListener == null) {
                this.setTaskListener(this.listenerClass);
            }
        }
        this.hasNLSBundleInfo = CSUtil.getBoolean((String)properties.get("jrs.has_nls_bundle_info"), false);
        if (this.hasNLSBundleInfo) {
            this.nlsBundleInfo = (NLSBundleInfo)properties.get("jrs.nls_bundle_info");
            if (this.nlsBundleInfo == null) {
                this.hasNLSBundleInfo = false;
            }
        }
        this.hasXMLDatasource = CSUtil.getBoolean((String)properties.get("jrs.has_xml_data_source"), false);
        if (this.hasXMLDatasource) {
            this.xmlDatasourceName = (String)properties.get("jrs.xml_data_source_name");
            this.xmlInstreamFactory = (InputStreamFactory)properties.get("jrs.xml_inputstream_factory");
            if (this.xmlDatasourceName == null || this.xmlInstreamFactory == null) {
                throw new RptServerException(600034);
            }
        }
        this.hasHDSDatasource = CSUtil.getBoolean((String)properties.get("jrs.has_hds_data_source"), false);
        if (this.hasHDSDatasource) {
            this.hdsDatasourceName = (String)properties.get("jrs.hds_data_source_name");
            this.hdsName = (String)properties.get("jrs.hds_name");
            this.hdsInstreamFactory = (InputStreamFactory)properties.get("jrs.hds_inputstream_factory");
            if (this.hdsDatasourceName == null || this.hdsName == null || this.hdsInstreamFactory == null || this.hdsName == null) {
                throw new RptServerException(600035);
            }
        }
        this.queuePriority = CSUtil.parseInt(properties.getProperty("jrs.tsk_priority"));
        if (this.queuePriority < 0 || this.queuePriority > 10) {
            this.queuePriority = this instanceof ViewRptTask ? ServerEnv.getOndemandTaskInitPriority() : ServerEnv.getScheduleTaskInitPriority();
        }
    }

    private void LINE(Properties properties) {
        if (this.addElement) {
            this.useJDK = CSUtil.parseInt((String)properties.get("jrs.print_usejdk"), -1);
            if (this.useJDK == 2) {
                this.printOrientation = (String)properties.get("jrs.print_orientation");
                this.printChromaticity = (String)properties.get("jrs.print_chromaticity");
                this.printQuality = (String)properties.get("jrs.print_quality");
                this.printSides = (String)properties.get("jrs.print_sides");
                this.printCollate = (String)properties.get("jrs.print_sheetcollate");
                this.printAttr.addElement(this.printOrientation);
                this.printAttr.addElement(this.printChromaticity);
                this.printAttr.addElement(this.printQuality);
                this.printAttr.addElement(this.printSides);
                this.printAttr.addElement(this.printCollate);
                this.size = (String)properties.get("jrs.print_size");
                this.begin[0] = CSUtil.parseInt((String)properties.get("jrs.forward_range"));
                this.end[0] = CSUtil.parseInt((String)properties.get("jrs.after_range"));
                String string = WebSecurityUtil.validateFilePathStr((String)properties.get("jrs.print_to_file"));
                if (string != null) {
                    this.toFile = new File(string);
                }
                this.jobname = (String)properties.get("jrs.print_job_name");
                this.username = (String)properties.get("jrs.print_user_name");
                this.priority = CSUtil.parseInt((String)properties.get("jrs.print_priority"));
                this.copies = CSUtil.parseInt((String)properties.get("jrs.print_copies"));
                this.leftMargin = CSUtil.parseFloat((String)properties.get("jrs.margins_left"));
                this.rightMargin = CSUtil.parseFloat((String)properties.get("jrs.margins_right"));
                this.topMargin = CSUtil.parseFloat((String)properties.get("jrs.margins_top"));
                this.bottomMargin = CSUtil.parseFloat((String)properties.get("jrs.margins_bottom"));
                String string2 = (String)properties.get("jrs.margins_unit");
                this.unit = 1000;
                if (string2 != null && "jrs.margins_unit_inch".equals(string2)) {
                    this.unit = 25400;
                }
                this.customMediaTray = (String)properties.get("jrs.print_mediatray");
                boolean bl = CSUtil.getBoolean(properties.getProperty("jrs.print_is_to_file"));
                boolean bl2 = CSUtil.getBoolean(properties.getProperty("jrs.print_is_job_attributes"));
                boolean bl3 = CSUtil.getBoolean(properties.getProperty("jrs.has_margins"));
                if (this.copies >= 1) {
                    this.customMedias.addElement(new CustomMediaCopies(this.copies));
                }
                if (bl3 && this.leftMargin >= 0.0f && this.rightMargin >= 0.0f && this.topMargin >= 0.0f && this.bottomMargin >= 0.0f) {
                    this.customMedias.addElement(new CustomMediaMargin(this.leftMargin, this.rightMargin, this.topMargin, this.bottomMargin, this.unit));
                }
                if (this.customMediaTray != null) {
                    this.customMedias.addElement(new CustomMediaTray(this.customMediaTray));
                }
                if (this.toFile != null && bl) {
                    this.customMedias.add(new CustomToFile(this.toFile));
                }
                if (this.begin[0] <= this.end[0] && this.begin[0] > 0) {
                    this.customMedias.add(new CustomPageRanges(this.begin, this.end));
                }
                if (this.size != null) {
                    this.customMedias.add(JReportSwingPrinter.getCustomMediaPaper((String)this.size));
                }
                if (bl2) {
                    if (this.jobname != null) {
                        this.customMedias.add(new CustomJobName(this.jobname));
                    }
                    if (this.username != null) {
                        this.customMedias.add(new CustomUserName(this.username));
                    }
                    if (this.priority > 0) {
                        this.customMedias.add(new CustomJobPriority(this.priority));
                    }
                }
            }
        }
    }

    protected void setServerInfo(Properties properties) {
        Object object = properties.get("jrs.schd_props");
        Properties properties2 = null;
        properties2 = object instanceof String ? CSUtil.parseQuery((String)object) : (Properties)object;
        if (this.serverInfo == null) {
            this.serverInfo = new JRServerInfo(this.toProperties(properties2));
        } else {
            this.serverInfo.getTaskProperties().putAll((Map<?, ?>)this.toProperties(properties2));
        }
        this.serverInfo.setRequestURL((String)properties.get("jrs.request_url"));
        this.serverInfo.setRemoteAddr((String)properties.get("jrs.remote_addr"));
    }

    public void setServerInfo(JRServerInfo jRServerInfo) {
        this.serverInfo = jRServerInfo;
    }

    public void setTaskListener(String string) {
        if (JRTUtil.validateTaskListenerClass(string)) {
            this.hasListener = true;
            this.listenerClass = string;
            try {
                this.taskListener = (TaskListener)Class.forName(string).newInstance();
            }
            catch (Throwable throwable) {
                this.hasListener = false;
                ServiceLogger.logError(throwable);
            }
        } else {
            this.hasListener = false;
            this.listenerClass = null;
            this.taskListener = null;
        }
    }

    public void setTaskListener(TaskListener taskListener) {
        this.taskListener = taskListener;
    }

    public String getTaskListener() {
        return this.listenerClass;
    }

    public static final void updateMaxReports() {
        LINE = ReportEnv.getR();
    }

    public static final int getMaxReports() {
        return LINE;
    }

    public JRTaskManager getJRTaskManager() {
        return this.taskManager;
    }

    public void setJRTaskManager(JRTaskManager jRTaskManager) {
        this.taskManager = jRTaskManager;
    }

    public Vector getNotifyMails() {
        return this.notifyMails;
    }

    public boolean getSuccessNotify() {
        return this.successNotify;
    }

    public boolean getFailNotify() {
        return this.failNotify;
    }

    public boolean isPrint() {
        return this.ifPrint;
    }

    protected ResourceStore getResourceStore() {
        return JRServerResourceStoreFactory.getInstance().getResourceStoreByUser(this.uid);
    }

    public String execNotification(boolean bl, String string, String string2, String string3, String string4, Date date, String string5, int n, String string6) {
        String string7 = null;
        try {
            int n2;
            if (this.notifyMails != null && (n2 = this.notifyMails.size()) > 0) {
                ConfigurationMail configurationMail = HttpUtil.getHttpRptServer().getAdminService().getConfigService().getConfigurationMail();
                String string8 = configurationMail.getMailBox();
                String string9 = configurationMail.getEncoding();
                if (string9.length() == 0) {
                    string9 = CSUtil.getUrlEncoding();
                }
                mail mail2 = new mail(null, null, string9, new ExportAuxInfo(this.getResourceStore().getDiskStore()));
                for (int i = 0; i < n2; ++i) {
                    CSMail cSMail = (CSMail)this.notifyMails.elementAt(i);
                    try {
                        String string10;
                        String string11 = cSMail.comments == null ? "" : cSMail.comments;
                        String string12 = cSMail.subject;
                        if (bl) {
                            string12 = string12 + " (Task ID:" + string2 + " " + JSvrResource.getMessage("SLT_PG_201") + ")";
                        } else {
                            string12 = string12 + " (Task ID:" + string2 + " " + JSvrResource.getMessage("SLT_PG_202") + ")";
                            string11 = cSMail.comments + (this.addElement(bl, string) == null ? "" : this.addElement(bl, string)) + "\n" + (this.add(bl, string) == null ? "" : this.add(bl, string));
                        }
                        string11 = string11 + "\r\n---------------------------------\r\n";
                        string11 = string11 + "Task ID: " + string2 + "\r\n";
                        string11 = string11 + "Catalog: " + string3 + "\r\n";
                        if (string4 != null) {
                            string11 = string11 + "Report: " + string4 + "\r\n";
                        } else if (string5 != null && string6 != null) {
                            string11 = string11 + "Data Source: " + string5 + "\r\n";
                            string10 = "";
                            if (n == 1) {
                                string10 = "Imported SQL";
                            } else if (n == 2) {
                                string10 = "Stored Procedure";
                            } else if (n == 3) {
                                string10 = "User Defined";
                            } else if (n == 4) {
                                string10 = "Hierarchical";
                            } else if (n == 5) {
                                string10 = "Query";
                            } else if (n == 6) {
                                string10 = "Parameter";
                            }
                            string11 = string11 + "Query Type: " + string10 + "\r\n";
                            string11 = string11 + "Query Name: " + string6 + "\r\n";
                        }
                        string11 = string11 + "Completed Time: " + DateFormat.getDateTimeInstance().format(date) + "\r\n";
                        string10 = new MailInformation();
                        string10.setMailTo(cSMail.to);
                        string10.setCarbonCopy(cSMail.cc);
                        string10.setBlindCarbonCopy(cSMail.bcc);
                        string10.setSubject(string12);
                        string10.setComments(string11);
                        if (cSMail.user != null && cSMail.pwd != null && cSMail.from != null && cSMail.user.length() != 0 && cSMail.pwd.length() != 0 && cSMail.from.length() != 0) {
                            string10.setMailFrom(cSMail.from);
                            string10.setAuthencatorMessage(cSMail.user, cSMail.pwd, cSMail.from);
                        } else {
                            string10.setMailFrom(string8);
                            if (configurationMail.getAuthentication()) {
                                string10.setAuthencatorMessage(configurationMail.getAuthenticationUser(), configurationMail.getAuthenticationPassword(), string8);
                            }
                        }
                        mail2.send((MailInformation)string10);
                        continue;
                    }
                    catch (Throwable throwable) {
                        string7 = string7 == null ? "Fail to notify: \"" + cSMail.to + "\"" : string7 + "; \"" + cSMail.to + "\"";
                        string7 = string7 + "-[" + throwable.getMessage() + "]";
                    }
                }
            }
        }
        catch (Throwable throwable) {
            string7 = string7 == null ? "Fail to notify: [" + throwable + "]" : string7 + "; Throwable[" + throwable + "]";
        }
        return string7;
    }

    public String execTimeoutNotification(CSMail cSMail) {
        String string = null;
        try {
            mail mail2 = new mail(null, null, CSUtil.getUrlEncoding(), new ExportAuxInfo(this.getResourceStore().getDiskStore()));
            try {
                mail2.send(cSMail.to, cSMail.cc, cSMail.bcc, cSMail.subject, cSMail.comments, cSMail.compress, -1, cSMail.attachedFiles);
            }
            catch (Throwable throwable) {
                string = "Fail to notify: \"" + cSMail.to + "\"";
                string = string + "-[" + throwable.getMessage() + "]";
            }
        }
        catch (Throwable throwable) {
            string = "Fail to notify: [" + throwable + "]";
        }
        return string;
    }

    private String SEDU(boolean bl) {
        String string = null;
        if (this.failNotify && !bl) {
            string = " (" + JSvrResource.getMessage("SLT_PG_202") + ")";
        }
        if (this.successNotify && bl) {
            string = " (" + JSvrResource.getMessage("SLT_PG_201") + ")";
        }
        return string;
    }

    private String add(boolean bl, String string) {
        String string2 = null;
        if (this.failNotify && !bl) {
            string2 = "*************Technical Details**************\n" + string + "\n" + "********************************************\n";
        }
        return string2;
    }

    private String addElement(boolean bl, String string) {
        String string2 = null;
        if (string.indexOf("\n\tat") > 0) {
            string = string.substring(0, string.indexOf("\n\tat"));
        }
        if (this.failNotify && !bl) {
            string2 = "--------------Error Message-------------\n" + string + "----------------------------------------\n";
        }
        return string2;
    }

    protected Properties findUserDefinedProperties(Properties properties) {
        Properties properties2 = new Properties();
        String string = "";
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (!string.startsWith("UDP$")) continue;
            properties2.put(string, properties.get(string));
        }
        return properties2;
    }

    @Override
    public Properties toProperties(Properties properties) {
        Properties properties2 = properties;
        if (properties2 == null) {
            properties2 = new Properties();
        }
        properties2.put("jrs.success_notify", String.valueOf(this.successNotify));
        properties2.put("jrs.fail_notify", String.valueOf(this.failNotify));
        if (this.notifyMails != null) {
            properties2.put("jrs.notification_emails", CSMail.toRawString(this.notifyMails));
        }
        properties2.put("jrs.if_print", String.valueOf(this.ifPrint));
        if (this.printer != null) {
            properties2.put("jrs.printer", this.printer);
        } else {
            properties2.remove("jrs.printer");
        }
        properties2.put("jrs.task_class", this.getClass().getName());
        properties2.put("jrs.has_task_listener", String.valueOf(this.hasListener));
        if (this.listenerClass != null) {
            properties2.put("jrs.task_listener_class", this.listenerClass);
        } else {
            properties2.remove("jrs.task_listener_class");
        }
        properties2.putAll((Map<?, ?>)this.add);
        if (this.addElement) {
            properties2.put("jrs.print_usejdk", String.valueOf(this.useJDK));
            if (this.useJDK == 2) {
                if (this.printOrientation != null) {
                    properties2.put("jrs.print_orientation", this.printOrientation);
                }
                if (this.printChromaticity != null) {
                    properties2.put("jrs.print_chromaticity", this.printChromaticity);
                }
                if (this.printQuality != null) {
                    properties2.put("jrs.print_quality", this.printQuality);
                }
                if (this.printSides != null) {
                    properties2.put("jrs.print_sides", this.printSides);
                }
                if (this.printCollate != null) {
                    properties2.put("jrs.print_sheetcollate", this.printCollate);
                }
            }
        }
        if (this.queuePriority != -1) {
            properties2.put("jrs.tsk_priority", String.valueOf(this.queuePriority));
        }
        return properties2;
    }

    @Override
    public String toString() {
        return super.toString() + "\r\nsuccessNotify=" + this.successNotify + "\r\nfailNotify=" + this.failNotify + "\r\nnotifyMails=" + this.notifyMails + "\r\nprinter=" + this.printer + "\r\nifPrint=" + this.ifPrint + "\r\nhasListener=" + this.hasListener + "\r\nlistenerClass=" + this.listenerClass + "\r\nqueuePriority=" + this.queuePriority;
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
    }

    public static String filterTaskScript(Hashtable hashtable, boolean bl) {
        if (hashtable == null) {
            return CSUtil.LINE;
        }
        Vector vector = new Vector();
        CSUtil.appendScript(vector, hashtable, "jrs.task_id", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.is_enabled", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.schedule_name", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.task_class", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.uid", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.success_notify", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.fail_notify", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.notification_emails", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.has_task_listener", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.task_listener_class", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.submit_time", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.if_print", true, bl);
        CSUtil.appendScript(vector, hashtable, "jrs.tsk_priority", true, bl);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < vector.size(); ++i) {
            stringBuffer.append((String)vector.get(i)).append(CSUtil.LINE);
        }
        return stringBuffer.toString();
    }

    public String getRunTaskId() {
        return this.run_task_id;
    }

    public boolean hasFatalError() {
        return this.fatalError;
    }

    public void setFatalError(boolean bl) {
        this.fatalError = bl;
    }

    public int getRecoverTaskMaxtimes() {
        return this.recoverTaskMaxtimes;
    }

    public long getRecoverTaskInterval() {
        return this.recoverTaskInterval;
    }

    public boolean isRecoverTaskRedoAll() {
        return this.recoverTaskRedoAll;
    }

    public int getRecoverTaskCount() {
        return this.recoverTaskCount;
    }

    public Properties getInitht() {
        return this.initht;
    }

    public void setStatus(String string) {
        this.taskStstus = string;
    }

    public String getStatus() {
        return this.taskStstus;
    }

    public void setHandledDuration(boolean bl) {
        this.hasHandleDuration = bl;
    }

    public boolean hasHandledDuration() {
        return this.hasHandleDuration;
    }

    public int getTaskPriority() {
        return this.queuePriority;
    }

    public void setTaskPriority(int n) {
        this.queuePriority = n;
    }

    public Throwable getThrowable() {
        return this.append;
    }

    protected void setThrowable(Throwable throwable) {
        this.append = throwable;
    }
}

