/*
 * Decompiled with CFR 0.152.
 */
package jet.server.schedule.jrtasks;

import java.util.Properties;
import jet.cs.CSUtil;
import jet.server.api.crd.CRDInfoKey;
import jet.server.api.crd.CRDManageException;
import jet.server.api.crd.CubeInfoKey;
import jet.server.api.http.HttpUtil;
import jet.server.jrserver.JRRptServer;
import jet.server.jrserver.crd.JRCRDManager;
import jet.server.log.ServiceLogger;
import jet.server.schedule.jrtasks.JRTask;

public class PublishCRDTask
extends JRTask {
    private String SEDU = null;
    private String append = null;
    private int appendError = 0;
    private String get = null;
    private boolean getBoolean = false;
    private String getCRDManager = null;
    private boolean getHttpRptServer = false;
    private String getMessage = null;

    @Override
    public void init(Properties properties) throws Exception {
        super.init(properties);
        this.SEDU = (String)properties.get("jrs.catalog");
        this.append = (String)properties.get("jrs.data_source_name");
        this.appendError = CSUtil.parseInt((String)properties.get("jrs.query_type"), 0);
        this.get = (String)properties.get("jrs.query_name");
        this.getBoolean = CSUtil.getBoolean(properties.getProperty("jrs.is_cube"), false);
        if (this.getBoolean) {
            this.getCRDManager = properties.getProperty("jrs.bv_name");
        }
    }

    @Override
    public void run() {
        JRRptServer jRRptServer = (JRRptServer)((Object)HttpUtil.getHttpRptServer());
        CRDInfoKey cRDInfoKey = null;
        cRDInfoKey = !this.getBoolean ? new CRDInfoKey(this.SEDU, this.append, this.appendError, this.get) : new CubeInfoKey(this.SEDU, this.append, this.appendError, this.get, this.getCRDManager);
        JRCRDManager jRCRDManager = jRRptServer.getCRDManager();
        try {
            jRCRDManager.updateCRDResult(cRDInfoKey);
        }
        catch (CRDManageException cRDManageException) {
            this.appendError(cRDManageException.getMessage());
        }
    }

    public void appendError(String string) {
        this.getHttpRptServer = true;
        this.getMessage = this.getMessage != null ? this.getMessage + "\r\n" + string : string;
        ServiceLogger.logError(this + "\r\n" + string);
    }

    @Override
    public boolean hasError() {
        return this.getHttpRptServer;
    }

    @Override
    public String getErrorMsg() {
        return this.getMessage;
    }

    @Override
    public void stopExec() {
    }

    @Override
    public void stopExec(boolean bl) {
    }

    public String getCatalog() {
        return this.SEDU;
    }

    public String getDataSource() {
        return this.append;
    }

    public int getQueryType() {
        return this.appendError;
    }

    public String getQueryName() {
        return this.get;
    }
}

