/*
 * Decompiled with CFR 0.152.
 */
package jet.server.schedule.jrtasks;

import guitools.toolkit.JDebug;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Properties;
import java.util.Vector;
import jet.JCliResource;
import jet.ReportEnv;
import jet.bean.ExcelParameter;
import jet.bean.HtmlParameter;
import jet.bean.MailInformation;
import jet.bean.PDFParameter;
import jet.bean.PSParameter;
import jet.bean.RtfParameter;
import jet.bean.TextParameter;
import jet.bean.XmlParameter;
import jet.cs.CSMail;
import jet.cs.CSUtil;
import jet.cs.JRMail;
import jet.export.ExportAuxInfo;
import jet.export.mail.mail;
import jet.export.mail.mailconfig;
import jet.server.ServerEnv;
import jet.server.api.admin.cfg.ConfigurationMail;
import jet.server.api.http.HttpUtil;
import jet.server.log.ServiceLogger;
import jet.server.schedule.SchdTools;
import jet.server.schedule.jrtasks.RunRptTaskRoot;
import jet.server.util.WebSecurityUtil;

public class SendMailTask
extends RunRptTaskRoot {
    protected Vector mails = null;
    protected Vector mailInfos = null;
    private boolean DefaultFormat = false;
    private boolean addElement = false;
    private boolean addProperties = false;
    private boolean append = false;
    private boolean appendError = false;
    private boolean attachedFiles = false;
    private boolean bcc = false;
    private boolean cc = false;
    private boolean charAt = false;
    private String clear = null;
    protected String properties = "";

    @Override
    public void init(Properties properties) throws Exception {
        super.init(properties);
        this.mails = CSMail.getMails(properties);
        if (this.mails == null || this.mails.size() == 0) {
            throw new Exception(this + " " + JCliResource.getMessage("CS_ERR_46") + " " + properties);
        }
        if (this.mails.size() > 0) {
            this.mailInfos = new Vector();
            for (int i = 0; i < this.mails.size(); ++i) {
                CSMail cSMail;
                Object e = this.mails.elementAt(i);
                MailInformation mailInformation = null;
                if (e instanceof JRMail) {
                    cSMail = (JRMail)this.mails.elementAt(i);
                    mailInformation = this.DefaultFormat(((JRMail)cSMail).toProperties(null), properties);
                } else if (e instanceof CSMail) {
                    cSMail = (CSMail)e;
                    mailInformation = this.DefaultFormat(cSMail.toProperties(null), properties);
                }
                this.clear = "\r\nmail" + i + ":";
                this.addProperties(this.clear);
                if (mailInformation == null) continue;
                this.mailInfos.addElement(mailInformation);
            }
        }
        this.setServerInfo(properties);
    }

    public Vector getMails() {
        return this.mails;
    }

    @Override
    public void run() {
        try {
            this.sendMails();
        }
        catch (Throwable throwable) {
            ServiceLogger.logError(throwable, 3);
        }
    }

    public void sendMails() throws Throwable {
        try {
            ServiceLogger.logDebug(6600036, this, 6);
            ServiceLogger.logDebug(4600181, new Object[]{this.getRunTaskKey(), this.getTaskName(), this.getUid(), this.getCatalog(), this.getReport()}, 4);
        }
        catch (Throwable throwable) {
            JDebug.WARNING((Throwable)throwable);
        }
        this.createEngineContext();
        try {
            this.engineContext.setRunningSheets(null, this.getTaskPriority());
            this.engineContext.createJREngine(this.uid, ReportEnv.getuid(), ReportEnv.gp(), "89Sfdswer470eGs190dfew324C", false, false);
            ServiceLogger.logEngine(6600066, 4);
            ServiceLogger.logEngine(6600067, this.engineContext, 4);
            this.engineContext.setSingleThread(ServerEnv.getEngineSingleThread());
            this.engineContext.addEngineListener(this.getRunTaskId());
            this.engineContext.setServerInfo(this.serverInfo);
            this.engineContext.setConnectionInfoProvider(this.getJRTaskManager().getConnectionInfoProvider());
            int n = this.mails.size();
            for (int i = 0; i < n; ++i) {
                Object e = this.mails.elementAt(i);
                CSMail cSMail = (CSMail)e;
                mail mail2 = new mail(null, null, new ExportAuxInfo(this.getResourceStore().getDiskStore()));
                try {
                    mail2.send(cSMail.from, cSMail.to, cSMail.cc, cSMail.bcc, cSMail.subject, cSMail.comments, cSMail.compress, -1, cSMail.attachedFiles);
                }
                catch (Exception exception) {
                    throw exception;
                }
                finally {
                    mail2.clear();
                }
                try {
                    ServiceLogger.logEngine(6600068, cSMail, 6);
                }
                catch (Throwable throwable) {
                    JDebug.WARNING((Throwable)throwable);
                }
                try {
                    ServiceLogger.logEngine(6600069, cSMail, 6);
                    continue;
                }
                catch (Throwable throwable) {
                    JDebug.WARNING((Throwable)throwable);
                }
            }
            this.engineContext.engineExit();
            ServiceLogger.logEngine(6600070, 4);
        }
        catch (Throwable throwable) {
            try {
                ServiceLogger.logDebug(SchdTools.getStackTraceString(throwable), 6);
            }
            catch (Throwable throwable2) {
                JDebug.WARNING((Throwable)throwable2);
            }
            if (throwable instanceof OutOfMemoryError) {
                if (this.engineContext != null) {
                    this.engineContext.engineExit();
                    ServiceLogger.logEngine(6600071, 4);
                    this.engineContext = null;
                }
                System.gc();
                Runtime runtime = Runtime.getRuntime();
                int n = 0;
                while (runtime.freeMemory() < 1000000L) {
                    try {
                        System.gc();
                        if (n++ > 5) break;
                        Thread.currentThread().wait(1000L);
                    }
                    catch (Exception exception) {
                        ServiceLogger.logError(exception, 3);
                    }
                }
            }
            if (!this.isThrowExcp) {
                this.appendError(SchdTools.getStackTraceString(throwable));
            }
            throw throwable;
        }
        if (ServerEnv.exeGC) {
            System.gc();
        }
        if (this.thrdThrow != null) {
            if (!this.isThrowExcp) {
                this.appendError(SchdTools.getStackTraceString(this.thrdThrow));
            } else {
                throw this.thrdThrow;
            }
        }
        try {
            ServiceLogger.logDebug(6600040, this, 6);
            ServiceLogger.logDebug(4600190, this.getRunTaskKey(), 4);
        }
        catch (Throwable throwable) {
            JDebug.WARNING((Throwable)throwable);
        }
    }

    @Override
    public Properties toProperties(Properties properties) {
        Properties properties2 = super.toProperties(properties);
        if (properties2 == null) {
            properties2 = new Properties();
        }
        properties2 = CSMail.toProperties(this.mails, properties2);
        return properties2;
    }

    @Override
    public String toString() {
        String string = "\r\nMails[";
        if (this.mails != null) {
            Object var2_2 = null;
            int n = this.mails.size();
            for (int i = 0; i < n; ++i) {
                Object e = this.mails.elementAt(i);
                if (e == null) continue;
                string = string + (i == 0 ? "" : "; ") + e.toString();
            }
        }
        return super.toString() + string + "]";
    }

    @Override
    protected void finalize() throws Throwable {
        if (this.mails != null) {
            this.mails.clear();
            this.mails = null;
        }
        super.finalize();
    }

    /*
     * WARNING - void declaration
     */
    private MailInformation DefaultFormat(Properties properties, Properties properties2) throws Exception {
        String string;
        Object object;
        int n;
        int n2;
        int n3;
        boolean bl;
        boolean bl2;
        boolean bl3;
        int c;
        int n4;
        boolean bl4;
        boolean bl5;
        HtmlParameter htmlParameter;
        boolean bl10;
        boolean bl11;
        boolean bl12;
        if (properties == null) {
            return null;
        }
        if (properties2 == null) {
            properties2 = new Properties();
        }
        String string2 = (String)properties.get("jrs.mailfrom");
        String string3 = (String)properties.get("jrs.mailto");
        String string4 = (String)properties.get("jrs.mailcc");
        String string5 = (String)properties.get("jrs.mailbcc");
        String string6 = (String)properties.get("jrs.mailsubject");
        String string7 = (String)properties.get("jrs.mailcomments");
        String string8 = (String)properties.get("jrs.mailencoding");
        boolean bl13 = CSUtil.getBoolean((String)properties.get("jrs.mailcompress"), false);
        int n5 = CSUtil.parseInt((String)properties.get("jrs.mail_size"), CSUtil.parseInt(ServerEnv.getMailSendSize(), 2000));
        String string9 = (String)properties.get("jrs.mail_name");
        String string10 = (String)properties.get("jrs.mail_dir");
        String string11 = (String)properties.get("jrs.mail_smpt_accountname");
        String string12 = (String)properties.get("jrs.mail_smtp_password");
        String string13 = (String)properties.get("jrs.mail_smtp_address");
        MailInformation mailInformation = new MailInformation(string2, string3, string4, string5, string6, string7);
        mailInformation.setArchiveCompress(bl13);
        mailInformation.setLimitSize((long)n5);
        mailInformation.setFilename(string9);
        if (string10 != null && string10.length() > 0) {
            mailInformation.setFolder(string10);
        }
        ConfigurationMail configurationMail = HttpUtil.getHttpRptServer().getAdminService().getConfigService().getConfigurationMail();
        if (string11 != null && string12 != null && string13 != null && string11.length() != 0 && string12.length() != 0 && string13.length() != 0) {
            mailInformation.setMailFrom(string13);
            mailInformation.setAuthencatorMessage(string11, string12, string13);
        } else {
            String string14 = configurationMail.getMailBox();
            mailInformation.setMailFrom(string14);
            if (configurationMail.getAuthentication()) {
                mailInformation.setAuthencatorMessage(configurationMail.getAuthenticationUser(), configurationMail.getAuthenticationPassword(), string14);
            }
        }
        string8 = configurationMail.getEncoding();
        if (string8 == null || 0 == string8.length()) {
            string8 = CSUtil.getUrlEncoding();
        }
        if (string8 != null) {
            mailInformation.setEncoding(string8);
        }
        this.clear = this.clear + " rcpt=" + string3 + " cc=" + string4 + " bcc=" + string5 + " subject=" + string6 + " comments=" + string7 + " compress=" + bl13;
        boolean bl14 = true;
        int n6 = CSUtil.parseInt(properties.getProperty("jrs.mailformat"), mailconfig.DefaultFormat);
        boolean bl6 = bl12 = n6 == 0 || CSUtil.getBoolean((String)properties.get("jrs.to_mail_htmlmail"), false);
        if (bl12) {
            bl14 = false;
            this.addElement = true;
            HtmlParameter htmlParameter2 = new HtmlParameter();
            mailInformation.setHtmlParameter(0, htmlParameter2);
            mailInformation.setPrecise(0, this.getPrecision(1, properties.getProperty("jrs.mail_html_precision")));
            mailInformation.setDisableLinkReport(0, !CSUtil.getBoolean((String)properties.get("jrs.to_mail_htmlmail_runLinkedReport"), false));
        }
        boolean bl16 = false;
        int n7 = 0;
        String string15 = null;
        boolean bl7 = bl11 = n6 == 2 || CSUtil.getBoolean((String)properties.get("jrs.to_mail_html"), false);
        if (bl11) {
            bl14 = false;
            this.addElement = true;
            bl16 = properties2.containsKey("jrs.is_multi_files#pref") ? CSUtil.getBoolean((String)properties2.get("jrs.is_multi_files#pref")) : CSUtil.getBoolean((String)properties2.get("jrs.is_multi_files"), false);
            bl10 = CSUtil.getBoolean((String)properties.get("jrs.mail_is_multi_files"), bl16);
            htmlParameter = new HtmlParameter();
            htmlParameter.setIsExportToMultiFiles(bl10);
            bl16 = properties.containsKey("jrs.embedded_css#pref") ? CSUtil.getBoolean((String)properties.get("jrs.embedded_css#pref")) : CSUtil.getBoolean((String)properties.get("jrs.embedded_css"), false);
            boolean bl9 = CSUtil.getBoolean((String)properties.get("jrs.mail_embedded_css"), bl16);
            htmlParameter.setEmbededCSS(bl9);
            bl16 = properties2.containsKey("jrs.is_applet_chart#pref") ? CSUtil.getBoolean((String)properties2.get("jrs.is_applet_chart#pref")) : CSUtil.getBoolean((String)properties2.get("jrs.is_applet_chart"), false);
            boolean bl8 = CSUtil.getBoolean((String)properties.get("jrs.mail_is_chart_applet"), bl16);
            htmlParameter.setIsExportAppletChart(bl8);
            bl16 = properties2.containsKey("jrs.has_hyperlink#pref") ? CSUtil.getBoolean((String)properties2.get("jrs.has_hyperlink#pref")) : CSUtil.getBoolean((String)properties2.get("jrs.has_hyperlink"), false);
            bl5 = CSUtil.getBoolean((String)properties.get("jrs.mail_has_hyperlink"), bl16);
            htmlParameter.setHasHyperlink(bl5);
            bl16 = properties2.containsKey("jrs.has_page_number#pref") ? CSUtil.getBoolean((String)properties2.get("jrs.has_page_number#pref")) : CSUtil.getBoolean((String)properties2.get("jrs.has_page_number"), false);
            bl4 = CSUtil.getBoolean((String)properties.get("jrs.mail_has_page_number"), bl16);
            htmlParameter.setHasPageNumber(bl4);
            bl16 = properties2.containsKey("jrs.drilldown#pref") ? CSUtil.getBoolean((String)properties2.get("jrs.drilldown#pref")) : CSUtil.getBoolean((String)properties2.get("jrs.drilldown"), false);
            boolean bl15 = CSUtil.getBoolean((String)properties.get("jrs.mail_drilldown"), bl16);
            htmlParameter.setIsIncludeDrillDownFile(bl15);
            bl16 = properties2.containsKey("jrs.use_section508_output#pref") ? CSUtil.getBoolean((String)properties2.get("jrs.use_section508_output#pref")) : CSUtil.getBoolean((String)properties2.get("jrs.use_section508_output"), false);
            n4 = CSUtil.getBoolean((String)properties.get("jrs.mail_use_section508_output"), bl16);
            htmlParameter.setIsSect508Html(n4 != 0);
            bl16 = properties2.containsKey("jrs.use_html_table#pref") ? CSUtil.getBoolean((String)properties2.get("jrs.use_html_table#pref")) : CSUtil.getBoolean((String)properties2.get("jrs.use_html_table"), false);
            c = CSUtil.getBoolean((String)properties.get("jrs.mail_use_html_table"), bl16);
            htmlParameter.setUseHtmlTable(c != 0);
            bl16 = properties2.containsKey("jrs.use_scope#pref") ? CSUtil.getBoolean((String)properties2.get("jrs.use_scope#pref")) : CSUtil.getBoolean((String)properties2.get("jrs.use_scope"), false);
            bl3 = CSUtil.getBoolean((String)properties.get("jrs.mail_use_scope"), bl16);
            htmlParameter.setUseScope(bl3);
            bl2 = CSUtil.getBoolean((String)properties.get("jrs.mail_use_table"), false);
            htmlParameter.setIsTableFormatHtml(bl2);
            bl16 = properties2.containsKey("jrs.relative_font_size#pref") ? CSUtil.getBoolean((String)properties2.get("jrs.relative_font_size#pref")) : CSUtil.getBoolean((String)properties2.get("jrs.relative_font_size"), false);
            bl = CSUtil.getBoolean((String)properties.get("jrs.mail_relative_font_size"), bl16);
            htmlParameter.setIsAbsoluteFontSize(!bl);
            bl16 = properties2.containsKey("jrs.no_margin_html#pref") ? CSUtil.getBoolean((String)properties2.get("jrs.no_margin_html#pref")) : CSUtil.getBoolean((String)properties2.get("jrs.no_margin_html"), false);
            boolean bl17 = CSUtil.getBoolean((String)properties.get("jrs.mail_no_margin_html"), bl16);
            htmlParameter.setIsNoMargin(bl17);
            boolean bl18 = CSUtil.getBoolean((String)properties.get("jrs.mail_is_dhtml"), false);
            htmlParameter.setDhtml(bl18);
            n7 = properties2.containsKey("jrs.web_browser#pref") ? CSUtil.parseInt((String)properties2.get("jrs.web_browser#pref")) : CSUtil.parseInt((String)properties2.get("jrs.web_browser"), 0);
            int n8 = CSUtil.parseInt((String)properties.get("jrs.mail_web_browser"), n7);
            htmlParameter.setBrowserType(n8);
            n7 = properties2.containsKey("jrs.text_overflow#pref") ? CSUtil.parseInt((String)properties2.get("jrs.text_overflow#pref")) : CSUtil.parseInt((String)properties2.get("jrs.text_overflow"), 1);
            n3 = CSUtil.parseInt((String)properties.get("jrs.mail_text_overflow"), n7);
            htmlParameter.setOverflowType(n3);
            n7 = properties2.containsKey("jrs.html_resolution#pref") ? CSUtil.parseInt((String)properties2.get("jrs.html_resolution#pref")) : CSUtil.parseInt((String)properties2.get("jrs.html_resolution"), -1);
            n2 = CSUtil.parseInt((String)properties.get("jrs.mail_html_resolution"), n7);
            htmlParameter.setResolution(n2);
            n7 = properties2.containsKey("jrs.format_chart#pref") ? CSUtil.parseInt((String)properties2.get("jrs.format_chart#pref")) : CSUtil.parseInt((String)properties2.get("jrs.format_chart"), -1);
            n = CSUtil.parseInt((String)properties.get("jrs.mail_format_chart"), n7);
            htmlParameter.setExportImageType(n);
            object = (String)properties.get("jrs.mail_html_file");
            mailInformation.setHtmlParameter(2, (String)object, htmlParameter);
            mailInformation.setMailFileNameFmt(2, (String)object);
            mailInformation.setPrecise(2, this.getPrecision(1, properties.getProperty("jrs.mail_html_precision")));
            mailInformation.setDisableLinkReport(2, !CSUtil.getBoolean((String)properties.get("jrs.to_mail_html_runLinkedReport"), false));
            this.clear = this.clear + "   \r\nhtmlMail=true multiFiles=" + bl10 + " isChartApplet=" + bl8 + " hasHyperlink=" + bl5 + " hasPageNumber=" + bl4 + " drillDownHtml=" + bl15 + " useTable=" + bl2 + " fontSize=" + bl + " noMarginHtml=" + bl17 + " isDhtml=" + bl18 + " iBrowser=" + n8 + " iOverflow=" + n3 + " resolutionValue=" + n2;
        }
        boolean bl19 = this.DefaultFormat = n6 == 4 || CSUtil.getBoolean((String)properties.get("jrs.to_mail_rst"), false);
        if (this.DefaultFormat) {
            bl14 = false;
            String string16 = (String)properties.get("jrs.mail_rst_file");
            mailInformation.setRSTFileName(string16);
            mailInformation.setMailFileNameFmt(4, string16);
            mailInformation.setMailFormat(4, true);
            mailInformation.setPrecise(4, this.getPrecision(0, properties.getProperty("jrs.mail_rst_precision")));
            bl16 = properties2.containsKey("jrs.zip_result#pref") ? CSUtil.getBoolean((String)properties2.get("jrs.zip_result#pref")) : CSUtil.getBoolean((String)properties2.get("jrs.zip_result"), false);
            boolean bl20 = CSUtil.getBoolean((String)properties.get("jrs.mail_zip_result"), bl16);
            mailInformation.setRstAsCompressed(bl20);
            mailInformation.setDisableLinkReport(4, !CSUtil.getBoolean((String)properties.get("jrs.to_mail_rst_runLinkedReport"), false));
            this.clear = this.clear + "   \r\nRst=true zipResult=" + bl20;
        }
        boolean bl20 = this.append = n6 == 3 || CSUtil.getBoolean((String)properties.get("jrs.to_mail_pdf"), false);
        if (this.append) {
            bl14 = false;
            bl16 = properties2.containsKey("jrs.no_margin_pdf#pref") ? CSUtil.getBoolean((String)properties2.get("jrs.no_margin_pdf#pref")) : CSUtil.getBoolean((String)properties2.get("jrs.no_margin_pdf"), false);
            bl10 = CSUtil.getBoolean((String)properties.get("jrs.mail_no_margin_pdf"), bl16);
            n7 = properties2.containsKey("jrs.compress_image_pdf#pref") ? CSUtil.parseInt((String)properties2.get("jrs.compress_image_pdf#pref")) : CSUtil.parseInt((String)properties2.get("jrs.compress_image_pdf"), 20);
            int n9 = CSUtil.parseInt((String)properties.get("jrs.mail_compress_image_pdf"), n7);
            boolean string34 = CSUtil.getBoolean((String)properties.get("jrs.mail_gif_transparent_pdf"), false);
            bl16 = properties2.containsKey("jrs.print_mode_pdf#pref") ? CSUtil.getBoolean((String)properties2.get("jrs.print_mode_pdf#pref")) : CSUtil.getBoolean((String)properties2.get("jrs.print_mode_pdf"), false);
            boolean bl21 = CSUtil.getBoolean((String)properties.get("jrs.mail_print_mode_pdf"), bl16);
            bl16 = properties2.containsKey("jrs.toc_pdf#pref") ? CSUtil.getBoolean((String)properties2.get("jrs.toc_pdf#pref")) : CSUtil.getBoolean((String)properties2.get("jrs.toc_pdf"), false);
            bl5 = CSUtil.getBoolean((String)properties.get("jrs.mail_toc_pdf"), bl16);
            bl16 = properties2.containsKey("jrs.drilldown_pdf#pref") ? CSUtil.getBoolean((String)properties2.get("jrs.drilldown_pdf#pref")) : CSUtil.getBoolean((String)properties2.get("jrs.drilldown_pdf"), false);
            bl4 = CSUtil.getBoolean((String)properties.get("jrs.mail_drilldown_pdf"), bl16);
            String string14 = (String)properties.get("jrs.mail_pdf_pwd");
            PDFParameter pDFParameter = new PDFParameter();
            Properties properties3 = HttpUtil.getHttpRptServer().getUserPreferenceManager().getUserPreference(this.uid);
            bl3 = CSUtil.getBoolean(properties3.getProperty("jrs.pdf_clipping_area"), true);
            pDFParameter.setClippingArea(bl3);
            pDFParameter.setNoMargin(bl10);
            pDFParameter.setImageCompressRatio(n9);
            pDFParameter.setToc(bl5);
            pDFParameter.setDrill(bl4);
            pDFParameter.setIsSimPrintMode(bl21);
            pDFParameter.setTransparent(string34);
            bl16 = properties2.containsKey("jrs.pdf_encrypt#pref") ? CSUtil.getBoolean((String)properties2.get("jrs.pdf_encrypt#pref")) : CSUtil.getBoolean((String)properties2.get("jrs.pdf_encrypt"), false);
            bl2 = CSUtil.getBoolean((String)properties.get("jrs.mail_pdf_encrypt"), bl16);
            bl16 = properties2.containsKey("jrs.pdf_sign#pref") ? CSUtil.getBoolean((String)properties2.get("jrs.pdf_sign#pref")) : CSUtil.getBoolean((String)properties2.get("jrs.pdf_sign"), false);
            bl = CSUtil.getBoolean((String)properties.get("jrs.mail_pdf_sign"), bl16);
            if (bl2) {
                void var38_80;
                boolean bl22 = true;
                n7 = properties2.containsKey("jrs.pdf_compatibitly#pref") ? CSUtil.parseInt((String)properties2.get("jrs.pdf_compatibitly#pref")) : CSUtil.parseInt((String)properties2.get("jrs.pdf_compatibitly"), 1);
                if (CSUtil.parseInt((String)properties.get("jrs.mail_pdf_compatibitly"), n7) == 0) {
                    boolean bl23 = false;
                } else {
                    boolean bl24 = true;
                }
                string15 = properties2.containsKey("jrs.password_pdf#pref") ? (String)properties2.get("jrs.password_pdf#pref") : (String)properties2.get("jrs.password_pdf");
                String string16 = (String)properties.get("jrs.mail_pdf_pwd");
                if (string16 == null && string15 != null && !string15.equals("")) {
                    string16 = string15;
                }
                string15 = properties2.containsKey("jrs.pdf_permis_pasw#pref") ? (String)properties2.get("jrs.pdf_permis_pasw#pref") : (String)properties2.get("jrs.pdf_permis_pasw");
                String string17 = (String)properties.get("jrs.mail_pdf_permis_pasw");
                if (string17 == null && string15 != null && !string15.equals("")) {
                    string17 = string15;
                }
                n7 = properties2.containsKey("jrs.pdf_printallow#pref") ? CSUtil.parseInt((String)properties2.get("jrs.pdf_printallow#pref")) : CSUtil.parseInt((String)properties2.get("jrs.pdf_printallow"), 0);
                n3 = CSUtil.parseInt((String)properties.get("jrs.mail_pdf_printAllow"), n7);
                n7 = properties2.containsKey("jrs.pdf_changallow#pref") ? CSUtil.parseInt((String)properties2.get("jrs.pdf_changallow#pref")) : CSUtil.parseInt((String)properties2.get("jrs.pdf_changallow"), 0);
                n2 = CSUtil.parseInt((String)properties.get("jrs.mail_pdf_changAllow"), n7);
                bl16 = properties2.containsKey("jrs.pdf_check_enablecopy#pref") ? CSUtil.getBoolean((String)properties2.get("jrs.pdf_check_enablecopy#pref")) : CSUtil.getBoolean((String)properties2.get("jrs.pdf_check_enablecopy"), false);
                n = CSUtil.getBoolean((String)properties.get("jrs.mail_pdf_check_enablecopy"), bl16);
                bl16 = properties2.containsKey("jrs.pdf_check_enableaccess#pref") ? CSUtil.getBoolean((String)properties2.get("jrs.pdf_check_enableaccess#pref")) : CSUtil.getBoolean((String)properties2.get("jrs.pdf_check_enableaccess"), false);
                boolean bl25 = CSUtil.getBoolean((String)properties.get("jrs.mail_pdf_check_enableaccess"), bl16);
                int n10 = 0;
                int n11 = 0;
                if (n != 0) {
                    n10 = 1;
                }
                if (bl25) {
                    n11 = 1;
                }
                int n12 = SendMailTask.counPermission((boolean)var38_80, n3, n2, n10, n11);
                pDFParameter.setEncryption((boolean)var38_80, string16, string17, n12);
            }
            if (bl) {
                n7 = properties2.containsKey("jrs.pdf_sign_method#pref") ? CSUtil.parseInt((String)properties2.get("jrs.pdf_sign_method#pref")) : CSUtil.parseInt((String)properties2.get("jrs.pdf_sign_method"), 0);
                int n13 = CSUtil.parseInt((String)properties.get("jrs.mail_pdf_sign_method"), n7);
                string15 = properties2.containsKey("jrs.pdf_digital_path#pref") ? (String)properties2.get("jrs.pdf_digital_path#pref") : (String)properties2.get("jrs.pdf_digital_path");
                String string18 = WebSecurityUtil.validateFilePathStr((String)properties.get("jrs.mail_pdf_digital_path"));
                if (string18 == null && string15 != null && !string15.equals("")) {
                    string18 = string15;
                }
                string15 = properties2.containsKey("jrs.pdf_user_pasw#pref") ? (String)properties2.get("jrs.pdf_user_pasw#pref") : (String)properties2.get("jrs.pdf_user_pasw");
                String string19 = (String)properties.get("jrs.mail_pdf_user_pasw");
                if (string19 == null && string15 != null && !string15.equals("")) {
                    string19 = string15;
                }
                string15 = properties2.containsKey("jrs.pdf_permis_pasw#pref") ? (String)properties2.get("jrs.pdf_document_reson#pref") : (String)properties2.get("jrs.pdf_document_reson");
                String string20 = (String)properties.get("jrs.mail_pdf_document_reson");
                if (string20 == null && string15 != null && !string15.equals("")) {
                    string20 = string15;
                }
                string15 = properties2.containsKey("jrs.pdf_location#pref") ? (String)properties2.get("jrs.pdf_location#pref") : (String)properties2.get("jrs.pdf_location");
                String string21 = (String)properties.get("jrs.mail_pdf_location");
                if (string21 == null && string15 != null && !string15.equals("")) {
                    string21 = string15;
                }
                string15 = properties2.containsKey("jrs.pdf_contact_inf#pref") ? (String)properties2.get("jrs.pdf_contact_inf#pref") : (String)properties2.get("jrs.pdf_contact_inf");
                String string22 = (String)properties.get("jrs.mail_pdf_contact_inf");
                if (string22 == null && string15 != null && !string15.equals("")) {
                    string22 = string15;
                }
                object = null;
                try {
                    if (string18 != null) {
                        File file = new File(string18);
                        object = new FileInputStream(file);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    ServiceLogger.logError(fileNotFoundException);
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray = new byte[8192];
                byte[] byArray2 = null;
                try {
                    int n14 = ((FileInputStream)object).read(byArray);
                    while (n14 >= 0) {
                        byteArrayOutputStream.write(byArray, 0, n14);
                        n14 = ((FileInputStream)object).read(byArray);
                    }
                    ((FileInputStream)object).close();
                    byArray2 = byteArrayOutputStream.toByteArray();
                    byteArrayOutputStream.close();
                }
                catch (Exception exception) {
                    ServiceLogger.logError(exception);
                }
                pDFParameter.setDigitalSignature(n13, byArray2, string19);
                pDFParameter.setSigningReason(string20);
                pDFParameter.setSigningLocation(string21);
                pDFParameter.setSigningContact(string22);
            }
            String string23 = (String)properties.get("jrs.mail_pdf_file");
            mailInformation.setPDFParameters(string23, pDFParameter);
            mailInformation.setMailFileNameFmt(3, string23);
            mailInformation.setPrecise(3, this.getPrecision(2, properties.getProperty("jrs.mail_pdf_precision")));
            mailInformation.setDisableLinkReport(3, !CSUtil.getBoolean((String)properties.get("jrs.to_mail_pdf_runLinkedReport"), false));
            this.clear = this.clear + "   \r\nPdf=true  noMargeinPdf=" + bl10 + " compressImagePdf=" + n9 + " transparentImage=" + string34 + " printModePdf=" + bl21 + " isTocPdf=" + bl5 + " isDrilldownPdf=" + bl4;
        }
        boolean bl26 = bl10 = n6 == 1 || CSUtil.getBoolean((String)properties.get("jrs.to_mail_textmail"), false);
        if (bl10) {
            bl14 = false;
            this.attachedFiles = true;
            htmlParameter = new TextParameter();
            int n15 = CSUtil.parseInt((String)properties.get("jrs.plaintext_mail_char_width"), -1);
            htmlParameter.setUDCHWidth(n15);
            int n16 = CSUtil.parseInt((String)properties.get("jrs.plaintext_mail_char_height"), -1);
            htmlParameter.setUDCHHeight(n16);
            bl5 = CSUtil.getBoolean((String)properties.get("jrs.plaintext_mail_txt_compress"), false);
            htmlParameter.setCompress(bl5);
            bl4 = CSUtil.getBoolean((String)properties.get("jrs.plaintext_mail_hasheadfoot"), false);
            htmlParameter.setHasHeadFoot(bl4);
            boolean bl27 = CSUtil.getBoolean((String)properties.get("jrs.plaintext_mail_txt_windows"), bl16);
            htmlParameter.setForWinExport(bl27);
            this.clear = this.clear + "   \r\nplainText=true plainTxtHeadFoot=" + bl4 + " plainTxtCompress=" + bl5 + "plainTxtForWindows=" + bl27;
            mailInformation.setTextParameter(11, null, (TextParameter)htmlParameter);
            mailInformation.setPrecise(11, this.getPrecision(3, properties.getProperty("jrs.mail_text_precision")));
            mailInformation.setDisableLinkReport(1, !CSUtil.getBoolean((String)properties.get("jrs.to_mail_textmail_runLinkedReport"), false));
        }
        boolean bl28 = this.attachedFiles = n6 == 11 || CSUtil.getBoolean((String)properties.get("jrs.to_mail_txt"), false);
        if (this.attachedFiles) {
            bl14 = false;
            htmlParameter = new TextParameter();
            bl16 = properties2.containsKey("jrs.txt_windows#pref") ? CSUtil.getBoolean((String)properties2.get("jrs.txt_windows#pref")) : CSUtil.getBoolean((String)properties2.get("jrs.txt_windows"), false);
            boolean bl29 = CSUtil.getBoolean((String)properties.get("jrs.mail_txt_windows"), bl16);
            htmlParameter.setForWinExport(bl29);
            bl16 = properties2.containsKey("jrs.is_norm_txt#pref") ? CSUtil.getBoolean((String)properties2.get("jrs.is_norm_txt#pref")) : CSUtil.getBoolean((String)properties2.get("jrs.is_norm_txt"), true);
            boolean bl30 = CSUtil.getBoolean((String)properties.get("jrs.mail_is_normal_text"), bl16);
            bl16 = properties2.containsKey("jrs.txt_compress#pref") ? CSUtil.getBoolean((String)properties2.get("jrs.txt_compress#pref")) : CSUtil.getBoolean((String)properties2.get("jrs.txt_compress"), false);
            bl5 = CSUtil.getBoolean((String)properties.get("jrs.mail_txt_compress"), bl16);
            htmlParameter.setCompress(bl5);
            bl16 = properties2.containsKey("jrs.hasHeadFoot#pref") ? CSUtil.getBoolean((String)properties2.get("jrs.hasHeadFoot#pref")) : CSUtil.getBoolean((String)properties2.get("jrs.hasHeadFoot"), false);
            bl4 = CSUtil.getBoolean((String)properties.get("jrs.mail_hasheadfoot"), bl16);
            htmlParameter.setHasHeadFoot(bl4);
            htmlParameter.setNormalTextFile(bl30);
            this.cc = bl30;
            if (bl30) {
                n7 = properties2.containsKey("jrs.udchar_width#pref") ? CSUtil.parseInt((String)properties2.get("jrs.udchar_width#pref")) : CSUtil.parseInt((String)properties2.get("jrs.udchar_width"), -1);
                int n17 = CSUtil.parseInt((String)properties.get("jrs.mail_char_width"), n7);
                htmlParameter.setUDCHWidth(n17);
                n7 = properties2.containsKey("jrs.udchar_height#pref") ? CSUtil.parseInt((String)properties2.get("jrs.udchar_height#pref")) : CSUtil.parseInt((String)properties2.get("jrs.udchar_height"), -1);
                n4 = CSUtil.parseInt((String)properties.get("jrs.mail_char_height"), n7);
                htmlParameter.setUDCHHeight(n4);
                c = CSUtil.parseInt((String)properties.get("jrs.mail_resolution"), -1);
                htmlParameter.setResolution(c);
                this.clear = this.clear + "   \r\nplaintTxt=true txtCompress=" + bl5 + " charWidth=" + n17 + " charHeight=" + n4 + " resolution=" + c;
            } else {
                void var38_85;
                bl16 = properties.containsKey("jrs.is_repeat#pref") ? CSUtil.getBoolean((String)properties.get("jrs.is_repeat#pref")) : CSUtil.getBoolean((String)properties.get("jrs.is_repeat"), false);
                boolean bl31 = CSUtil.getBoolean((String)properties.get("jrs.mail_repeat"), bl16);
                htmlParameter.setRepeat(bl31);
                bl16 = properties2.containsKey("jrs.is_quotemark#pref") ? CSUtil.getBoolean((String)properties2.get("jrs.is_quotemark#pref")) : CSUtil.getBoolean((String)properties2.get("jrs.is_quotemark"), false);
                n4 = CSUtil.getBoolean((String)properties.get("jrs.mail_is_quotemark"), bl16) ? 1 : 0;
                htmlParameter.setUseQuoteMark(n4 != 0);
                c = 32;
                bl3 = true;
                String string24 = null;
                bl = false;
                string15 = properties2.containsKey("jrs.is_text_delimiter#pref") ? (String)properties2.get("jrs.is_text_delimiter#pref") : (String)properties2.get("jrs.is_text_delimiter");
                String string25 = (String)properties.get("jrs.mail_text_is_delimiter");
                if (string25 == null && string15 != null && !string15.equals("")) {
                    String string26 = string15;
                }
                if (var38_85 != null) {
                    if (var38_85.equals("jrs.mail_is_csv")) {
                        string24 = ",";
                    } else if (var38_85.equals("jrs.mail_is_tab")) {
                        bl = true;
                        string24 = " ";
                    } else if (var38_85.equals("jrs.mail_delimiter")) {
                        string15 = properties2.containsKey("jrs.delimiter#pref") ? (String)properties2.get("jrs.delimiter#pref") : (String)properties2.get("jrs.delimiter");
                        string24 = (String)properties.get("jrs.mail_delimiter");
                        if (string24 == null && string15 != null && !string15.equals("")) {
                            string24 = string15;
                        }
                    }
                }
                if (string24 != null && string24.length() > 0) {
                    if ("blank".equals(string24)) {
                        string24 = " ";
                    }
                    c = string24.charAt(0);
                } else {
                    bl3 = false;
                }
                if (bl) {
                    c = HttpUtil.decodeEsc("%09").charAt(0);
                }
                if (bl3) {
                    htmlParameter.setDelimiter(c);
                }
                this.clear = this.clear + "   \r\nText=true  isNormalText=false repeat=" + bl31 + " quoteMark=" + (n4 != 0) + " headFoot=" + bl4 + " compressText=" + bl5 + " delimiter=" + c + " forWindows=" + bl29;
            }
            String string27 = (String)properties.get("jrs.mail_text_file");
            mailInformation.setTextParameter(string27, (TextParameter)htmlParameter);
            mailInformation.setMailFileNameFmt(1, string27);
            mailInformation.setPrecise(1, this.getPrecision(3, properties.getProperty("jrs.mail_text_precision")));
            mailInformation.setDisableLinkReport(11, !CSUtil.getBoolean((String)properties.get("jrs.to_mail_txt_runLinkedReport"), false));
        }
        boolean bl32 = this.charAt = n6 == 7 || CSUtil.getBoolean((String)properties.get("jrs.to_mail_excel"), false);
        if (this.charAt) {
            bl14 = false;
            n7 = properties2.containsKey("jrs.is_wordwrap#pref") ? CSUtil.parseInt((String)properties2.get("jrs.is_wordwrap#pref")) : CSUtil.parseInt((String)properties2.get("jrs.is_wordwrap"), 0);
            int n14 = CSUtil.parseInt((String)properties.get("jrs.mail_excel_wordwrap"), n7);
            bl16 = properties2.containsKey("jrs.excel2000#pref") ? CSUtil.getBoolean((String)properties2.get("jrs.excel2000#pref")) : CSUtil.getBoolean((String)properties2.get("jrs.excel2000"), false);
            boolean bl33 = CSUtil.getBoolean((String)properties.get("jrs.mail_excel2000"), bl16);
            bl16 = properties2.containsKey("jrs.has_shapes#pref") ? CSUtil.getBoolean((String)properties2.get("jrs.has_shapes#pref")) : CSUtil.getBoolean((String)properties2.get("jrs.has_shapes"), false);
            boolean bl34 = CSUtil.getBoolean((String)properties.get("jrs.mail_has_shapes"), bl16);
            bl16 = properties2.containsKey("jrs.excel_layout#pref") ? CSUtil.getBoolean((String)properties2.get("jrs.excel_layout#pref")) : CSUtil.getBoolean((String)properties2.get("jrs.excel_layout"), true);
            bl5 = CSUtil.getBoolean((String)properties.get("jrs.mail_excel_layout"), bl16);
            bl4 = CSUtil.getBoolean(properties.getProperty("jrs.mail_match_layout"), false);
            if (!properties.containsKey("jrs.mail_excel_layout") && properties.containsKey("jrs.mail_match_layout")) {
                bl5 = bl4;
            }
            n7 = properties.containsKey("jrs.excel_format#pref") ? CSUtil.parseInt((String)properties.get("jrs.excel_format#pref")) : CSUtil.parseInt((String)properties.get("jrs.excel_format"), 1);
            int n18 = CSUtil.parseInt((String)properties.get("jrs.mail_excel_format"), n7);
            n4 = n18 == 1 ? 0 : 1;
            bl16 = properties2.containsKey("jrs.excel_advanced#pref") ? CSUtil.getBoolean((String)properties2.get("jrs.excel_advanced#pref")) : CSUtil.getBoolean((String)properties2.get("jrs.excel_advanced"), false);
            c = CSUtil.getBoolean((String)properties.get("jrs.mail_excel_advanced"), bl16);
            string15 = properties2.containsKey("jrs.print_header#pref") ? (String)properties2.get("jrs.print_header#pref") : (String)properties2.get("jrs.print_header");
            String string28 = (String)properties.get("jrs.mail_print_header");
            if (string28 == null && string15 != null && !string15.equals("")) {
                string28 = string15;
            }
            string15 = properties2.containsKey("jrs.print_footer#pref") ? (String)properties2.get("jrs.print_footer#pref") : (String)properties2.get("jrs.print_footer");
            String string29 = (String)properties.get("jrs.mail_print_footer");
            if (string29 == null && string15 != null && !string15.equals("")) {
                string29 = string15;
            }
            bl16 = properties2.containsKey("jrs.print_gridlines#pref") ? CSUtil.getBoolean((String)properties2.get("jrs.print_gridlines#pref")) : CSUtil.getBoolean((String)properties2.get("jrs.print_gridlines"), false);
            bl = CSUtil.getBoolean((String)properties.get("jrs.mail_print_gridlines"), bl16);
            ExcelParameter excelParameter = new ExcelParameter();
            excelParameter.setWordWrapType(n14);
            excelParameter.setBiff8(bl33);
            excelParameter.setParam(bl34 ? 1 : 0);
            excelParameter.setNewExcelLayout(bl5);
            excelParameter.setFileFormat(n4);
            if (c != 0) {
                excelParameter.setPrintPageHeaderAndFooter(string28, string29);
                excelParameter.setPrintGridlinesAble(bl);
            }
            String string30 = (String)properties.get("jrs.mail_excel_file");
            mailInformation.setExcelParameter(string30, excelParameter);
            mailInformation.setMailFileNameFmt(7, string30);
            mailInformation.setPrecise(7, this.getPrecision(4, properties.getProperty("jrs.mail_excel_precision")));
            mailInformation.setDisableLinkReport(7, !CSUtil.getBoolean((String)properties.get("jrs.to_mail_excel_runLinkedReport"), false));
            this.clear = this.clear + "   \r\nExcel=true  wordWrap=" + n14 + " excel2000=" + bl33;
        }
        boolean bl35 = this.appendError = n6 == 6 || CSUtil.getBoolean((String)properties.get("jrs.to_mail_ps"), false);
        if (this.appendError) {
            bl14 = false;
            PSParameter pSParameter = new PSParameter();
            bl16 = properties2.containsKey("jrs.no_margin_ps#pref") ? CSUtil.getBoolean((String)properties2.get("jrs.no_margin_ps#pref")) : CSUtil.getBoolean((String)properties2.get("jrs.no_margin_ps"), false);
            boolean bl36 = CSUtil.getBoolean((String)properties.get("jrs.mail_no_margin_ps"), bl16);
            pSParameter.setNoMargin(bl36);
            String string31 = (String)properties.get("jrs.mail_ps_file");
            mailInformation.setPSParameter(string31, pSParameter);
            mailInformation.setMailFileNameFmt(6, string31);
            mailInformation.setPrecise(6, this.getPrecision(5, properties.getProperty("jrs.mail_ps_precision")));
            mailInformation.setDisableLinkReport(6, !CSUtil.getBoolean((String)properties.get("jrs.to_mail_ps_runLinkedReport"), false));
            this.clear = this.clear + "   \r\nPostScript=true  noMarginPs=" + bl36;
        }
        boolean bl37 = this.bcc = n6 == 8 || CSUtil.getBoolean((String)properties.get("jrs.to_mail_rtf"), false);
        if (this.bcc) {
            bl14 = false;
            bl16 = properties2.containsKey("jrs.no_margin_rtf#pref") ? CSUtil.getBoolean((String)properties2.get("jrs.no_margin_rtf#pref")) : CSUtil.getBoolean((String)properties2.get("jrs.no_margin_rtf"), false);
            boolean bl282 = CSUtil.getBoolean((String)properties.get("jrs.mail_no_margin_rtf"), bl16);
            bl16 = properties2.containsKey("jrs.best_editing_rtp#pref") ? CSUtil.getBoolean((String)properties2.get("jrs.best_editing_rtp#pref")) : CSUtil.getBoolean((String)properties2.get("jrs.best_editing_rtp"), false);
            boolean bl38 = CSUtil.getBoolean((String)properties.get("jrs.mail_best_editing_rtf"), bl16);
            RtfParameter rtfParameter = new RtfParameter();
            rtfParameter.setNoMargin(bl282);
            rtfParameter.setRtfFlow(bl38);
            String string32 = (String)properties.get("jrs.mail_rtf_file");
            mailInformation.setRtfParameter(string32, rtfParameter);
            mailInformation.setMailFileNameFmt(8, string32);
            mailInformation.setPrecise(8, this.getPrecision(6, properties.getProperty("jrs.mail_rtf_precision")));
            mailInformation.setDisableLinkReport(8, !CSUtil.getBoolean((String)properties.get("jrs.to_mail_rtf_runLinkedReport"), false));
            this.clear = this.clear + "   \r\nRtf=true  noMarginRtf=" + bl282;
        }
        boolean bl39 = this.addProperties = n6 == 9 || CSUtil.getBoolean((String)properties.get("jrs.to_mail_xml"), false);
        if (this.addProperties) {
            bl14 = false;
            bl16 = properties2.containsKey("jrs.is_only_data#pref") ? CSUtil.getBoolean((String)properties2.get("jrs.is_only_data#pref")) : CSUtil.getBoolean((String)properties2.get("jrs.is_only_data"), false);
            boolean bl30 = CSUtil.getBoolean((String)properties.get("jrs.mail_is_only_data"), bl16);
            String string33 = (String)properties.get("jrs.mail_xsdfile");
            XmlParameter xmlParameter = new XmlParameter();
            xmlParameter.setOnlyData(bl30);
            xmlParameter.setSchemaFile(string33);
            String string34 = (String)properties.get("jrs.mail_xml_file");
            mailInformation.setXmlParameter(string34, xmlParameter);
            mailInformation.setMailFileNameFmt(9, string34);
            mailInformation.setPrecise(9, this.getPrecision(7, properties.getProperty("jrs.mail_xml_precision")));
            mailInformation.setDisableLinkReport(9, !CSUtil.getBoolean((String)properties.get("jrs.to_mail_xml_runLinkedReport"), false));
            this.clear = this.clear + "   \r\nXml=true  onlyDataXml=" + bl30 + " xsdFile=" + string33;
        }
        if (bl14 && mailconfig.DefaultFormat == 4) {
            mailInformation.setMailFormat(4, true);
            mailInformation.setPrecise(4, this.getPrecision(0, properties.getProperty("jrs.mail_rst_precision")));
        }
        if (properties.getProperty("jrs.mail_archive_file") != null && properties.getProperty("jrs.mail_archive_file").length() > 0 && (string = (String)properties.get("jrs.mail_archive_file")) != null) {
            mailInformation.setFilename(string);
            mailInformation.setFilenameFmt(string);
        }
        return mailInformation;
    }

    public void addProperties(String string) {
        this.properties = this.properties + "\r\n" + string;
    }
}

